/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler;

import com.fe.client.BBSyncMgmt;
import com.fe.db.SchedulerDB;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.SchedulerEngine;
import com.fe.scheduler.engines.deprecated.RConsoleScript;
import com.fe.scheduler.engines.deprecated.RhinoJavaScriptTask;
import com.fe.scheduler.group.BBDownloadScheduledTask;
import com.fe.scheduler.group.DirectRServeExecuteRUnix;
import com.fe.scheduler.group.REngineScriptTask;
import com.fe.scheduler.group.RScriptScheduledTask;
import com.fe.scheduler.group.RServeScheduledTask;
import com.fe.scheduler.group.RServeUnixTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class ScheduledTaskFactory {
    private static List<ScheduledTask> scheduledTasks = Collections.synchronizedList(new ArrayList());
    private static List<ScheduledTask> allTasks = Collections.synchronizedList(new ArrayList());

    public ScheduledTaskFactory() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refreshTaskLoaded() {
        List<ScheduledTask> list = scheduledTasks;
        synchronized (list) {
            if (allTasks.size() > 0 || scheduledTasks.size() > 0) {
                allTasks.clear();
                scheduledTasks.clear();
                this.init();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void init() {
        List<ScheduledTask> list = scheduledTasks;
        synchronized (list) {
            if (allTasks.size() <= 0 && scheduledTasks.size() <= 0) {
                allTasks.clear();
                scheduledTasks.clear();
                Vector vector = SchedulerEngine.getEnabledTaskTypes();
                SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
                try {
                    schedulerDB.connectDB(BBSyncMgmt.getDBName());
                    Vector vector2 = schedulerDB.getAllGroups();
                    Iterator object = vector2.iterator();
                    while (object.hasNext()) {
                        Map map = (Map)object.next();
                        String string = (String)map.get("taskuid");
                        String string2 = (String)map.get("name");
                        String string3 = (String)map.get("enginetype");
                        ScheduledTask scheduledTask = null;
                        if (string3.equalsIgnoreCase("rscript")) {
                            scheduledTask = new RScriptScheduledTask(string2, string);
                        }
                        if (string3.equalsIgnoreCase("rscript4rserve")) {
                            scheduledTask = new RServeScheduledTask(string2, string);
                        }
                        if (string3.equalsIgnoreCase("bb_download")) {
                            scheduledTask = new BBDownloadScheduledTask(string2, string);
                        }
                        if (System.getProperty("os.name").toLowerCase().startsWith("windows") && string3.equalsIgnoreCase("rhinoscript")) {
                            scheduledTask = new RhinoJavaScriptTask(string2, string);
                        }
                        if (string3.equalsIgnoreCase("rscript4rserveunix")) {
                            scheduledTask = new RServeUnixTask(string2, string);
                        }
                        if (string3.equalsIgnoreCase("direct_script")) {
                            scheduledTask = new REngineScriptTask(string2, string);
                        }
                        if (string3.equalsIgnoreCase("direct_script_unix")) {
                            scheduledTask = new DirectRServeExecuteRUnix(string2, string);
                        }
                        if (string3.equalsIgnoreCase("rscript4rconsole")) {
                            scheduledTask = new RConsoleScript(string2, string);
                        }
                        if (scheduledTask == null) continue;
                        allTasks.add(scheduledTask);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        schedulerDB.closeDB();
                    }
                    catch (Exception exception) {}
                }
                for (ScheduledTask scheduledTask : allTasks) {
                    if (!vector.contains(scheduledTask.getUniqueid())) continue;
                    scheduledTasks.add(scheduledTask);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getTaskUids() {
        TreeSet<String> treeSet = new TreeSet<String>();
        List<ScheduledTask> list = scheduledTasks;
        synchronized (list) {
            for (ScheduledTask scheduledTask : scheduledTasks) {
                treeSet.add(scheduledTask.getUniqueid());
            }
        }
        return treeSet;
    }

    public List<ScheduledTask> getTasks() {
        return scheduledTasks;
    }

    public List<ScheduledTask> getAllConfiguredTasks() {
        return allTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledTask getTask(String string) {
        ScheduledTask scheduledTask = null;
        List<ScheduledTask> list = scheduledTasks;
        synchronized (list) {
            for (ScheduledTask scheduledTask2 : this.getTasks()) {
                if (!scheduledTask2.getUniqueid().equals(string)) continue;
                scheduledTask = scheduledTask2;
            }
        }
        return scheduledTask;
    }

    public ScheduledTask getTaskFromAll(String string) {
        ScheduledTask scheduledTask = null;
        for (ScheduledTask scheduledTask2 : allTasks) {
            if (!scheduledTask2.getUniqueid().equals(string)) continue;
            scheduledTask = scheduledTask2;
        }
        return scheduledTask;
    }
}

