/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler;

import com.fe.Config;
import com.fe.ValueObject;
import com.fe.client.BBSyncMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.db.SchedulerDB;
import com.fe.p2p.P2PService;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.ScheduledTaskFactory;
import com.fe.scheduler.ScheduledTaskJob;
import com.fe.scheduler.ScheduledTaskQueue;
import com.fe.scheduler.SchedulerEngineUtils;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.balance.LoadBalancingQueueItem;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.mozilla.javascript.edu.emory.mathcs.backport.java.util.Arrays;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

public class SchedulerEngine {
    private Logger log = Logger.getLogger(SchedulerEngine.class);
    public static final String SCHEDULE_TASK_GROUP = "MY_SCHEDULER_Group";
    public static final String SCHEDULE_TASK_TIMEOUT_GROUP = "MY_SCHEDULER_TIMEOUT_Group";
    public static final String JOBDATA_UPDATED_TIME = "jobdata_updatedtime";
    public static final String JOBDATA_INVOKED_BY = "jobdata_invoked_by";
    public static final String JOBDATA_TRIGGER_ROW_ID = "trigger_row_id";

    private String generateCronExpr(Map map) throws Exception {
        String string = "";
        string = map.get("exp_second") != null && !map.get("exp_second").equals("") ? string + map.get("exp_second") : string + " 0";
        string = map.get("exp_minute") != null && !map.get("exp_minute").equals("") ? string + " " + map.get("exp_minute") : string + " 0";
        string = map.get("exp_hour") != null && !map.get("exp_hour").equals("") ? string + " " + map.get("exp_hour") : string + " *";
        boolean bl = false;
        if (map.get("exp_day") != null && !map.get("exp_day").equals("")) {
            string = string + " " + map.get("exp_day");
        } else {
            string = string + " ?";
            bl = true;
        }
        string = map.get("exp_month") != null && !map.get("exp_month").equals("") ? string + " " + map.get("exp_month") : string + " *";
        string = map.get("exp_week") != null && !map.get("exp_week").equals("") ? string + " " + map.get("exp_week") : string + (bl ? " *" : " ?");
        return string;
    }

    private String getNext5Times(Trigger trigger, TimeZone timeZone) throws Exception {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMM, yyyy hh:mm:ss a");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("dd MMM, yyyy HH:mm:ss");
        simpleDateFormat2.setTimeZone(timeZone);
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("dd MMM, yyyy HH:mm:ss");
        SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("hh:mm:ss a");
        String string = "";
        Date date = null;
        date = trigger.getPreviousFireTime() != null ? trigger.getPreviousFireTime() : trigger.getStartTime();
        for (int i = 0; trigger.getFireTimeAfter(date) != null && i < 5; ++i) {
            Date date2 = trigger.getFireTimeAfter(date);
            Date date3 = simpleDateFormat3.parse(simpleDateFormat2.format(date2));
            Date date4 = new Date();
            Date date5 = simpleDateFormat3.parse(simpleDateFormat2.format(date4));
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(date3);
            Calendar calendar3 = Calendar.getInstance();
            calendar3.setTime(date5);
            String string2 = null;
            if (calendar2.get(5) == calendar3.get(5) && calendar2.get(2) == calendar3.get(2) && calendar2.get(1) == calendar3.get(1)) {
                string2 = "Today at " + simpleDateFormat4.format(date3);
            }
            Calendar calendar4 = Calendar.getInstance();
            calendar4.setTime(date5);
            calendar4.add(5, 1);
            if (calendar2.get(5) == calendar4.get(5) && calendar2.get(2) == calendar4.get(2) && calendar2.get(1) == calendar4.get(1)) {
                string2 = "Tomorrow at " + simpleDateFormat4.format(date3);
            }
            String string3 = null;
            string3 = string2 == null ? "\n" + simpleDateFormat.format(date3) : "\n" + string2;
            date = trigger.getFireTimeAfter(date);
            string = string + string3;
        }
        return string;
    }

    public String getNext5Times(String string, String string2, TimeZone timeZone, int n) throws Exception {
        Trigger trigger;
        String string3 = this.generateUniqueJobName(string, string2, n, 0);
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
        Scheduler scheduler = stdSchedulerFactory.getScheduler();
        if (!scheduler.isStarted()) {
            scheduler.start();
        }
        if ((trigger = scheduler.getTrigger(new TriggerKey(string3, SCHEDULE_TASK_GROUP))) != null) {
            String string4 = this.getNext5Times(trigger, timeZone);
            return string4;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getEnabledTaskTypes() {
        Vector vector = new Vector();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Vector vector2 = schedulerDB.getActiveGroups();
            for (Map map : vector2) {
                vector.add(map.get("taskuid"));
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                schedulerDB.closeDB();
            }
            catch (Exception exception) {}
        }
        return vector;
    }

    public void startSchedulerQueue() throws Exception {
        String string;
        this.log.debug((Object)"startSchedulerQueue() called ()");
        this.log.debug((Object)("scheduler queue called at:" + new Date()));
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        schedulerDB.connectDB(BBSyncMgmt.getDBName());
        List list = schedulerDB.listScheduler();
        Vector vector = SchedulerEngine.getEnabledTaskTypes();
        String string2 = "";
        for (Map map : list) {
            string = (String)map.get("taskuid");
            this.log.debug((Object)("taskuid:" + string));
            if (!vector.contains(string)) continue;
            string2 = string2 + (string2.equals("") ? "'" + string + "'" : ",'" + string + "'");
        }
        schedulerDB.removeQueueLogs(new Date().getTime(), string2);
        this.log.debug((Object)("vs:" + vector));
        for (Map map : list) {
            string = (String)map.get("taskuid");
            this.log.debug((Object)("taskuid:" + string));
            if (!vector.contains(string)) continue;
            Number number = (Number)map.get("id");
            Map map2 = schedulerDB.getScheduler(number.intValue());
            try {
                this.updateJob(map2, string, schedulerDB);
            }
            catch (Exception exception) {
                this.log.error((Object)("Error while adding task id:" + number + " to the queue"));
                ClientErrorMgmt.reportError(exception, "Error while adding task id:" + number + " to the queue");
            }
        }
        schedulerDB.closeDB();
    }

    public void removeGroup2Queue(String string) throws Exception {
        block8: {
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            this.log.debug((Object)"removeGroup2Queue() called");
            try {
                List list = schedulerDB.listAllTasksByUID(string);
                Vector vector = SchedulerEngine.getEnabledTaskTypes();
                if (!vector.contains(string)) {
                    schedulerDB.removeQueueLogs(new Date().getTime(), "'" + string + "'");
                    StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
                    Scheduler scheduler = stdSchedulerFactory.getScheduler();
                    if (!scheduler.isStarted()) {
                        throw new Exception("Removing tasks failed, scheduler is not started first of all");
                    }
                    new ScheduledTaskFactory().refreshTaskLoaded();
                    Set set = scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)SCHEDULE_TASK_GROUP));
                    for (JobKey jobKey : set) {
                        JobDetail jobDetail = scheduler.getJobDetail(jobKey);
                        if (jobDetail == null) continue;
                        scheduler.deleteJob(jobKey);
                    }
                    break block8;
                }
                throw new Exception("Taskuid:" + string + " is active, please deactivate before remove them from queue");
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                schedulerDB.closeDB();
            }
        }
    }

    public void addGroup2Queue(String string) throws Exception {
        block9: {
            this.log.debug((Object)"addGroup2Queue() called");
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            try {
                List list = schedulerDB.listAllTasksByUID(string);
                Vector vector = SchedulerEngine.getEnabledTaskTypes();
                if (vector.contains(string)) {
                    schedulerDB.removeQueueLogs(new Date().getTime(), "'" + string + "'");
                    new ScheduledTaskFactory().refreshTaskLoaded();
                    for (Map map : list) {
                        Number number = (Number)map.get("id");
                        Map map2 = schedulerDB.getScheduler(number.intValue());
                        this.log.debug((Object)("adding task into live queue:id:" + number));
                        try {
                            this.updateJob(map2, string, schedulerDB);
                        }
                        catch (Exception exception) {
                            this.log.error((Object)("Error while adding task id:" + number + " to the queue"));
                            ClientErrorMgmt.reportError(exception, "Error while adding task id:" + number + " to the queue");
                        }
                    }
                    break block9;
                }
                throw new Exception("Taskuid:" + string + " is not active, please make it active before add them into queue");
            }
            catch (Exception exception) {
                throw exception;
            }
            finally {
                schedulerDB.closeDB();
            }
        }
    }

    public String generateUniqueJobName(String string, String string2, int n, int n2) {
        return n + "_" + n2;
    }

    public void updateJob(Map map, String string, SchedulerDB schedulerDB) throws Exception {
        Object object;
        if (Config.getValue("load_balancing_server") == null || !Config.getValue("load_balancing_server").equals(P2PService.getComputerName())) {
            throw new Exception("Couldn't update as this computer configuration doesn't support load balancing");
        }
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
        Scheduler scheduler = stdSchedulerFactory.getScheduler();
        if (!scheduler.isStarted()) {
            scheduler.start();
        }
        int n = ((Number)map.get("id")).intValue();
        String string2 = (String)map.get("name");
        for (int i = 0; i < 1000; ++i) {
            object = this.generateUniqueJobName(string2, string, n, i);
            JobDetail jobDetail = scheduler.getJobDetail(new JobKey((String)object, SCHEDULE_TASK_GROUP));
            if (jobDetail != null) {
                scheduler.deleteJob(new JobKey((String)object, SCHEDULE_TASK_GROUP));
                this.log.debug((Object)("deleleting job:" + (String)object));
                continue;
            }
            i = 1001;
        }
        schedulerDB.removeQueueLog(new Date().getTime(), n);
        Vector vector = schedulerDB.getTriggerData(n);
        object = (Number)map.get("active");
        if ((object == null || object != null && ((Number)object).intValue() != -1) && vector != null && vector.size() > 0) {
            int n2 = 0;
            for (Map map2 : vector) {
                String string3 = new SchedulerEngineUtils().generateCronExpr((String)map2.get("exp_second"), (String)map2.get("exp_minute"), (String)map2.get("exp_hour"), (String)map2.get("exp_week"), (String)map2.get("exp_day"), (String)map2.get("exp_month"));
                String string4 = this.generateUniqueJobName(string2, string, n, n2);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
                JobDetail jobDetail = JobBuilder.newJob(ScheduledTaskJob.class).withIdentity(string4, SCHEDULE_TASK_GROUP).usingJobData("scheduler_id", Integer.valueOf(n)).usingJobData("taskuid", string).usingJobData(JOBDATA_TRIGGER_ROW_ID, Long.valueOf(((Number)map2.get("id")).longValue())).usingJobData(JOBDATA_UPDATED_TIME, simpleDateFormat.format(new Date())).build();
                String string5 = (String)map.get("timezone");
                try {
                    CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)string3);
                    List list = Arrays.asList((Object[])TimeZone.getAvailableIDs());
                    if (string5 != null && !string5.trim().equals("") && list.contains(string5.trim())) {
                        cronScheduleBuilder.inTimeZone(TimeZone.getTimeZone(string5));
                    }
                    CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(string4, SCHEDULE_TASK_GROUP).withSchedule((ScheduleBuilder)cronScheduleBuilder).build();
                    Calendar calendar = Calendar.getInstance();
                    scheduler.scheduleJob(jobDetail, (Trigger)cronTrigger);
                    try {
                        Number number = (Number)map.get("id");
                        TreeMap<String, Number> treeMap = new TreeMap<String, Number>();
                        treeMap.put("scheduler_id", number);
                        treeMap.put("trigger_time", new Long(cronTrigger.getNextFireTime().getTime()));
                        Vector<TreeMap<String, Number>> vector2 = new Vector<TreeMap<String, Number>>();
                        vector2.add(treeMap);
                        schedulerDB.updateQueueLog(vector2, new Vector());
                    }
                    catch (Exception exception) {
                        ClientErrorMgmt.reportError(exception, null);
                    }
                }
                catch (Exception exception) {
                    this.log.error((Object)("Trigger Expression " + string3 + " failed for scheduler,please review the cron syntax " + n));
                }
                ++n2;
            }
        }
    }

    public void runJobDelayed(Map map, String string, SchedulerDB schedulerDB, int n, String string2) throws Exception {
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
        Scheduler scheduler = stdSchedulerFactory.getScheduler();
        if (!scheduler.isStarted()) {
            scheduler.start();
        }
        int n2 = ((Number)map.get("id")).intValue();
        String string3 = (String)map.get("name");
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, n);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMyyHHmm");
        this.log.debug((Object)("c:" + calendar.getTime()));
        this.log.debug((Object)("format:" + simpleDateFormat));
        this.log.debug((Object)("delay_in_minutes:" + n));
        String string4 = string3 + "_" + simpleDateFormat.format(calendar.getTime());
        JobDetail jobDetail = JobBuilder.newJob(ScheduledTaskJob.class).withIdentity(string4, SCHEDULE_TASK_GROUP).usingJobData("scheduler_id", Integer.valueOf(n2)).usingJobData("taskuid", string).usingJobData(JOBDATA_INVOKED_BY, string2).build();
        Trigger trigger = TriggerBuilder.newTrigger().withIdentity(string4, SCHEDULE_TASK_GROUP).startAt(calendar.getTime()).endAt(calendar.getTime()).build();
        Calendar calendar2 = Calendar.getInstance();
        scheduler.scheduleJob(jobDetail, trigger);
        try {
            Number number = (Number)map.get("id");
            TreeMap<String, Number> treeMap = new TreeMap<String, Number>();
            treeMap.put("scheduler_id", number);
            treeMap.put("trigger_time", calendar.getTime().getTime());
            Vector<TreeMap<String, Number>> vector = new Vector<TreeMap<String, Number>>();
            vector.add(treeMap);
            schedulerDB.updateQueueLog(vector, new Vector());
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
        }
    }

    public boolean isSchedulerStarted() throws Exception {
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
        Scheduler scheduler = stdSchedulerFactory.getScheduler();
        return scheduler.isStarted();
    }

    public void removeJob(long l, Map map, String string) throws Exception {
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
        Scheduler scheduler = stdSchedulerFactory.getScheduler();
        if (!scheduler.isStarted()) {
            scheduler.start();
        }
        String string2 = (String)map.get("name");
        for (int i = 0; i < 1000; ++i) {
            String string3 = this.generateUniqueJobName(string2, string, (int)l, i);
            JobDetail jobDetail = scheduler.getJobDetail(new JobKey(string3, SCHEDULE_TASK_GROUP));
            if (jobDetail != null) {
                scheduler.deleteJob(new JobKey(string3, SCHEDULE_TASK_GROUP));
                this.log.debug((Object)("deleleting job:" + string3));
                continue;
            }
            i = 1001;
        }
    }

    public synchronized String executeScriptExpression(String string, String string2, String string3) throws Exception {
        ArrayList<ValueObject> arrayList = new SchedulerEngineUtils().parseCodeInjection(string);
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        String string4 = "";
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            String string5 = null;
            boolean bl = false;
            for (ValueObject valueObject : arrayList) {
                this.log.debug((Object)("vo:key:" + valueObject.getKey()));
                int n = Integer.parseInt(valueObject.getKey());
                Map map = schedulerDB.getScheduler(n);
                if (map == null) continue;
                if (map.get("deleted") == null || map.get("deleted") != null && ((Number)map.get("deleted")).intValue() != 1) {
                    Number number = (Number)map.get("active");
                    String string6 = (String)map.get("taskuid");
                    String string7 = (String)map.get("name");
                    String string8 = valueObject.getValue() == null ? "" : valueObject.getValue();
                    String string9 = string3 != null ? string8 + "\n" + string3 : string8;
                    this.log.debug((Object)("inject:" + string9));
                    this.log.debug((Object)("vovalue:" + string8 + " vo.key:" + valueObject.getKey() + " vo:" + valueObject.getValue()));
                    new SchedulerEngine().executeJobNow(string7, string6, map, schedulerDB, string2, string9);
                    bl = true;
                    continue;
                }
                string5 = string5 == null ? n + "" : string5 + "," + n;
            }
            string4 = bl ? "done " + (string5 != null ? ", but " + string5 + " failed" : "") : "no success";
            String string10 = string4;
            return string10;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            try {
                schedulerDB.closeDB();
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void executeJobNow(String string, String string2, Map map, SchedulerDB schedulerDB, String string3, String string4) throws Exception {
        Serializable serializable;
        Object object;
        if (map.get("deleted") != null && ((Number)map.get("deleted")).intValue() == 1) {
            throw new Exception("Deleted Task can't be executed");
        }
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
        Scheduler scheduler = stdSchedulerFactory.getScheduler();
        if (!scheduler.isStarted()) {
            scheduler.start();
        }
        Number number = (Number)map.get("id");
        String string5 = this.generateUniqueJobName(string, string2, number.intValue(), 0);
        Date date = null;
        date = new Date();
        if (ScheduledTaskQueue.getQueuedTaskIds().contains(number)) {
            throw new Exception("This task is currently in the queue or already excuting...");
        }
        ScheduledTask scheduledTask = new ScheduledTaskFactory().getTask(string2);
        StackFrame stackFrame = new StackFrame(scheduledTask, map);
        stackFrame.setInvokedby(string3);
        stackFrame.setTrigger_time(new Date().getTime());
        Trigger trigger = scheduler.getTrigger(new TriggerKey(string5, SCHEDULE_TASK_GROUP));
        if (trigger != null && trigger.getNextFireTime() != null) {
            stackFrame.setNexttrigger_time(trigger.getNextFireTime().getTime());
        }
        if (Config.getValue("load_balancing_server") != null && Config.getValue("load_balancing_server").equals(P2PService.getComputerName())) {
            object = new LoadBalancingQueueItem();
            ((LoadBalancingQueueItem)object).setSf(stackFrame);
            serializable = (Integer)map.get("id");
            ((LoadBalancingQueueItem)object).setSchedulerid((Integer)serializable);
            ((LoadBalancingQueueItem)object).setInject_code(string4);
            LoadBalancingQueue.getDefault().add((LoadBalancingQueueItem)object);
        } else {
            ScheduledTaskQueue.add(stackFrame);
        }
        object = new TreeMap<String, Number>();
        ((TreeMap)object).put("scheduler_id", number);
        ((TreeMap)object).put("trigger_time", stackFrame.getTrigger_time());
        serializable = new Vector();
        ((Vector)serializable).add(object);
        schedulerDB.updateQueueLog((Collection)((Object)serializable), new Vector());
        this.log.debug((Object)("triggering job:" + string5 + " time:" + stackFrame.getTrigger_time() + " scheduler_Id:" + number));
    }

    public class SQueuedItem
    extends TreeMap
    implements Comparable {
        public int compareTo(Object object) {
            Date date;
            SQueuedItem sQueuedItem = (SQueuedItem)object;
            Date date2 = (Date)this.get("execute_dt");
            if (date2.after(date = (Date)sQueuedItem.get("execute_dt"))) {
                return 1;
            }
            return -1;
        }
    }
}

