/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.balance;

import com.fe.client.BBSyncMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.db.SchedulerDB;
import com.fe.p2p.listener.IncomingMessage;
import com.fe.p2p.peer.PeerMachine;
import com.fe.p2p.peer.PeerManagerHSQL;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.SchedulerAlert;
import com.fe.scheduler.SchedulerExePlanLogs;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.balance.LoadBalancingQueueItem;
import com.fe.scheduler.balance.hsqldb.LoadBalancingHSQLQueue;
import com.fe.scheduler.balance.hsqldb.LoadBalancingHSQLQueueItem;
import com.fe.scheduler.exception.ExceptionPeerNoResponse;
import com.fe.scheduler.exception.ExceptionRemoveFromQ;
import com.fe.scheduler.exception.ExceptionRemoveFromQNotInPeer;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class ExecutingQueueCleaner
extends TimerTask {
    private static long frequency = 65L;
    private Logger log = Logger.getLogger(ExecutingQueueCleaner.class);
    private static TimerTask cleanerTask = null;
    private static Timer timer = new Timer();

    public static void clean() {
        if (cleanerTask == null) {
            cleanerTask = new ExecutingQueueCleaner();
            long l = frequency * 1000L;
            timer.scheduleAtFixedRate(cleanerTask, l, l);
        }
    }

    public static void stop() {
        timer.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.log.debug((Object)"~~~~~~~~~~~~~~~~~~~~`Cleaning thread started ");
        var1_1 = LoadBalancingQueue.getDefault().getExecutingTasks();
        if (var1_1.size() > 0) {
            try {
                LoadBalancingQueue.getDefault().findAndUpdateOnlinePeers();
                Thread.sleep(3000L);
            }
            catch (Exception var2_2) {
                // empty catch block
            }
            var2_3 = SchedulerDB.getSchedulerDB();
            try {
                var2_3.connectDB(BBSyncMgmt.getDBName());
                var3_4 = var2_3.getLast10minuteSuspectedFailure();
                for (Object var5_11 : var3_4) {
                    var6_12 = (Integer)var5_11.get("scheduler_id");
                    var7_13 = (Long)var5_11.get("trigger_time");
                    var8_14 = LoadBalancingQueue.getDefault().getAllTasks();
                    var9_15 = true;
                    if (var8_14.size() > 0) {
                        var9_15 = false;
                    }
                    var10_17 = var8_14.iterator();
                    while (var10_17.hasNext()) {
                        var11_18 = (LoadBalancingQueueItem)var10_17.next();
                        var12_19 = 0L;
                        if (var11_18 instanceof LoadBalancingHSQLQueueItem) {
                            var12_19 = ((LoadBalancingHSQLQueueItem)var11_18).getTrigger_time();
                        } else if (var11_18.getSf() != null) {
                            var12_19 = var11_18.getSf().getTrigger_time();
                        }
                        if (var9_15 || var12_19 != var7_13.longValue()) continue;
                        var9_15 = true;
                    }
                    if (var9_15 || (var10_17 = var2_3.getQueueLog(var6_12.intValue(), var7_13.longValue())).get("status") != null && (var10_17.get("status") == null || !((String)var10_17.get("status")).equals(""))) continue;
                    var2_3.updateQueueNullStatus(var6_12.intValue(), var7_13.longValue(), "fail");
                    var11_18 = "Checking based on the log, the item not found in the Q,hence updating the status as failed";
                    new SchedulerExePlanLogs(var6_12.intValue(), var7_13.longValue()).log((String)var11_18, var2_3, 3006);
                    var12_20 = new ExceptionRemoveFromQ((String)var11_18);
                    var2_3.updateResponseCode(var6_12.intValue(), var7_13.longValue(), var12_20.getErrorcode());
                    var13_22 = var2_3.getScheduler(var6_12.intValue());
                    var14_23 = (String)var13_22.get("alert_type");
                    if (var14_23 == null || var14_23.equals("")) continue;
                    var15_25 = new SchedulerAlert(var6_12.intValue(), var7_13.longValue());
                    var15_25.alert(var14_23, (String)var13_22.get("name"), SchedulerAlert.ALERT_SUB_FAILED, (String)var11_18, null, var2_3, var12_20, (Map)var13_22);
                }
            }
            catch (Exception var3_6) {
            }
            finally {
                try {
                    var2_3.closeDB();
                }
                catch (Exception var3_5) {}
            }
            var3_8 = 5000;
            var4_10 = 180000;
            var5_11 = LoadBalancingQueue.getDefault();
            if (var5_11 instanceof LoadBalancingHSQLQueue) {
                var6_12 = (LoadBalancingHSQLQueue)var5_11;
                var7_13 = new PeerManagerHSQL().getOnlinePeers(var3_8);
                var8_14 = new PeerManagerHSQL().getOnlinePeers(var4_10);
                var9_16 = var6_12.getRunningMoreThan3Mins();
                for (Object var11_18 : var9_16) {
                    var12_21 = var11_18.getSchedulerid() + "_" + var11_18.getTrigger_time();
                    var13_22 = new PeerMachine(var11_18.getMachine());
                    var14_24 = false;
                    var15_25 = null;
                    var16_27 = null;
                    if (var7_13.indexOf(var13_22) >= 0) {
                        try {
                            var2_3.connectDB(BBSyncMgmt.getDBName());
                            if (((PeerMachine)var7_13.get(var7_13.indexOf(var13_22))).getRunning().contains(var12_21) || var2_3.isAnyExecLogsInLast3Mins(var11_18.getSchedulerid(), var11_18.getTrigger_time())) ** GOTO lbl108
                            var15_25 = "Removing because this no longer running in peer";
                            if (!var6_12.removeFaultyProcessingTask(var11_18.getSchedulerid(), var11_18.getTrigger_time())) {
                                var15_25 = (String)var15_25 + " Q Update failed";
                            }
                            new SchedulerExePlanLogs(var11_18.getSchedulerid(), var11_18.getTrigger_time()).log((String)var15_25, 3009);
                            var16_27 = new ExceptionRemoveFromQNotInPeer((String)var15_25);
                            var14_24 = true;
                        }
                        catch (Exception var17_31) {
                            this.log.error((Object)("Error11A, Err: " + var17_31.getMessage()));
                        }
                        finally {
                            try {
                                var2_3.closeDB();
                            }
                            catch (Exception var17_32) {}
                        }
                    } else {
                        try {
                            var2_3.connectDB(BBSyncMgmt.getDBName());
                            if (!var8_14.contains(var13_22) && !var2_3.isAnyExecLogsInLast3Mins(var11_18.getSchedulerid(), var11_18.getTrigger_time())) {
                                var15_25 = "Removed from the Q: Peer not responded last 3 or more minutes";
                                if (!var6_12.removeFaultyProcessingTask(var11_18.getSchedulerid(), var11_18.getTrigger_time())) {
                                    var15_25 = (String)var15_25 + " Q Update failed";
                                }
                                new SchedulerExePlanLogs(var11_18.getSchedulerid(), var11_18.getTrigger_time()).log((String)var15_25, 3008);
                                var16_27 = new ExceptionPeerNoResponse((String)var15_25);
                                var14_24 = true;
                            }
                        }
                        catch (Exception var17_34) {
                            this.log.error((Object)("Error11B, Err: " + var17_34.getMessage()));
                        }
                        finally {
                            try {
                                var2_3.closeDB();
                            }
                            catch (Exception var17_35) {}
                        }
                    }
                    if (!var14_24) continue;
                    try {
                        var2_3.connectDB(BBSyncMgmt.getDBName());
                        var17_29 = var2_3.getScheduler(var11_18.getSchedulerid());
                        var18_39 = (String)var17_29.get("alert_type");
                        if (var18_39 == null || var18_39.equals("") || (var19_41 = var2_3.getQueueLog(var11_18.getSchedulerid(), var11_18.getTrigger_time())).get("status") != null && (var19_41.get("status") == null || ((String)var19_41.get("status")).equals(ScheduledTask.EXCECUTION_SUCCESS))) continue;
                        if (var16_27 != null) {
                            var2_3.updateResponseCode(var11_18.getSchedulerid(), var11_18.getTrigger_time(), var16_27.getErrorcode());
                        }
                        var20_43 = new SchedulerAlert(var11_18.getSchedulerid(), var11_18.getTrigger_time());
                        var20_43.alert(var18_39, (String)var17_29.get("name"), SchedulerAlert.ALERT_SUB_FAILED, (String)var15_25, null, var2_3, var16_27, var17_29);
                    }
                    catch (Exception var17_37) {
                        this.log.error((Object)("Error1, Err: " + var17_37.getMessage()));
                    }
                    finally {
                        try {
                            var2_3.closeDB();
                        }
                        catch (Exception var17_38) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeFaultyExecutingTask(int n, long l) throws Exception {
        try {
            boolean bl = false;
            if (n > 0 && l > 0L) {
                Map<String, Map> map;
                bl = LoadBalancingQueue.getDefault().removeFaultyProcessingTask(n, l);
                Map<String, Map> map2 = map = IncomingMessage.getExecutingPeersTime();
                synchronized (map2) {
                    for (Map map3 : map.values()) {
                        if (!map3.keySet().contains(n)) continue;
                        map3.remove(n);
                    }
                }
            }
            if (bl) {
                return "Task has been removed";
            }
            return "Removing failed";
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }
}

