/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.balance.executeR;

import com.fe.client.ClientErrorMgmt;
import com.fe.json.JSONObject;
import com.fe.p2p.websocket.TomcatWSServer;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.balance.LoadBalancingQueueItem;
import com.fe.scheduler.balance.executeR.GroupQueue;
import com.fe.scheduler.balance.hsqldb.LoadBalancingHSQLQueue;
import com.fe.scheduler.rscript.RScript;
import com.fe.scheduler.rscript.RScriptListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;

public class LoadBalancingExecuteRQueue
extends LoadBalancingQueue {
    private Logger log = Logger.getLogger(LoadBalancingExecuteRQueue.class);
    private static ExecutorService startScriptService = Executors.newCachedThreadPool();

    protected String getGroupUid(RScript rScript) {
        return rScript.getTaskuid() != null ? rScript.getTaskuid() : "general";
    }

    @Override
    public void addExecuteR(RScript rScript, RScriptListener rScriptListener) throws Exception {
        this.log.debug((Object)("adding script:" + rScript.getScript()));
        rScript.setExecuting(false);
        rScript.setQueued_time(new Date().getTime());
        String string = this.getGroupUid(rScript);
        GroupQueue groupQueue = GroupQueue.getGroupInstance(string);
        groupQueue.getScriptQueue().add(rScript);
        GroupQueue.scriptQueueVec.add(rScript);
        IElementAttributes iElementAttributes = groupQueue.getCache().getDefaultElementAttributes();
        iElementAttributes.setMaxLifeSeconds((long)CACHE_GROUP_EXPIRY);
        groupQueue.getCache().put((Object)rScript.getUid(), (Object)"alive", iElementAttributes);
        if (rScriptListener != null) {
            groupQueue.getScriptQueueListener().put(rScript.getUid(), rScriptListener);
        }
        if (groupQueue.getFuture() == null || groupQueue.getFuture() != null && groupQueue.getFuture().isDone()) {
            groupQueue.start();
        }
        this.toWSAdded(rScript);
    }

    @Override
    public final RScript startScriptIfNotStarted(RScript rScript, String string) {
        Future<RScript> future = startScriptService.submit(new Callable<RScript>(){
            private RScript rscript = null;
            private String peer = null;

            @Override
            public RScript call() {
                RScript rScript = null;
                if (LoadBalancingQueue.getDefault() instanceof LoadBalancingHSQLQueue) {
                    LoadBalancingExecuteRQueue loadBalancingExecuteRQueue = (LoadBalancingExecuteRQueue)LoadBalancingQueue.getExecuteRScriptDefault();
                    rScript = loadBalancingExecuteRQueue.startScriptIfNotStarted1(this.rscript, this.peer);
                }
                return rScript;
            }

            public Callable<RScript> init(RScript rScript, String string) {
                this.rscript = rScript;
                this.peer = string;
                return this;
            }
        }.init(rScript, string));
        RScript rScript2 = null;
        try {
            rScript2 = future.get();
        }
        catch (Exception exception) {
            this.log.error((Object)"error while retriveing future result");
        }
        return rScript2;
    }

    private RScript getRScript(Collection<RScript> collection, RScript rScript) {
        RScript rScript2 = null;
        for (RScript rScript3 : collection) {
            if (!rScript3.equals(rScript)) continue;
            rScript2 = rScript3;
        }
        return rScript2;
    }

    protected synchronized RScript startScriptIfNotStarted1(RScript rScript, String string) {
        RScript rScript2 = GroupQueue.scriptQueueVec.get(GroupQueue.scriptQueueVec.indexOf(rScript));
        String string2 = this.getGroupUid(rScript2);
        GroupQueue groupQueue = GroupQueue.getGroupInstance(string2);
        if (groupQueue.getScriptQueue().contains(rScript)) {
            Object object;
            groupQueue.getScriptQueue().remove(rScript);
            rScript2.setPeer(string);
            rScript2.setDelay(new Date().getTime() - rScript2.getQueued_time());
            rScript2.setExecuting(true);
            rScript2.setStartedtime(new Date());
            groupQueue.getScriptQueueProcessing().add(rScript2);
            if (groupQueue.getScriptQueueListener().get(rScript2.getUid()) != null) {
                object = groupQueue.getScriptQueueListener().get(rScript2.getUid());
                try {
                    object.onScriptSent(rScript2, string);
                }
                catch (Exception exception) {
                    ClientErrorMgmt.reportError(exception, "Error while invoking listener");
                }
            }
            try {
                object = this.getGroupedCache().getDefaultElementAttributes();
                object.setMaxLifeSeconds((long)CACHE_GROUP_EXPIRY);
                this.getGroupedCache().putInGroup((Object)string, CACHE_GROUP_ACTIVEPEERS, (Object)"active", (IElementAttributes)object);
            }
            catch (Exception exception) {
                this.log.error((Object)"error while caching active peer");
            }
            this.toWSStarted(rScript.getUid(), string);
            return rScript2;
        }
        return null;
    }

    @Override
    public synchronized void scriptFinished(RScript rScript, String string, String string2) {
        RScript rScript2 = GroupQueue.scriptQueueVec.get(GroupQueue.scriptQueueVec.indexOf(rScript));
        String string3 = this.getGroupUid(rScript2);
        GroupQueue groupQueue = GroupQueue.getGroupInstance(string3);
        groupQueue.getScriptQueueProcessing().remove(rScript);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MM HH:mm:ss");
        Date date = new Date();
        date.setTime(rScript2.getQueued_time());
        this.log.debug((Object)("scriptFinished called:" + simpleDateFormat.format(date) + " qid:" + string3));
        try {
            String string4 = rScript2.getPeer() + "_" + rScript2.getTaskuid();
            rScript2.setError(rScript.getError());
            IElementAttributes iElementAttributes = groupQueue.getGroupedCache().getDefaultElementAttributes();
            iElementAttributes.setMaxLifeSeconds((long)CACHE_GROUP_EXPIRY);
            groupQueue.getGroupedCache().putInGroup((Object)rScript2.getUid(), CACHE_GROUP_FINISHED, (Object)rScript2.getDelay(), iElementAttributes);
            for (Object e : groupQueue.getGroupedCache().getGroupKeys(CACHE_GROUP_FINISHED)) {
                groupQueue.getGroupedCache().getFromGroup(e, CACHE_GROUP_FINISHED);
            }
            if (groupQueue.getScriptQueueListener().get(rScript2.getUid()) != null) {
                Object object = groupQueue.getScriptQueueListener().get(rScript2.getUid());
                try {
                    object.onScriptFinished(rScript2, rScript2.getPeer(), string, string2);
                }
                catch (Exception exception) {
                    ClientErrorMgmt.reportError(exception, "Error while invoking listener");
                }
                groupQueue.getScriptQueueListener().remove(rScript2.getUid());
                object = null;
            }
            groupQueue.getCache().remove((Object)string4);
            rScript2 = null;
            this.toWSFinished(rScript.getUid());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        GroupQueue.scriptQueueVec.remove(rScript);
        rScript = null;
    }

    @Override
    public void removeScriptFromAllQueue(RScript rScript) {
        try {
            RScript rScript2 = GroupQueue.scriptQueueVec.get(GroupQueue.scriptQueueVec.indexOf(rScript));
            String string = this.getGroupUid(rScript2);
            GroupQueue groupQueue = GroupQueue.getGroupInstance(string);
            groupQueue.getScriptQueueProcessing().remove(rScript2);
            String string2 = rScript2.getPeer() + "_" + rScript2.getTaskuid();
            rScript2.setError(rScript.getError());
            groupQueue.getCache().remove((Object)string2);
            GroupQueue.scriptQueueVec.remove(rScript);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public Collection<RScript> getScriptQueue() throws Exception {
        ArrayList<RScript> arrayList = new ArrayList<RScript>();
        for (GroupQueue groupQueue : GroupQueue.getAllGroupQueues().values()) {
            arrayList.addAll(groupQueue.getScriptQueue());
        }
        return arrayList;
    }

    @Override
    public Collection<RScript> getScriptProcessingQueue() throws Exception {
        ArrayList<RScript> arrayList = new ArrayList<RScript>();
        for (GroupQueue groupQueue : GroupQueue.getAllGroupQueues().values()) {
            arrayList.addAll(groupQueue.getScriptQueueProcessing());
        }
        return arrayList;
    }

    private Map getScriptListeners() throws Exception {
        HashMap<String, RScriptListener> hashMap = new HashMap<String, RScriptListener>();
        for (GroupQueue groupQueue : GroupQueue.getAllGroupQueues().values()) {
            hashMap.putAll(groupQueue.getScriptQueueListener());
        }
        return hashMap;
    }

    public Map<String, Integer> debug_data() throws Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("scriptQueueListener_size", this.getScriptListeners().size());
        hashMap.put("scriptQueueVec_size", GroupQueue.scriptQueueVec.size());
        hashMap.put("scriptQueue_size", this.getScriptQueue().size());
        hashMap.put("queue_size", this.getScriptQueue().size());
        hashMap.put("queueprocessing_size", this.getScriptProcessingQueue().size());
        return hashMap;
    }

    @Override
    public List<LoadBalancingQueueItem> getAllTasks() {
        return null;
    }

    @Override
    public long lastExcecutedTime() {
        return 0L;
    }

    @Override
    public void removeItemProcessing(LoadBalancingQueueItem loadBalancingQueueItem, String string, int n) {
    }

    @Override
    public void executeScript(Vector<Object> vector, int n) throws Exception {
    }

    @Override
    public void peerStarted(int n, long l, String string) throws Exception {
    }

    @Override
    public void executionEnded(int n) {
    }

    @Override
    public void add(LoadBalancingQueueItem loadBalancingQueueItem) {
    }

    @Override
    public LoadBalancingQueueItem getItemFromProcessingQueue(int n, long l) {
        return null;
    }

    @Override
    public boolean killQueuedTask(int n, long l) {
        return false;
    }

    @Override
    public boolean removeFaultyProcessingTask(int n, long l) {
        return false;
    }

    @Override
    public int startedIfNotStarted(int n, long l, String string) {
        return 0;
    }

    @Override
    public void executionFailed(int n, long l, String string) {
    }

    @Override
    public void executionEnded(int n, long l) {
    }

    @Override
    public void cleanupProccesingQueue(int n, String string) {
    }

    @Override
    public Collection<LoadBalancingQueueItem> getExecutingTasks() {
        return null;
    }

    @Override
    public Collection<LoadBalancingQueueItem> getQueuedTasks() {
        return null;
    }

    protected void toWSAdded(RScript rScript) {
        try {
            JSONObject jSONObject = new JSONObject();
            Map map = BeanUtils.describe((Object)rScript);
            jSONObject.put("added", map);
            jSONObject.put("queue_size", this.getScriptQueue().size());
            TomcatWSServer.broadcast(jSONObject.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void toWSStarted(String string, String string2) {
        try {
            JSONObject jSONObject = new JSONObject();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("uid", string);
            hashMap.put("peer", string2);
            jSONObject.put("started", hashMap);
            jSONObject.put("executing_size", this.getScriptProcessingQueue().size());
            jSONObject.put("queue_size", this.getScriptQueue().size());
            TomcatWSServer.broadcast(jSONObject.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void toWSFinished(String string) {
        try {
            JSONObject jSONObject = new JSONObject();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("uid", string);
            jSONObject.put("finished", hashMap);
            jSONObject.put("executing_size", this.getScriptProcessingQueue().size());
            try {
                this.get30SecsData(jSONObject);
            }
            catch (Exception exception) {
                this.log.error((Object)("Error while geting 30secs data, e:" + exception.getMessage()));
            }
            TomcatWSServer.broadcast(jSONObject.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void toWSTimedout(String string) {
        try {
            JSONObject jSONObject = new JSONObject();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("uid", string);
            jSONObject.put("timedout", hashMap);
            try {
                this.get30SecsData(jSONObject);
            }
            catch (Exception exception) {
                this.log.error((Object)("Error while geting 30secs data, e:" + exception.getMessage()));
            }
            TomcatWSServer.broadcast(jSONObject.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void get30SecsData(JSONObject jSONObject) throws Exception {
        if (this.getCache().get((Object)"WS30SecData") == null) {
            Object object3;
            Object object2;
            JCS jCS = this.getGroupedCache();
            int n = 0;
            long l = 0L;
            for (Object e : jCS.getGroupKeys(LoadBalancingQueue.CACHE_GROUP_FINISHED)) {
                object2 = (Long)jCS.getFromGroup(e, LoadBalancingQueue.CACHE_GROUP_FINISHED);
                if (object2 == null) continue;
                l += ((Long)object2).longValue();
                ++n;
            }
            this.log.debug((Object)("totaldelay:" + l + " counter:" + n));
            long l2 = n > 0 && l > 0L ? l / (long)n / 1000L : 0L;
            for (Object object3 : jCS.getGroupKeys(LoadBalancingQueue.CACHE_GROUP_TIMEOUT)) {
                jCS.getFromGroup(object3, LoadBalancingQueue.CACHE_GROUP_TIMEOUT);
            }
            for (Object object3 : jCS.getGroupKeys(LoadBalancingQueue.CACHE_GROUP_FINISHED)) {
                jCS.getFromGroup(object3, LoadBalancingQueue.CACHE_GROUP_FINISHED);
            }
            for (Object object3 : jCS.getGroupKeys(LoadBalancingQueue.CACHE_GROUP_ACTIVEPEERS)) {
                jCS.getFromGroup(object3, LoadBalancingQueue.CACHE_GROUP_ACTIVEPEERS);
            }
            object2 = jCS.getGroupKeys(LoadBalancingQueue.CACHE_GROUP_FINISHED);
            object3 = jCS.getGroupKeys(LoadBalancingQueue.CACHE_GROUP_TIMEOUT);
            Set set = jCS.getGroupKeys(LoadBalancingQueue.CACHE_GROUP_ACTIVEPEERS);
            HashMap<String, Number> hashMap = new HashMap<String, Number>();
            hashMap.put("ave_delay", l2 > 0L ? l2 : 0L);
            hashMap.put("active_peers", set.size());
            hashMap.put("finished_count", object2.size());
            hashMap.put("timedout_count", object3.size());
            jSONObject.put("ave_delay", l2 > 0L ? l2 : 0L);
            jSONObject.put("active_peers", set.size());
            jSONObject.put("finished_count", object2.size());
            jSONObject.put("timedout_count", object3.size());
            IElementAttributes iElementAttributes = this.getCache().getDefaultElementAttributes();
            iElementAttributes.setMaxLifeSeconds(2L);
            this.getCache().put((Object)"WS30SecData", hashMap, iElementAttributes);
        } else {
            Map map = (Map)this.getCache().get((Object)"WS30SecData");
            for (String string : map.keySet()) {
                jSONObject.put(string, map.get(string));
            }
        }
    }
}

