/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.balance.hsqldb;

import com.fe.Config;
import com.fe.client.BBSyncMgmt;
import com.fe.client.Debugger;
import com.fe.db.SchedulerDB;
import com.fe.db.SuperDB;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.ScheduledTaskFactory;
import com.fe.scheduler.SchedulerAlert;
import com.fe.scheduler.SchedulerEngine;
import com.fe.scheduler.SchedulerExePlanLogs;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.balance.LoadBalancingQueueItem;
import com.fe.scheduler.balance.LoadBalancingQueueTimeout;
import com.fe.scheduler.balance.WaitingQueueList;
import com.fe.scheduler.balance.hsqldb.LoadBalancingHSQLQueue;
import com.fe.scheduler.balance.hsqldb.LoadBalancingHSQLQueueItem;
import com.fe.scheduler.exception.ExceptionDependencyTimeout;
import com.fe.util.RandomString;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;

public abstract class LoadBalancingHSQLLayerDB
extends LoadBalancingQueue {
    private Connection connection = null;
    private Logger log = Logger.getLogger(LoadBalancingHSQLLayerDB.class);
    private static Semaphore dblock = new Semaphore(1, true);
    private static final Byte QUEUEGATE_QUEUED = new Byte("1");
    private static final Byte QUEUEGATE_RUNNING = new Byte("2");
    private static long TIMEOUT_MS = 2000L;
    protected long lastExcecutedTime = 0L;
    protected static final int ADDED_TO_QUEUE = 1;
    protected static final int QUEUE_OVERLAPPED = -1;
    protected static final int QUEUE_DUPLICATE_FOUND = -2;
    protected static final int QUEUE_ERROR_FOUND = 0;
    private static Timer timer = null;
    private static Map<String, String> alert_range = null;
    private static JCS cache = null;
    private static TreeMap<String, Long> task_stat_max_waiting = new TreeMap();
    private static int ALERT_FREQUENCY_MINUTES = 5;
    private static ExecutorService startTaskService = Executors.newFixedThreadPool(1);
    public static int DELAY_QUEUE_PROCESSING = 75;
    private static String nextLineChar = "\r\n";

    protected void acquireLock() {
        try {
            dblock.tryAcquire(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
    }

    protected void releaseLock() {
        try {
            dblock.release();
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initDB() {
        if (this.connection == null) {
            this.acquireLock();
            try {
                this.log.debug((Object)"connecting database");
                Class.forName("org.hsqldb.jdbc.JDBCDriver");
                String string = Config.HSQLDB_QUEUE_FILE;
                String string2 = Config.getValue(string);
                if (string2 == null) {
                    string2 = "queue";
                }
                String string3 = "jdbc:hsqldb:file:" + string2;
                this.log.debug((Object)("************************************** driver:" + string3));
                File file = new File(string2 + ".script");
                if (!file.exists()) {
                    this.connection = DriverManager.getConnection(string3, "SA", "SA");
                    String string4 = this.createSchemaQuery();
                    Statement statement = this.connection.createStatement();
                    statement.execute(string4);
                    statement.close();
                } else {
                    this.connection = DriverManager.getConnection(string3, "SA", "SA");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.log.error((Object)("Error while getting db connection, Error:" + exception.getMessage()));
            }
            finally {
                this.releaseLock();
            }
        }
    }

    protected abstract void processQueueItem(LoadBalancingHSQLQueueItem var1) throws Exception;

    private boolean isOutputExpired(String string, int n) throws Exception {
        if (this.getCache().get((Object)string) == null) {
            IElementAttributes iElementAttributes = cache.getDefaultElementAttributes();
            iElementAttributes.setMaxLifeSeconds((long)n);
            this.getCache().put((Object)string, (Object)"0", iElementAttributes);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueLoop() throws Exception {
        int n = 0;
        boolean bl = true;
        while (bl) {
            Object object;
            Statement statement = this.connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT distinct taskuid from queue");
            String string = "";
            int n2 = 0;
            while (resultSet.next()) {
                object = "Select * from (select * from queue where taskuid='" + resultSet.getString("taskuid") + "' AND queuegate=" + QUEUEGATE_QUEUED + " AND waitingfordp=false ORDER by trigger_time,lastExecutedDuration,schedulerid limit 1) as a" + n2++;
                string = string + (String)(!string.equals("") ? " UNION " + (String)object : object);
            }
            string = string + (!string.equals("") ? " UNION " : "");
            if ((string = string + "Select * from (Select * from queue WHERE queuegate=" + QUEUEGATE_QUEUED + " and  waitingfordp=true) as all_dep ") != null && !string.equals("")) {
                object = this.connection.prepareStatement(string);
                this.acquireLock();
                try {
                    Object object2;
                    ResultSet resultSet2 = object.executeQuery();
                    while (resultSet2.next()) {
                        try {
                            object2 = this.getLBQItem(resultSet2);
                            if (!this.processDependencyQueueItem((LoadBalancingHSQLQueueItem)object2)) continue;
                            this.processQueueItem((LoadBalancingHSQLQueueItem)object2);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            this.log.error((Object)("error while processing row, error:" + exception.getMessage()));
                        }
                    }
                    object.close();
                    resultSet2.close();
                    object2 = this.connection.prepareStatement("SELECT * from queue WHERE queuegate=" + QUEUEGATE_QUEUED);
                    ResultSet resultSet3 = object2.executeQuery();
                    ++n;
                    if (!resultSet3.next()) {
                        this.log.debug((Object)("no record found so exiting" + string));
                        bl = false;
                    }
                    resultSet3.close();
                    object2.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.log.error((Object)("Error while looping...e:" + exception.getMessage()));
                }
                finally {
                    this.releaseLock();
                }
                Thread.sleep(DELAY_QUEUE_PROCESSING);
                continue;
            }
            bl = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean processDependencyQueueItem(LoadBalancingHSQLQueueItem loadBalancingHSQLQueueItem) throws Exception {
        boolean bl = true;
        if (loadBalancingHSQLQueueItem == null) return bl;
        String string = loadBalancingHSQLQueueItem.getDependentids();
        int n = 0;
        if (string == null) return true;
        if (string.equals("")) return true;
        if (loadBalancingHSQLQueueItem.getDependentchecktime() == null) return true;
        if (loadBalancingHSQLQueueItem.getDependentchecktime().equals("")) return true;
        String string2 = loadBalancingHSQLQueueItem.getDependentchecktime();
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            n = this.dependencyCheck(loadBalancingHSQLQueueItem, string, string2, schedulerDB);
            if (n == 1) {
                bl = true;
            }
            if (n == 0) {
                bl = false;
            }
            if (n == -1) {
                Object object;
                bl = false;
                String string3 = ScheduledTask.DEPENDENCY_TIMEOUT;
                TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                treeMap.put("scheduler_id", loadBalancingHSQLQueueItem.getSchedulerid());
                treeMap.put("trigger_time", loadBalancingHSQLQueueItem.getTrigger_time());
                treeMap.put("status", ScheduledTask.DEPENDENCY_TIMEOUT);
                ArrayList<TreeMap<String, Object>> arrayList = new ArrayList<TreeMap<String, Object>>();
                arrayList.add(treeMap);
                schedulerDB.updateQueueLog(arrayList, new Vector());
                String string4 = "Dependency timed out, because next trigger time is in a minute";
                new SchedulerExePlanLogs(loadBalancingHSQLQueueItem.getSchedulerid(), loadBalancingHSQLQueueItem.getTrigger_time()).log(string4, schedulerDB, 3007);
                ExceptionDependencyTimeout exceptionDependencyTimeout = new ExceptionDependencyTimeout(string4);
                schedulerDB.updateResponseCode(loadBalancingHSQLQueueItem.getSchedulerid(), loadBalancingHSQLQueueItem.getSf().getTrigger_time(), exceptionDependencyTimeout.getErrorcode());
                this.removeDependencyTimedout(loadBalancingHSQLQueueItem.getSchedulerid(), loadBalancingHSQLQueueItem.getTrigger_time());
                Map map = schedulerDB.getScheduler(loadBalancingHSQLQueueItem.getSchedulerid());
                String string5 = (String)map.get("alert_type");
                String string6 = (String)map.get("name");
                if (string5 != null && !string5.equals("")) {
                    object = new SchedulerAlert(loadBalancingHSQLQueueItem.getSchedulerid(), loadBalancingHSQLQueueItem.getSf().getTrigger_time());
                    ((SchedulerAlert)object).alert(string5, string6, SchedulerAlert.ALERT_SUB_TIMEOUT, string4, null, schedulerDB, exceptionDependencyTimeout, map);
                }
                if ((object = schedulerDB.getTaskEventActions(loadBalancingHSQLQueueItem.getSchedulerid(), loadBalancingHSQLQueueItem.getSf().getTrigger_time())).containsKey(ScheduledTask.FIELD_DEPENDENCY_TIMEOUT) && object.get(ScheduledTask.FIELD_DEPENDENCY_TIMEOUT) != null && !((String)object.get(ScheduledTask.FIELD_DEPENDENCY_TIMEOUT)).trim().equals("")) {
                    String string7 = (String)object.get(ScheduledTask.FIELD_DEPENDENCY_TIMEOUT);
                    String string8 = ScheduledTask.TASK_EVENT_CALL_EXP_ID_VARIABLE + "=" + loadBalancingHSQLQueueItem.getSchedulerid() + "\n";
                    string8 = string8 + ScheduledTask.TASK_EVENT_CALL_EXP_TRIGGERTIME_VARIABLE + "=" + loadBalancingHSQLQueueItem.getSf().getTrigger_time() + "\n";
                    new SchedulerEngine().executeScriptExpression(string7, "onDependency timeout of " + loadBalancingHSQLQueueItem.getSchedulerid(), string8);
                }
            }
            if (loadBalancingHSQLQueueItem.isWaitingfordp()) return bl;
            this.waiting4Dependent(loadBalancingHSQLQueueItem.getSchedulerid(), loadBalancingHSQLQueueItem.getTrigger_time());
            return bl;
        }
        catch (Exception exception) {
            this.log.error((Object)("Error at processDependencyQueueItem:" + exception.getMessage()));
            return bl;
        }
        finally {
            schedulerDB.closeDB();
        }
    }

    protected void waiting4Dependent(int n, long l) throws Exception {
        PreparedStatement preparedStatement = this.connection.prepareStatement("UPDATE queue SET waitingfordp=? WHERE schedulerid=? AND trigger_time=?");
        preparedStatement.setBoolean(1, new Boolean(true));
        preparedStatement.setInt(2, n);
        preparedStatement.setLong(3, l);
        int n2 = preparedStatement.executeUpdate();
        this.log.debug((Object)("waiting4Dependent() result:" + n2));
        preparedStatement.close();
    }

    @Override
    public final int startedIfNotStarted(int n, long l, String string) {
        Future<Integer> future = startTaskService.submit(new Callable<Integer>(){
            private int sc_id = 0;
            private long tri_time = 0L;
            private String peer = null;

            @Override
            public Integer call() {
                int n = 0;
                if (LoadBalancingQueue.getDefault() instanceof LoadBalancingHSQLQueue) {
                    LoadBalancingHSQLQueue loadBalancingHSQLQueue = (LoadBalancingHSQLQueue)LoadBalancingQueue.getDefault();
                    n = loadBalancingHSQLQueue.startedIfNotStarted1(this.sc_id, this.tri_time, this.peer);
                    LoadBalancingHSQLLayerDB.this.log.debug((Object)("starting sc_id:" + this.sc_id + " tri_time:" + this.sc_id + " peer:" + this.peer));
                }
                return new Integer(n);
            }

            public Callable<Integer> init(int n, long l, String string) {
                this.sc_id = n;
                this.tri_time = l;
                this.peer = string;
                return this;
            }
        }.init(n, l, string));
        Integer n2 = new Integer(0);
        try {
            n2 = future.get();
        }
        catch (Exception exception) {
            this.log.error((Object)"error while retriveing future result");
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int startedIfNotStarted1(int n, long l, String string) {
        int n2 = -1;
        String string2 = n + "_" + l;
        boolean bl = false;
        try {
            if (this.getGroupedCache().getFromGroup((Object)string2, LoadBalancingQueue.CACHE_GROUP_TENDERSCHEDULERTASK) != null) {
                bl = true;
            }
        }
        catch (Exception exception) {
            this.log.error((Object)("error while accessing grouped cache, e:" + exception.getMessage()));
        }
        if (bl) {
            try {
                this.getGroupedCache().remove((Object)string2, LoadBalancingQueue.CACHE_GROUP_TENDERSCHEDULERTASK);
                PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT * from queue WHERE schedulerid=? AND trigger_time=? AND executing=?");
                preparedStatement.setInt(1, n);
                preparedStatement.setLong(2, l);
                preparedStatement.setBoolean(3, new Boolean(true));
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    n2 = 0;
                } else {
                    PreparedStatement preparedStatement2 = this.connection.prepareStatement("UPDATE queue SET queuegate=?,executing=?,machine=?,started=?,started_time=? WHERE schedulerid=? AND trigger_time=?");
                    preparedStatement2.setByte(1, QUEUEGATE_RUNNING);
                    preparedStatement2.setBoolean(2, new Boolean(true));
                    preparedStatement2.setString(3, string);
                    Date date = new Date();
                    preparedStatement2.setTimestamp(4, new Timestamp(date.getTime()));
                    preparedStatement2.setLong(5, date.getTime());
                    preparedStatement2.setInt(6, n);
                    preparedStatement2.setLong(7, l);
                    int n3 = preparedStatement2.executeUpdate();
                    n2 = 1;
                    this.log.debug((Object)("startedIfNotStarted() result:" + n3));
                    preparedStatement2.close();
                    if (n3 > 0) {
                        PreparedStatement preparedStatement3 = this.connection.prepareStatement("SELECT * from queue WHERE schedulerid=? AND trigger_time=?");
                        preparedStatement3.setInt(1, n);
                        preparedStatement3.setLong(2, l);
                        ResultSet resultSet2 = preparedStatement3.executeQuery();
                        LoadBalancingHSQLQueueItem loadBalancingHSQLQueueItem = null;
                        if (resultSet2.next()) {
                            loadBalancingHSQLQueueItem = this.getLBQItem(resultSet2);
                        }
                        this.log.debug((Object)("-----------item.getTimeoutexpiry:" + loadBalancingHSQLQueueItem.getTimeoutexpiry()));
                        if (loadBalancingHSQLQueueItem != null && loadBalancingHSQLQueueItem.getTimeoutexpiry() > 0L) {
                            this.addTimeoutForTask(loadBalancingHSQLQueueItem.getSchedulerid(), loadBalancingHSQLQueueItem.getTrigger_time(), loadBalancingHSQLQueueItem.getStarted().getTime(), loadBalancingHSQLQueueItem.getTimeoutexpiry());
                        }
                    }
                }
                preparedStatement.close();
                resultSet.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.log.error((Object)("Error while moving queued to running:" + exception.getMessage()));
            }
        }
        return n2;
    }

    @Override
    public boolean killQueuedTask(int n, long l) {
        boolean bl = false;
        int n2 = this.removeFromQueue(n, l);
        if (n2 > 0) {
            new SchedulerExePlanLogs(n, l).log("Queued task killed by user", 3001);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int removeFromQueue(int n, long l) {
        int n2 = 0;
        this.acquireLock();
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("DELETE from queue WHERE schedulerid=? AND trigger_time=? AND queuegate=?");
            preparedStatement.setInt(1, n);
            preparedStatement.setLong(2, l);
            preparedStatement.setByte(3, QUEUEGATE_QUEUED);
            n2 = preparedStatement.executeUpdate();
            this.log.debug((Object)("removeFromQueue(): rtn:" + n2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.error((Object)("Error removeFromQueue():" + exception.getMessage()));
        }
        finally {
            this.releaseLock();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int add2DBQueue(LoadBalancingHSQLQueueItem loadBalancingHSQLQueueItem) {
        int n = 0;
        try {
            PreparedStatement preparedStatement;
            PreparedStatement preparedStatement2 = this.connection.prepareStatement("SELECT * from queue WHERE schedulerid=?");
            preparedStatement2.setInt(1, loadBalancingHSQLQueueItem.getSchedulerid());
            ResultSet resultSet = preparedStatement2.executeQuery();
            boolean bl = false;
            if (resultSet.next()) {
                preparedStatement = this.connection.prepareStatement("SELECT * from queue WHERE schedulerid=? AND trigger_time=?");
                preparedStatement.setInt(1, loadBalancingHSQLQueueItem.getSchedulerid());
                preparedStatement.setLong(2, loadBalancingHSQLQueueItem.getTrigger_time());
                ResultSet resultSet2 = preparedStatement.executeQuery();
                if (resultSet2.next()) {
                    n = -2;
                } else if (loadBalancingHSQLQueueItem.getConcurrentexecution() > 1) {
                    PreparedStatement preparedStatement3 = this.connection.prepareStatement("SELECT count(*) thrd from queue WHERE schedulerid=?");
                    preparedStatement3.setInt(1, loadBalancingHSQLQueueItem.getSchedulerid());
                    ResultSet resultSet3 = preparedStatement3.executeQuery();
                    if (resultSet3.next()) {
                        int n2 = resultSet3.getInt("thrd");
                        if (n2 >= loadBalancingHSQLQueueItem.getConcurrentexecution()) {
                            n = -1;
                            bl = false;
                        } else {
                            bl = true;
                        }
                    }
                    resultSet3.close();
                    preparedStatement3.close();
                } else {
                    n = -1;
                    bl = false;
                }
            } else {
                bl = true;
            }
            if (bl) {
                this.log.debug((Object)("adding item:" + loadBalancingHSQLQueueItem.getSchedulerid()));
                this.log.debug((Object)("item last executedDuration:" + loadBalancingHSQLQueueItem.getLastExecutedDuration()));
                this.log.debug((Object)("item timeout expiry:" + loadBalancingHSQLQueueItem.getTimeoutexpiry()));
                preparedStatement = this.connection.prepareStatement("INSERT INTO queue(schedulerid,executing,machine,started,lastExecutedDuration,overlaptimeout,inject_code,timeoutexpiry,trigger_time,nexttrigger_time,started_time,status,taskuid,queuegate,dependentids,dependentchecktime,waitingfordp,started_peers) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                preparedStatement.setInt(1, loadBalancingHSQLQueueItem.getSchedulerid());
                preparedStatement.setBoolean(2, loadBalancingHSQLQueueItem.isExecuting());
                preparedStatement.setString(3, loadBalancingHSQLQueueItem.getMachine());
                if (loadBalancingHSQLQueueItem.getStarted() != null) {
                    preparedStatement.setTimestamp(4, new Timestamp(loadBalancingHSQLQueueItem.getStarted().getTime()));
                } else {
                    preparedStatement.setTimestamp(4, null);
                }
                preparedStatement.setLong(5, loadBalancingHSQLQueueItem.getLastExecutedDuration());
                preparedStatement.setLong(6, loadBalancingHSQLQueueItem.getOverlaptimeout());
                preparedStatement.setString(7, loadBalancingHSQLQueueItem.getInject_code());
                preparedStatement.setLong(8, loadBalancingHSQLQueueItem.getTimeoutexpiry());
                preparedStatement.setLong(9, loadBalancingHSQLQueueItem.getTrigger_time());
                preparedStatement.setLong(10, loadBalancingHSQLQueueItem.getNexttrigger_time());
                preparedStatement.setLong(11, loadBalancingHSQLQueueItem.getStarted_time());
                preparedStatement.setString(12, loadBalancingHSQLQueueItem.getStatus());
                preparedStatement.setString(13, loadBalancingHSQLQueueItem.getTaskuid());
                if (loadBalancingHSQLQueueItem.getQueuegate() == null) {
                    preparedStatement.setByte(14, QUEUEGATE_QUEUED);
                } else {
                    preparedStatement.setByte(14, loadBalancingHSQLQueueItem.getQueuegate());
                }
                preparedStatement.setString(15, loadBalancingHSQLQueueItem.getDependentids());
                preparedStatement.setString(16, loadBalancingHSQLQueueItem.getDependentchecktime());
                preparedStatement.setBoolean(17, loadBalancingHSQLQueueItem.isWaitingfordp());
                preparedStatement.setString(18, loadBalancingHSQLQueueItem.getStarted_peers());
                preparedStatement.executeUpdate();
                n = 1;
            }
            preparedStatement2.close();
            resultSet.close();
            if (timer == null) {
                this.startTimer();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.error((Object)("Error adding to db, Error:" + exception.getMessage()));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeItemProcessing(LoadBalancingQueueItem loadBalancingQueueItem, String string, int n) {
        if (loadBalancingQueueItem instanceof LoadBalancingHSQLQueueItem) {
            LoadBalancingHSQLQueueItem loadBalancingHSQLQueueItem = (LoadBalancingHSQLQueueItem)loadBalancingQueueItem;
            if (string != null) {
                new SchedulerExePlanLogs(loadBalancingHSQLQueueItem.getSchedulerid(), loadBalancingHSQLQueueItem.getTrigger_time()).log(string, n);
            }
            this.acquireLock();
            try {
                PreparedStatement preparedStatement = this.connection.prepareStatement("DELETE from queue WHERE schedulerid=? AND trigger_time=? AND queuegate=?");
                preparedStatement.setInt(1, loadBalancingHSQLQueueItem.getSchedulerid());
                preparedStatement.setLong(2, loadBalancingHSQLQueueItem.getTrigger_time());
                preparedStatement.setByte(3, QUEUEGATE_RUNNING);
                int n2 = preparedStatement.executeUpdate();
                if (n2 == 0) {
                    this.log.error((Object)("item scd_id:" + loadBalancingHSQLQueueItem.getSchedulerid() + " trig_time:" + loadBalancingHSQLQueueItem.getTrigger_time() + " not found in the running queue"));
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.log.error((Object)("Error removeFromQueue():" + exception.getMessage()));
            }
            finally {
                this.releaseLock();
            }
            this.removeTimeoutForTask(loadBalancingHSQLQueueItem.getSchedulerid(), loadBalancingHSQLQueueItem.getTrigger_time());
            Debugger.addDebugMsg("script id:" + loadBalancingHSQLQueueItem.getSchedulerid() + " executing finishing removing form LB executing Queue", loadBalancingHSQLQueueItem.getSchedulerid() + "");
            this.log.debug((Object)("removing from processing Q schedueler_id:" + loadBalancingHSQLQueueItem.getSchedulerid()));
        }
    }

    protected void removeDependencyTimedout(int n, long l) throws Exception {
        PreparedStatement preparedStatement = this.connection.prepareStatement("DELETE from queue WHERE schedulerid=? AND trigger_time=?");
        preparedStatement.setInt(1, n);
        preparedStatement.setLong(2, l);
        preparedStatement.executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeFaultyProcessingTask(int n, long l) {
        boolean bl = false;
        this.acquireLock();
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("DELETE from queue WHERE schedulerid=? AND trigger_time=? AND queuegate=?");
            preparedStatement.setInt(1, n);
            preparedStatement.setLong(2, l);
            preparedStatement.setByte(3, QUEUEGATE_RUNNING);
            int n2 = preparedStatement.executeUpdate();
            if (n2 > 0) {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.error((Object)("Error removeFromQueue():" + exception.getMessage()));
        }
        finally {
            this.releaseLock();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void executionFailed(int n, long l, String string) {
        this.acquireLock();
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("UPDATE queue SET queuegate=?,executing=?,machine=? WHERE schedulerid=? AND trigger_time=?");
            preparedStatement.setByte(1, QUEUEGATE_QUEUED);
            preparedStatement.setBoolean(2, new Boolean(false));
            preparedStatement.setString(3, null);
            preparedStatement.setLong(4, n);
            preparedStatement.setLong(5, l);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.error((Object)("Error executionFailed():" + exception.getMessage()));
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void peerStarted(int n, long l, String string) throws Exception {
        this.acquireLock();
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT * from queue WHERE schedulerid=? AND trigger_time=?");
            preparedStatement.setInt(1, n);
            preparedStatement.setLong(2, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                String string2 = resultSet.getString("started_peers");
                if (string2 != null) {
                    this.log.error((Object)("The task " + n + " trigger_time" + l + " is already started on " + string2));
                }
                string2 = string2 != null && !string2.equals("") ? string2 + "," + string : string;
                PreparedStatement preparedStatement2 = this.connection.prepareStatement("UPDATE queue SET started_peers=? WHERE schedulerid=? AND trigger_time=?");
                preparedStatement2.setString(1, string2);
                preparedStatement2.setInt(2, n);
                preparedStatement2.setLong(3, l);
                preparedStatement2.executeUpdate();
                preparedStatement2.close();
            }
            preparedStatement.close();
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.error((Object)("Error executionFailed():" + exception.getMessage()));
        }
        finally {
            this.releaseLock();
        }
    }

    @Override
    public void executionEnded(int n, long l) {
        LoadBalancingQueueItem loadBalancingQueueItem = this.getItemFromProcessingQueue(n, l);
        this.removeItemProcessing(loadBalancingQueueItem, null, 2001);
        this.lastExcecutedTime = new Date().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoadBalancingQueueItem getItemFromProcessingQueue(int n, long l) {
        this.acquireLock();
        LoadBalancingHSQLQueueItem loadBalancingHSQLQueueItem = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT * from queue WHERE schedulerid=? AND trigger_time=?");
            preparedStatement.setInt(1, n);
            preparedStatement.setLong(2, l);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                loadBalancingHSQLQueueItem = this.getLBQItem(resultSet);
            }
            preparedStatement.close();
            resultSet.close();
        }
        catch (Exception exception) {
            this.log.error((Object)("Error getItemFromProcessingQueue() " + exception.getMessage()));
        }
        finally {
            this.releaseLock();
        }
        return loadBalancingHSQLQueueItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LoadBalancingHSQLQueueItem getItemFromQueue(int n) {
        this.acquireLock();
        LoadBalancingHSQLQueueItem loadBalancingHSQLQueueItem = null;
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT * from queue WHERE schedulerid=?");
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                loadBalancingHSQLQueueItem = this.getLBQItem(resultSet);
            }
            preparedStatement.close();
            resultSet.close();
        }
        catch (Exception exception) {
            this.log.error((Object)("Error getItemFromQueue() " + exception.getMessage()));
        }
        finally {
            this.releaseLock();
        }
        return loadBalancingHSQLQueueItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LoadBalancingHSQLQueueItem> getItemsFromQueue(int n) {
        this.acquireLock();
        ArrayList<LoadBalancingHSQLQueueItem> arrayList = new ArrayList<LoadBalancingHSQLQueueItem>();
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement("SELECT * from queue WHERE schedulerid=?");
            preparedStatement.setInt(1, n);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                LoadBalancingHSQLQueueItem loadBalancingHSQLQueueItem = this.getLBQItem(resultSet);
                arrayList.add(loadBalancingHSQLQueueItem);
            }
            preparedStatement.close();
            resultSet.close();
        }
        catch (Exception exception) {
            this.log.error((Object)("Error getItemFromQueue() " + exception.getMessage()));
        }
        finally {
            this.releaseLock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<LoadBalancingQueueItem> getTasks(String string) {
        ArrayList<LoadBalancingQueueItem> arrayList = new ArrayList<LoadBalancingQueueItem>();
        this.acquireLock();
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                try {
                    LoadBalancingHSQLQueueItem loadBalancingHSQLQueueItem = this.getLBQItem(resultSet);
                    arrayList.add(loadBalancingHSQLQueueItem);
                }
                catch (Exception exception) {
                    this.log.error((Object)("error while processing row, error:" + exception.getMessage()));
                }
            }
            preparedStatement.close();
            resultSet.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.error((Object)("getTasks...e:" + exception.getMessage()));
        }
        finally {
            this.releaseLock();
        }
        return arrayList;
    }

    public ArrayList<LoadBalancingQueueItem> getAllTasks() {
        return this.getTasks("SELECT * from queue ORDER BY trigger_time");
    }

    @Override
    public Collection<LoadBalancingQueueItem> getExecutingTasks() {
        return this.getTasks("SELECT * from queue WHERE queuegate=" + QUEUEGATE_RUNNING + " ORDER BY trigger_time");
    }

    @Override
    public Collection<LoadBalancingQueueItem> getQueuedTasks() {
        return this.getTasks("SELECT * from queue WHERE queuegate=" + QUEUEGATE_QUEUED + " ORDER BY trigger_time");
    }

    @Override
    public void cleanupProccesingQueue(int n, String string) {
    }

    protected LoadBalancingHSQLQueueItem getLBQItem(ResultSet resultSet) throws Exception {
        Object object;
        LoadBalancingHSQLQueueItem loadBalancingHSQLQueueItem = new LoadBalancingHSQLQueueItem();
        loadBalancingHSQLQueueItem.setId(resultSet.getInt("id"));
        loadBalancingHSQLQueueItem.setSchedulerid(resultSet.getInt("schedulerid"));
        loadBalancingHSQLQueueItem.setExecuting(resultSet.getBoolean("executing"));
        loadBalancingHSQLQueueItem.setMachine(resultSet.getString("machine"));
        if (resultSet.getTimestamp("started") != null) {
            object = new Date(resultSet.getTimestamp("started").getTime());
            loadBalancingHSQLQueueItem.setStarted((Date)object);
        }
        loadBalancingHSQLQueueItem.setLastExecutedDuration(resultSet.getLong("lastExecutedDuration"));
        loadBalancingHSQLQueueItem.setOverlaptimeout(resultSet.getLong("overlaptimeout"));
        loadBalancingHSQLQueueItem.setInject_code(resultSet.getString("inject_code"));
        loadBalancingHSQLQueueItem.setTimeoutexpiry(resultSet.getLong("timeoutexpiry"));
        loadBalancingHSQLQueueItem.setTrigger_time(resultSet.getLong("trigger_time"));
        loadBalancingHSQLQueueItem.setNexttrigger_time(resultSet.getLong("nexttrigger_time"));
        loadBalancingHSQLQueueItem.setStarted_time(resultSet.getLong("started_time"));
        loadBalancingHSQLQueueItem.setStatus(resultSet.getString("status"));
        loadBalancingHSQLQueueItem.setTaskuid(resultSet.getString("taskuid"));
        loadBalancingHSQLQueueItem.setQueuegate(resultSet.getByte("queuegate"));
        loadBalancingHSQLQueueItem.setDependentids(resultSet.getString("dependentids"));
        loadBalancingHSQLQueueItem.setDependentchecktime(resultSet.getString("dependentchecktime"));
        loadBalancingHSQLQueueItem.setWaitingfordp(resultSet.getBoolean("waitingfordp"));
        loadBalancingHSQLQueueItem.setStarted_peers(resultSet.getString("started_peers"));
        object = new ScheduledTaskFactory().getTask(loadBalancingHSQLQueueItem.getTaskuid());
        StackFrame stackFrame = new StackFrame((ScheduledTask)object, new HashMap());
        stackFrame.setTrigger_time(loadBalancingHSQLQueueItem.getTrigger_time());
        stackFrame.setNexttrigger_time(loadBalancingHSQLQueueItem.getNexttrigger_time());
        stackFrame.setStarted_time(loadBalancingHSQLQueueItem.getStarted_time());
        loadBalancingHSQLQueueItem.setSf(stackFrame);
        return loadBalancingHSQLQueueItem;
    }

    private String createSchemaQuery() {
        String string = "CREATE TABLE queue(";
        string = string + " id IDENTITY,";
        string = string + " schedulerid BIGINT,";
        string = string + " executing BIT,";
        string = string + " machine VARCHAR(250),";
        string = string + " started DATETIME,";
        string = string + " lastExecutedDuration BIGINT, ";
        string = string + " overlaptimeout BIGINT, ";
        string = string + " inject_code VARCHAR(250),";
        string = string + " timeoutexpiry BIGINT, ";
        string = string + " trigger_time BIGINT, ";
        string = string + " nexttrigger_time  BIGINT,";
        string = string + " started_time BIGINT, ";
        string = string + " status VARCHAR(250),";
        string = string + " lastTenderTime BIGINT, ";
        string = string + " taskuid VARCHAR(250), ";
        string = string + " queuegate TINYINT, ";
        string = string + " dependentids VARCHAR(250), ";
        string = string + " dependentchecktime VARCHAR(250), ";
        string = string + " started_peers VARCHAR(250), ";
        string = string + " waitingfordp BIT ";
        string = string + ")";
        return string;
    }

    private static String collectStack(StackTraceElement[] stackTraceElementArray) throws Exception {
        int n;
        String string = "";
        int n2 = 0;
        for (n = 0; n < stackTraceElementArray.length; ++n) {
            if (!stackTraceElementArray[n].getClassName().startsWith("com.fe.")) continue;
            n2 = n;
        }
        n = 2;
        n2 = n2 > n ? n2 - n : 0;
        int n3 = 1;
        for (int i = n2; i < stackTraceElementArray.length; ++i) {
            if (i > n2 + n && !stackTraceElementArray[i].getClassName().startsWith("com.fe.")) continue;
            String string2 = "";
            for (int j = 0; j < n3; ++j) {
                string2 = string2 + " ";
            }
            ++n3;
            if (stackTraceElementArray[i].getClassName().startsWith("com.fe.")) {
                string2 = string2 + "->";
            }
            string = string + string2 + "" + stackTraceElementArray[i].getClassName() + "." + stackTraceElementArray[i].getMethodName() + "()" + nextLineChar;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LoadBalancingHSQLQueueItem> getRunningButNotOnPeer(List<String> list) {
        ArrayList<LoadBalancingHSQLQueueItem> arrayList = new ArrayList<LoadBalancingHSQLQueueItem>();
        this.acquireLock();
        try {
            String string = "";
            for (String object : list) {
                string = string + (string.equals("") ? "'" + object + "'" : ",'" + object + "'");
            }
            if (!string.equals("")) {
                String string2 = "SELECT * from queue WHERE cast(schedulerid AS VARCHAR(24))||'_'||CAST(trigger_time AS VARCHAR(25))  NOT IN (" + string + ") and queuegate=? AND started<dateadd('minute',-1,LOCALTIMESTAMP)";
                PreparedStatement preparedStatement = this.connection.prepareStatement(string2);
                preparedStatement.setByte(1, QUEUEGATE_RUNNING);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    LoadBalancingHSQLQueueItem loadBalancingHSQLQueueItem = this.getLBQItem(resultSet);
                    arrayList.add(loadBalancingHSQLQueueItem);
                }
                resultSet.close();
                preparedStatement.close();
            }
        }
        catch (Exception exception) {
            this.log.error((Object)("getRunningButNotOnPeer() Error:" + exception.getMessage()));
        }
        finally {
            this.releaseLock();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LoadBalancingHSQLQueueItem> getRunningMoreThan3Mins() {
        ArrayList<LoadBalancingHSQLQueueItem> arrayList = new ArrayList<LoadBalancingHSQLQueueItem>();
        this.acquireLock();
        try {
            String string = "SELECT * from queue WHERE queuegate=? AND started<dateadd('minute',-3,LOCALTIMESTAMP)";
            PreparedStatement preparedStatement = this.connection.prepareStatement(string);
            preparedStatement.setByte(1, QUEUEGATE_RUNNING);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                LoadBalancingHSQLQueueItem loadBalancingHSQLQueueItem = this.getLBQItem(resultSet);
                arrayList.add(loadBalancingHSQLQueueItem);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception exception) {
            this.log.error((Object)("getRunningButNotOnPeer() Error:" + exception.getMessage()));
        }
        finally {
            this.releaseLock();
        }
        return arrayList;
    }

    private void startTimer() {
        timer = new Timer();
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    LoadBalancingHSQLLayerDB.calculateQueueAndAlertTraffic();
                }
                catch (Exception exception) {
                    LoadBalancingHSQLLayerDB.this.log.error((Object)("Error " + exception.getMessage()));
                }
            }
        };
        timer.schedule(timerTask, 60000L, 60000L);
    }

    public static void setAlertRange(Map<String, String> map) {
        alert_range = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void calculateQueueAndAlertTraffic() throws Exception {
        Collection<LoadBalancingQueueItem> collection = LoadBalancingQueue.getHSQLQueue().getQueuedTasks();
        if (alert_range != null && LoadBalancingHSQLLayerDB.getOwnCache().get((Object)"alerted") == null && collection.size() > 0) {
            LoadBalancingQueueTimeout loadBalancingQueueTimeout;
            Object object;
            Long l;
            Serializable serializable;
            Object object2;
            task_stat_max_waiting.clear();
            for (LoadBalancingHSQLQueueItem object32 : collection) {
                if (object32.getDependentids() != null) continue;
                object2 = object32.getTaskuid();
                serializable = Long.valueOf(new Date().getTime() - object32.getTrigger_time());
                if (task_stat_max_waiting.containsKey(object2)) {
                    serializable = task_stat_max_waiting.get(object2) > (Long)serializable ? task_stat_max_waiting.get(object2) : serializable;
                }
                task_stat_max_waiting.put((String)object2, (Long)serializable);
            }
            Object object4 = "";
            ScheduledTaskFactory scheduledTaskFactory = new ScheduledTaskFactory();
            object2 = new SimpleDateFormat("HH:mm:ss 'Hrs'");
            ((DateFormat)object2).setTimeZone(TimeZone.getTimeZone("GMT"));
            serializable = new SimpleDateFormat("mm:ss 'Mins'");
            ((DateFormat)serializable).setTimeZone(TimeZone.getTimeZone("GMT"));
            Date date = new Date();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : alert_range.keySet()) {
                l = null;
                try {
                    l = Long.parseLong(alert_range.get(string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (l == null || !task_stat_max_waiting.containsKey(string) || task_stat_max_waiting.get(string) <= l * 1000L * 60L) continue;
                object = scheduledTaskFactory.getTask(string);
                date.setTime(task_stat_max_waiting.get(string));
                object4 = task_stat_max_waiting.get(string) >= 3600000L ? (String)object4 + ((ScheduledTask)object).getName() + "(" + ((DateFormat)object2).format(date) + ") " : (String)object4 + ((ScheduledTask)object).getName() + "(" + ((DateFormat)serializable).format(date) + ") ";
                arrayList.add(((ScheduledTask)object).getUniqueid());
                loadBalancingQueueTimeout = LoadBalancingHSQLLayerDB.getOwnCache().getDefaultElementAttributes();
                loadBalancingQueueTimeout.setMaxLifeSeconds(ALERT_FREQUENCY_MINUTES * 60);
                LoadBalancingHSQLLayerDB.getOwnCache().put((Object)"alerted", (Object)"alerted", (IElementAttributes)loadBalancingQueueTimeout);
            }
            if (!((String)object4).equals("")) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("hh:mm:ss a");
                object4 = (String)object4 + "<div style='height:10px; background-color:#c0c0c0;text-align:center;margin:20px 0px 0px 0px;'>Screen shot at " + simpleDateFormat.format(new Date()) + "</div>";
                ResourceBundle resourceBundle = ResourceBundle.getBundle("com.fe.scheduler.scheduleralert");
                l = Logger.getLogger(LoadBalancingHSQLLayerDB.class);
                l.debug("---******00000--->Alerting queue jammed, bodymsg:" + (String)object4);
                object = SchedulerDB.getSchedulerDB();
                try {
                    ((SuperDB)object).connectDB(BBSyncMgmt.getDBName());
                    loadBalancingQueueTimeout = new LoadBalancingQueueTimeout((SchedulerDB)object, scheduledTaskFactory.getTaskUids());
                    String string = loadBalancingQueueTimeout.getAlert_theme();
                    String string2 = loadBalancingQueueTimeout.getAlert_type();
                    String string3 = resourceBundle.getString("screenshot.folder.link");
                    String string4 = resourceBundle.getString("alert.subject");
                    String string5 = null;
                    try {
                        string5 = LoadBalancingHSQLLayerDB.captureQueue(arrayList);
                        if (string5 != null) {
                            string5 = string3 + string5 + ".png";
                        }
                        l.debug("filename:" + string5);
                    }
                    catch (Exception exception) {
                        object4 = (String)object4 + "<small>Couldn't capture screenshot, Error:" + exception.getMessage() + "</small>";
                    }
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.add(string);
                    SchedulerAlert.alert(arrayList2, string2, string4, (String)object4, string5, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                finally {
                    ((SuperDB)object).closeDB();
                }
            }
        }
    }

    private static String captureQueue(List<String> list) throws Exception {
        String string;
        String string22;
        Logger logger = Logger.getLogger(LoadBalancingHSQLLayerDB.class);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.fe.scheduler.scheduleralert");
        String string3 = null;
        for (String string22 : list) {
            string3 = string3 == null ? string22 : string3 + "," + string22;
        }
        String string4 = new RandomString(10).nextString();
        string22 = resourceBundle.getString("casper.commandfile");
        String string5 = resourceBundle.getString("script.queue_capture");
        String string6 = resourceBundle.getString("screenshot.folder");
        String string7 = resourceBundle.getString("scheduler.url");
        String string8 = resourceBundle.getString("ssh.enable");
        String string9 = resourceBundle.getString("ssh.ipaddress");
        String string10 = null;
        if (string8.equalsIgnoreCase("true")) {
            String string11;
            string = string22 + " " + string5 + " --filename=" + string6 + (String)string4 + " --group=" + string3 + " --url=" + string7;
            JSch jSch = new JSch();
            JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
            jSch.addIdentity("/root/.ssh/id_dsa");
            Session session = jSch.getSession("root", string9, 22);
            session.connect();
            ChannelExec channelExec = (ChannelExec)session.openChannel("exec");
            channelExec.setCommand(string);
            channelExec.setInputStream(null);
            channelExec.setErrStream((OutputStream)System.err);
            InputStream inputStream = channelExec.getInputStream();
            channelExec.connect();
            string10 = "";
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string11 = bufferedReader.readLine()) != null) {
                string10 = string10 + string11 + (string10.equals("") ? "" : "\n");
            }
            channelExec.disconnect();
            session.disconnect();
        } else {
            Object object;
            string = string22 + " " + string5 + " --filename=" + string6 + (String)string4 + " --group=" + string3 + " --url=" + string7;
            BufferedReader bufferedReader = null;
            try {
                object = Runtime.getRuntime();
                Process process = ((Runtime)object).exec(string);
                bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw exception;
            }
            string10 = "";
            while ((object = bufferedReader.readLine()) != null) {
                string10 = string10 + (String)object + (string10.equals("") ? "" : "\n");
            }
        }
        logger.debug((Object)("command:" + string));
        if (string10.contains("queue captured")) {
            return string4;
        }
        logger.error((Object)("couldn't capture screenshot, casperjs reports:" + string10));
        throw new Exception("Captured output:" + string10);
    }

    private static String captureQueue_old(List<String> list) throws Exception {
        Object object;
        Object object2;
        String string3;
        Logger logger = Logger.getLogger(LoadBalancingHSQLLayerDB.class);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.fe.scheduler.scheduleralert");
        String string2 = null;
        for (String string3 : list) {
            string2 = string2 == null ? string3 : string2 + "," + string3;
        }
        String string4 = new RandomString(10).nextString();
        string3 = resourceBundle.getString("casper.commandfile");
        String string5 = resourceBundle.getString("script.queue_capture");
        String string6 = resourceBundle.getString("screenshot.folder");
        String string7 = resourceBundle.getString("scheduler.url");
        String string8 = resourceBundle.getString("ssh.enable");
        String string9 = resourceBundle.getString("ssh.ipaddress");
        String string10 = string8.equalsIgnoreCase("true") ? "ssh " + string9 + " -x '" + string3 + " " + string5 + " --filename=" + string6 + (String)string4 + " --group=" + string2 + " --url=" + string7 + "'" : string3 + " " + string5 + " --filename=" + string6 + (String)string4 + " --group=" + string2 + " --url=" + string7;
        logger.debug((Object)("command:" + string10));
        System.out.println("LoadBalancingHSQLLayerDB.captureQueue() (java) command:" + string10);
        BufferedReader bufferedReader = null;
        try {
            object2 = Runtime.getRuntime();
            object = ((Runtime)object2).exec(string10);
            bufferedReader = new BufferedReader(new InputStreamReader(((Process)object).getInputStream()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        object = "";
        while ((object2 = bufferedReader.readLine()) != null) {
            object = (String)object + "\n" + (String)object2;
        }
        logger.debug((Object)("captureQueue():::content:" + (String)object));
        if (((String)object).contains("queue captured")) {
            return string4;
        }
        logger.error((Object)("couldn't capture screenshot, casperjs reports:" + (String)object));
        throw new Exception("Captured output:" + (String)object);
    }

    private static JCS getOwnCache() throws Exception {
        if (cache == null) {
            cache = JCS.getInstance((String)WaitingQueueList.class.getName());
        }
        return cache;
    }
}

