/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.peer;

import com.fe.Config;
import com.fe.client.BBSyncMgmt;
import com.fe.db.SchedulerDB;
import com.fe.p2p.P2PService;
import com.fe.p2p.peer.PeerSpecificConfigurations;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.ScheduledTaskFactory;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.peer.QueueAbstract;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class QueueFactory {
    private static TreeMap queueHandlers = new TreeMap();
    public static String KEY_STARTED_TIME = "started_time";
    public static String KEY_TRIGGER_TIME = "trigger_time";
    public static String KEY_SCHEDULER_ID = "scheduler_id";
    public static String KEY_CURRENT_TIME = "current_time";
    public static String KEY_TASK_NAME = "name";
    private static final int NUM_SIMULTANEOUS_CONN = 10;
    protected static boolean restartRequested = false;
    private Logger log = Logger.getLogger(QueueFactory.class);

    public QueueFactory() {
        if (queueHandlers.size() == 0) {
            this.initQueue();
        }
    }

    public QueueAbstract getQueue(String string) {
        return (QueueAbstract)queueHandlers.get(string);
    }

    public TreeMap getQueue() {
        return queueHandlers;
    }

    public static void setRestartRequested() {
        restartRequested = true;
    }

    public int countExcTasksInPeer() {
        int n = 0;
        for (QueueAbstract queueAbstract : queueHandlers.values()) {
            if (queueAbstract.getExecutingStacksSize() <= 0) continue;
            n += queueAbstract.getExecutingStacksSize();
        }
        return n;
    }

    public Vector getExecutingIDs() {
        Vector vector = new Vector();
        for (QueueAbstract queueAbstract : queueHandlers.values()) {
            Object[] objectArray = queueAbstract.getExecutingStacks();
            for (int i = 0; i < objectArray.length; ++i) {
                StackFrame stackFrame = (StackFrame)objectArray[i];
                if (stackFrame.getData() == null || vector.contains(stackFrame.getData().get("id"))) continue;
                vector.add(stackFrame.getData().get("id"));
            }
        }
        return vector;
    }

    public Vector getExecutingTasksData() {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        for (QueueAbstract queueAbstract : queueHandlers.values()) {
            Object[] objectArray = queueAbstract.getExecutingStacks();
            for (int i = 0; i < objectArray.length; ++i) {
                StackFrame stackFrame = (StackFrame)objectArray[i];
                if (stackFrame.getData() == null || vector.contains(stackFrame.getData().get("id"))) continue;
                vector.add(stackFrame.getData().get("id"));
                HashMap hashMap = new HashMap();
                hashMap.put(KEY_SCHEDULER_ID, stackFrame.getData().get("id"));
                hashMap.put(KEY_STARTED_TIME, stackFrame.getStarted_time());
                hashMap.put(KEY_TRIGGER_TIME, stackFrame.getTrigger_time());
                hashMap.put(KEY_TASK_NAME, stackFrame.getData().get("name"));
                hashMap.put(KEY_CURRENT_TIME, new Date().getTime());
                vector2.add(hashMap);
            }
        }
        return vector2;
    }

    public Map<String, String> getExecutingIDAndSTimes() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (QueueAbstract queueAbstract : queueHandlers.values()) {
            Object[] objectArray = queueAbstract.getExecutingStacks();
            for (int i = 0; i < objectArray.length; ++i) {
                StackFrame stackFrame = (StackFrame)objectArray[i];
                if (stackFrame.getData() == null) continue;
                treeMap.put(stackFrame.getData().get("id") + "", stackFrame.getTrigger_time() + "");
            }
        }
        return treeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initQueue() {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.removeAllPeerThreadStatus(P2PService.getComputerName());
        }
        catch (Exception exception) {
        }
        finally {
            try {
                schedulerDB.closeDB();
            }
            catch (Exception exception) {}
        }
        QueueAbstract queueAbstract = new QueueAbstract("rserv"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Vector getTaskUids() {
                Vector<String> vector = new Vector<String>();
                SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
                try {
                    schedulerDB.connectDB(BBSyncMgmt.getDBName());
                    Vector vector2 = schedulerDB.getGroups("rscript4rserve");
                    for (Map map : vector2) {
                        String string = (String)map.get("taskuid");
                        vector.add(string);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        schedulerDB.closeDB();
                    }
                    catch (Exception exception) {}
                }
                return vector;
            }

            @Override
            public int getConcurrentThreads() {
                if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    return 1;
                }
                int n = 10;
                try {
                    if (Config.getValue("rserve.thread.size") != null) {
                        n = Integer.parseInt(Config.getValue("rserve.thread.size").trim());
                        QueueFactory.this.log.debug((Object)("group rscript4rserve found peer specific thread size, currently" + n));
                    }
                }
                catch (Exception exception) {
                    System.out.println("QueueFactory.initQueue() Error:" + exception.getMessage());
                }
                return n;
            }
        };
        this.add2Qhandler(queueAbstract);
        QueueAbstract queueAbstract2 = new QueueAbstract("rservunix"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Vector getTaskUids() {
                Vector<String> vector = new Vector<String>();
                vector.add("direct_script_unix");
                SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
                try {
                    schedulerDB.connectDB(BBSyncMgmt.getDBName());
                    Vector vector2 = schedulerDB.getGroups("rscript4rserveunix");
                    for (Map map : vector2) {
                        String string = (String)map.get("taskuid");
                        vector.add(string);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        schedulerDB.closeDB();
                    }
                    catch (Exception exception) {}
                }
                return vector;
            }

            @Override
            public int getConcurrentThreads() {
                int n = 10;
                try {
                    String string = PeerSpecificConfigurations.getProperties().getProperty("rserve.concurrent.sessions");
                    if (string != null && !string.trim().equals("")) {
                        n = Integer.parseInt(string);
                    }
                }
                catch (Exception exception) {
                    System.out.println("QueueFactory.initQueue() Error:" + exception.getMessage());
                }
                return n;
            }
        };
        this.add2Qhandler(queueAbstract2);
        QueueAbstract queueAbstract3 = new QueueAbstract("rscript"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Vector getTaskUids() {
                Vector<String> vector = new Vector<String>();
                vector.add("direct_script");
                SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
                try {
                    schedulerDB.connectDB(BBSyncMgmt.getDBName());
                    Vector vector2 = schedulerDB.getGroups("rscript");
                    for (Map map : vector2) {
                        String string = (String)map.get("taskuid");
                        if (string == null) continue;
                        vector.add(string);
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        schedulerDB.closeDB();
                    }
                    catch (Exception exception) {}
                }
                return vector;
            }

            @Override
            public int getConcurrentThreads() {
                return 1;
            }
        };
        this.add2Qhandler(queueAbstract3);
        QueueAbstract queueAbstract4 = new QueueAbstract("othercripts"){

            @Override
            public Vector getTaskUids() {
                Vector<String> vector = new Vector<String>();
                List<ScheduledTask> list = new ScheduledTaskFactory().getAllConfiguredTasks();
                for (ScheduledTask scheduledTask : list) {
                    if (queueHandlers.containsKey(scheduledTask.getUniqueid())) continue;
                    vector.add(scheduledTask.getUniqueid());
                }
                return vector;
            }

            @Override
            public int getConcurrentThreads() {
                return 1;
            }
        };
        this.add2Qhandler(queueAbstract4);
    }

    private void add2Qhandler(QueueAbstract queueAbstract) {
        Iterator iterator = queueAbstract.getTaskUids().iterator();
        while (iterator.hasNext()) {
            queueHandlers.put(iterator.next(), queueAbstract);
        }
    }
}

