/*
 * Decompiled with CFR 0.152.
 */
package com.fe.servlet;

import com.fe.client.Authenticated;
import com.fe.client.BBSyncMgmt;
import com.fe.db.BBSyncDB;
import com.fe.p2p.P2PService;
import com.fe.p2p.P2PServiceServlet;
import com.fe.scheduler.balance.ExecutingQueueCleaner;
import java.util.Date;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.log4j.Logger;

public class P2PServletContextListener
implements ServletContextListener,
HttpSessionListener,
ServletRequestListener {
    private static long sessionid = 0L;
    private Logger log = Logger.getLogger(P2PServletContextListener.class);
    private static final String ATTRIBUTE_NAME = "com.example.SessionCounter";
    private static ConcurrentLinkedQueue<HttpSession> sessions = new ConcurrentLinkedQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
        try {
            bBSyncDB.connectDB(BBSyncMgmt.getDBName());
            bBSyncDB.peerStopped(P2PService.getComputerName(), sessionid, new Date());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                bBSyncDB.closeDB();
            }
            catch (Exception exception) {}
        }
        System.out.println("~~~~~~~~~~~~cleaning and stopping all running services.....");
        new P2PServiceServlet().destroy();
        ExecutingQueueCleaner.stop();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        sessionid = new Date().getTime();
        BBSyncDB bBSyncDB = BBSyncDB.getBBSyncDB();
        try {
            bBSyncDB.connectDB(BBSyncMgmt.getDBName());
            bBSyncDB.peerStarted(P2PService.getComputerName(), sessionid, new Date());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                bBSyncDB.closeDB();
            }
            catch (Exception exception) {}
        }
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        sessions.add(httpSession);
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        String string = (String)httpSession.getAttribute(Authenticated.REMOTE_IP);
        this.log.debug((Object)("Session before destroyed:" + sessions.size()));
        sessions.remove(httpSession);
        this.log.debug((Object)("Session after destroyed:" + sessions.size()));
    }

    public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
    }

    public void requestInitialized(ServletRequestEvent servletRequestEvent) {
    }

    public static ConcurrentLinkedQueue<HttpSession> getSessions() {
        return sessions;
    }

    public static HttpSession getActiveSessions(String string) {
        HttpSession httpSession = null;
        for (HttpSession httpSession2 : P2PServletContextListener.getSessions()) {
            if (httpSession2.getAttribute("session^logged^user") == null || !httpSession2.getAttribute("session^logged^user").equals(string)) continue;
            httpSession = httpSession2;
        }
        return httpSession;
    }
}

