/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.indexed;

import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.disk.AbstractDiskCache;
import org.apache.jcs.auxiliary.disk.LRUMapJCS;
import org.apache.jcs.auxiliary.disk.indexed.IndexedDisk;
import org.apache.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.jcs.auxiliary.disk.indexed.IndexedDiskElementDescriptor;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.control.group.GroupAttrName;
import org.apache.jcs.engine.control.group.GroupId;
import org.apache.jcs.engine.logging.behavior.ICacheEvent;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;
import org.apache.jcs.utils.struct.SortedPreferentialArray;
import org.apache.jcs.utils.timing.ElapsedTimer;

public class IndexedDiskCache
extends AbstractDiskCache {
    private static final long serialVersionUID = -265035607729729629L;
    private static final Log log = LogFactory.getLog((Class)IndexedDiskCache.class);
    private final String logCacheName;
    private String fileName;
    private IndexedDisk dataFile;
    private IndexedDisk keyFile;
    private Map keyHash;
    private int maxKeySize;
    private File rafDir;
    boolean doRecycle = true;
    boolean isRealTimeOptimizationEnabled = true;
    boolean isShutdownOptimizationEnabled = true;
    boolean isOptimizing = false;
    private int timesOptimized = 0;
    private volatile Thread currentOptimizationThread;
    private int removeCount = 0;
    private boolean queueInput = false;
    private LinkedList queuedPutList = new LinkedList();
    private SortedPreferentialArray recycle;
    private IndexedDiskCacheAttributes cattr;
    private int recycleCnt = 0;
    private int startupSize = 0;
    private long bytesFree = 0L;
    private int hitCount = 0;
    protected ReentrantWriterPreferenceReadWriteLock storageLock = new ReentrantWriterPreferenceReadWriteLock();

    public IndexedDiskCache(IndexedDiskCacheAttributes cacheAttributes) {
        this(cacheAttributes, null);
    }

    public IndexedDiskCache(IndexedDiskCacheAttributes cattr, IElementSerializer elementSerializer) {
        super(cattr);
        this.setElementSerializer(elementSerializer);
        this.cattr = cattr;
        this.maxKeySize = cattr.getMaxKeySize();
        this.isRealTimeOptimizationEnabled = cattr.getOptimizeAtRemoveCount() > 0;
        this.isShutdownOptimizationEnabled = cattr.isOptimizeOnShutdown();
        this.logCacheName = "Region [" + this.getCacheName() + "] ";
        this.fileName = this.getCacheName();
        try {
            this.initializeFileSystem(cattr);
            this.initializeKeysAndData(cattr);
            this.initializeRecycleBin();
            this.alive = true;
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Indexed Disk Cache is alive."));
            }
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Failure initializing for fileName: " + this.fileName + " and directory: " + this.rafDir.getAbsolutePath()), (Throwable)e);
        }
        if (this.isRealTimeOptimizationEnabled && this.keyHash.size() > 0) {
            this.doOptimizeRealTime();
        }
    }

    private void initializeFileSystem(IndexedDiskCacheAttributes cattr) {
        String rootDirName = cattr.getDiskPath();
        this.rafDir = new File(rootDirName);
        boolean createdDirectories = this.rafDir.mkdirs();
        if (log.isInfoEnabled()) {
            log.info((Object)(this.logCacheName + "Cache file root directory: " + rootDirName));
            log.info((Object)(this.logCacheName + "Created root directory: " + createdDirectories));
        }
    }

    private void initializeKeysAndData(IndexedDiskCacheAttributes cattr) throws FileNotFoundException, IOException, InterruptedException {
        this.dataFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".data"), this.getElementSerializer());
        this.keyFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".key"), this.getElementSerializer());
        if (cattr.isClearDiskOnStartup()) {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "ClearDiskOnStartup is set to true.  Ingnoring any persisted data."));
            }
            this.initializeEmptyStore();
        } else if (this.keyFile.length() > 0L) {
            this.initializeStoreFromPersistedData();
        } else {
            this.initializeEmptyStore();
        }
    }

    private void initializeEmptyStore() throws IOException {
        this.initializeKeyMap();
        if (this.dataFile.length() > 0L) {
            this.dataFile.reset();
        }
    }

    private void initializeStoreFromPersistedData() throws InterruptedException, IOException {
        this.loadKeys();
        if (this.keyHash.size() == 0) {
            this.dataFile.reset();
        } else {
            boolean isOk = this.checkKeyDataConsistency(false);
            if (!isOk) {
                this.keyHash.clear();
                this.keyFile.reset();
                this.dataFile.reset();
                log.warn((Object)(this.logCacheName + "Corruption detected.  Reseting data and keys files."));
            } else {
                this.startupSize = this.keyHash.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadKeys() throws InterruptedException {
        this.storageLock.writeLock().acquire();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.logCacheName + "Loading keys for " + this.keyFile.toString()));
        }
        try {
            this.initializeKeyMap();
            HashMap keys = (HashMap)this.keyFile.readObject(new IndexedDiskElementDescriptor(0L, (int)this.keyFile.length() - 4));
            if (keys != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.logCacheName + "Found " + keys.size() + " in keys file."));
                }
                this.keyHash.putAll(keys);
                if (log.isInfoEnabled()) {
                    log.info((Object)(this.logCacheName + "Loaded keys from [" + this.fileName + "], key count: " + this.keyHash.size() + "; up to " + this.maxKeySize + " will be available."));
                }
            }
            if (log.isDebugEnabled()) {
                this.dump(false);
            }
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Problem loading keys for file " + this.fileName), (Throwable)e);
        }
        finally {
            this.storageLock.writeLock().release();
        }
    }

    private boolean checkKeyDataConsistency(boolean checkForDedOverlaps) {
        ElapsedTimer timer = new ElapsedTimer();
        log.debug((Object)(this.logCacheName + "Performing inital consistency check"));
        boolean isOk = true;
        long fileLength = 0L;
        try {
            fileLength = this.dataFile.length();
            Iterator itr = this.keyHash.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry e = itr.next();
                IndexedDiskElementDescriptor ded = (IndexedDiskElementDescriptor)e.getValue();
                isOk = ded.pos + 4L + (long)ded.len <= fileLength;
                if (isOk) continue;
                log.warn((Object)(this.logCacheName + "The dataFile is corrupted!" + "\n raf.length() = " + fileLength + "\n ded.pos = " + ded.pos));
                break;
            }
            if (isOk && checkForDedOverlaps) {
                isOk = this.checkForDedOverlaps(this.createPositionSortedDescriptorList());
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            isOk = false;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(this.logCacheName + "Finished inital consistency check, isOk = " + isOk + " in " + timer.getElapsedTimeString()));
        }
        return isOk;
    }

    protected boolean checkForDedOverlaps(IndexedDiskElementDescriptor[] sortedDescriptors) {
        long start = System.currentTimeMillis();
        boolean isOk = true;
        long expectedNextPos = 0L;
        for (int i = 0; i < sortedDescriptors.length; ++i) {
            IndexedDiskElementDescriptor ded = sortedDescriptors[i];
            if (expectedNextPos > ded.pos) {
                log.error((Object)(this.logCacheName + "Corrupt file: overlapping deds " + ded));
                isOk = false;
                break;
            }
            expectedNextPos = ded.pos + 4L + (long)ded.len;
        }
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.logCacheName + "Check for DED overlaps took " + (end - start) + " ms."));
        }
        return isOk;
    }

    protected void saveKeys() {
        try {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Saving keys to: " + this.fileName + ", key count: " + this.keyHash.size()));
            }
            this.keyFile.reset();
            HashMap keys = new HashMap();
            keys.putAll(this.keyHash);
            if (keys.size() > 0) {
                this.keyFile.writeObject(keys, 0L);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Finished saving keys."));
            }
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Problem storing keys."), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processUpdate(ICacheElement ce) {
        if (!this.alive) {
            log.error((Object)(this.logCacheName + "No longer alive; aborting put of key = " + ce.getKey()));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.logCacheName + "Storing element on disk, key: " + ce.getKey()));
        }
        IndexedDiskElementDescriptor ded = null;
        IndexedDiskElementDescriptor old = null;
        try {
            byte[] data = this.getElementSerializer().serialize(ce);
            this.storageLock.writeLock().acquire();
            try {
                old = (IndexedDiskElementDescriptor)this.keyHash.get(ce.getKey());
                if (old != null && data.length <= old.len) {
                    ded = old;
                    ded.len = data.length;
                } else {
                    IndexedDiskElementDescriptor rep;
                    ded = new IndexedDiskElementDescriptor(this.dataFile.length(), data.length);
                    if (this.doRecycle && (rep = (IndexedDiskElementDescriptor)this.recycle.takeNearestLargerOrEqual(ded)) != null) {
                        ded = rep;
                        ded.len = data.length;
                        ++this.recycleCnt;
                        this.adjustBytesFree(ded, false);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(this.logCacheName + "using recycled ded " + ded.pos + " rep.len = " + rep.len + " ded.len = " + ded.len));
                        }
                    }
                    this.keyHash.put(ce.getKey(), ded);
                    if (this.queueInput) {
                        this.queuedPutList.add(ded);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(this.logCacheName + "added to queued put list." + this.queuedPutList.size()));
                        }
                    }
                }
                this.dataFile.write(ded, data);
            }
            finally {
                this.storageLock.writeLock().release();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.logCacheName + "Put to file: " + this.fileName + ", key: " + ce.getKey() + ", position: " + ded.pos + ", size: " + ded.len));
            }
        }
        catch (ConcurrentModificationException cme) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.logCacheName + "Caught ConcurrentModificationException." + cme));
            }
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Failure updating element, key: " + ce.getKey() + " old: " + old), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICacheElement processGet(Serializable key) {
        if (!this.alive) {
            log.error((Object)(this.logCacheName + "No longer alive so returning null for key = " + key));
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.logCacheName + "Trying to get from disk: " + key));
        }
        ICacheElement object = null;
        try {
            this.storageLock.readLock().acquire();
            try {
                object = this.readElement(key);
            }
            finally {
                this.storageLock.readLock().release();
            }
            if (object != null) {
                this.incrementHitCount();
            }
        }
        catch (IOException ioe) {
            log.error((Object)(this.logCacheName + "Failure getting from disk, key = " + key), (Throwable)ioe);
            this.reset();
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Failure getting from disk, key = " + key), (Throwable)e);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map processGetMatching(String pattern) {
        HashMap<String, ICacheElement> elements = new HashMap<String, ICacheElement>();
        try {
            Object[] keyArray = null;
            this.storageLock.readLock().acquire();
            try {
                keyArray = this.keyHash.keySet().toArray();
            }
            finally {
                this.storageLock.readLock().release();
            }
            Set matchingKeys = this.getKeyMatcher().getMatchingKeysFromArray(pattern, keyArray);
            Iterator keyIterator = matchingKeys.iterator();
            while (keyIterator.hasNext()) {
                String key = (String)keyIterator.next();
                ICacheElement element = this.processGet((Serializable)((Object)key));
                if (element == null) continue;
                elements.put(key, element);
            }
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Failure getting matching from disk, pattern = " + pattern), (Throwable)e);
        }
        return elements;
    }

    private ICacheElement readElement(Serializable key) throws IOException {
        ICacheElement object = null;
        IndexedDiskElementDescriptor ded = (IndexedDiskElementDescriptor)this.keyHash.get(key);
        if (ded != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.logCacheName + "Found on disk, key: " + key));
            }
            try {
                object = (ICacheElement)this.dataFile.readObject(ded);
            }
            catch (IOException e) {
                log.error((Object)(this.logCacheName + "IO Exception, Problem reading object from file"), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error((Object)(this.logCacheName + "Exception, Problem reading object from file"), (Throwable)e);
                throw new IOException(this.logCacheName + "Problem reading object from disk. " + e.getMessage());
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getGroupKeys(String groupName) {
        GroupId groupId = new GroupId(this.cacheName, groupName);
        HashSet<Object> keys = new HashSet<Object>();
        try {
            this.storageLock.readLock().acquire();
            Iterator itr = this.keyHash.keySet().iterator();
            while (itr.hasNext()) {
                Object k = itr.next();
                if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(groupId)) continue;
                keys.add(((GroupAttrName)k).attrName);
            }
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Failure getting from disk, group = " + groupName), (Throwable)e);
        }
        finally {
            this.storageLock.readLock().release();
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processRemove(Serializable key) {
        if (!this.alive) {
            log.error((Object)(this.logCacheName + "No longer alive so returning false for key = " + key));
            return false;
        }
        if (key == null) {
            return false;
        }
        boolean reset = false;
        boolean removed = false;
        try {
            this.storageLock.writeLock().acquire();
            removed = key instanceof String && key.toString().endsWith(":") ? this.performPartialKeyRemoval((String)((Object)key)) : (key instanceof GroupId ? this.performGroupRemoval((GroupId)key) : this.performSingleKeyRemoval(key));
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Problem removing element."), (Throwable)e);
            reset = true;
        }
        finally {
            this.storageLock.writeLock().release();
        }
        if (reset) {
            this.reset();
        }
        if (removed) {
            this.doOptimizeRealTime();
        }
        return removed;
    }

    private boolean performPartialKeyRemoval(String key) {
        boolean removed = false;
        LinkedList itemsToRemove = new LinkedList();
        Iterator iter = this.keyHash.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object k = entry.getKey();
            if (!(k instanceof String) || !k.toString().startsWith(key.toString())) continue;
            itemsToRemove.add(k);
        }
        Iterator itToRemove = itemsToRemove.iterator();
        while (itToRemove.hasNext()) {
            String fullKey = (String)itToRemove.next();
            IndexedDiskElementDescriptor ded = (IndexedDiskElementDescriptor)this.keyHash.get(fullKey);
            this.addToRecycleBin(ded);
            this.performSingleKeyRemoval((Serializable)((Object)fullKey));
            removed = true;
        }
        return removed;
    }

    private boolean performGroupRemoval(GroupId key) {
        boolean removed = false;
        LinkedList itemsToRemove = new LinkedList();
        Iterator iter = this.keyHash.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object k = entry.getKey();
            if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(key)) continue;
            itemsToRemove.add(k);
        }
        Iterator itToRemove = itemsToRemove.iterator();
        while (itToRemove.hasNext()) {
            GroupAttrName keyToRemove = (GroupAttrName)itToRemove.next();
            IndexedDiskElementDescriptor ded = (IndexedDiskElementDescriptor)this.keyHash.get(keyToRemove);
            this.addToRecycleBin(ded);
            this.performSingleKeyRemoval(keyToRemove);
            removed = true;
        }
        return removed;
    }

    private boolean performSingleKeyRemoval(Serializable key) {
        IndexedDiskElementDescriptor ded = (IndexedDiskElementDescriptor)this.keyHash.remove(key);
        boolean removed = ded != null;
        this.addToRecycleBin(ded);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.logCacheName + "Disk removal: Removed from key hash, key [" + key + "] removed = " + removed));
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRemoveAll() {
        ICacheEvent cacheEvent = this.createICacheEvent(this.cacheName, (Serializable)((Object)"all"), "removeAll");
        try {
            this.reset();
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Problem removing all."), (Throwable)e);
            this.reset();
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        if (log.isWarnEnabled()) {
            log.warn((Object)(this.logCacheName + "Reseting cache"));
        }
        try {
            this.storageLock.writeLock().acquire();
            if (this.dataFile != null) {
                this.dataFile.close();
            }
            File dataFileTemp = new File(this.rafDir, this.fileName + ".data");
            dataFileTemp.delete();
            if (this.keyFile != null) {
                this.keyFile.close();
            }
            File keyFileTemp = new File(this.rafDir, this.fileName + ".key");
            keyFileTemp.delete();
            this.dataFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".data"), this.getElementSerializer());
            this.keyFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".key"), this.getElementSerializer());
            this.initializeRecycleBin();
            this.initializeKeyMap();
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Failure reseting state"), (Throwable)e);
        }
        finally {
            this.storageLock.writeLock().release();
        }
    }

    private void initializeRecycleBin() {
        int recycleBinSize = this.cattr.getMaxRecycleBinSize() >= 0 ? this.cattr.getMaxRecycleBinSize() : 0;
        this.recycle = new SortedPreferentialArray(recycleBinSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.logCacheName + "Set recycle max Size to MaxRecycleBinSize: '" + recycleBinSize + "'"));
        }
    }

    private void initializeKeyMap() {
        this.keyHash = null;
        if (this.maxKeySize >= 0) {
            this.keyHash = new LRUMap(this.maxKeySize);
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Set maxKeySize to: '" + this.maxKeySize + "'"));
            }
        } else {
            this.keyHash = new HashMap();
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Set maxKeySize to unlimited'"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDispose() {
        ICacheEvent cacheEvent = this.createICacheEvent(this.cacheName, (Serializable)((Object)"none"), "dispose");
        try {
            Runnable disR = new Runnable(){

                public void run() {
                    IndexedDiskCache.this.disposeInternal();
                }
            };
            Thread t = new Thread(disR, "IndexedDiskCache-DisposalThread");
            t.start();
            try {
                t.join(60000L);
            }
            catch (InterruptedException ex) {
                log.error((Object)(this.logCacheName + "Interrupted while waiting for disposal thread to finish."), (Throwable)ex);
            }
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    private void disposeInternal() {
        if (!this.alive) {
            log.error((Object)(this.logCacheName + "Not alive and dispose was called, filename: " + this.fileName));
            return;
        }
        this.alive = false;
        Thread optimizationThread = this.currentOptimizationThread;
        if (this.isRealTimeOptimizationEnabled && optimizationThread != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.logCacheName + "In dispose, optimization already " + "in progress; waiting for completion."));
            }
            try {
                optimizationThread.join();
            }
            catch (InterruptedException e) {
                log.error((Object)(this.logCacheName + "Unable to join current optimization thread."), (Throwable)e);
            }
        } else if (this.isShutdownOptimizationEnabled && this.getBytesFree() > 0L) {
            this.optimizeFile();
        }
        this.saveKeys();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.logCacheName + "Closing files, base filename: " + this.fileName));
            }
            this.dataFile.close();
            this.dataFile = null;
            this.keyFile.close();
            this.keyFile = null;
        }
        catch (IOException e) {
            log.error((Object)(this.logCacheName + "Failure closing files in dispose, filename: " + this.fileName), (Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(this.logCacheName + "Shutdown complete."));
        }
    }

    private void addToRecycleBin(IndexedDiskElementDescriptor ded) {
        if (ded != null) {
            this.adjustBytesFree(ded, true);
            if (this.doRecycle) {
                this.recycle.add(ded);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.logCacheName + "recycled ded" + ded));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOptimizeRealTime() {
        if (this.isRealTimeOptimizationEnabled && !this.isOptimizing && this.removeCount++ >= this.cattr.getOptimizeAtRemoveCount()) {
            this.isOptimizing = true;
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Optimizing file. removeCount [" + this.removeCount + "] OptimizeAtRemoveCount [" + this.cattr.getOptimizeAtRemoveCount() + "]"));
            }
            if (this.currentOptimizationThread == null) {
                try {
                    this.storageLock.writeLock().acquire();
                    if (this.currentOptimizationThread == null) {
                        this.currentOptimizationThread = new Thread(new Runnable(){

                            public void run() {
                                IndexedDiskCache.this.optimizeFile();
                                IndexedDiskCache.this.currentOptimizationThread = null;
                            }
                        }, "IndexedDiskCache-OptimizationThread");
                    }
                }
                catch (InterruptedException e) {
                    log.error((Object)(this.logCacheName + "Unable to aquire storage write lock."), (Throwable)e);
                }
                finally {
                    this.storageLock.writeLock().release();
                }
                if (this.currentOptimizationThread != null) {
                    this.currentOptimizationThread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void optimizeFile() {
        ElapsedTimer timer = new ElapsedTimer();
        ++this.timesOptimized;
        if (log.isInfoEnabled()) {
            log.info((Object)(this.logCacheName + "Beginning Optimization #" + this.timesOptimized));
        }
        IndexedDiskElementDescriptor[] defragList = null;
        try {
            this.storageLock.writeLock().acquire();
            this.queueInput = true;
            this.doRecycle = false;
            defragList = this.createPositionSortedDescriptorList();
            this.storageLock.writeLock().release();
        }
        catch (InterruptedException e) {
            log.error((Object)(this.logCacheName + "Error setting up optimization."), (Throwable)e);
            return;
        }
        long expectedNextPos = this.defragFile(defragList, 0L);
        try {
            this.storageLock.writeLock().acquire();
            if (!this.queuedPutList.isEmpty()) {
                defragList = new IndexedDiskElementDescriptor[this.queuedPutList.size()];
                this.queuedPutList.toArray(defragList);
                Arrays.sort(defragList, new PositionComparator());
                expectedNextPos = this.defragFile(defragList, expectedNextPos);
            }
            this.dataFile.truncate(expectedNextPos);
        }
        catch (Exception e) {
            log.error((Object)(this.logCacheName + "Error optimizing queued puts."), (Throwable)e);
        }
        finally {
            this.removeCount = 0;
            this.bytesFree = 0L;
            this.initializeRecycleBin();
            this.queuedPutList.clear();
            this.queueInput = false;
            this.doRecycle = true;
            this.isOptimizing = false;
            this.storageLock.writeLock().release();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(this.logCacheName + "Finished #" + this.timesOptimized + " Optimization took " + timer.getElapsedTimeString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long defragFile(IndexedDiskElementDescriptor[] defragList, long startingPos) {
        ElapsedTimer timer = new ElapsedTimer();
        long preFileSize = 0L;
        long postFileSize = 0L;
        long expectedNextPos = 0L;
        try {
            preFileSize = this.dataFile.length();
            expectedNextPos = startingPos;
            for (int i = 0; i < defragList.length; ++i) {
                this.storageLock.writeLock().acquire();
                try {
                    if (expectedNextPos != defragList[i].pos) {
                        this.dataFile.move(defragList[i], expectedNextPos);
                    }
                    expectedNextPos = defragList[i].pos + 4L + (long)defragList[i].len;
                    continue;
                }
                finally {
                    this.storageLock.writeLock().release();
                }
            }
            postFileSize = this.dataFile.length();
            long i = expectedNextPos;
            return i;
        }
        catch (IOException e) {
            log.error((Object)(this.logCacheName + "Error occurred during defragmentation."), (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error((Object)(this.logCacheName + "Threading problem"), (Throwable)e);
        }
        finally {
            if (log.isInfoEnabled()) {
                log.info((Object)(this.logCacheName + "Defragmentation took " + timer.getElapsedTimeString() + ". File Size (before=" + preFileSize + ") (after=" + postFileSize + ") (truncating to " + expectedNextPos + ")"));
            }
        }
        return 0L;
    }

    private IndexedDiskElementDescriptor[] createPositionSortedDescriptorList() {
        IndexedDiskElementDescriptor[] defragList = new IndexedDiskElementDescriptor[this.keyHash.size()];
        Iterator iterator = this.keyHash.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            defragList[i] = (IndexedDiskElementDescriptor)next.getValue();
            ++i;
        }
        Arrays.sort(defragList, new PositionComparator());
        return defragList;
    }

    public int getSize() {
        return this.keyHash.size();
    }

    protected int getRecyleBinSize() {
        return this.recycle.size();
    }

    protected int getRecyleCount() {
        return this.recycleCnt;
    }

    protected synchronized long getBytesFree() {
        return this.bytesFree;
    }

    private synchronized void adjustBytesFree(IndexedDiskElementDescriptor ded, boolean add) {
        if (ded != null) {
            int amount = ded.len + 4;
            this.bytesFree = add ? (this.bytesFree += (long)amount) : (this.bytesFree -= (long)amount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getDataFileSize() throws IOException {
        long size = 0L;
        try {
            this.storageLock.readLock().acquire();
            if (this.dataFile != null) {
                size = this.dataFile.length();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.storageLock.readLock().release();
        }
        return size;
    }

    public void dump() {
        this.dump(true);
    }

    public void dump(boolean dumpValues) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.logCacheName + "[dump] Number of keys: " + this.keyHash.size()));
            Iterator itr = this.keyHash.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry e = itr.next();
                Serializable key = (Serializable)e.getKey();
                IndexedDiskElementDescriptor ded = (IndexedDiskElementDescriptor)e.getValue();
                log.debug((Object)(this.logCacheName + "[dump] Disk element, key: " + key + ", pos: " + ded.pos + ", ded.len" + ded.len + (dumpValues ? ", val: " + this.get(key) : "")));
            }
        }
    }

    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.cattr;
    }

    private synchronized void incrementHitCount() {
        ++this.hitCount;
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public synchronized IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Indexed Disk Cache");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Is Alive");
        se.setData("" + this.alive);
        elems.add(se);
        se = new StatElement();
        se.setName("Key Map Size");
        if (this.keyHash != null) {
            se.setData("" + this.keyHash.size());
        } else {
            se.setData("-1");
        }
        elems.add(se);
        try {
            se = new StatElement();
            se.setName("Data File Length");
            if (this.dataFile != null) {
                se.setData("" + this.dataFile.length());
            } else {
                se.setData("-1");
            }
            elems.add(se);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        se = new StatElement();
        se.setName("Hit Count");
        se.setData("" + this.hitCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Bytes Free");
        se.setData("" + this.bytesFree);
        elems.add(se);
        se = new StatElement();
        se.setName("Optimize Operation Count");
        se.setData("" + this.removeCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Times Optimized");
        se.setData("" + this.timesOptimized);
        elems.add(se);
        se = new StatElement();
        se.setName("Recycle Count");
        se.setData("" + this.recycleCnt);
        elems.add(se);
        se = new StatElement();
        se.setName("Recycle Bin Size");
        se.setData("" + this.recycle.size());
        elems.add(se);
        se = new StatElement();
        se.setName("Startup Size");
        se.setData("" + this.startupSize);
        elems.add(se);
        IStats sStats = super.getStatistics();
        IStatElement[] sSEs = sStats.getStatElements();
        List<IStatElement> sL = Arrays.asList(sSEs);
        elems.addAll(sL);
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    protected int getTimesOptimized() {
        return this.timesOptimized;
    }

    protected String getDiskLocation() {
        return this.dataFile.getFilePath();
    }

    public class LRUMap
    extends LRUMapJCS {
        private static final long serialVersionUID = 4955079991472142198L;
        public String tag;

        public LRUMap() {
            this.tag = "orig";
        }

        public LRUMap(int maxKeySize) {
            super(maxKeySize);
            this.tag = "orig";
        }

        protected void processRemovedLRU(Object key, Object value) {
            IndexedDiskCache.this.addToRecycleBin((IndexedDiskElementDescriptor)value);
            if (log.isDebugEnabled()) {
                log.debug((Object)(IndexedDiskCache.this.logCacheName + "Removing key: [" + key + "] from key store."));
                log.debug((Object)(IndexedDiskCache.this.logCacheName + "Key store size: [" + this.size() + "]."));
            }
            IndexedDiskCache.this.doOptimizeRealTime();
        }
    }

    private static final class PositionComparator
    implements Comparator {
        private PositionComparator() {
        }

        public int compare(Object o1, Object o2) {
            IndexedDiskElementDescriptor ded1 = (IndexedDiskElementDescriptor)o1;
            IndexedDiskElementDescriptor ded2 = (IndexedDiskElementDescriptor)o2;
            if (ded1.pos < ded2.pos) {
                return -1;
            }
            if (ded1.pos == ded2.pos) {
                return 0;
            }
            return 1;
        }
    }
}

