/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.jdbc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCache;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCacheManagerAbstractTemplate;
import org.apache.jcs.auxiliary.disk.jdbc.TableState;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;

public class JDBCDiskCacheManager
extends JDBCDiskCacheManagerAbstractTemplate {
    private static final long serialVersionUID = -8258856770927857896L;
    private static final Log log = LogFactory.getLog((Class)JDBCDiskCacheManager.class);
    private static JDBCDiskCacheManager instance;
    private JDBCDiskCacheAttributes defaultJDBCDiskCacheAttributes;
    private ICompositeCacheManager compositeCacheManager;

    private JDBCDiskCacheManager(JDBCDiskCacheAttributes cattr, ICompositeCacheManager compositeCacheManager, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Creating JDBCDiskCacheManager with " + cattr));
        }
        this.defaultJDBCDiskCacheAttributes = cattr;
        this.setElementSerializer(elementSerializer);
        this.setCacheEventLogger(cacheEventLogger);
        this.setCompositeCacheManager(compositeCacheManager);
    }

    public JDBCDiskCacheAttributes getDefaultJDBCDiskCacheAttributes() {
        return this.defaultJDBCDiskCacheAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JDBCDiskCacheManager getInstance(JDBCDiskCacheAttributes cattr, ICompositeCacheManager compositeCacheManager, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        Class clazz = JDBCDiskCacheManager.class;
        synchronized (clazz) {
            if (instance == null) {
                instance = new JDBCDiskCacheManager(cattr, compositeCacheManager, cacheEventLogger, elementSerializer);
            }
        }
        ++clients;
        return instance;
    }

    public AuxiliaryCache getCache(String cacheName) {
        JDBCDiskCacheAttributes cattr = (JDBCDiskCacheAttributes)this.defaultJDBCDiskCacheAttributes.copy();
        cattr.setCacheName(cacheName);
        return this.getCache(cattr);
    }

    protected AuxiliaryCache createJDBCDiskCache(JDBCDiskCacheAttributes cattr, TableState tableState) {
        JDBCDiskCache raf = new JDBCDiskCache(cattr, tableState, this.getCompositeCacheManager());
        return raf;
    }

    protected void setCompositeCacheManager(ICompositeCacheManager compositeCacheManager) {
        this.compositeCacheManager = compositeCacheManager;
    }

    protected ICompositeCacheManager getCompositeCacheManager() {
        return this.compositeCacheManager;
    }
}

