/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import EDU.oswego.cs.dl.util.concurrent.Callable;
import EDU.oswego.cs.dl.util.concurrent.FutureResult;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AbstractAuxiliaryCacheEventLogging;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.remote.ZombieRemoteCacheService;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheClient;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheElementSerialized;
import org.apache.jcs.engine.behavior.IZombie;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;
import org.apache.jcs.utils.serialization.SerializationConversionUtil;
import org.apache.jcs.utils.threadpool.ThreadPool;
import org.apache.jcs.utils.threadpool.ThreadPoolManager;

public abstract class AbstractRemoteAuxiliaryCache
extends AbstractAuxiliaryCacheEventLogging
implements IRemoteCacheClient {
    private static final long serialVersionUID = -5329231850422826461L;
    private static final Log log = LogFactory.getLog((Class)AbstractRemoteAuxiliaryCache.class);
    private IRemoteCacheService remoteCacheService;
    protected final String cacheName;
    private IRemoteCacheListener remoteCacheListener;
    private IRemoteCacheAttributes remoteCacheAttributes;
    private ThreadPool pool = null;
    private boolean usePoolForGet = false;

    public AbstractRemoteAuxiliaryCache(IRemoteCacheAttributes cattr, IRemoteCacheService remote, IRemoteCacheListener listener) {
        this.setRemoteCacheAttributes(cattr);
        this.cacheName = cattr.getCacheName();
        this.setRemoteCacheService(remote);
        this.setRemoteCacheListener(listener);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Construct> cacheName=" + cattr.getCacheName()));
            log.debug((Object)("irca = " + this.getRemoteCacheAttributes()));
            log.debug((Object)("remote = " + remote));
            log.debug((Object)("listener = " + listener));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("GetTimeoutMillis() = " + this.getRemoteCacheAttributes().getGetTimeoutMillis()));
        }
        if (this.getRemoteCacheAttributes().getGetTimeoutMillis() > 0) {
            this.pool = ThreadPoolManager.getInstance().getPool(this.getRemoteCacheAttributes().getThreadPoolName());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Thread Pool = " + this.pool));
            }
            if (this.pool != null) {
                this.usePoolForGet = true;
            }
        }
    }

    protected void processDispose() throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Disposing of remote cache.");
        }
        try {
            if (this.getRemoteCacheListener() != null) {
                this.getRemoteCacheListener().dispose();
            }
        }
        catch (Exception ex) {
            log.error((Object)"Couldn't dispose", (Throwable)ex);
            this.handleException(ex, "Failed to dispose [" + this.cacheName + "]", "dispose");
        }
    }

    protected ICacheElement processGet(Serializable key) throws IOException {
        ICacheElement retVal = null;
        try {
            retVal = this.usePoolForGet ? this.getUsingPool(key) : this.getRemoteCacheService().get(this.cacheName, key, this.getListenerId());
            if (retVal != null && retVal instanceof ICacheElementSerialized && this.getRemoteCacheAttributes().getRemoteType() != 1) {
                retVal = SerializationConversionUtil.getDeSerializedCacheElement((ICacheElementSerialized)retVal, this.elementSerializer);
            }
        }
        catch (Exception ex) {
            this.handleException(ex, "Failed to get [" + key + "] from [" + this.cacheName + "]", "get");
        }
        return retVal;
    }

    public ICacheElement getUsingPool(final Serializable key) throws IOException {
        int timeout = this.getRemoteCacheAttributes().getGetTimeoutMillis();
        try {
            FutureResult future = new FutureResult();
            Runnable command = future.setter(new Callable(){

                public Object call() throws IOException {
                    return AbstractRemoteAuxiliaryCache.this.getRemoteCacheService().get(AbstractRemoteAuxiliaryCache.this.cacheName, key, AbstractRemoteAuxiliaryCache.this.getListenerId());
                }
            });
            this.pool.execute(command);
            ICacheElement ice = (ICacheElement)future.timedGet((long)timeout);
            if (log.isDebugEnabled()) {
                if (ice == null) {
                    log.debug((Object)"nothing found in remote cache");
                } else {
                    log.debug((Object)"found item in remote cache");
                }
            }
            return ice;
        }
        catch (TimeoutException te) {
            log.warn((Object)("TimeoutException, Get Request timed out after " + timeout));
            throw new IOException("Get Request timed out after " + timeout);
        }
        catch (InterruptedException ex) {
            log.warn((Object)("InterruptedException, Get Request timed out after " + timeout));
            throw new IOException("Get Request timed out after " + timeout);
        }
        catch (InvocationTargetException ex) {
            log.error((Object)"InvocationTargetException, Assuming an IO exception thrown in the background.", (Throwable)ex);
            throw new IOException("Get Request timed out after " + timeout);
        }
    }

    public Map processGetMatching(String pattern) throws IOException {
        HashMap results = new HashMap();
        try {
            Map rawResults = this.getRemoteCacheService().getMatching(this.cacheName, pattern, this.getListenerId());
            if (rawResults != null) {
                Set entrySet = rawResults.entrySet();
                Iterator it = entrySet.iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    ICacheElement unwrappedResult = null;
                    if (entry.getValue() instanceof ICacheElementSerialized) {
                        if (this.getRemoteCacheAttributes().getRemoteType() != 1) {
                            unwrappedResult = SerializationConversionUtil.getDeSerializedCacheElement((ICacheElementSerialized)entry.getValue(), this.elementSerializer);
                        }
                    } else {
                        unwrappedResult = (ICacheElement)entry.getValue();
                    }
                    results.put(entry.getKey(), unwrappedResult);
                }
            }
        }
        catch (Exception ex) {
            this.handleException(ex, "Failed to getMatching [" + pattern + "] from [" + this.cacheName + "]", "get");
        }
        return results;
    }

    protected Map processGetMultiple(Set keys) throws IOException {
        HashMap<Serializable, ICacheElement> elements = new HashMap<Serializable, ICacheElement>();
        if (keys != null && !keys.isEmpty()) {
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                Serializable key = (Serializable)iterator.next();
                ICacheElement element = this.get(key);
                if (element == null) continue;
                elements.put(key, element);
            }
        }
        return elements;
    }

    protected boolean processRemove(Serializable key) throws IOException {
        if (!this.getRemoteCacheAttributes().getGetOnly()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("remove> key=" + key));
            }
            try {
                this.getRemoteCacheService().remove(this.cacheName, key, this.getListenerId());
            }
            catch (Exception ex) {
                this.handleException(ex, "Failed to remove " + key + " from " + this.cacheName, "remove");
            }
            return true;
        }
        return false;
    }

    protected void processRemoveAll() throws IOException {
        if (!this.getRemoteCacheAttributes().getGetOnly()) {
            try {
                this.getRemoteCacheService().removeAll(this.cacheName, this.getListenerId());
            }
            catch (Exception ex) {
                this.handleException(ex, "Failed to remove all from " + this.cacheName, "removeAll");
            }
        }
    }

    protected void processUpdate(ICacheElement ce) throws IOException {
        if (!this.getRemoteCacheAttributes().getGetOnly()) {
            ICacheElementSerialized serialized = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sending item to remote server");
                }
                serialized = SerializationConversionUtil.getSerializedCacheElement(ce, this.elementSerializer);
                this.remoteCacheService.update(serialized, this.getListenerId());
            }
            catch (NullPointerException npe) {
                log.error((Object)("npe for ce = " + ce + "ce.attr = " + ce.getElementAttributes()), (Throwable)npe);
            }
            catch (Exception ex) {
                this.handleException(ex, "Failed to put [" + ce.getKey() + "] to " + ce.getCacheName(), "update");
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"get only mode, not sending to remote server");
        }
    }

    public Set getGroupKeys(String groupName) throws RemoteException, IOException {
        return this.getRemoteCacheService().getGroupKeys(this.cacheName, groupName);
    }

    public IRemoteCacheListener getListener() {
        return this.getRemoteCacheListener();
    }

    public void setListenerId(long id) {
        if (this.getRemoteCacheListener() != null) {
            try {
                this.getRemoteCacheListener().setListenerId(id);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("set listenerId = " + id));
                }
            }
            catch (Exception e) {
                log.error((Object)"Problem setting listenerId", (Throwable)e);
            }
        }
    }

    public long getListenerId() {
        if (this.getRemoteCacheListener() != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("get listenerId = " + this.getRemoteCacheListener().getListenerId()));
                }
                return this.getRemoteCacheListener().getListenerId();
            }
            catch (Exception e) {
                log.error((Object)"Problem getting listenerId", (Throwable)e);
            }
        }
        return -1L;
    }

    public int getSize() {
        return 0;
    }

    protected abstract void handleException(Exception var1, String var2, String var3) throws IOException;

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("AbstractRemoteAuxiliaryCache");
        ArrayList<StatElement> elems = new ArrayList<StatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Remote Type");
        se.setData(this.getRemoteCacheAttributes().getRemoteTypeName() + "");
        elems.add(se);
        if (this.getRemoteCacheAttributes().getRemoteType() == 1) {
            // empty if block
        }
        se = new StatElement();
        se.setName("UsePoolForGet");
        se.setData("" + this.usePoolForGet);
        elems.add(se);
        if (this.pool != null) {
            se = new StatElement();
            se.setName("Pool Size");
            se.setData("" + this.pool.getPool().getPoolSize());
            elems.add(se);
            se = new StatElement();
            se.setName("Maximum Pool Size");
            se.setData("" + this.pool.getPool().getMaximumPoolSize());
            elems.add(se);
        }
        if (this.getRemoteCacheService() instanceof ZombieRemoteCacheService) {
            se = new StatElement();
            se.setName("Zombie Queue Size");
            se.setData("" + ((ZombieRemoteCacheService)this.getRemoteCacheService()).getQueueSize());
            elems.add(se);
        }
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    public int getStatus() {
        return this.getRemoteCacheService() instanceof IZombie ? 3 : 1;
    }

    public void fixCache(IRemoteCacheService restoredRemote) {
        if (this.getRemoteCacheService() != null && this.getRemoteCacheService() instanceof ZombieRemoteCacheService) {
            ZombieRemoteCacheService zombie = (ZombieRemoteCacheService)this.getRemoteCacheService();
            this.setRemoteCacheService(restoredRemote);
            try {
                zombie.propagateEvents(restoredRemote);
            }
            catch (Exception e) {
                try {
                    this.handleException(e, "Problem propagating events from Zombie Queue to new Remote Service.", "fixCache");
                }
                catch (IOException e1) {}
            }
        } else {
            this.setRemoteCacheService(restoredRemote);
        }
    }

    public int getCacheType() {
        return 4;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    protected void setRemoteCacheService(IRemoteCacheService remote) {
        this.remoteCacheService = remote;
    }

    protected IRemoteCacheService getRemoteCacheService() {
        return this.remoteCacheService;
    }

    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.getRemoteCacheAttributes();
    }

    protected void setRemoteCacheAttributes(IRemoteCacheAttributes remoteCacheAttributes) {
        this.remoteCacheAttributes = remoteCacheAttributes;
    }

    protected IRemoteCacheAttributes getRemoteCacheAttributes() {
        return this.remoteCacheAttributes;
    }

    protected void setRemoteCacheListener(IRemoteCacheListener remoteCacheListener) {
        this.remoteCacheListener = remoteCacheListener;
    }

    protected IRemoteCacheListener getRemoteCacheListener() {
        return this.remoteCacheListener;
    }
}

