/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.server;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheObserver;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheServiceAdmin;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.jcs.auxiliary.remote.server.behavior.IRemoteCacheServerAttributes;
import org.apache.jcs.engine.CacheEventQueueFactory;
import org.apache.jcs.engine.CacheListeners;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.behavior.ICacheListener;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.engine.logging.CacheEvent;
import org.apache.jcs.engine.logging.behavior.ICacheEvent;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;

class RemoteCacheServer
extends UnicastRemoteObject
implements IRemoteCacheService,
IRemoteCacheObserver,
IRemoteCacheServiceAdmin,
Unreferenced {
    private static final long serialVersionUID = -8072345435941473116L;
    private static final Log log = LogFactory.getLog((Class)RemoteCacheServer.class);
    protected static final boolean timing = true;
    private int puts = 0;
    private final Hashtable cacheListenersMap = new Hashtable();
    private final Hashtable clusterListenersMap = new Hashtable();
    private CompositeCacheManager cacheManager;
    private final Hashtable idTypeMap = new Hashtable();
    private final Hashtable idIPMap = new Hashtable();
    private int[] listenerId = new int[1];
    protected IRemoteCacheServerAttributes remoteCacheServerAttributes;
    private int logInterval = 100;
    private transient ICacheEventLogger cacheEventLogger;
    private static final ICacheEvent EMPTY_ICACHE_EVENT = new CacheEvent();

    RemoteCacheServer(IRemoteCacheServerAttributes rcsa) throws RemoteException {
        super(rcsa.getServicePort());
        this.remoteCacheServerAttributes = rcsa;
        this.init(rcsa.getConfigFileName());
    }

    RemoteCacheServer(IRemoteCacheServerAttributes rcsa, RMISocketFactory customRMISocketFactory) throws RemoteException {
        super(rcsa.getServicePort(), customRMISocketFactory, customRMISocketFactory);
        this.remoteCacheServerAttributes = rcsa;
        this.init(rcsa.getConfigFileName());
    }

    private void init(String prop) {
        this.cacheManager = this.createCacheManager(prop);
        String[] list = this.cacheManager.getCacheNames();
        for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            this.cacheListenersMap.put(name, new CacheListeners(this.cacheManager.getCache(name)));
        }
    }

    private CompositeCacheManager createCacheManager(String prop) {
        CompositeCacheManager hub = CompositeCacheManager.getUnconfiguredInstance();
        if (prop == null) {
            hub.configure("/remote.cache.ccf");
        } else {
            hub.configure(prop);
        }
        return hub;
    }

    public void put(ICacheElement item) throws IOException {
        this.update(item);
    }

    public void update(ICacheElement item) throws IOException {
        this.update(item, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ICacheElement item, long requesterId) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(item, requesterId, "update");
        try {
            this.processUpdate(item, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdate(ICacheElement item, long requesterId) {
        long start = 0L;
        start = System.currentTimeMillis();
        this.logUpdateInfo(item);
        try {
            CacheListeners cacheDesc = this.getCacheListeners(item.getCacheName());
            item.getVal();
            boolean fromCluster = this.isRequestFromCluster(requesterId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("In update, requesterId = [" + requesterId + "] fromCluster = " + fromCluster));
            }
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                block20: {
                    try {
                        CompositeCache c = (CompositeCache)cacheDesc.cache;
                        if (fromCluster) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Put FROM cluster, NOT updating other auxiliaries for region.  requesterId [" + requesterId + "]"));
                            }
                            c.localUpdate(item);
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Put NOT from cluster, updating other auxiliaries for region.  requesterId [" + requesterId + "]"));
                            }
                            c.update(item);
                        }
                    }
                    catch (Exception ce) {
                        if (!log.isInfoEnabled()) break block20;
                        log.info((Object)("Exception caught updating item. requesterId [" + requesterId + "] " + ce.getMessage()));
                    }
                }
                if (!fromCluster || fromCluster && this.remoteCacheServerAttributes.getLocalClusterConsistency()) {
                    ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                    if (qlist != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("qlist.length = " + qlist.length));
                        }
                        for (int i = 0; i < qlist.length; ++i) {
                            qlist[i].addPutEvent(item);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"q list is null");
                    }
                }
            }
        }
        catch (Exception e) {
            if (this.cacheEventLogger != null) {
                this.cacheEventLogger.logError("RemoteCacheServer", "update", e.getMessage() + " REGION: " + item.getCacheName() + " ITEM: " + item);
            }
            log.error((Object)("Trouble in Update. requesterId [" + requesterId + "]"), (Throwable)e);
        }
        long end = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("put took " + String.valueOf(end - start) + " ms."));
        }
    }

    private void logUpdateInfo(ICacheElement item) {
        if (log.isInfoEnabled()) {
            ++this.puts;
            if (this.puts % this.logInterval == 0) {
                log.info((Object)("puts = " + this.puts));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("In update, put [" + item.getKey() + "] in [" + item.getCacheName() + "]"));
        }
    }

    public ICacheElement get(String cacheName, Serializable key) throws IOException {
        return this.get(cacheName, key, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICacheElement get(String cacheName, Serializable key, long requesterId) throws IOException {
        ICacheElement element = null;
        ICacheEvent cacheEvent = this.createICacheEvent(cacheName, key, requesterId, "get");
        try {
            element = this.processGet(cacheName, key, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
        return element;
    }

    private ICacheElement processGet(String cacheName, Serializable key, long requesterId) {
        CacheListeners cacheDesc;
        boolean fromCluster;
        block3: {
            fromCluster = this.isRequestFromCluster(requesterId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("get [" + key + "] from cache [" + cacheName + "] requesterId = [" + requesterId + "] fromCluster = " + fromCluster));
            }
            cacheDesc = null;
            try {
                cacheDesc = this.getCacheListeners(cacheName);
            }
            catch (Exception e) {
                log.error((Object)"Problem getting listeners.", (Throwable)e);
                if (this.cacheEventLogger == null) break block3;
                this.cacheEventLogger.logError("RemoteCacheServer", "get", e.getMessage() + cacheName + " KEY: " + key);
            }
        }
        ICacheElement element = null;
        element = this.getFromCacheListeners(key, fromCluster, cacheDesc, element);
        return element;
    }

    private ICacheElement getFromCacheListeners(Serializable key, boolean fromCluster, CacheListeners cacheDesc, ICacheElement element) {
        if (cacheDesc != null) {
            CompositeCache c = (CompositeCache)cacheDesc.cache;
            if (!fromCluster && this.remoteCacheServerAttributes.getAllowClusterGet()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NonLocalGet. fromCluster [" + fromCluster + "] AllowClusterGet [" + this.remoteCacheServerAttributes.getAllowClusterGet() + "]"));
                }
                element = c.get(key);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("LocalGet.  fromCluster [" + fromCluster + "] AllowClusterGet [" + this.remoteCacheServerAttributes.getAllowClusterGet() + "]"));
                }
                element = c.localGet(key);
            }
        }
        return element;
    }

    public Map getMatching(String cacheName, String pattern) throws IOException {
        return this.getMatching(cacheName, pattern, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMatching(String cacheName, String pattern, long requesterId) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(cacheName, (Serializable)((Object)pattern), requesterId, "getMatching");
        try {
            Map map = this.processGetMatching(cacheName, pattern, requesterId);
            return map;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    protected Map processGetMatching(String cacheName, String pattern, long requesterId) {
        CacheListeners cacheDesc;
        boolean fromCluster;
        block3: {
            fromCluster = this.isRequestFromCluster(requesterId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("getMatching [" + pattern + "] from cache [" + cacheName + "] requesterId = [" + requesterId + "] fromCluster = " + fromCluster));
            }
            cacheDesc = null;
            try {
                cacheDesc = this.getCacheListeners(cacheName);
            }
            catch (Exception e) {
                log.error((Object)"Problem getting listeners.", (Throwable)e);
                if (this.cacheEventLogger == null) break block3;
                this.cacheEventLogger.logError("RemoteCacheServer", "getMatching", e.getMessage() + cacheName + " pattern: " + pattern);
            }
        }
        return this.getMatchingFromCacheListeners(pattern, fromCluster, cacheDesc);
    }

    private Map getMatchingFromCacheListeners(String pattern, boolean fromCluster, CacheListeners cacheDesc) {
        Map elements = null;
        if (cacheDesc != null) {
            CompositeCache c = (CompositeCache)cacheDesc.cache;
            if (!fromCluster && this.remoteCacheServerAttributes.getAllowClusterGet()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NonLocalGetMatching. fromCluster [" + fromCluster + "] AllowClusterGet [" + this.remoteCacheServerAttributes.getAllowClusterGet() + "]"));
                }
                elements = c.getMatching(pattern);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("LocalGetMatching.  fromCluster [" + fromCluster + "] AllowClusterGet [" + this.remoteCacheServerAttributes.getAllowClusterGet() + "]"));
                }
                elements = c.localGetMatching(pattern);
            }
        }
        return elements;
    }

    public Map getMultiple(String cacheName, Set keys) throws IOException {
        return this.getMultiple(cacheName, keys, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMultiple(String cacheName, Set keys, long requesterId) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(cacheName, (Serializable)((Object)keys), requesterId, "getMultiple");
        try {
            Map map = this.processGetMultiple(cacheName, keys, requesterId);
            return map;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    private Map processGetMultiple(String cacheName, Set keys, long requesterId) {
        Map elements = null;
        boolean fromCluster = this.isRequestFromCluster(requesterId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("getMultiple [" + keys + "] from cache [" + cacheName + "] requesterId = [" + requesterId + "] fromCluster = " + fromCluster));
        }
        CacheListeners cacheDesc = null;
        try {
            cacheDesc = this.getCacheListeners(cacheName);
        }
        catch (Exception e) {
            log.error((Object)"Problem getting listeners.", (Throwable)e);
        }
        elements = this.getMultipleFromCacheListeners(keys, elements, fromCluster, cacheDesc);
        return elements;
    }

    private boolean isRequestFromCluster(long requesterId) {
        Integer remoteTypeL = (Integer)this.idTypeMap.get(new Long(requesterId));
        boolean fromCluster = false;
        if (remoteTypeL != null && remoteTypeL == 1) {
            fromCluster = true;
        }
        return fromCluster;
    }

    private Map getMultipleFromCacheListeners(Set keys, Map elements, boolean fromCluster, CacheListeners cacheDesc) {
        if (cacheDesc != null) {
            CompositeCache c = (CompositeCache)cacheDesc.cache;
            if (!fromCluster && this.remoteCacheServerAttributes.getAllowClusterGet()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("NonLocalGetMultiple. fromCluster [" + fromCluster + "] AllowClusterGet [" + this.remoteCacheServerAttributes.getAllowClusterGet() + "]"));
                }
                elements = c.getMultiple(keys);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("LocalGetMultiple.  fromCluster [" + fromCluster + "] AllowClusterGet [" + this.remoteCacheServerAttributes.getAllowClusterGet() + "]"));
                }
                elements = c.localGetMultiple(keys);
            }
        }
        return elements;
    }

    public Set getGroupKeys(String cacheName, String group) {
        return this.processGetGroupKeys(cacheName, group);
    }

    protected Set processGetGroupKeys(String cacheName, String group) {
        CacheListeners cacheDesc = null;
        try {
            cacheDesc = this.getCacheListeners(cacheName);
        }
        catch (Exception e) {
            log.error((Object)"Problem getting listeners.", (Throwable)e);
        }
        if (cacheDesc == null) {
            return Collections.EMPTY_SET;
        }
        CompositeCache c = (CompositeCache)cacheDesc.cache;
        return c.getGroupKeys(group);
    }

    public void remove(String cacheName, Serializable key) throws IOException {
        this.remove(cacheName, key, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String cacheName, Serializable key, long requesterId) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(cacheName, key, requesterId, "remove");
        try {
            this.processRemove(cacheName, key, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRemove(String cacheName, Serializable key, long requesterId) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("remove [" + key + "] from cache [" + cacheName + "]"));
        }
        CacheListeners cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName);
        boolean fromCluster = this.isRequestFromCluster(requesterId);
        if (cacheDesc != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                boolean removeSuccess = false;
                CompositeCache c = (CompositeCache)cacheDesc.cache;
                if (fromCluster) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Remove FROM cluster, NOT updating other auxiliaries for region");
                    }
                    removeSuccess = c.localRemove(key);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Remove NOT from cluster, updating other auxiliaries for region");
                    }
                    removeSuccess = c.remove(key);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("remove [" + key + "] from cache [" + cacheName + "] success (was it found) = " + removeSuccess));
                }
                if (!fromCluster || fromCluster && this.remoteCacheServerAttributes.getLocalClusterConsistency()) {
                    ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                    for (int i = 0; i < qlist.length; ++i) {
                        qlist[i].addRemoveEvent(key);
                    }
                }
            }
        }
    }

    public void removeAll(String cacheName) throws IOException {
        this.removeAll(cacheName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(String cacheName, long requesterId) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(cacheName, (Serializable)((Object)"all"), requesterId, "removeAll");
        try {
            this.processRemoveAll(cacheName, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRemoveAll(String cacheName, long requesterId) throws IOException {
        CacheListeners cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName);
        boolean fromCluster = this.isRequestFromCluster(requesterId);
        if (cacheDesc != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                CompositeCache c = (CompositeCache)cacheDesc.cache;
                if (fromCluster) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"RemoveALL FROM cluster, NOT updating other auxiliaries for region");
                    }
                    c.localRemoveAll();
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"RemoveALL NOT from cluster, updating other auxiliaries for region");
                    }
                    c.removeAll();
                }
                if (!fromCluster || fromCluster && this.remoteCacheServerAttributes.getLocalClusterConsistency()) {
                    ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                    for (int i = 0; i < qlist.length; ++i) {
                        qlist[i].addRemoveAllEvent();
                    }
                }
            }
        }
    }

    protected int getPutCount() {
        return this.puts;
    }

    public void dispose(String cacheName) throws IOException {
        this.dispose(cacheName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(String cacheName, long requesterId) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(cacheName, (Serializable)((Object)"none"), requesterId, "dispose");
        try {
            this.processDispose(cacheName, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDispose(String cacheName, long requesterId) throws IOException {
        CacheListeners cacheDesc;
        if (log.isInfoEnabled()) {
            log.info((Object)("Dispose request received from listener [" + requesterId + "]"));
        }
        if ((cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName)) != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                for (int i = 0; i < qlist.length; ++i) {
                    qlist[i].addDisposeEvent();
                }
                this.cacheManager.freeCache(cacheName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws IOException {
        Hashtable hashtable = this.cacheListenersMap;
        synchronized (hashtable) {
            Enumeration en = this.cacheListenersMap.elements();
            while (en.hasMoreElements()) {
                CacheListeners cacheDesc = (CacheListeners)en.nextElement();
                ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, 0L);
                for (int i = 0; i < qlist.length; ++i) {
                    qlist[i].addDisposeEvent();
                }
            }
            this.cacheManager.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheListeners getCacheListeners(String cacheName) {
        CacheListeners cacheListeners = (CacheListeners)this.cacheListenersMap.get(cacheName);
        Hashtable hashtable = this.cacheListenersMap;
        synchronized (hashtable) {
            if (cacheListeners == null && (cacheListeners = (CacheListeners)this.cacheListenersMap.get(cacheName)) == null) {
                cacheListeners = new CacheListeners(this.cacheManager.getCache(cacheName));
                this.cacheListenersMap.put(cacheName, cacheListeners);
            }
        }
        return cacheListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheListeners getClusterListeners(String cacheName) {
        CacheListeners cacheListeners = (CacheListeners)this.clusterListenersMap.get(cacheName);
        Hashtable hashtable = this.clusterListenersMap;
        synchronized (hashtable) {
            if (cacheListeners == null && (cacheListeners = (CacheListeners)this.clusterListenersMap.get(cacheName)) == null) {
                cacheListeners = new CacheListeners(this.cacheManager.getCache(cacheName));
                this.clusterListenersMap.put(cacheName, cacheListeners);
            }
        }
        return cacheListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICacheEventQueue[] getEventQList(CacheListeners cacheListeners, long requesterId) {
        ICacheEventQueue[] list = null;
        Map map = cacheListeners.eventQMap;
        synchronized (map) {
            list = cacheListeners.eventQMap.values().toArray(new ICacheEventQueue[0]);
        }
        int count = 0;
        for (int i = 0; i < list.length; ++i) {
            ICacheEventQueue q = list[i];
            if (q.isWorking() && q.getListenerId() != requesterId) {
                ++count;
                continue;
            }
            list[i] = null;
        }
        if (count == list.length) {
            return list;
        }
        ICacheEventQueue[] qq = new ICacheEventQueue[count];
        count = 0;
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null) continue;
            qq[count++] = list[i];
        }
        return qq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupEventQMap(Map eventQMap) {
        Map map = eventQMap;
        synchronized (map) {
            Iterator itr = eventQMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry e = itr.next();
                ICacheEventQueue q = (ICacheEventQueue)e.getValue();
                if (q.isWorking()) continue;
                itr.remove();
                log.warn((Object)("Cache event queue " + q + " is not working and removed from cache server."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheListener(String cacheName, ICacheListener listener) throws IOException {
        CacheListeners cacheListeners;
        if (cacheName == null || listener == null) {
            throw new IllegalArgumentException("cacheName and listener must not be null");
        }
        IRemoteCacheListener ircl = (IRemoteCacheListener)listener;
        String listenerAddress = ircl.getLocalHostAddress();
        int remoteType = ircl.getRemoteType();
        if (remoteType == 1) {
            log.debug((Object)("adding cluster listener, listenerAddress [" + listenerAddress + "]"));
            cacheListeners = this.getClusterListeners(cacheName);
        } else {
            log.debug((Object)("adding normal listener, listenerAddress [" + listenerAddress + "]"));
            cacheListeners = this.getCacheListeners(cacheName);
        }
        Map eventQMap = cacheListeners.eventQMap;
        RemoteCacheServer.cleanupEventQMap(eventQMap);
        Class clazz = ICacheListener.class;
        synchronized (clazz) {
            long id;
            block15: {
                id = 0L;
                try {
                    id = listener.getListenerId();
                    if (id == 0L) {
                        long listenerIdB = this.nextListenerId();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("listener id=" + (listenerIdB & 0xFFL) + " addded for cache [" + cacheName + "], listenerAddress [" + listenerAddress + "]"));
                        }
                        listener.setListenerId(listenerIdB);
                        id = listenerIdB;
                        String message = "Adding vm listener under new id = [" + listenerIdB + "], listenerAddress [" + listenerAddress + "]";
                        this.logApplicationEvent("RemoteCacheServer", "addCacheListener", message);
                        if (log.isInfoEnabled()) {
                            log.info((Object)message);
                        }
                    } else {
                        String message = "Adding listener under existing id = [" + id + "], listenerAddress [" + listenerAddress + "]";
                        this.logApplicationEvent("RemoteCacheServer", "addCacheListener", message);
                        if (log.isInfoEnabled()) {
                            log.info((Object)message);
                        }
                    }
                    this.idTypeMap.put(new Long(id), new Integer(remoteType));
                    if (listenerAddress != null) {
                        this.idIPMap.put(new Long(id), listenerAddress);
                    }
                }
                catch (IOException ioe) {
                    String message = "Problem setting listener id, listenerAddress [" + listenerAddress + "]";
                    log.error((Object)message, (Throwable)ioe);
                    if (this.cacheEventLogger == null) break block15;
                    this.cacheEventLogger.logError("RemoteCacheServer", "addCacheListener", message + " - " + ioe.getMessage());
                }
            }
            CacheEventQueueFactory fact = new CacheEventQueueFactory();
            ICacheEventQueue q = fact.createCacheEventQueue(listener, id, cacheName, this.remoteCacheServerAttributes.getEventQueuePoolName(), this.remoteCacheServerAttributes.getEventQueueType());
            eventQMap.put(new Long(listener.getListenerId()), q);
            if (log.isInfoEnabled()) {
                log.info((Object)cacheListeners);
            }
        }
    }

    public void addCacheListener(ICacheListener listener) throws IOException {
        Enumeration en = this.cacheListenersMap.keys();
        while (en.hasMoreElements()) {
            String cacheName = (String)en.nextElement();
            this.addCacheListener(cacheName, listener);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Adding listener for cache [" + cacheName + "]"));
        }
    }

    public void removeCacheListener(String cacheName, ICacheListener listener) throws IOException {
        this.removeCacheListener(cacheName, listener.getListenerId());
    }

    public void removeCacheListener(String cacheName, long listenerId) {
        String message = "Removing listener for cache region = [" + cacheName + "] and listenerId [" + listenerId + "]";
        this.logApplicationEvent("RemoteCacheServer", "removeCacheListener", message);
        if (log.isInfoEnabled()) {
            log.info((Object)message);
        }
        boolean isClusterListener = this.isRequestFromCluster(listenerId);
        CacheListeners cacheDesc = null;
        cacheDesc = isClusterListener ? this.getClusterListeners(cacheName) : this.getCacheListeners(cacheName);
        Map eventQMap = cacheDesc.eventQMap;
        RemoteCacheServer.cleanupEventQMap(eventQMap);
        ICacheEventQueue q = (ICacheEventQueue)eventQMap.remove(new Long(listenerId));
        if (q != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found queue for cache region = [" + cacheName + "] and listenerId  [" + listenerId + "]"));
            }
            q.destroy();
            RemoteCacheServer.cleanupEventQMap(eventQMap);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Did not find queue for cache region = [" + cacheName + "] and listenerId [" + listenerId + "]"));
        }
        this.idTypeMap.remove(new Long(listenerId));
        this.idIPMap.remove(new Long(listenerId));
        if (log.isInfoEnabled()) {
            log.info((Object)("After removing listener [" + listenerId + "] cache region " + cacheName + "'s listener size [" + cacheDesc.eventQMap.size() + "]"));
        }
    }

    public void removeCacheListener(ICacheListener listener) throws IOException {
        Enumeration en = this.cacheListenersMap.keys();
        while (en.hasMoreElements()) {
            String cacheName = (String)en.nextElement();
            this.removeCacheListener(cacheName, listener);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("Removing listener for cache [" + cacheName + "]"));
        }
    }

    public void shutdown() throws IOException {
        RemoteCacheServerFactory.shutdownImpl("", 1099);
    }

    public void shutdown(String host, int port) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)"Received shutdown request.  Shutting down server.");
        }
        RemoteCacheServerFactory.shutdownImpl(host, port);
        this.cacheManager.shutDown();
    }

    public void unreferenced() {
        if (log.isInfoEnabled()) {
            log.info((Object)"*** Server now unreferenced and subject to GC. ***");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long nextListenerId() {
        long id = 0L;
        if ((long)this.listenerId[0] == Long.MAX_VALUE) {
            int[] nArray = this.listenerId;
            synchronized (this.listenerId) {
                id = this.listenerId[0];
                this.listenerId[0] = 0;
                // ** MonitorExit[var3_2] (shouldn't be in output)
            }
        }
        int[] nArray = this.listenerId;
        synchronized (this.listenerId) {
            this.listenerId[0] = this.listenerId[0] + 1;
            id = this.listenerId[0];
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return id;
        }
    }

    public String getStats() throws IOException {
        return this.cacheManager.getStats();
    }

    private ICacheEvent createICacheEvent(ICacheElement item, long requesterId, String eventName) {
        if (this.cacheEventLogger == null) {
            return EMPTY_ICACHE_EVENT;
        }
        String ipAddress = this.getExtraInfoForRequesterId(requesterId);
        return this.cacheEventLogger.createICacheEvent("RemoteCacheServer", item.getCacheName(), eventName, ipAddress, item);
    }

    private ICacheEvent createICacheEvent(String cacheName, Serializable key, long requesterId, String eventName) {
        if (this.cacheEventLogger == null) {
            return EMPTY_ICACHE_EVENT;
        }
        String ipAddress = this.getExtraInfoForRequesterId(requesterId);
        return this.cacheEventLogger.createICacheEvent("RemoteCacheServer", cacheName, eventName, ipAddress, key);
    }

    protected void logApplicationEvent(String source, String eventName, String optionalDetails) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logApplicationEvent(source, eventName, optionalDetails);
        }
    }

    protected void logICacheEvent(ICacheEvent cacheEvent) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logICacheEvent(cacheEvent);
        }
    }

    protected String getExtraInfoForRequesterId(long requesterId) {
        String ipAddress = (String)this.idIPMap.get(new Long(requesterId));
        return ipAddress;
    }

    public void setCacheEventLogger(ICacheEventLogger cacheEventLogger) {
        this.cacheEventLogger = cacheEventLogger;
    }
}

