/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.key;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.utils.date.DateFormatter;
import org.apache.jcs.utils.net.AddressUtil;

public final class KeyGeneratorUtil {
    private static final Log log = LogFactory.getLog((Class)KeyGeneratorUtil.class);
    private static int requestCounter = 0;
    private static long lastCounterResetTime = System.currentTimeMillis();
    private static final long DEFAULT_COUNTER_RESET_INTERVAL_MILLIS = 0x6DDD00L;
    protected static long counterResetIntervalMillis = 0x6DDD00L;
    private static final int LENGTH_OF_DATE_STRING = 8;
    public static final String KEY_LEAD_NUMBER_PROPERTY_NAME = "KEY_LEAD_NUMBER";
    public static final int DEFAULT_LEAD_NUMBER = 3;
    protected static int leadNumber = 3;

    protected static void setLeadFromSystemProperty() {
        String leadString = System.getProperty(KEY_LEAD_NUMBER_PROPERTY_NAME, String.valueOf(3));
        if (log.isInfoEnabled()) {
            log.info((Object)("leadString = [" + leadString + "]"));
        }
        try {
            leadNumber = Integer.parseInt(leadString);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Problem parsing lead number system property value. [" + leadString + "]"), (Throwable)e);
        }
    }

    public static String generateRequestId() {
        int counter = KeyGeneratorUtil.getNextRequestCounter();
        Date d = new Date();
        String dateString = DateFormatter.getDddHHmm(d);
        String finalOctetOfIp = AddressUtil.obtainFinalThreeDigitsOfAddressAsString();
        String queryId = leadNumber + dateString + finalOctetOfIp + counter;
        return queryId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Date getDateOfShopFromRequestId(String queryId) throws ParseException {
        int minute;
        int hour;
        int dayOfYear;
        Date date = null;
        if (queryId == null) throw new ParseException("Can't parse a null string.", 0);
        if (queryId.length() < 8) throw new ParseException("The input string is not long enough [" + queryId + "]", queryId.length());
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        try {
            dayOfYear = Integer.parseInt(queryId.substring(1, 4));
            hour = Integer.parseInt(queryId.substring(4, 6));
            minute = Integer.parseInt(queryId.substring(6, 8));
        }
        catch (NumberFormatException e) {
            throw new ParseException("Error reading date/hour/minute from input string [" + queryId + "]", 0);
        }
        cal.set(1, year);
        cal.set(6, dayOfYear);
        cal.set(11, hour);
        cal.set(12, minute);
        return cal.getTime();
    }

    protected static synchronized int getNextRequestCounter() {
        long now = System.currentTimeMillis();
        if (now - lastCounterResetTime > counterResetIntervalMillis) {
            KeyGeneratorUtil.resetCounter();
        }
        return ++requestCounter;
    }

    protected static synchronized void resetCounter() {
        lastCounterResetTime = System.currentTimeMillis();
        requestCounter = 0;
    }

    static {
        KeyGeneratorUtil.setLeadFromSystemProperty();
    }
}

