/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.http.server;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.engine.logging.CacheEvent;
import org.apache.jcs.engine.logging.behavior.ICacheEvent;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;

public abstract class AbstractRemoteCacheService
implements IRemoteCacheService {
    private transient ICacheEventLogger cacheEventLogger;
    private static final ICacheEvent EMPTY_ICACHE_EVENT = new CacheEvent();
    private ICompositeCacheManager cacheManager;
    private String eventLogSourceName = "AbstractRemoteCacheService";
    private int puts = 0;
    private int logInterval = 100;
    private static final Log log = LogFactory.getLog((Class)AbstractRemoteCacheService.class);

    public AbstractRemoteCacheService(ICompositeCacheManager cacheManager, ICacheEventLogger cacheEventLogger) {
        this.cacheManager = cacheManager;
        this.cacheEventLogger = cacheEventLogger;
    }

    public void update(ICacheElement item) throws IOException {
        this.update(item, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ICacheElement item, long requesterId) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(item, requesterId, "update");
        try {
            this.logUpdateInfo(item);
            this.processUpdate(item, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    abstract void processUpdate(ICacheElement var1, long var2) throws IOException;

    private void logUpdateInfo(ICacheElement item) {
        if (log.isInfoEnabled()) {
            ++this.puts;
            if (this.puts % this.logInterval == 0) {
                log.info((Object)("puts = " + this.puts));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("In update, put [" + item.getKey() + "] in [" + item.getCacheName() + "]"));
        }
    }

    public ICacheElement get(String cacheName, Serializable key) throws IOException {
        return this.get(cacheName, key, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICacheElement get(String cacheName, Serializable key, long requesterId) throws IOException {
        ICacheElement element = null;
        ICacheEvent cacheEvent = this.createICacheEvent(cacheName, key, requesterId, "get");
        try {
            element = this.processGet(cacheName, key, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
        return element;
    }

    abstract ICacheElement processGet(String var1, Serializable var2, long var3) throws IOException;

    public Map getMatching(String cacheName, String pattern) throws IOException {
        return this.getMatching(cacheName, pattern, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMatching(String cacheName, String pattern, long requesterId) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(cacheName, (Serializable)((Object)pattern), requesterId, "getMatching");
        try {
            Map map = this.processGetMatching(cacheName, pattern, requesterId);
            return map;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    abstract Map processGetMatching(String var1, String var2, long var3) throws IOException;

    public Map getMultiple(String cacheName, Set keys) throws IOException {
        return this.getMultiple(cacheName, keys, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMultiple(String cacheName, Set keys, long requesterId) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(cacheName, (Serializable)((Object)keys), requesterId, "getMultiple");
        try {
            Map map = this.processGetMultiple(cacheName, keys, requesterId);
            return map;
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    abstract Map processGetMultiple(String var1, Set var2, long var3) throws IOException;

    public Set getGroupKeys(String cacheName, String group) {
        return this.processGetGroupKeys(cacheName, group);
    }

    public Set processGetGroupKeys(String cacheName, String groupName) {
        CompositeCache cache = this.getCacheManager().getCache(cacheName);
        return cache.getGroupKeys(groupName);
    }

    public void remove(String cacheName, Serializable key) throws IOException {
        this.remove(cacheName, key, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String cacheName, Serializable key, long requesterId) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(cacheName, key, requesterId, "remove");
        try {
            this.processRemove(cacheName, key, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    abstract void processRemove(String var1, Serializable var2, long var3) throws IOException;

    public void removeAll(String cacheName) throws IOException {
        this.removeAll(cacheName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(String cacheName, long requesterId) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(cacheName, (Serializable)((Object)"all"), requesterId, "removeAll");
        try {
            this.processRemoveAll(cacheName, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    abstract void processRemoveAll(String var1, long var2) throws IOException;

    public void dispose(String cacheName) throws IOException {
        this.dispose(cacheName, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose(String cacheName, long requesterId) throws IOException {
        ICacheEvent cacheEvent = this.createICacheEvent(cacheName, (Serializable)((Object)"none"), requesterId, "dispose");
        try {
            this.processDispose(cacheName, requesterId);
        }
        finally {
            this.logICacheEvent(cacheEvent);
        }
    }

    abstract void processDispose(String var1, long var2) throws IOException;

    public String getStats() throws IOException {
        return this.cacheManager.getStats();
    }

    protected ICacheEvent createICacheEvent(ICacheElement item, long requesterId, String eventName) {
        if (this.cacheEventLogger == null) {
            return EMPTY_ICACHE_EVENT;
        }
        String ipAddress = this.getExtraInfoForRequesterId(requesterId);
        return this.cacheEventLogger.createICacheEvent(this.getEventLogSourceName(), item.getCacheName(), eventName, ipAddress, item);
    }

    protected ICacheEvent createICacheEvent(String cacheName, Serializable key, long requesterId, String eventName) {
        if (this.cacheEventLogger == null) {
            return EMPTY_ICACHE_EVENT;
        }
        String ipAddress = this.getExtraInfoForRequesterId(requesterId);
        return this.cacheEventLogger.createICacheEvent(this.getEventLogSourceName(), cacheName, eventName, ipAddress, key);
    }

    protected void logApplicationEvent(String source, String eventName, String optionalDetails) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logApplicationEvent(source, eventName, optionalDetails);
        }
    }

    protected void logICacheEvent(ICacheEvent cacheEvent) {
        if (this.cacheEventLogger != null) {
            this.cacheEventLogger.logICacheEvent(cacheEvent);
        }
    }

    protected abstract String getExtraInfoForRequesterId(long var1);

    public void setCacheEventLogger(ICacheEventLogger cacheEventLogger) {
        this.cacheEventLogger = cacheEventLogger;
    }

    protected void setCacheManager(CompositeCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected ICompositeCacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected void setEventLogSourceName(String eventLogSourceName) {
        this.eventLogSourceName = eventLogSourceName;
    }

    protected String getEventLogSourceName() {
        return this.eventLogSourceName;
    }
}

