/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.server;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCacheConfigurator;
import org.apache.jcs.auxiliary.remote.RemoteUtils;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheServiceAdmin;
import org.apache.jcs.auxiliary.remote.server.RegistryKeepAliveRunner;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheServer;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheServerAttributes;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;
import org.apache.jcs.utils.config.OptionConverter;
import org.apache.jcs.utils.config.PropertySetter;

public class RemoteCacheServerFactory
implements IRemoteCacheConstants {
    private static final Log log = LogFactory.getLog((Class)RemoteCacheServerFactory.class);
    private static RemoteCacheServer remoteCacheServer;
    private static String serviceName;
    private static ClockDaemon keepAliveDaemon;

    private RemoteCacheServerFactory() {
    }

    public static RemoteCacheServer getRemoteCacheServer() {
        return remoteCacheServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startup(String host, int port, String propFile) throws IOException {
        if (remoteCacheServer != null) {
            throw new IllegalArgumentException("Server already started.");
        }
        Class clazz = RemoteCacheServer.class;
        synchronized (clazz) {
            if (remoteCacheServer != null) {
                return;
            }
            if (host == null) {
                host = "";
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("ConfigFileName = [" + propFile + "]"));
            }
            Properties props = RemoteUtils.loadProps(propFile);
            RemoteCacheServerAttributes rcsa = RemoteCacheServerFactory.configureServerAttributes(propFile);
            rcsa.setRemotePort(port);
            rcsa.setRemoteHost(host);
            if (log.isInfoEnabled()) {
                log.info((Object)("Creating server with these attributes: " + rcsa));
            }
            RemoteCacheServerFactory.setServiceName(rcsa.getRemoteServiceName());
            RMISocketFactory customRMISocketFactory = RemoteCacheServerFactory.configureObjectSpecificCustomFactory(props);
            RemoteUtils.configureGlobalCustomSocketFactory(rcsa.getRmiSocketFactoryTimeoutMillis());
            ICacheEventLogger cacheEventLogger = RemoteCacheServerFactory.configureCacheEventLogger(props);
            remoteCacheServer = customRMISocketFactory != null ? new RemoteCacheServer(rcsa, customRMISocketFactory) : new RemoteCacheServer(rcsa);
            remoteCacheServer.setCacheEventLogger(cacheEventLogger);
            RemoteCacheServerFactory.startTheRegistry(port, rcsa);
            RemoteCacheServerFactory.registerServer(host, port, serviceName);
            if (rcsa.isUseRegistryKeepAlive()) {
                if (keepAliveDaemon == null) {
                    keepAliveDaemon = new ClockDaemon();
                    keepAliveDaemon.setThreadFactory((ThreadFactory)new MyThreadFactory());
                }
                RegistryKeepAliveRunner runner = new RegistryKeepAliveRunner(host, port, serviceName);
                runner.setCacheEventLogger(cacheEventLogger);
                keepAliveDaemon.executePeriodically(rcsa.getRegistryKeepAliveDelayMillis(), (Runnable)runner, false);
            }
        }
    }

    protected static ICacheEventLogger configureCacheEventLogger(Properties props) {
        ICacheEventLogger cacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(props, "jcs.remotecache");
        if (cacheEventLogger == null) {
            cacheEventLogger = AuxiliaryCacheConfigurator.parseCacheEventLogger(props, "remote");
        }
        return cacheEventLogger;
    }

    protected static RMISocketFactory configureObjectSpecificCustomFactory(Properties props) {
        RMISocketFactory customRMISocketFactory = (RMISocketFactory)OptionConverter.instantiateByKey(props, "jcs.remotecache.customrmisocketfactory", RMIClientSocketFactory.class, null);
        if (customRMISocketFactory != null) {
            PropertySetter.setProperties(customRMISocketFactory, props, "jcs.remotecache.customrmisocketfactory.");
            if (log.isInfoEnabled()) {
                log.info((Object)("Will use server specific custom socket factory. " + customRMISocketFactory));
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)"No server specific custom socket factory defined.");
        }
        return customRMISocketFactory;
    }

    private static void startTheRegistry(int registryPort, RemoteCacheServerAttributes rcsa) {
        if (rcsa.isStartRegistry()) {
            try {
                LocateRegistry.createRegistry(registryPort);
            }
            catch (RemoteException e) {
                log.warn((Object)("Problem creating registry.  It may already be started. " + e.getMessage()));
            }
            catch (Throwable t) {
                log.error((Object)"Problem creating registry.", t);
            }
        }
    }

    protected static void registerServer(String host, int port, String serviceName) throws RemoteException {
        if (remoteCacheServer == null) {
            String message = "Cannot register the server until it is created.  Please start the server first.";
            log.error((Object)message);
            throw new RemoteException(message);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Binding server to " + host + ":" + port + " with the name " + serviceName));
        }
        try {
            Naming.rebind("//" + host + ":" + port + "/" + serviceName, remoteCacheServer);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex.getMessage() + "; host=" + host + ", port=" + port);
        }
    }

    protected static RemoteCacheServerAttributes configureServerAttributes(String propFile) throws IOException {
        Properties prop = RemoteUtils.loadProps(propFile);
        RemoteCacheServerAttributes rcsa = RemoteCacheServerFactory.configureRemoteCacheServerAttributes(prop);
        rcsa.setConfigFileName(propFile);
        return rcsa;
    }

    protected static RemoteCacheServerAttributes configureRemoteCacheServerAttributes(Properties prop) {
        RemoteCacheServerAttributes rcsa = new RemoteCacheServerAttributes();
        PropertySetter.setProperties(rcsa, prop, "jcs.remotecache.serverattributes.");
        RemoteCacheServerFactory.configureManuallyIfValuesArePresent(prop, rcsa);
        return rcsa;
    }

    private static void configureManuallyIfValuesArePresent(Properties prop, RemoteCacheServerAttributes rcsa) {
        String acgStr;
        String lccStr;
        String socketTimeoutMillisStr;
        String servicePortStr = prop.getProperty("remote.cache.service.port");
        if (servicePortStr != null) {
            try {
                int servicePort = Integer.parseInt(servicePortStr);
                rcsa.setServicePort(servicePort);
                log.debug((Object)("Remote cache service uses port number " + servicePort + "."));
            }
            catch (NumberFormatException ignore) {
                log.debug((Object)"Remote cache service port property remote.cache.service.port not specified.  An anonymous port will be used.");
            }
        }
        if ((socketTimeoutMillisStr = prop.getProperty("remote.cache.rmiSocketFactoryTimeoutMillis")) != null) {
            try {
                int rmiSocketFactoryTimeoutMillis = Integer.parseInt(socketTimeoutMillisStr);
                rcsa.setRmiSocketFactoryTimeoutMillis(rmiSocketFactoryTimeoutMillis);
                log.debug((Object)("Remote cache socket timeout " + rmiSocketFactoryTimeoutMillis + "ms."));
            }
            catch (NumberFormatException ignore) {
                log.debug((Object)"Remote cache socket timeout property remote.cache.rmiSocketFactoryTimeoutMillis not specified.  The default will be used.");
            }
        }
        if ((lccStr = prop.getProperty("remote.cluster.LocalClusterConsistency")) != null) {
            if (lccStr == null) {
                lccStr = "true";
            }
            boolean lcc = Boolean.valueOf(lccStr);
            rcsa.setLocalClusterConsistency(lcc);
        }
        if ((acgStr = prop.getProperty("remote.cluster.AllowClusterGet")) != null) {
            if (acgStr == null) {
                acgStr = "true";
            }
            boolean acg = Boolean.valueOf(acgStr);
            rcsa.setAllowClusterGet(acg);
        }
        rcsa.setRemoteServiceName(prop.getProperty("remote.cache.service.name", REMOTE_CACHE_SERVICE_VAL).trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void shutdownImpl(String host, int port) throws IOException {
        if (remoteCacheServer == null) {
            return;
        }
        Class clazz = RemoteCacheServer.class;
        synchronized (clazz) {
            if (remoteCacheServer == null) {
                return;
            }
            log.info((Object)("Unbinding host=" + host + ", port=" + port + ", serviceName=" + RemoteCacheServerFactory.getServiceName()));
            try {
                Naming.unbind("//" + host + ":" + port + "/" + RemoteCacheServerFactory.getServiceName());
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException(ex.getMessage() + "; host=" + host + ", port=" + port + ", serviceName=" + RemoteCacheServerFactory.getServiceName());
            }
            catch (NotBoundException ex) {
                // empty catch block
            }
            remoteCacheServer.release();
            remoteCacheServer = null;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    public static void main(String[] args) throws Exception {
        String host;
        IRemoteCacheServiceAdmin admin;
        Remote obj;
        String registry;
        String serviceName;
        int port;
        Properties prop = args.length > 0 ? RemoteUtils.loadProps(args[args.length - 1]) : new Properties();
        try {
            port = Integer.parseInt(prop.getProperty("registry.port"));
        }
        catch (NumberFormatException ex) {
            port = 1099;
        }
        if (args.length > 0 && args[0].toLowerCase().indexOf("-shutdown") != -1) {
            serviceName = prop.getProperty("remote.cache.service.name", REMOTE_CACHE_SERVICE_VAL).trim();
            registry = "//:" + port + "/" + serviceName;
            if (log.isDebugEnabled()) {
                log.debug((Object)("looking up server " + registry));
            }
            obj = Naming.lookup(registry);
            if (log.isDebugEnabled()) {
                log.debug((Object)"server found");
            }
            admin = (IRemoteCacheServiceAdmin)obj;
            try {
                admin.shutdown();
            }
            catch (Exception ex) {
                log.error((Object)"Problem calling shutdown.", (Throwable)ex);
            }
            log.debug((Object)"done.");
            System.exit(0);
        }
        if (args.length > 0 && args[0].toLowerCase().indexOf("-stats") != -1) {
            log.debug((Object)"getting cache stats");
            try {
                serviceName = prop.getProperty("remote.cache.service.name", REMOTE_CACHE_SERVICE_VAL).trim();
                registry = "//:" + port + "/" + serviceName;
                log.debug((Object)("looking up server " + registry));
                obj = Naming.lookup(registry);
                log.debug((Object)"server found");
                log.debug((Object)("obj = " + obj));
                admin = (IRemoteCacheServiceAdmin)obj;
                try {
                    System.out.println(admin.getStats().toString());
                    log.debug((Object)admin.getStats());
                }
                catch (Exception es) {
                    log.error((Object)es);
                }
            }
            catch (Exception ex) {
                log.error((Object)"Problem getting stats.", (Throwable)ex);
            }
            log.debug((Object)"done.");
            System.exit(0);
        }
        if ((host = prop.getProperty("registry.host")) == null || host.trim().equals("") || host.trim().equals("localhost")) {
            log.debug((Object)"main> creating registry on the localhost");
            port = RemoteUtils.createRegistry(port);
        }
        log.debug((Object)"main> starting up RemoteCacheServer");
        RemoteCacheServerFactory.startup(host, port, args.length > 0 ? args[0] : null);
        log.debug((Object)"main> done");
    }

    protected static void setServiceName(String serviceName) {
        RemoteCacheServerFactory.serviceName = serviceName;
    }

    protected static String getServiceName() {
        return serviceName;
    }

    static {
        serviceName = IRemoteCacheConstants.REMOTE_CACHE_SERVICE_VAL;
    }

    static class MyThreadFactory
    implements ThreadFactory {
        MyThreadFactory() {
        }

        public Thread newThread(Runnable runner) {
            Thread t = new Thread(runner);
            String oldName = t.getName();
            t.setName("JCS-RemoteCacheServerFactory-" + oldName);
            t.setDaemon(true);
            t.setPriority(1);
            return t;
        }
    }
}

