/*
 * Decompiled with CFR 0.152.
 */
package com.javamex.classmexer;

import com.javamex.classmexer.Agent;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryUtil {
    public static long memoryUsageOf(Object obj) {
        return Agent.getInstrumentation().getObjectSize(obj);
    }

    public static long deepMemoryUsageOf(Object obj) {
        return MemoryUtil.deepMemoryUsageOf(obj, VisibilityFilter.NON_PUBLIC);
    }

    public static long deepMemoryUsageOf(Object obj, VisibilityFilter referenceFilter) {
        return MemoryUtil.deepMemoryUsageOf0(Agent.getInstrumentation(), new HashSet<Integer>(), obj, referenceFilter);
    }

    public static long deepMemoryUsageOfAll(Collection<? extends Object> objs) {
        return MemoryUtil.deepMemoryUsageOfAll(objs, VisibilityFilter.NON_PUBLIC);
    }

    public static long deepMemoryUsageOfAll(Collection<? extends Object> objs, VisibilityFilter referenceFilter) {
        Instrumentation instr = Agent.getInstrumentation();
        long total = 0L;
        HashSet<Integer> counted = new HashSet<Integer>(objs.size() * 4);
        for (Object object : objs) {
            total += MemoryUtil.deepMemoryUsageOf0(instr, counted, object, referenceFilter);
        }
        return total;
    }

    private static long deepMemoryUsageOf0(Instrumentation instrumentation, Set<Integer> counted, Object obj, VisibilityFilter filter) throws SecurityException {
        Stack<Object> st = new Stack<Object>();
        st.push(obj);
        long total = 0L;
        while (!st.isEmpty()) {
            int n;
            Object o = st.pop();
            if (!counted.add(System.identityHashCode(o))) continue;
            long sz = instrumentation.getObjectSize(o);
            total += sz;
            Class<?> clz = o.getClass();
            Class<?> compType = clz.getComponentType();
            if (compType != null && !compType.isPrimitive()) {
                Object[] arr;
                Object[] objectArray = arr = (Object[])o;
                n = 0;
                int n2 = objectArray.length;
                while (n < n2) {
                    Object el = objectArray[n];
                    if (el != null) {
                        st.push(el);
                    }
                    ++n;
                }
            }
            while (clz != null) {
                Field[] fieldArray = clz.getDeclaredFields();
                int n3 = 0;
                n = fieldArray.length;
                while (n3 < n) {
                    Class<?> fieldClass;
                    Field fld = fieldArray[n3];
                    int mod = fld.getModifiers();
                    if ((mod & 8) == 0 && MemoryUtil.isOf(filter, mod) && !(fieldClass = fld.getType()).isPrimitive()) {
                        if (!fld.isAccessible()) {
                            fld.setAccessible(true);
                        }
                        try {
                            Object subObj = fld.get(o);
                            if (subObj != null) {
                                st.push(subObj);
                            }
                        }
                        catch (IllegalAccessException illAcc) {
                            throw new InternalError("Couldn't read " + fld);
                        }
                    }
                    ++n3;
                }
                clz = clz.getSuperclass();
            }
        }
        return total;
    }

    private static boolean isOf(VisibilityFilter f, int mod) {
        switch (f) {
            case ALL: {
                return true;
            }
            case NONE: {
                return false;
            }
            case PRIVATE_ONLY: {
                return (mod & 2) != 0;
            }
            case NON_PUBLIC: {
                return (mod & 1) == 0;
            }
        }
        throw new IllegalArgumentException("Illegal filter " + mod);
    }

    private MemoryUtil() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VisibilityFilter {
        ALL,
        PRIVATE_ONLY,
        NON_PUBLIC,
        NONE;

    }
}

