/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.http.server;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.auxiliary.remote.http.server.RemoteHttpCacheSeviceFactory;
import org.apache.jcs.auxiliary.remote.value.RemoteCacheRequest;
import org.apache.jcs.auxiliary.remote.value.RemoteCacheResponse;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.control.CompositeCacheManager;

public class RemoteCacheServiceAdaptor {
    private static final Log log = LogFactory.getLog((Class)RemoteCacheServiceAdaptor.class);
    private IRemoteCacheService remoteCacheService;

    protected RemoteCacheServiceAdaptor() {
    }

    public RemoteCacheServiceAdaptor(CompositeCacheManager cacheManager) {
        this.setRemoteCacheService(RemoteHttpCacheSeviceFactory.createRemoteHttpCacheService(cacheManager));
    }

    public RemoteCacheResponse processRequest(RemoteCacheRequest request) {
        RemoteCacheResponse response = new RemoteCacheResponse();
        if (request == null) {
            String message = "The request is null.  Cannot process";
            log.warn((Object)message);
            response.setSuccess(false);
            response.setErrorMessage(message);
        } else {
            try {
                switch (request.getRequestType()) {
                    case 1: {
                        ICacheElement element = this.getRemoteCacheService().get(request.getCacheName(), request.getKey(), request.getRequesterId());
                        if (element != null) {
                            response.getPayload().put(element.getKey(), element);
                        }
                        break;
                    }
                    case 2: {
                        Map elementMap = this.getRemoteCacheService().getMultiple(request.getCacheName(), request.getKeySet(), request.getRequesterId());
                        if (elementMap != null) {
                            response.getPayload().putAll(elementMap);
                        }
                        break;
                    }
                    case 3: {
                        Map elementMapMatching = this.getRemoteCacheService().getMatching(request.getCacheName(), request.getPattern(), request.getRequesterId());
                        if (elementMapMatching != null) {
                            response.getPayload().putAll(elementMapMatching);
                        }
                        break;
                    }
                    case 5: {
                        this.getRemoteCacheService().remove(request.getCacheName(), request.getKey(), request.getRequesterId());
                        break;
                    }
                    case 6: {
                        this.getRemoteCacheService().removeAll(request.getCacheName(), request.getRequesterId());
                        break;
                    }
                    case 4: {
                        this.getRemoteCacheService().update(request.getCacheElement(), request.getRequesterId());
                        break;
                    }
                    case 0: {
                        response.setSuccess(true);
                        break;
                    }
                    case 8: {
                        response.setSuccess(true);
                        break;
                    }
                    case 7: {
                        Set groupKeys = this.getRemoteCacheService().getGroupKeys(request.getCacheName(), request.getKey() + "");
                        if (groupKeys == null) {
                            groupKeys = Collections.EMPTY_SET;
                        }
                        response.getPayload().put(request.getKey(), groupKeys);
                        break;
                    }
                    default: {
                        String message = "Unknown event type.  Cannot process " + request;
                        log.warn((Object)message);
                        response.setSuccess(false);
                        response.setErrorMessage(message);
                        break;
                    }
                }
            }
            catch (Exception e) {
                String message = "Problem processing request. " + request + " Error: " + e.getMessage();
                log.error((Object)message, (Throwable)e);
                response.setSuccess(false);
                response.setErrorMessage(message);
            }
        }
        return response;
    }

    public void setRemoteCacheService(IRemoteCacheService remoteHttpCacheService) {
        this.remoteCacheService = remoteHttpCacheService;
    }

    public IRemoteCacheService getRemoteCacheService() {
        return this.remoteCacheService;
    }
}

