/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.behavior.ICacheListener;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public class CacheEventQueue
implements ICacheEventQueue {
    private static final Log log = LogFactory.getLog((Class)CacheEventQueue.class);
    private static final String queueType = "SINGLE";
    private static final int DEFAULT_WAIT_TO_DIE_MILLIS = 10000;
    private int waitToDieMillis = 10000;
    private ICacheListener listener;
    private long listenerId;
    private String cacheName;
    private int maxFailure;
    private int waitBeforeRetry;
    private boolean destroyed = true;
    private boolean working = true;
    private Thread processorThread;
    private Object queueLock = new Object();
    private Node head;
    private Node tail = this.head = new Node();
    private int size = 0;

    public CacheEventQueue(ICacheListener listener, long listenerId, String cacheName) {
        this(listener, listenerId, cacheName, 10, 500);
    }

    public CacheEventQueue(ICacheListener listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry) {
        this.initialize(listener, listenerId, cacheName, maxFailure, waitBeforeRetry, null);
    }

    public void initialize(ICacheListener listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry, String threadPoolName) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listener = listener;
        this.listenerId = listenerId;
        this.cacheName = cacheName;
        this.maxFailure = maxFailure <= 0 ? 3 : maxFailure;
        int n = this.waitBeforeRetry = waitBeforeRetry <= 0 ? 500 : waitBeforeRetry;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructed: " + this));
        }
    }

    public String getQueueType() {
        return queueType;
    }

    public synchronized void stopProcessing() {
        this.destroyed = true;
        this.processorThread = null;
    }

    public int getWaitToDieMillis() {
        return this.waitToDieMillis;
    }

    public void setWaitToDieMillis(int wtdm) {
        this.waitToDieMillis = wtdm;
    }

    public String toString() {
        return "CacheEventQueue [listenerId=" + this.listenerId + ", cacheName=" + this.cacheName + "]";
    }

    public synchronized boolean isAlive() {
        return !this.destroyed;
    }

    public synchronized void setAlive(boolean aState) {
        this.destroyed = !aState;
    }

    public long getListenerId() {
        return this.listenerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            if (log.isInfoEnabled()) {
                log.info((Object)("Destroying queue, stats =  " + this.getStatistics()));
            }
            if (this.processorThread != null) {
                Object object = this.queueLock;
                synchronized (object) {
                    this.processorThread.interrupt();
                }
            }
            this.processorThread = null;
            if (log.isInfoEnabled()) {
                log.info((Object)("Cache event queue destroyed: " + this));
            }
        } else if (log.isInfoEnabled()) {
            log.info((Object)("Destroy was called after queue was destroyed.  Doing nothing.  Stats =  " + this.getStatistics()));
        }
    }

    public synchronized void addPutEvent(ICacheElement ce) throws IOException {
        if (this.isWorking()) {
            this.put(new PutEvent(ce));
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Not enqueuing Put Event for [" + this + "] because it's non-functional."));
        }
    }

    public synchronized void addRemoveEvent(Serializable key) throws IOException {
        if (this.isWorking()) {
            this.put(new RemoveEvent(key));
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Not enqueuing Remove Event for [" + this + "] because it's non-functional."));
        }
    }

    public synchronized void addRemoveAllEvent() throws IOException {
        if (this.isWorking()) {
            this.put(new RemoveAllEvent());
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Not enqueuing RemoveAll Event for [" + this + "] because it's non-functional."));
        }
    }

    public synchronized void addDisposeEvent() throws IOException {
        if (this.isWorking()) {
            this.put(new DisposeEvent());
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Not enqueuing Dispose Event for [" + this + "] because it's non-functional."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(AbstractCacheEvent event) {
        Node newNode = new Node();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event entering Queue for " + this.cacheName + ": " + event));
        }
        newNode.event = event;
        Object object = this.queueLock;
        synchronized (object) {
            ++this.size;
            this.tail.next = newNode;
            this.tail = newNode;
            if (this.isWorking()) {
                if (!this.isAlive()) {
                    this.destroyed = false;
                    this.processorThread = new QProcessor(this);
                    this.processorThread.start();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Cache event queue created: " + this));
                    }
                } else {
                    this.queueLock.notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractCacheEvent take() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.head == this.tail) {
                return null;
            }
            Node node = this.head.next;
            AbstractCacheEvent value = node.event;
            if (log.isDebugEnabled()) {
                log.debug((Object)("head.event = " + this.head.event));
                log.debug((Object)("node.event = " + node.event));
            }
            node.event = null;
            this.head = node;
            --this.size;
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Cache Event Queue");
        ArrayList<StatElement> elems = new ArrayList<StatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Working");
        se.setData("" + this.working);
        elems.add(se);
        se = new StatElement();
        se.setName("Alive");
        se.setData("" + this.isAlive());
        elems.add(se);
        se = new StatElement();
        se.setName("Empty");
        se.setData("" + this.isEmpty());
        elems.add(se);
        int size = 0;
        Object object = this.queueLock;
        synchronized (object) {
            if (this.head == this.tail) {
                size = 0;
            } else {
                Node n = this.head;
                while (n != null) {
                    n = n.next;
                    ++size;
                }
            }
            se = new StatElement();
            se.setName("Size");
            se.setData("" + size);
            elems.add(se);
        }
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    public boolean isWorking() {
        return this.working;
    }

    public void setWorking(boolean b) {
        this.working = b;
    }

    public boolean isEmpty() {
        return this.tail == this.head;
    }

    public int size() {
        return this.size;
    }

    private class DisposeEvent
    extends AbstractCacheEvent {
        private DisposeEvent() {
        }

        protected void doRun() throws IOException {
            CacheEventQueue.this.listener.handleDispose(CacheEventQueue.this.cacheName);
        }

        public String toString() {
            return "DisposeEvent";
        }
    }

    private class RemoveAllEvent
    extends AbstractCacheEvent {
        private RemoveAllEvent() {
        }

        protected void doRun() throws IOException {
            CacheEventQueue.this.listener.handleRemoveAll(CacheEventQueue.this.cacheName);
        }

        public String toString() {
            return "RemoveAllEvent";
        }
    }

    private class RemoveEvent
    extends AbstractCacheEvent {
        private Serializable key;

        RemoveEvent(Serializable key) throws IOException {
            this.key = key;
        }

        protected void doRun() throws IOException {
            CacheEventQueue.this.listener.handleRemove(CacheEventQueue.this.cacheName, this.key);
        }

        public String toString() {
            return "RemoveEvent for " + this.key;
        }
    }

    private class PutEvent
    extends AbstractCacheEvent {
        private ICacheElement ice;

        PutEvent(ICacheElement ice) throws IOException {
            this.ice = ice;
        }

        protected void doRun() throws IOException {
            CacheEventQueue.this.listener.handlePut(this.ice);
        }

        public String toString() {
            return "PutEvent for key: " + this.ice.getKey() + " value: " + this.ice.getVal();
        }
    }

    private abstract class AbstractCacheEvent
    implements Runnable {
        int failures = 0;
        boolean done = false;

        private AbstractCacheEvent() {
        }

        public void run() {
            try {
                this.doRun();
            }
            catch (IOException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)e);
                }
                if (++this.failures >= CacheEventQueue.this.maxFailure) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Error while running event from Queue: " + this + ". Dropping Event and marking Event Queue as non-functional."));
                    }
                    CacheEventQueue.this.setWorking(false);
                    CacheEventQueue.this.setAlive(false);
                    return;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Error while running event from Queue: " + this + ". Retrying..."));
                }
                try {
                    Thread.sleep(CacheEventQueue.this.waitBeforeRetry);
                    this.run();
                }
                catch (InterruptedException ie) {
                    if (log.isErrorEnabled()) {
                        log.warn((Object)("Interrupted while sleeping for retry on event " + this + "."));
                    }
                    CacheEventQueue.this.setWorking(false);
                    CacheEventQueue.this.setAlive(false);
                }
            }
        }

        protected abstract void doRun() throws IOException;
    }

    private class QProcessor
    extends Thread {
        CacheEventQueue queue;

        QProcessor(CacheEventQueue aQueue) {
            super("CacheEventQueue.QProcessor-" + aQueue.cacheName);
            this.setDaemon(true);
            this.queue = aQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            AbstractCacheEvent event = null;
            while (this.queue.isAlive()) {
                event = this.queue.take();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Event from queue = " + event));
                }
                if (event == null) {
                    Object object = CacheEventQueue.this.queueLock;
                    synchronized (object) {
                        try {
                            CacheEventQueue.this.queueLock.wait(this.queue.getWaitToDieMillis());
                        }
                        catch (InterruptedException e) {
                            log.warn((Object)"Interrupted while waiting for another event to come in before we die.");
                            return;
                        }
                        event = this.queue.take();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Event from queue after sleep = " + event));
                        }
                    }
                    if (event == null) {
                        this.queue.stopProcessing();
                    }
                }
                if (!this.queue.isWorking() || !this.queue.isAlive() || event == null) continue;
                event.run();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("QProcessor exiting for " + this.queue));
            }
        }
    }

    private static class Node {
        Node next = null;
        AbstractCacheEvent event = null;

        private Node() {
        }
    }
}

