/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.Config;
import com.fe.auth.ValidateSuperUser;
import com.fe.auth.ValidateWikiPass;
import com.fe.db.WikiDB;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.util.Logger;

public class LoginMgmt {
    private Logger log = Logger.getLogger(LoginMgmt.class);
    private static String dbname = Config.getString("db_wiki");
    private HttpServletRequest request = null;

    public LoginMgmt() {
    }

    public LoginMgmt(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
    }

    public static String getDBName() {
        return dbname;
    }

    public Map login(String string, String string2) throws Exception {
        WikiDB wikiDB = WikiDB.getWikiDB();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Object object;
            this.log.debug("connecting wiki db...db:" + wikiDB.getDriver(dbname) + " driver:");
            wikiDB.connectDB(LoginMgmt.getDBName());
            this.log.debug("connected catalog:" + wikiDB.connection().getCatalog());
            boolean bl = new ValidateWikiPass().validateUser(string, string2, wikiDB);
            if (!bl) {
                hashMap.put("message", "Invalid username or password");
            } else {
                object = this.getRequest().getSession(true);
                object.setMaxInactiveInterval(86400);
                object.setAttribute("session^logged^user", (Object)string);
                boolean bl2 = false;
                object.setAttribute("session^logged^header", (Object)this.getHeaders(this.getRequest(), bl2));
                String string3 = wikiDB.getEncryptedPwd(string);
                hashMap.put("fesessionuid", string3);
            }
            hashMap.put("loggedin", bl);
            object = hashMap;
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            wikiDB.closeDB();
        }
    }

    private Map getHeaders(HttpServletRequest httpServletRequest, boolean bl) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashMap.put(string, httpServletRequest.getHeader(string));
        }
        hashMap.put("sess_cookielogin", bl);
        hashMap.put("sess_ip_address", this.getRequest().getRemoteAddr());
        return hashMap;
    }

    public Map loginSuperUser(String string, String string2, String string3) throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Object object;
            boolean bl = false;
            if (string.equalsIgnoreCase("administrator") && string3 != null && !string3.equals("")) {
                object = new ValidateSuperUser();
                bl = ((ValidateSuperUser)object).changePwd(string2, string3);
            } else {
                object = new ValidateSuperUser();
                bl = ((ValidateSuperUser)object).validateOrSet(string2);
            }
            if (!bl) {
                hashMap.put("message", "Invalid username or password");
            } else {
                object = this.getRequest().getSession(true);
                object.setAttribute("session^logged^superuser", (Object)string);
            }
            hashMap.put("loggedin", bl);
            object = hashMap;
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public Map validateRememberedUser(String string, String string2) throws Exception {
        WikiDB wikiDB = WikiDB.getWikiDB();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            Object object;
            wikiDB.connectDB(LoginMgmt.getDBName());
            boolean bl = false;
            String string3 = URLDecoder.decode(string2);
            this.log.debug("user:" + string + " passcode:" + string3);
            String string4 = wikiDB.getEncryptedPwd(string);
            if (!string3.equals(string4)) {
                hashMap.put("message", "Invalid username or password");
            } else {
                bl = true;
                object = this.getRequest().getSession(true);
                object.setMaxInactiveInterval(86400);
                object.setAttribute("session^logged^user", (Object)string);
                boolean bl2 = true;
                object.setAttribute("session^logged^header", (Object)this.getHeaders(this.getRequest(), bl2));
                hashMap.put("fesessionuid", string4);
            }
            hashMap.put("loggedin", bl);
            this.log.debug("rtn:" + hashMap);
            object = hashMap;
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            wikiDB.closeDB();
        }
    }

    public void logout() throws Exception {
        HttpSession httpSession = this.getRequest().getSession();
        httpSession.removeAttribute("session^logged^user");
        httpSession.invalidate();
    }

    private HttpServletRequest getRequest() throws Exception {
        return this.request == null && WebContextFactory.get() != null ? WebContextFactory.get().getHttpServletRequest() : this.request;
    }
}

