/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.Config;
import com.fe.client.BBSyncMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.client.ExecuteRMgmt;
import com.fe.client.IExecMgmt;
import com.fe.client.LoginMgmt;
import com.fe.client.SchedulerMgmt;
import com.fe.db.SchedulerDB;
import com.fe.p2p.MessageBean;
import com.fe.p2p.P2PAdvertisement;
import com.fe.p2p.P2PService;
import com.fe.p2p.listener.IncomingMessage;
import com.fe.p2p.listener.OutgoingMessage;
import com.fe.p2p.listener.P2PTransportMessage;
import com.fe.scheduler.SchedulerEngine;
import com.fe.scheduler.balance.ExecutingQueueCleaner;
import com.fe.scheduler.balance.LoadBalancingLinkedQueue;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.balance.LoadBalancingQueueItem;
import com.fe.scheduler.rscript.RScript;
import com.fe.scheduler.rscript.RScriptAsyncListenerImpl;
import com.fe.util.ProxifyURL;
import com.fe.util.RestartTomcat;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;
import org.jfree.util.Log;

public class SchedulerAPIServlet
extends HttpServlet {
    private static String EXECUTETASKS = "run";
    private static String GETLIVE = "livepeers";
    private static String QUEUE = "queue";
    private static String SYNC_REF_CONTRACT = "syncContract";
    private static String EXECUTE_R_QUEUEINFO = "xRQInfo";
    private static String EXECUTE_R_QUEUE = "executeR_queue";
    private static String PEER_PACKAGES = "getPeerPackages";
    private static String PEER_INFO = "getPeerInfo";
    private static String PEER_QUEUE = "getPeerQueue";
    private static String SERVER_DATE_TIME = "getCurrentDateTime";
    private static String SYNC_REF_SECURITY = "syncSecurity";
    private static String SCHEDULER_QUEUEGROUP_ADD = "addGroupIntoQueue";
    private static String SCHEDULER_QUEUEGROUP_REMOVE = "removeGroupFromQueue";
    private static String RESTART_PEER = "restartPeer";
    private static String RESTART_PEER_LATER = "restartAfterDone";
    private static String RESTART_SERVER = "restartServer";
    private static String PRIORITY_QUEUE = "priorityQueue";
    private static String REMOVE_EXECUTING_TASK = "removeExecutingTask";
    private static String STRATEGY_XML = "strategyXML";
    private static String EXECUTE_SSCRIPT_P2P = "execSyncScript";
    private static String EXECUTE_ASCRIPT_P2P = "execAsyncScript";
    private static String EXECUTE_ASCRIPT_P2P_RESULT = "getScriptResult";
    private static int EXPIRY_FOR_UNRETRIEVED = 30;
    private static int EXPIRY_FOR_RETRIEVED = 2;
    private static String AUTHENTICATION_CHECK = "check_auth";
    private String msg = null;
    private Logger log = Logger.getLogger(SchedulerAPIServlet.class);
    private static JCS cache = null;

    private static JCS getCache() throws Exception {
        if (cache == null) {
            cache = JCS.getInstance((String)"direct_script");
        }
        return cache;
    }

    public static Map getAllTokens() throws Exception {
        HashMap hashMap = SchedulerAPIServlet.getCache().getMatching("^[A-Za-z0-9\\-]+$");
        return hashMap != null ? hashMap : new HashMap();
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("method");
        if (string != null && !string.equals("") && (string.equals(EXECUTE_SSCRIPT_P2P) || string.equals(EXECUTE_ASCRIPT_P2P))) {
            this.log.debug((Object)("debug doPost: method:" + string));
            try {
                Object object;
                String string2 = httpServletRequest.getParameter("script");
                RScript rScript = new RScript();
                rScript.setUniquename(rScript.getUid());
                if (httpServletRequest.getParameter("uniquename") != null && !httpServletRequest.getParameter("uniquename").trim().equals("")) {
                    rScript.setUniquename(httpServletRequest.getParameter("uniquename"));
                }
                if (httpServletRequest.getRemoteHost() != null) {
                    rScript.setRequesthost(httpServletRequest.getRemoteHost());
                }
                rScript.setTaskuid("direct_script");
                if (httpServletRequest.getParameter("engine") != null && httpServletRequest.getParameter("engine").equalsIgnoreCase("rserve")) {
                    rScript.setTaskuid("direct_script_unix");
                }
                if (httpServletRequest.getParameter("executeAt") != null && !httpServletRequest.getParameter("executeAt").equals("")) {
                    rScript.setExecuteAt(httpServletRequest.getParameter("executeAt"));
                }
                rScript.setScript(string2);
                String string3 = rScript.getUid();
                IElementAttributes iElementAttributes = SchedulerAPIServlet.getCache().getDefaultElementAttributes();
                iElementAttributes.setMaxLifeSeconds((long)EXPIRY_FOR_UNRETRIEVED);
                RScriptAsyncListenerImpl rScriptAsyncListenerImpl = new RScriptAsyncListenerImpl(SchedulerAPIServlet.getCache(), iElementAttributes);
                SchedulerAPIServlet.getCache().put((Object)string3, (Object)RScriptAsyncListenerImpl.ALIVE, iElementAttributes);
                LoadBalancingQueue.getExecuteRScriptDefault().addExecuteR(rScript, rScriptAsyncListenerImpl);
                boolean bl = false;
                Object object2 = null;
                if (string.equals(EXECUTE_SSCRIPT_P2P)) {
                    while (!bl) {
                        object = (String)SchedulerAPIServlet.getCache().get((Object)string3);
                        if (object != null && !((String)object).equalsIgnoreCase(RScriptAsyncListenerImpl.ALIVE)) {
                            SchedulerAPIServlet.getCache().remove((Object)string3);
                            object2 = object;
                            bl = true;
                        }
                        if (object == null) {
                            bl = true;
                        }
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    object = httpServletRequest.getParameter("responseType") != null ? httpServletRequest.getParameter("responseType") : "text/xml";
                    httpServletResponse.setContentType((String)object);
                } else {
                    httpServletResponse.setContentType("text/plain");
                    object2 = string3;
                }
                object = httpServletResponse.getWriter();
                ((PrintWriter)object).println((String)object2);
                ((PrintWriter)object).flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getParameter("method");
        this.msg = "Error in current request, Method value required";
        boolean bl = false;
        if (string != null && !string.equals("")) {
            String string2;
            Object object;
            PrintWriter printWriter;
            Object object2;
            if (string.equals(EXECUTETASKS) && httpServletRequest.getParameter("ids") != null && !httpServletRequest.getParameter("ids").equals("") && (httpServletRequest.getParameter("delay") == null || httpServletRequest.getParameter("delay") != null && httpServletRequest.getParameter("delay").equals(""))) {
                bl = this.executeTask(httpServletRequest, httpServletResponse);
            } else if (string.equals(EXECUTETASKS) && httpServletRequest.getParameter("ids") != null && !httpServletRequest.getParameter("ids").equals("") && httpServletRequest.getParameter("delay") != null && !httpServletRequest.getParameter("delay").equals("")) {
                int n = 0;
                boolean bl2 = false;
                try {
                    n = Integer.parseInt(httpServletRequest.getParameter("delay"));
                    bl2 = true;
                }
                catch (Exception exception) {
                    bl2 = false;
                }
                if (bl2) {
                    if (n == 0) {
                        bl = this.executeTask(httpServletRequest, httpServletResponse);
                    }
                    if (n > 0) {
                        bl = this.executeTaskDelayed(httpServletRequest, httpServletResponse);
                    }
                } else {
                    this.msg = "Integer value expected for delay";
                    bl = false;
                }
            } else {
                this.msg = "Error in current request, Method value required";
                bl = true;
            }
            if (string.equals(SYNC_REF_CONTRACT) && httpServletRequest.getParameter("contract") != null && !httpServletRequest.getParameter("contract").equals("")) {
                String string3 = Config.getValue("bloomberg.server.servletAPI.url");
                ProxifyURL proxifyURL = new ProxifyURL(httpServletRequest, httpServletResponse);
                if (string3 != null && proxifyURL.isProxified(string3)) {
                    proxifyURL.proxifyGet(string3, null);
                } else {
                    object2 = this.syncRefData4Contract(httpServletRequest, httpServletResponse);
                    this.generateResult(httpServletResponse, "<status>" + (String)object2 + "</status>");
                }
            }
            if (string.equals(PEER_PACKAGES)) {
                String string4 = null;
                try {
                    string4 = this.getPeerInfo("rpackages");
                }
                catch (Exception exception) {
                    string4 = "<error>" + exception.getMessage() + "</error>";
                }
                this.generateResult(httpServletResponse, string4);
            }
            if (string.equals(PEER_INFO)) {
                String string5 = null;
                try {
                    string5 = this.getPeerInfo("statistics");
                }
                catch (Exception exception) {
                    string5 = "<error>" + exception.getMessage() + "</error>";
                }
                this.generateResult(httpServletResponse, string5);
            }
            if (string.equals(EXECUTE_R_QUEUEINFO)) {
                String string6 = null;
                try {
                    ExecuteRMgmt executeRMgmt = new ExecuteRMgmt(httpServletRequest);
                    string6 = executeRMgmt.getQueueXML();
                }
                catch (Exception exception) {
                    string6 = "<error>" + exception.getMessage() + "</error>";
                }
                this.generateResult(httpServletResponse, string6);
            }
            if (string.equals(EXECUTE_R_QUEUE) && httpServletRequest.getParameter("server_ip") != null) {
                ProxifyURL proxifyURL = new ProxifyURL(httpServletRequest, httpServletResponse);
                proxifyURL.proxifyGet("http://" + httpServletRequest.getParameter("server_ip") + ":8080/bldb/schedulerAPI", "method=" + EXECUTE_R_QUEUEINFO);
            }
            if (string.equals(PEER_QUEUE)) {
                String string7 = null;
                try {
                    string7 = this.getPeerInfo("peerqueue");
                }
                catch (Exception exception) {
                    string7 = "<error>" + exception.getMessage() + "</error>";
                }
                this.generateResult(httpServletResponse, string7);
            }
            if (string.equals(SYNC_REF_CONTRACT) && httpServletRequest.getParameter("contract") == null) {
                String string8 = Config.getValue("bloomberg.server.servletAPI.url");
                ProxifyURL proxifyURL = new ProxifyURL(httpServletRequest, httpServletResponse);
                if (string8 != null && proxifyURL.isProxified(string8)) {
                    proxifyURL.proxifyGet(string8, null);
                } else {
                    object2 = this.syncRefDataAllContract(httpServletRequest, httpServletResponse);
                    httpServletResponse.setContentType("text/xml");
                    printWriter = httpServletResponse.getWriter();
                    printWriter.println("<?xml version=\"1.0\"?>");
                    if (object2 != null && ((Vector)object2).size() > 0) {
                        printWriter.println("<result><status>true</status>");
                        object = ((Vector)object2).iterator();
                        while (object.hasNext()) {
                            string2 = (String)object.next();
                            if (string2 == null) continue;
                            printWriter.println("<contract>" + string2 + "</contract>");
                        }
                        printWriter.println("</result>");
                    } else {
                        printWriter.println("<result><status>false</status></result>");
                    }
                    printWriter.flush();
                }
            }
            if (string.equals(AUTHENTICATION_CHECK)) {
                try {
                    this.authenticationCheck(httpServletRequest, httpServletResponse);
                }
                catch (Exception exception) {
                    this.generateResult(httpServletResponse, "<status>Error:" + exception.getMessage() + "</status>");
                }
            }
            if (string.equalsIgnoreCase(STRATEGY_XML) && httpServletRequest.getParameter("strategy") != null && httpServletRequest.getParameter("contract") != null) {
                httpServletResponse.setContentType("text/xml");
                PrintWriter printWriter2 = httpServletResponse.getWriter();
                String string9 = httpServletRequest.getParameter("contract");
                if (string9 == null) {
                    string9 = "";
                }
                try {
                    object2 = new IExecMgmt(httpServletRequest, false);
                    printWriter2.write(((IExecMgmt)object2).getMyParsedXML(httpServletRequest.getParameter("strategy"), string9));
                }
                catch (Exception exception) {
                    printWriter2.write("Error:" + exception.getMessage());
                    exception.printStackTrace();
                }
                printWriter2.flush();
            }
            if (string.equals(SYNC_REF_SECURITY) && httpServletRequest.getParameter("security") != null && !httpServletRequest.getParameter("security").equals("")) {
                String string10 = Config.getValue("bloomberg.server.servletAPI.url");
                ProxifyURL proxifyURL = new ProxifyURL(httpServletRequest, httpServletResponse);
                if (string10 != null && proxifyURL.isProxified(string10)) {
                    proxifyURL.proxifyGet(string10, null);
                } else {
                    object2 = this.syncRefData4Security(httpServletRequest, httpServletResponse);
                    this.generateResult(httpServletResponse, "<status>" + (String)object2 + "</status>");
                }
            }
            if (string.equals(EXECUTE_ASCRIPT_P2P_RESULT) && httpServletRequest.getParameter("token") != null && !httpServletRequest.getParameter("token").equals("")) {
                String string11 = null;
                String string12 = null;
                try {
                    string11 = (String)SchedulerAPIServlet.getCache().get((Object)httpServletRequest.getParameter("token").trim());
                    string12 = httpServletRequest.getParameter("token").trim();
                }
                catch (Exception exception) {
                    Log.error((Object)("Error:" + exception.getMessage()));
                }
                if (string11 != null && !string11.equalsIgnoreCase(RScriptAsyncListenerImpl.ALIVE)) {
                    object2 = httpServletRequest.getParameter("responseType") != null ? httpServletRequest.getParameter("responseType") : "text/xml";
                    httpServletResponse.setContentType((String)object2);
                    printWriter = httpServletResponse.getWriter();
                    printWriter.print(string11);
                    printWriter.flush();
                    try {
                        object = SchedulerAPIServlet.getCache().getDefaultElementAttributes();
                        object.setMaxLifeSeconds((long)EXPIRY_FOR_RETRIEVED);
                        SchedulerAPIServlet.getCache().remove((Object)string12);
                        SchedulerAPIServlet.getCache().put((Object)string12, (Object)string11, (IElementAttributes)object);
                    }
                    catch (Exception exception) {
                        this.log.error((Object)"Error while resetting token in cache");
                    }
                } else if (string11 != null && string11.equalsIgnoreCase(RScriptAsyncListenerImpl.ALIVE)) {
                    object2 = httpServletRequest.getParameter("responseType") != null ? httpServletRequest.getParameter("responseType") : "text/xml";
                    httpServletResponse.setContentType((String)object2);
                    printWriter = httpServletResponse.getWriter();
                    printWriter.println("<?xml version=\"1.0\"?>");
                    printWriter.println("<result>not ready</result>");
                    printWriter.flush();
                } else {
                    object2 = httpServletRequest.getParameter("responseType") != null ? httpServletRequest.getParameter("responseType") : "text/xml";
                    httpServletResponse.setContentType((String)object2);
                    printWriter = httpServletResponse.getWriter();
                    printWriter.println("<?xml version=\"1.0\"?>");
                    printWriter.println("<result>No script associated to this token, Result for the token expires in " + EXPIRY_FOR_UNRETRIEVED + " seconds. </result>");
                    printWriter.flush();
                }
            }
            if (string.equals(SCHEDULER_QUEUEGROUP_ADD) && httpServletRequest.getParameter("taskuid") != null && !httpServletRequest.getParameter("taskuid").equals("")) {
                String string13 = this.addRemoveGroup2Queue(httpServletRequest, httpServletResponse, string);
                this.generateResult(httpServletResponse, "<status>" + string13 + "</status>");
            }
            if (string.equals(REMOVE_EXECUTING_TASK) && httpServletRequest.getParameter("task_id") != null && !httpServletRequest.getParameter("task_id").equals("") && httpServletRequest.getParameter("trigger_time") != null && !httpServletRequest.getParameter("trigger_time").equals("")) {
                String string14 = this.removeTaskID(httpServletRequest, httpServletResponse);
                this.generateResult(httpServletResponse, "<status>" + string14 + "</status>");
            }
            if (string.equals(SCHEDULER_QUEUEGROUP_REMOVE) && httpServletRequest.getParameter("taskuid") != null && !httpServletRequest.getParameter("taskuid").equals("")) {
                String string15 = this.addRemoveGroup2Queue(httpServletRequest, httpServletResponse, string);
                this.generateResult(httpServletResponse, "<status>" + string15 + "</status>");
            }
            if ((string.equals(RESTART_PEER) || string.equals(RESTART_PEER_LATER)) && httpServletRequest.getParameter("peer") != null && !httpServletRequest.getParameter("peer").equals("")) {
                String string16 = SchedulerAPIServlet.restartPeer(string, httpServletRequest);
                this.generateResult(httpServletResponse, "<status>" + string16 + "</status>");
            }
            if (string.equals(SERVER_DATE_TIME)) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
                Date date = new Date();
                this.generateResult(httpServletResponse, "<time milliseconds=\"" + date.getTime() + "\" formatted=\"" + simpleDateFormat.format(date) + "\" />");
            }
            if (string.equals(PRIORITY_QUEUE)) {
                if (httpServletRequest.getParameter("enable") != null && httpServletRequest.getParameter("enable").equalsIgnoreCase("true")) {
                    LoadBalancingLinkedQueue.priorityQueue = true;
                }
                if (httpServletRequest.getParameter("enable") != null && httpServletRequest.getParameter("enable").equalsIgnoreCase("false")) {
                    LoadBalancingLinkedQueue.priorityQueue = false;
                }
                this.generateResult(httpServletResponse, "<status>" + LoadBalancingLinkedQueue.priorityQueue + "</status>");
            }
            if (string.equals(SYNC_REF_SECURITY) && httpServletRequest.getParameter("security") == null) {
                String string17 = Config.getValue("bloomberg.server.servletAPI.url");
                ProxifyURL proxifyURL = new ProxifyURL(httpServletRequest, httpServletResponse);
                if (string17 != null && proxifyURL.isProxified(string17)) {
                    proxifyURL.proxifyGet(string17, null);
                } else {
                    object2 = this.syncRefDataAllSecurity(httpServletRequest, httpServletResponse);
                    httpServletResponse.setContentType("text/xml");
                    printWriter = httpServletResponse.getWriter();
                    printWriter.println("<?xml version=\"1.0\"?>");
                    if (object2 != null && ((Vector)object2).size() > 0) {
                        printWriter.println("<result><status>true</status>");
                        object = ((Vector)object2).iterator();
                        while (object.hasNext()) {
                            string2 = (String)object.next();
                            if (string2 == null) continue;
                            printWriter.println("<security>" + string2 + "</security>");
                        }
                        printWriter.println("</result>");
                    } else {
                        printWriter.println("<result><status>false</status></result>");
                    }
                    printWriter.flush();
                }
            }
            if (string.equals(GETLIVE)) {
                bl = this.getLive(httpServletRequest, httpServletResponse);
            }
            if (string.equals(QUEUE)) {
                bl = this.getQueue(httpServletRequest, httpServletResponse);
            }
        }
        if (!bl) {
            try {
                this.getServletConfig().getServletContext().getRequestDispatcher("/schedulerAPI.jsp").forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
            catch (ServletException servletException) {
                this.log.error((Object)servletException);
            }
        }
    }

    public String addRemoveGroup2Queue(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        String string2 = httpServletRequest.getParameter("taskuid");
        try {
            if (string2 != null && !string2.equals("")) {
                if (string.equals(SCHEDULER_QUEUEGROUP_ADD)) {
                    new SchedulerEngine().addGroup2Queue(string2);
                }
                if (string.equals(SCHEDULER_QUEUEGROUP_REMOVE)) {
                    new SchedulerEngine().removeGroup2Queue(string2);
                }
            } else {
                throw new Exception("Parameter taskuid not found");
            }
            return "success";
        }
        catch (Exception exception) {
            return "Error:" + exception.getMessage();
        }
    }

    private String removeTaskID(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        int n = 0;
        long l = 0L;
        try {
            n = Integer.parseInt(httpServletRequest.getParameter("task_id"));
            l = Long.parseLong(httpServletRequest.getParameter("trigger_time"));
            new ExecutingQueueCleaner().removeFaultyExecutingTask(n, l);
            return "success";
        }
        catch (Exception exception) {
            return "ERROR:" + exception.getMessage();
        }
    }

    private boolean executeTask(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            String string = httpServletRequest.getParameter("ids");
            String string2 = null;
            String string3 = new SchedulerEngine().executeScriptExpression(string, "SchedulerAPI", string2);
            httpServletResponse.setContentType("text/xml");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<?xml version=\"1.0\"?>");
            printWriter.println("<result>" + string3 + "</result>");
            printWriter.flush();
            return true;
        }
        catch (Exception exception) {
            this.log.error((Object)("executeTask() Error:" + exception.getMessage()));
            this.msg = "Error occured: MSG:" + exception.getMessage();
            return false;
        }
    }

    private boolean executeTaskDelayed(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        StringTokenizer stringTokenizer = new StringTokenizer(httpServletRequest.getParameter("ids"), ",");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        int n = Integer.parseInt(httpServletRequest.getParameter("delay"));
        try {
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            for (String string : vector) {
                int n2 = Integer.parseInt(string);
                Map map = schedulerDB.getScheduler(n2);
                if (map == null) continue;
                Number number = (Number)map.get("active");
                String string2 = (String)map.get("taskuid");
                String string3 = (String)map.get("name");
                new SchedulerEngine().runJobDelayed(map, string2, schedulerDB, n, "SchedulerAPI");
            }
            schedulerDB.closeDB();
            httpServletResponse.setContentType("text/xml");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<?xml version=\"1.0\"?>");
            printWriter.println("<result>done</result>");
            printWriter.flush();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            this.msg = "Error occured: MSG:" + exception.getMessage();
            return false;
        }
    }

    private void generateResult(HttpServletResponse httpServletResponse, String string) {
        try {
            httpServletResponse.setContentType("text/xml");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<?xml version=\"1.0\"?>");
            printWriter.println("<result>" + string + "</result>");
            printWriter.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String syncRefData4Contract(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = httpServletRequest.getParameter("contract");
        try {
            BBSyncMgmt bBSyncMgmt = new BBSyncMgmt(httpServletRequest);
            boolean bl = bBSyncMgmt.bbSynchOneContract(string);
            return bl + "";
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            this.msg = "Error occured: MSG:" + exception.getMessage();
            return "ERROR:" + exception.getMessage();
        }
    }

    private Vector syncRefDataAllContract(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = "";
        try {
            BBSyncMgmt bBSyncMgmt = new BBSyncMgmt(httpServletRequest);
            Vector vector = bBSyncMgmt.bbSynchContracts(true);
            return vector;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            this.msg = "Error occured: MSG:" + exception.getMessage();
            return null;
        }
    }

    private String syncRefData4Security(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string = httpServletRequest.getParameter("security");
        try {
            BBSyncMgmt bBSyncMgmt = new BBSyncMgmt(httpServletRequest);
            boolean bl = bBSyncMgmt.bbSynchOneSecurity(string);
            return bl + "";
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            this.msg = "Error occured: MSG:" + exception.getMessage();
            return "ERROR:" + exception.getMessage();
        }
    }

    private Vector syncRefDataAllSecurity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            BBSyncMgmt bBSyncMgmt = new BBSyncMgmt(httpServletRequest);
            Vector vector = bBSyncMgmt.bbSynchSecurites(true);
            return vector;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            return null;
        }
    }

    private boolean getLive(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            SchedulerMgmt schedulerMgmt = new SchedulerMgmt();
            Map map = schedulerMgmt.getOnlinePeers();
            httpServletResponse.setContentType("text/xml");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<?xml version=\"1.0\"?>");
            printWriter.println("<result>");
            for (String string : map.keySet()) {
                printWriter.println("<peer status=\"" + map.get(string) + "\">" + string + "</peer>");
            }
            printWriter.println("</result>");
            printWriter.flush();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean getQueue(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            Collection<LoadBalancingQueueItem> collection = LoadBalancingQueue.getDefault().getExecutingTasks();
            Collection<LoadBalancingQueueItem> collection2 = LoadBalancingQueue.getDefault().getQueuedTasks();
            httpServletResponse.setContentType("text/xml");
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.println("<?xml version=\"1.0\"?>");
            printWriter.println("<result>");
            for (LoadBalancingQueueItem loadBalancingQueueItem : collection) {
                printWriter.println("<task status=\"EXCECUTING\" id=\"" + loadBalancingQueueItem.getSchedulerid() + "\" trigger_time=\"" + loadBalancingQueueItem.getSf().getTrigger_time() + "\" task_sent_time=\"" + loadBalancingQueueItem.getStarted().getTime() + "\" peer=\"" + loadBalancingQueueItem.getMachine() + "\"></task> ");
            }
            for (LoadBalancingQueueItem loadBalancingQueueItem : collection2) {
                loadBalancingQueueItem.getSchedulerid();
                printWriter.println("<task status=\"WAITING\" id=\"" + loadBalancingQueueItem.getSchedulerid() + "\"  trigger_time=\"" + loadBalancingQueueItem.getSf().getTrigger_time() + "\" task_sent_time=\"\" peer=\"\"></task> ");
            }
            printWriter.println("</result>");
            printWriter.flush();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String restartServer() {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                RestartTomcat.restartMainServer();
            }
        };
        long l = 4000L;
        Timer timer = new Timer();
        timer.schedule(timerTask, l);
        return "Server has been restarted, Please check the server status after 1 minute ";
    }

    private void authenticationCheck(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        Object object;
        String string = (String)httpServletRequest.getSession().getAttribute("session^logged^user");
        if (string == null || string != null && string.equals("")) {
            object = null;
            String string2 = null;
            Cookie[] cookieArray = httpServletRequest.getCookies();
            if (cookieArray != null) {
                for (int i = 0; i < cookieArray.length; ++i) {
                    if (cookieArray[i].getName().equals("4eprevuser") && cookieArray[i].getValue() != null) {
                        object = cookieArray[i].getValue();
                    }
                    if (!cookieArray[i].getName().equals("4esessionuid") || cookieArray[i].getValue() == null) continue;
                    string2 = cookieArray[i].getValue();
                }
            }
            if (object != null && string2 != null && !((String)object).equals("") && !string2.equals("")) {
                LoginMgmt loginMgmt = new LoginMgmt(httpServletRequest);
                try {
                    Map map = loginMgmt.validateRememberedUser((String)object, string2);
                    boolean bl = (Boolean)map.get("loggedin");
                    if (bl) {
                        Cookie cookie = new Cookie("4eprevuser", (String)object);
                        cookie.setMaxAge(2592000);
                        httpServletResponse.addCookie(cookie);
                        Cookie cookie2 = new Cookie("4esessionuid", string2);
                        cookie2.setMaxAge(2592000);
                        httpServletResponse.addCookie(cookie2);
                    }
                }
                catch (Exception exception) {
                    this.log.error((Object)("Erorr:" + exception.getMessage()));
                }
            }
        }
        string = (String)httpServletRequest.getSession().getAttribute("session^logged^user");
        httpServletResponse.setContentType("application/javascript");
        object = httpServletResponse.getWriter();
        if (string == null || string != null && string.equals("")) {
            if (httpServletRequest.getParameter("redirect") != null) {
                ((PrintWriter)object).print("window.location='http://4ecapsvsg2:8080/bldb/login.jsp?referer=" + httpServletRequest.getParameter("redirect") + "'");
            } else {
                ((PrintWriter)object).print("window.location='http://4ecapsvsg2:8080/bldb/login.jsp'");
            }
        }
        if (string != null && !string.equals("")) {
            ((PrintWriter)object).print("var loggedin_user=new Object();loggedin_user.username='" + string + "'");
        }
        ((PrintWriter)object).flush();
    }

    public static String restartPeer(String string, HttpServletRequest httpServletRequest) {
        String string2 = httpServletRequest.getParameter("peer");
        PeerGroup peerGroup = P2PService.getPeerGroup();
        PipeAdvertisement pipeAdvertisement = new P2PAdvertisement().getPipeAdvertisement(string2, peerGroup);
        MessageBean messageBean = new MessageBean();
        messageBean.setType(MessageBean.TYPE_REQUEST);
        if (string.equals(RESTART_PEER)) {
            messageBean.setCommand("RESTART_PEER");
        }
        if (string.equals(RESTART_PEER_LATER)) {
            if (httpServletRequest.getParameter("kill") != null && !httpServletRequest.getParameter("kill").equals("")) {
                messageBean.setCommand("RESTART_PEER_LATER:" + httpServletRequest.getParameter("kill"));
            } else {
                messageBean.setCommand("RESTART_PEER_LATER");
            }
        }
        messageBean.setSender(P2PService.getComputerName());
        OutgoingMessage outgoingMessage = new OutgoingMessage(null, messageBean, string2);
        PipeService pipeService = P2PService.getPipeService();
        try {
            pipeService.createOutputPipe(pipeAdvertisement, (OutputPipeListener)outgoingMessage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            PipeService pipeService2 = P2PService.getNewPipeService();
            try {
                pipeService2.createOutputPipe(pipeAdvertisement, (OutputPipeListener)outgoingMessage);
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
        }
        return "Restart request has been sent to peer  " + string2;
    }

    private String getPeerInfo(String string) throws Exception {
        try {
            String string2;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            if (string.equals("statistics")) {
                LoadBalancingQueue.getDefault().updatePeerData(P2PTransportMessage.COMMAND_STATISTICS);
            }
            if (string.equals("rpackages")) {
                LoadBalancingQueue.getDefault().updatePeerData(P2PTransportMessage.COMMAND_R_PACKAGES);
            }
            if (string.equals("peerqueue")) {
                LoadBalancingQueue.getDefault().updatePeerData(P2PTransportMessage.COMMAND_PEER_QUEUE);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string3 = "";
            Map map = null;
            if (string.equals("statistics") || string.equals("rpackages")) {
                map = string.equals("statistics") ? IncomingMessage.getPeerStatistics() : IncomingMessage.getPeerRPackages();
                Vector vector = new Vector();
                Object object6 = new HashMap();
                for (Object object7 : map.keySet()) {
                    object5 = (String)map.get(object7);
                    if (object7 == null || object5 == null || ((String)object5).equals("")) continue;
                    object4 = new StringTokenizer((String)object5, "|");
                    object3 = new HashMap();
                    while (((StringTokenizer)object4).hasMoreTokens()) {
                        object2 = ((StringTokenizer)object4).nextToken();
                        object = new StringTokenizer((String)object2, "=");
                        if (((StringTokenizer)object).countTokens() < 2) continue;
                        string2 = ((StringTokenizer)object).nextToken();
                        String string4 = ((StringTokenizer)object).nextToken();
                        if (!vector.contains(string2)) {
                            vector.add(string2);
                        }
                        ((HashMap)object3).put(string2, string4);
                    }
                    ((HashMap)object6).put(object7, object3);
                }
                for (Object object7 : ((HashMap)object6).keySet()) {
                    object5 = (Map)((HashMap)object6).get(object7);
                    string3 = string3 + "<peer ";
                    object4 = vector.iterator();
                    while (object4.hasNext()) {
                        object3 = (String)object4.next();
                        object2 = object5.get(object3) == null ? "0" : (String)object5.get(object3);
                        string3 = string3 + (String)object3 + "=\"" + (String)object2 + "\" ";
                    }
                    string3 = string3 + "/>";
                }
            }
            if (string.equals("peerqueue")) {
                map = IncomingMessage.getPeerQueueStat();
                for (Object object6 : map.keySet()) {
                    Object object7;
                    String string5 = (String)map.get(object6);
                    if (object6 == null || string5 == null || string5.equals("")) continue;
                    object7 = new StringTokenizer(string5, "|");
                    while (((StringTokenizer)object7).hasMoreTokens()) {
                        string3 = string3 + "<task ";
                        object5 = ((StringTokenizer)object7).nextToken();
                        object4 = new StringTokenizer((String)object5, ",");
                        while (((StringTokenizer)object4).hasMoreTokens()) {
                            object3 = ((StringTokenizer)object4).nextToken();
                            object2 = new StringTokenizer((String)object3, "=");
                            if (((StringTokenizer)object2).countTokens() < 2) continue;
                            object = ((StringTokenizer)object2).nextToken();
                            string2 = ((StringTokenizer)object2).nextToken();
                            string3 = string3 + (String)object + "=\"" + string2 + "\" ";
                        }
                        string3 = string3 + "/>";
                    }
                }
            }
            return string3;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "what:" + string);
            throw exception;
        }
    }
}

