/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.Config;
import com.fe.client.ClientErrorMgmt;
import com.fe.client.MigrationMgmt;
import com.fe.connectbl.SyncManager;
import com.fe.db.SuperDB;
import com.fe.db.UtilDB;
import com.fe.lucene.LuceneCrawler;
import com.fe.lucene.MyIndexer;
import com.fe.lucene.SearchSession;
import com.fe.migrate.current.CurrentSecuritiesData;
import com.fe.migrate.historical.HistoricalSecuritiesData;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SecuritiesMgmt
extends MigrationMgmt {
    private Logger log = Logger.getLogger(SecuritiesMgmt.class);

    public Map getUniqueSecuriteisFields() throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(new HistoricalSecuritiesData(this).getDB());
            utilDB.connectDB(new HistoricalSecuritiesData(this).getDB());
            List list = utilDB.listAllUniqueFields(utilDB.connection());
            utilDB.closeDB();
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            treeMap.put("data", list);
            treeMap.put("db", new HistoricalSecuritiesData(this).getDB());
            return treeMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Map getSecuritiesFiles() throws Exception {
        TreeMap<String, Map> treeMap = new TreeMap<String, Map>();
        treeMap.put("history", this.getHistoricalFiles(new HistoricalSecuritiesData(this).getFolder()));
        treeMap.put("current", this.getCurrentFiles(new CurrentSecuritiesData(this).getFolder()));
        return treeMap;
    }

    public boolean importSecuritiesHistoryData(boolean bl) throws Exception {
        this.log.debug((Object)"importSecuritiesHistoryData() called");
        boolean bl2 = !bl;
        HistoricalSecuritiesData historicalSecuritiesData = new HistoricalSecuritiesData(this);
        try {
            if (historicalSecuritiesData.getFiles().length <= 0) {
                throw new Exception("Importing historical data failed. No source files found!");
            }
            this.setMessageClientServe("Processing...");
            historicalSecuritiesData.startProcess(bl2);
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "ignoreDupCheck:" + bl);
            throw exception;
        }
    }

    public boolean importSecuritiesCurrentData() throws Exception {
        CurrentSecuritiesData currentSecuritiesData = new CurrentSecuritiesData(this);
        try {
            if (currentSecuritiesData.getFiles().length <= 0) {
                throw new Exception("Importing Current data failed. No source files found!");
            }
            currentSecuritiesData.startProcess();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "");
            throw exception;
        }
    }

    public String generateSecuritiesContracts(String string, boolean bl, String string2, Vector vector, String string3) throws Exception {
        try {
            if (bl) {
                return this.generateAllContracts(new HistoricalSecuritiesData(this).getDB(), string, string2, vector, string3);
            }
            return this.generateContracts(new HistoricalSecuritiesData(this).getDB(), string);
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "fieldtable:" + string + ",allCommoditiesSelected:" + bl + ",dateQuery:" + string2 + ",commodities:" + vector + ",commString:" + string3);
            throw exception;
        }
    }

    @Override
    public List removeFieldTable(String string, String string2) throws Exception {
        UtilDB utilDB = new SuperDB().getUtilDB(new HistoricalSecuritiesData(this).getDB());
        utilDB.connectDB(new HistoricalSecuritiesData(this).getDB());
        List list = null;
        if (!utilDB.removeFieldTable(utilDB.connection(), string)) {
            throw new Exception("Couldn't delete the field");
        }
        list = utilDB.listFieldTables4Admin(utilDB.connection(), string2);
        return list;
    }

    @Override
    public List getFields4Admin(String string) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(new HistoricalSecuritiesData(this).getDB());
            utilDB.connectDB(new HistoricalSecuritiesData(this).getDB());
            List list = utilDB.listFieldTables4Admin(utilDB.connection(), string);
            utilDB.closeDB();
            return list;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "mtable" + string);
            throw exception;
        }
    }

    @Override
    public boolean synchronize(int n) throws Exception {
        try {
            String string = Config.getString("xls_sec_bloomberg_mapping");
            String string2 = new HistoricalSecuritiesData(this).getDB();
            SyncManager syncManager = new SyncManager(n, this, string, string2);
            syncManager.start();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, " lastndays:" + n);
            throw exception;
        }
    }

    @Override
    public boolean synchronizeXML(int n, String string) throws Exception {
        try {
            String string2 = new File(Config.getString("xls_sec_bloomberg_mapping")).getParent() + File.separator + string;
            File file = new File(string2);
            if (!file.exists()) {
                throw new Exception("XML file does not exist");
            }
            String string3 = Config.getString("xls_sec_bloomberg_mapping");
            String string4 = new HistoricalSecuritiesData(this).getDB();
            SyncManager syncManager = new SyncManager(n, this, string3, string4);
            syncManager.setFilename(string);
            syncManager.setUpdatesyncdate(false);
            syncManager.start();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, " lastndays:" + n + " filename:" + string);
            throw exception;
        }
    }

    public Vector securitiesSearch(String string) throws Exception {
        MyIndexer myIndexer = new MyIndexer(LuceneCrawler.INDEX_TABLE_SECURITY);
        SearchSession searchSession = new SearchSession(myIndexer);
        Vector vector = searchSession.results(string, 0);
        return vector;
    }
}

