/*
 * Decompiled with CFR 0.152.
 */
package com.fe.connectbl;

import com.bloomberglp.blpapi.Element;
import com.bloomberglp.blpapi.Event;
import com.bloomberglp.blpapi.Message;
import com.bloomberglp.blpapi.MessageIterator;
import com.bloomberglp.blpapi.Request;
import com.bloomberglp.blpapi.Service;
import com.bloomberglp.blpapi.Session;
import com.bloomberglp.blpapi.SessionOptions;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;

public class BloombergSession {
    private Session session;
    private Service service;
    private Request request;
    private String currentMode = "HistoricalDataRequest";
    private ArrayList fieldnames = new ArrayList();
    public static String REQUEST_TYPE_HISTORICAL = "HistoricalDataRequest";
    public static String REQUEST_TYPE_REFERENCE = "ReferenceDataRequest";
    private ArrayList<String> data = new ArrayList();

    public Session open(String string) throws Exception {
        this.currentMode = string;
        String string2 = "localhost";
        int n = 8194;
        SessionOptions sessionOptions = new SessionOptions();
        sessionOptions.setServerHost(string2);
        sessionOptions.setServerPort(n);
        this.session = new Session(sessionOptions);
        if (!this.session.start()) {
            throw new Exception("Failed to start Bloomberg Session");
        }
        this.request = this.getRequest(this.currentMode);
        this.request.set("periodicityAdjustment", "ACTUAL");
        this.request.set("periodicitySelection", "DAILY");
        this.request.set("returnEids", true);
        return this.session;
    }

    public void close() throws Exception {
        this.session.stop();
    }

    public Request getRequest() {
        return this.request;
    }

    public void addSecurities(String string) {
        Element element = this.request.getElement("securities");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            element.appendValue(stringTokenizer.nextToken());
        }
    }

    public void addFields(String string) {
        Element element = this.request.getElement("fields");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            element.appendValue(string2);
            this.fieldnames.add(string2);
        }
    }

    public void setRequestAttr(String string, String string2) {
        this.request.set(string, string2);
    }

    public void fetchData(String string, String string2) throws Exception {
        block4: {
            Event event;
            this.request.set("startDate", string);
            this.request.set("endDate", string2);
            this.session.sendRequest(this.request, null);
            String string3 = null;
            this.data.clear();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-dd-MM HH:mm:ss");
            do {
                event = this.session.nextEvent();
                MessageIterator messageIterator = event.messageIterator();
                while (messageIterator.hasNext()) {
                    Message message = messageIterator.next();
                    if (event.eventType() != Event.EventType.RESPONSE && event.eventType() != Event.EventType.PARTIAL_RESPONSE) continue;
                    Element element = message.getElement("securityData");
                    String string4 = element.getElementAsString("security");
                    Element element2 = element.getElement("fieldData");
                    int n = element2.numValues();
                    for (int i = 0; i < n; ++i) {
                        Element element3 = element2.getValueAsElement(i);
                        for (String string5 : this.fieldnames) {
                            Date date = element3.getElementAsDate("date").calendar().getTime();
                            String string6 = element3.getElementAsString(string5.toUpperCase());
                            String string7 = simpleDateFormat.format(date) + "|" + string4 + "|" + string5 + "|" + string6;
                            this.data.add(string7);
                        }
                    }
                }
                if (event.eventType() == Event.EventType.RESPONSE) break block4;
            } while (event.eventType() != Event.EventType.TIMEOUT);
            string3 = "Bloomberg API throws timed out exception.....";
        }
    }

    public ArrayList getDataAsArrayList() {
        return this.data;
    }

    public String[] getDataAsStrings() {
        String[] stringArray = new String[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            stringArray[i] = this.data.get(i);
        }
        return stringArray;
    }

    public String getDataAsPlainString() {
        String string = "";
        for (int i = 0; i < this.data.size(); ++i) {
            string = string + this.data.get(i) + "\n";
        }
        return string;
    }

    private Request getRequest(String string) throws Exception {
        if (!this.session.openService("//blp/refdata")) {
            throw new Exception("Failed to open //blp/refdata");
        }
        this.service = this.session.getService("//blp/refdata");
        Request request = this.service.createRequest(string);
        return request;
    }
}

