/*
 * Decompiled with CFR 0.152.
 */
package com.fe.connectbl;

import com.fe.client.MigrationMgmt;
import com.fe.connectbl.ConnectBloomberg;
import com.fe.data.Contract;
import com.fe.db.ContractDB;
import com.fe.db.SuperDB;
import com.fe.db.UtilDB;
import com.fe.migrate.historical.HistoricalMarketData;
import com.fe.xml.XMLCommodity;
import com.fe.xml.XMLFields;
import com.fe.xml.XMLScheduledJob;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.commons.digester.Digester;

public class SyncManager {
    private int lastndays;
    private MigrationMgmt clientGateway;
    private String mappingfile;
    private String db;
    private String filename = null;
    private boolean updatesyncdate = true;

    public SyncManager(int n, MigrationMgmt migrationMgmt, String string, String string2) {
        this.lastndays = n;
        this.clientGateway = migrationMgmt;
        this.mappingfile = string;
        this.db = string2;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public void setUpdatesyncdate(boolean bl) {
        this.updatesyncdate = bl;
    }

    public void start() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -this.lastndays);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        String string = simpleDateFormat.format(calendar.getTime());
        String string2 = simpleDateFormat.format(new Date());
        this.sync(string, string2);
        if (this.updatesyncdate) {
            UtilDB utilDB = new SuperDB().getUtilDB(this.db);
            utilDB.connectDB(this.db);
            utilDB.LastSyncUpdate(utilDB.connection());
            utilDB.closeDB();
        }
    }

    private Vector getMapping(String string) throws Exception {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("mapping", "java.util.Vector");
        digester.addSetProperties("mapping");
        digester.addObjectCreate("mapping/commodity", "com.fe.xml.XMLCommodity");
        digester.addSetProperties("mapping/commodity");
        digester.addCallMethod("mapping/commodity/ticker", "setContracts", 0);
        digester.addSetNext("mapping/commodity", "add", "com.fe.xml.XMLCommodity");
        digester.addObjectCreate("mapping/commodity/field", "com.fe.xml.XMLFields");
        digester.addSetProperties("mapping/commodity/field");
        digester.addSetNext("mapping/commodity/field", "addFields", "com.fe.xml.XMLFields");
        String string2 = new File(this.mappingfile).getParent() + File.separator + string;
        File file = new File(string2);
        Vector vector = (Vector)digester.parse(file);
        return vector;
    }

    private List sync(String string, String string2) throws Exception {
        Vector<String> vector;
        Vector vector2 = new Vector();
        if (this.filename == null) {
            vector = XMLScheduledJob.getSchedulerMapping(this.mappingfile);
            for (XMLScheduledJob object : vector) {
                vector2.addAll(this.getMapping(object.getFilename()));
            }
        } else {
            vector2.addAll(this.getMapping(this.filename));
        }
        vector = null;
        for (XMLCommodity xMLCommodity : vector2) {
            for (XMLFields xMLFields : xMLCommodity.getFields()) {
                Vector<Contract> vector3;
                String string3 = HistoricalMarketData.resolvedColName(xMLCommodity.getName()) + "_" + HistoricalMarketData.resolvedColName(xMLFields.getSqlserver());
                ContractDB contractDB = new SuperDB().getContractDB(string3, this.db);
                contractDB.connectDB(this.db);
                try {
                    vector3 = contractDB.getContractTitles(contractDB.connection());
                    vector = new Vector<String>();
                }
                catch (Exception exception) {
                    this.clientGateway.setMessageClientServe("Importing first time! creating necessary tables");
                    vector = new Vector();
                    try {
                        contractDB.updateMasterTable(contractDB.connection(), xMLCommodity.getName(), xMLFields.getSqlserver());
                        contractDB.createTable(contractDB.connection(), 8);
                    }
                    catch (Exception exception2) {
                        throw exception;
                    }
                }
                for (String string4 : xMLCommodity.getContractsAsList()) {
                    if (vector.contains(string4)) continue;
                    vector.add(string4);
                }
                vector3 = new ConnectBloomberg(vector, string, string2, xMLFields.getBloomberg(), xMLCommodity.getBloombergmarketsector(), this.clientGateway).getData();
                this.clientGateway.setMessageClientServe("Data being sent to SQL Server");
                contractDB.updateRecords(contractDB.connection(), vector3);
                contractDB.closeDB();
            }
        }
        return vector;
    }
}

