/*
 * Decompiled with CFR 0.152.
 */
package com.fe.db;

import com.fe.db.SchedulerDB;
import com.fe.db.SuperDB;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.dbutils.BasicRowProcessor;

public abstract class AbstractTeamOrgDB
extends SuperDB {
    public abstract String getTagTable();

    public abstract String getTagItemTable();

    public abstract String getTagItemId();

    public abstract String getTagItemFollowTable();

    public Vector getTags() throws Exception {
        Vector<Map> vector = new Vector<Map>();
        PreparedStatement preparedStatement = this.connection().prepareStatement("select * FROM " + this.getTagTable() + " ORDER BY tagname");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            vector.add(new BasicRowProcessor().toMap(resultSet));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    public Vector getTagsDetails(String[] stringArray) throws Exception {
        Vector<Map> vector = new Vector<Map>();
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string = string == null ? "'" + stringArray[i] + "'" : string + ",'" + stringArray[i] + "'";
        }
        if (string != null) {
            String string2 = "select * FROM " + this.getTagTable() + " WHERE tagname IN (" + string + ") ORDER BY tagname";
            PreparedStatement preparedStatement = this.connection().prepareStatement(string2);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                vector.add(new BasicRowProcessor().toMap(resultSet));
            }
            resultSet.close();
            preparedStatement.close();
        }
        return vector;
    }

    public Vector getTagIds4Item(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select tag_id FROM " + this.getTagItemTable() + " WHERE " + this.getTagItemId() + "=?");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Integer> vector = new Vector<Integer>();
        while (resultSet.next()) {
            vector.add(resultSet.getInt("tag_id"));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    public Vector getFollowTagIds4Item(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select tag_id FROM " + this.getTagItemFollowTable() + " WHERE " + this.getTagItemId() + "=?");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Integer> vector = new Vector<Integer>();
        while (resultSet.next()) {
            vector.add(resultSet.getInt("tag_id"));
        }
        resultSet.close();
        preparedStatement.close();
        return vector;
    }

    public void updateTagIds4Item(int n, Vector vector, int n2) throws Exception {
        PreparedStatement preparedStatement;
        if (SchedulerDB.REMOVE_BEFORE_UPDATE == n2) {
            preparedStatement = this.connection().prepareStatement("DELETE FROM " + this.getTagItemTable() + " WHERE " + this.getTagItemId() + "=?");
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        preparedStatement = this.connection().prepareStatement("INSERT INTO " + this.getTagItemTable() + "(" + this.getTagItemId() + ",tag_id) VALUES(?,?)");
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, Integer.parseInt((String)iterator.next()));
            preparedStatement.executeUpdate();
        }
        preparedStatement.close();
    }

    public void removeTagIds4Item(int n, int n2) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("DELETE FROM " + this.getTagItemTable() + " WHERE " + this.getTagItemId() + "=? and tag_id=?");
        preparedStatement.setInt(1, n);
        preparedStatement.setInt(2, n2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    public void updateItemTagIds(int n, List<Integer> list) throws Exception {
        String string = "";
        string = "mariadb".equalsIgnoreCase(dbType) ? "DELETE FROM " + this.getTagItemTable() + "  WHERE id IN (select * from (select a.id from " + this.getTagItemTable() + " as a left outer join " + this.getTagTable() + " as b on a.tag_id = b.id where " + this.getTagItemId() + "=? and left(b.tagname,3)<>'usr') temp_table ) " : "DELETE FROM " + this.getTagItemTable() + "  WHERE id IN (select a.id from " + this.getTagItemTable() + " as a left outer join " + this.getTagTable() + " as b on a.tag_id = b.id where " + this.getTagItemId() + "=? and left(b.tagname,3)<>'usr') ";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("INSERT INTO " + this.getTagItemTable() + "(" + this.getTagItemId() + ",tag_id) VALUES(?,?)");
        for (Integer n2 : list) {
            preparedStatement2.setInt(1, n);
            preparedStatement2.setInt(2, n2);
            preparedStatement2.executeUpdate();
        }
        preparedStatement2.close();
    }

    public void updateFollwerTagIds(int n, List<Integer> list) throws Exception {
        String string = "";
        string = "mariadb".equalsIgnoreCase(dbType) ? "DELETE FROM " + this.getTagItemFollowTable() + "  WHERE id IN (select * from (select a.id from " + this.getTagItemFollowTable() + " as a left outer join " + this.getTagTable() + " as b on a.tag_id = b.id where " + this.getTagItemId() + "=? and left(b.tagname,3)<>'usr') temp_table ) " : "DELETE FROM " + this.getTagItemFollowTable() + "  WHERE id IN (select a.id from " + this.getTagItemFollowTable() + " as a left outer join " + this.getTagTable() + " as b on a.tag_id = b.id where " + this.getTagItemId() + "=? and left(b.tagname,3)<>'usr') ";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        PreparedStatement preparedStatement2 = this.connection().prepareStatement("INSERT INTO " + this.getTagItemFollowTable() + "(" + this.getTagItemId() + ",tag_id) VALUES(?,?)");
        for (Integer n2 : list) {
            preparedStatement2.setInt(1, n);
            preparedStatement2.setInt(2, n2);
            preparedStatement2.executeUpdate();
        }
        preparedStatement2.close();
    }

    public List getThemeTags(int n) throws Exception {
        String string = "select replace(b.tagname,'thm-','') as theme FROM " + this.getTagItemTable() + " as a ";
        string = string + "left outer join " + this.getTagTable() + " as b on a.tag_id=b.id ";
        string = string + "where a." + this.getTagItemId() + "=? ";
        string = string + "and left(b.tagname,4)='thm-' ";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (resultSet.next()) {
            arrayList.add(resultSet.getString("theme"));
        }
        return arrayList;
    }

    public String getThemeTagName(int n) throws Exception {
        String string = "select replace(a.tagname,'thm-','') as theme FROM " + this.getTagTable() + " as a where id=?";
        PreparedStatement preparedStatement = this.connection().prepareStatement(string);
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        String string2 = null;
        if (resultSet.next()) {
            string2 = resultSet.getString("theme");
        }
        return string2;
    }

    public ArrayList getThemeNames4Item(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select b.tagname FROM " + this.getTagItemTable() + " as a left outer join " + this.getTagTable() + " as b on a.tag_id=b.id WHERE a." + this.getTagItemId() + "=? and left(b.tagname,4)<>'usr-'");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (resultSet.next()) {
            String string = resultSet.getString("tagname");
            string = string.replaceAll("thm-", "");
            arrayList.add(string);
        }
        resultSet.close();
        preparedStatement.close();
        return arrayList;
    }

    public ArrayList getFollowTags4Item(int n) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("select b.tagname FROM " + this.getTagItemFollowTable() + " as a left outer join " + this.getTagTable() + " as b on a.tag_id=b.id WHERE a." + this.getTagItemId() + "=? and left(b.tagname,4)<>'usr-'");
        preparedStatement.setInt(1, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (resultSet.next()) {
            String string = resultSet.getString("tagname");
            string = string.replaceAll("thm-", "");
            arrayList.add(string);
        }
        resultSet.close();
        preparedStatement.close();
        return arrayList;
    }

    public Map getSVNUser4WikiUser(String string) throws Exception {
        PreparedStatement preparedStatement = this.connection().prepareStatement("SELECT * FROM users where svn_username=?");
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        Map map = new HashMap();
        if (resultSet.next()) {
            map = new BasicRowProcessor().toMap(resultSet);
        }
        resultSet.close();
        preparedStatement.close();
        return map;
    }
}

