/*
 * Decompiled with CFR 0.152.
 */
package com.fe.db;

import com.fe.Config;
import com.fe.db.BBSyncDB;
import com.fe.db.ConstructQueryDB;
import com.fe.db.ContractDB;
import com.fe.db.DBManagerDB;
import com.fe.db.FlexiFieldDB;
import com.fe.db.IExecDB;
import com.fe.db.InfrastructureDB;
import com.fe.db.RFunctionDB;
import com.fe.db.ReferenceDB;
import com.fe.db.SchedulerDB;
import com.fe.db.TradeDB;
import com.fe.db.UtilDB;
import com.fe.db.WeatherNewDB;
import com.fe.db.WikiDB;
import com.fe.db.mariadb.BBSyncDBMariaDB;
import com.fe.db.mariadb.ConstructQueryDBMariaDB;
import com.fe.db.mariadb.DBManagerDBMariaDB;
import com.fe.db.mariadb.FlexiFieldDBMariaDB;
import com.fe.db.mariadb.IExecDBMariaDB;
import com.fe.db.mariadb.InfrastructureDBMariaDB;
import com.fe.db.mariadb.RFunctionDBMariaDB;
import com.fe.db.mariadb.ReferenceDBMariaDB;
import com.fe.db.mariadb.SchedulerDBMariaDB;
import com.fe.db.mariadb.TradeDBMariaDB;
import com.fe.db.mysql.ContractDBMySql;
import com.fe.db.mysql.UtilDBMySql;
import com.fe.db.mysql.WeatherNewDBMySql;
import com.fe.db.mysql.WikiDBMySql;
import com.fe.db.sqlserver.BBSyncDBSQL;
import com.fe.db.sqlserver.ConstructQueryDBSQL;
import com.fe.db.sqlserver.ContractDBSQL;
import com.fe.db.sqlserver.DBManagerDBSQL;
import com.fe.db.sqlserver.FlexiFieldDBSQL;
import com.fe.db.sqlserver.IExecDBSQL;
import com.fe.db.sqlserver.InfrastructureDBSQL;
import com.fe.db.sqlserver.RFunctionDBSQL;
import com.fe.db.sqlserver.ReferenceDBSQL;
import com.fe.db.sqlserver.SchedulerDBSQL;
import com.fe.db.sqlserver.TradeDBSQL;
import com.fe.db.sqlserver.UtilDBSQL;
import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import com.jolbox.bonecp.Statistics;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;

public class SuperDB {
    public static boolean CONNECTION_POOL_ACTIVE = false;
    public static boolean CONNECTION_POOL_CONN_COUNT = true;
    private Connection con = null;
    private String db = null;
    private String driver = null;
    private static ConcurrentHashMap<String, BoneCP> connPools = new ConcurrentHashMap();
    private static Vector<SuperDB> connections = new Vector();
    private Date connectedDate = null;
    private String callStack = null;
    public static String MY_SQL_DRIVER = "com.mysql.jdbc.Driver";
    private String tablename = null;
    private Logger log = Logger.getLogger(SuperDB.class);
    private static long count = 0L;
    private static long delays = 0L;
    private static JCS cache = null;
    public static final String DB_TYPE_MSSQL = "mssql";
    public static final String DB_TYPE_MARIADB = "mariadb";
    public static String dbType = "mssql";

    public Date getConnectedDate() {
        return this.connectedDate;
    }

    public void setConnectedDate(Date date) {
        this.connectedDate = date;
    }

    public String getCallStack() {
        return this.callStack;
    }

    public void setCallStack(String string) {
        this.callStack = string;
    }

    public void connectDB(String string) throws Exception {
        dbType = Config.getValue("db_type");
        this.db = string;
        Date date = new Date();
        String string2 = "";
        if (DB_TYPE_MARIADB.equalsIgnoreCase(dbType)) {
            string2 = "jdbc:mysql://" + Config.getString("mariadb_server") + ":" + Config.getString("mariadb_port") + "/" + string + "?user=" + Config.getString("mariadb_user") + "&password=" + Config.getString("mariadb_password");
            string2 = string2 + "&useUnicode=true&useFastDateParsing=false&characterEncoding=UTF-8";
            this.driver = "com.mysql.jdbc.Driver";
        } else {
            string2 = "jdbc:sqlserver://" + Config.getString("db_server") + ":1433;databaseName=" + string + ";integratedSecurity=false;user=" + Config.getString("db_user") + ";password=" + Config.getString("db_password");
            this.driver = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (Config.getValue(string + ".db_url") != null && Config.getValue(string + ".db_driver") != null) {
            string2 = Config.getValue(string + ".db_url");
            this.driver = Config.getValue(string + ".db_driver");
        }
        if (CONNECTION_POOL_ACTIVE) {
            if (connPools.get(string) == null) {
                this.setupConnectionPool(string2);
            }
            if (this.con != null && !this.con.isClosed()) {
                this.printOrphanConns();
            } else {
                this.con = (Connection)connPools.get(string).getAsyncConnection().get();
                this.setCallStack(SuperDB.collectErrorStack(new Exception().getStackTrace()));
                this.setConnectedDate(new Date());
                connections.add(this);
            }
        } else {
            Class.forName(this.driver);
            this.log.debug((Object)("marketConnectionURL:" + string2));
            if (this.con != null && !this.con.isClosed()) {
                this.printOrphanConns();
            } else {
                this.con = DriverManager.getConnection(string2);
                connections.add(this);
                this.setCallStack(SuperDB.collectErrorStack(new Exception().getStackTrace()));
                this.setConnectedDate(new Date());
            }
        }
        if (CONNECTION_POOL_CONN_COUNT) {
            Date date2 = new Date();
            long l = date2.getTime() - date.getTime();
            delays += l;
            ++count;
        }
    }

    private static JCS getCache() throws Exception {
        if (cache == null) {
            cache = JCS.getInstance((String)"SuperDB-cache");
        }
        return cache;
    }

    private void printOrphanConns() throws Exception {
        if (SuperDB.getCache().get((Object)"delayPrint") != null) {
            System.out.println("~~~SuperDB.connectDB(): Reuse connection, Already connection is active");
        } else {
            IElementAttributes iElementAttributes = SuperDB.getCache().getDefaultElementAttributes();
            iElementAttributes.setMaxLifeSeconds(600L);
            SuperDB.getCache().put((Object)"delayPrint", (Object)"delay", iElementAttributes);
            try {
                System.out.println("=====SuperDB.connectDB(): Reuse connection, Already connection is active====\n" + SuperDB.collectErrorStack(new Exception().getStackTrace()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private synchronized void setupConnectionPool(String string) throws Exception {
        Class.forName(this.driver);
        BoneCPConfig boneCPConfig = new BoneCPConfig();
        boneCPConfig.setJdbcUrl(string);
        boneCPConfig.setMinConnectionsPerPartition(1);
        boneCPConfig.setMaxConnectionsPerPartition(25);
        boneCPConfig.setPartitionCount(2);
        boneCPConfig.setMaxConnectionAgeInSeconds(10L);
        boneCPConfig.setLogStatementsEnabled(true);
        connPools.put(this.db, new BoneCP(boneCPConfig));
    }

    public static void closeAllConnections() {
        for (String string : connPools.keySet()) {
            BoneCP boneCP = connPools.get(string);
            boneCP.shutdown();
            connPools.remove(string);
        }
    }

    public static String getConnectionCount() {
        String string = "Total Conn:" + count + " total delay:" + delays + " average:" + delays / count + " ms";
        return string;
    }

    public static List<SuperDB> getConnectionObjs() {
        return connections;
    }

    public static void connectionCountReset() {
        count = 0L;
        delays = 0L;
    }

    public static String getConnStatus() {
        String string = "\n";
        for (String string2 : connPools.keySet()) {
            BoneCP boneCP = connPools.get(string2);
            Statistics statistics = boneCP.getStatistics();
            string = string + "Db:" + string2 + " --->";
            string = string + " Total Conn:" + statistics.getTotalCreatedConnections() + "  Free:" + statistics.getTotalFree() + " Cached hits:" + statistics.getCacheHits() + " Cached miss:" + statistics.getCacheMiss() + " Req Conn:" + statistics.getConnectionsRequested() + "  Leased:" + statistics.getTotalLeased();
            string = string + "\n";
        }
        return string;
    }

    public static String getOpenedConnections() {
        return "Size:" + connections.size();
    }

    public static String collectStack() throws Exception {
        return SuperDB.collectErrorStack(new Exception().getStackTrace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killConnections(int n) throws Exception {
        Logger logger = Logger.getLogger(SuperDB.class);
        Vector<SuperDB> vector = new Vector<SuperDB>();
        Vector<SuperDB> vector2 = connections;
        synchronized (vector2) {
            for (SuperDB superDB : connections) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(superDB.getConnectedDate());
                Calendar calendar2 = Calendar.getInstance();
                calendar2.setTime(new Date());
                calendar2.add(12, -n);
                long l = new Date().getTime() - superDB.getConnectedDate().getTime();
                l /= 1000L;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM HH:mm:ss");
                if (!calendar2.after(calendar)) continue;
                vector.add(superDB);
            }
        }
        if (vector.size() > 0) {
            logger.error((Object)("~~~~~~Closing " + vector.size() + " connections after " + n + " minutes"));
        }
        for (SuperDB superDB : vector) {
            superDB.closeDB();
        }
    }

    private static String collectErrorStack(StackTraceElement[] stackTraceElementArray) throws Exception {
        String string = "";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM HH:mm:ss.SSS ");
        string = string + "\n-- " + simpleDateFormat.format(new Date()) + " Thread:" + Thread.currentThread().getId() + " - " + Thread.currentThread().getName() + " --\n";
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            if (!stackTraceElementArray[i].getClassName().contains("com.fe.")) continue;
            string = string + "           " + stackTraceElementArray[i].getClassName() + "." + stackTraceElementArray[i].getMethodName() + "\n";
        }
        return string;
    }

    public static String collectStack4All() throws Exception {
        String string = "";
        for (SuperDB superDB : connections) {
            string = string + superDB.getCallStack() + "\n";
        }
        return string;
    }

    public void setDb(String string) {
        this.db = string;
    }

    public String getDb() {
        return this.db;
    }

    public String getDriver(String string) {
        return Config.getValue(string + ".db_driver");
    }

    public Connection connection() {
        return this.con;
    }

    public void setReadOnly(boolean bl) throws Exception {
        this.con.setReadOnly(bl);
    }

    public boolean isReadOnly() throws Exception {
        return this.con.isReadOnly();
    }

    public void closeDB() throws Exception {
        if (this.con != null) {
            connections.remove(this);
            this.con.close();
            this.con = null;
        }
    }

    public boolean isMySQLDriver() {
        return this.db != null && this.getDriver(this.db) != null && this.getDriver(this.db).equals(MY_SQL_DRIVER);
    }

    public final ContractDB getContractDB(String string, String string2) {
        this.tablename = string;
        this.db = string2;
        if (this.db != null && this.getDriver(this.db) != null && this.getDriver(this.db).equals(MY_SQL_DRIVER)) {
            ContractDBMySql contractDBMySql = new ContractDBMySql(this.tablename);
            contractDBMySql.setDb(string2);
            return contractDBMySql;
        }
        ContractDBSQL contractDBSQL = new ContractDBSQL(this.tablename);
        contractDBSQL.setDb(string2);
        return contractDBSQL;
    }

    public final UtilDB getUtilDB(String string) {
        this.db = string;
        if (this.db != null && this.getDriver(this.db) != null && this.getDriver(this.db).equals(MY_SQL_DRIVER)) {
            UtilDBMySql utilDBMySql = new UtilDBMySql();
            utilDBMySql.setDb(string);
            return utilDBMySql;
        }
        UtilDBSQL utilDBSQL = new UtilDBSQL();
        utilDBSQL.setDb(string);
        return utilDBSQL;
    }

    public final WeatherNewDB getWeatherNewDB(String string) {
        this.db = string;
        if (this.db != null && this.getDriver(this.db) != null && this.getDriver(this.db).equals(MY_SQL_DRIVER)) {
            WeatherNewDBMySql weatherNewDBMySql = new WeatherNewDBMySql();
            weatherNewDBMySql.setDb(string);
            return weatherNewDBMySql;
        }
        return null;
    }

    public static BBSyncDB getBBSyncDB() {
        if (DB_TYPE_MSSQL.equals(SuperDB.getDbTypeByDbName(Config.getString("db_bbsync_name")))) {
            return new BBSyncDBSQL();
        }
        return new BBSyncDBMariaDB();
    }

    public static FlexiFieldDB getFlexiFieldDB() {
        if (DB_TYPE_MSSQL.equals(SuperDB.getDbTypeByDbName(Config.getString("db_bbsync_name")))) {
            return new FlexiFieldDBSQL();
        }
        return new FlexiFieldDBMariaDB();
    }

    public static ReferenceDB getReferenceDB() {
        if (DB_TYPE_MSSQL.equals(SuperDB.getDbTypeByDbName(Config.getString("db_bbsync_name")))) {
            return new ReferenceDBSQL();
        }
        return new ReferenceDBMariaDB();
    }

    public static SchedulerDB getSchedulerDB() {
        if (DB_TYPE_MSSQL.equals(SuperDB.getDbTypeByDbName(Config.getString("db_bbsync_name")))) {
            return new SchedulerDBSQL();
        }
        return new SchedulerDBMariaDB();
    }

    public static RFunctionDB getRFunctionDB() {
        if (DB_TYPE_MSSQL.equals(SuperDB.getDbTypeByDbName(Config.getString("db_rfunction")))) {
            return new RFunctionDBSQL();
        }
        return new RFunctionDBMariaDB();
    }

    public static TradeDB getTradeDB() {
        if (DB_TYPE_MSSQL.equals(SuperDB.getDbTypeByDbName(Config.getString("db_trading_name")))) {
            return new TradeDBSQL();
        }
        return new TradeDBMariaDB();
    }

    public static IExecDB getIExcecDB() {
        if (DB_TYPE_MSSQL.equals(SuperDB.getDbTypeByDbName(Config.getString("db_iexec")))) {
            return new IExecDBSQL();
        }
        return new IExecDBMariaDB();
    }

    public static DBManagerDB getDBManagerDB() {
        if (DB_TYPE_MSSQL.equals(SuperDB.getDbTypeByDbName(Config.getString("db_bbsync_name")))) {
            return new DBManagerDBSQL();
        }
        return new DBManagerDBMariaDB();
    }

    public static WikiDB getWikiDB() {
        return new WikiDBMySql();
    }

    public static UtilDB getUtilDB4SQLServer() {
        if (DB_TYPE_MARIADB.equalsIgnoreCase(dbType)) {
            return new UtilDBMySql();
        }
        return new UtilDBSQL();
    }

    public static ConstructQueryDB getConstructQueryDB() {
        if (DB_TYPE_MSSQL.equals(SuperDB.getDbTypeByDbName(Config.getString("db_bbsync_name")))) {
            return new ConstructQueryDBSQL();
        }
        return new ConstructQueryDBMariaDB();
    }

    public static InfrastructureDB getInfrastructureDB() {
        if (DB_TYPE_MSSQL.equals(SuperDB.getDbTypeByDbName(Config.getString("db_infrastructure_name")))) {
            return new InfrastructureDBSQL();
        }
        return new InfrastructureDBMariaDB();
    }

    private static String getDbTypeByDbName(String string) {
        if (Config.getValue(string + ".db_url") == null || Config.getValue(string + ".db_driver") == null) {
            return Config.getValue("db_type");
        }
        if ("com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(Config.getValue(string + ".db_driver"))) {
            return DB_TYPE_MSSQL;
        }
        return DB_TYPE_MARIADB;
    }
}

