/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p;

import com.fe.p2p.ConfigurationFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.jxta.credential.AuthenticationCredential;
import net.jxta.credential.Credential;
import net.jxta.discovery.DiscoveryEvent;
import net.jxta.discovery.DiscoveryListener;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.Element;
import net.jxta.document.MimeMediaType;
import net.jxta.document.StructuredDocumentFactory;
import net.jxta.document.StructuredTextDocument;
import net.jxta.document.XMLDocument;
import net.jxta.document.XMLElement;
import net.jxta.exception.PeerGroupException;
import net.jxta.id.IDFactory;
import net.jxta.membership.Authenticator;
import net.jxta.membership.MembershipService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupFactory;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.protocol.DiscoveryResponseMsg;
import net.jxta.protocol.ModuleImplAdvertisement;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PeerGroupAdvertisement;
import net.jxta.rendezvous.RendezvousEvent;
import net.jxta.rendezvous.RendezvousListener;
import org.apache.log4j.Logger;

public class BridgeServlet
extends HttpServlet
implements RendezvousListener,
DiscoveryListener {
    private PeerGroupAdvertisement pgAdv = null;
    private PeerGroup pg;
    private PeerGroup netpg;
    private MembershipService membership;
    private DiscoveryService discovery;
    private Logger LOG = Logger.getLogger(BridgeServlet.class);
    private String logLevel = "info";
    private volatile boolean discospin;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        PrintWriter printWriter = httpServletResponse.getWriter();
        printWriter.println("<html><body>");
        printWriter.println("<div style=\"margin-top: +10%;\"/>");
        printWriter.println("<table border=\"1\">");
        printWriter.println("<tr><td><strong>Peer name</strong></td><td><strong>PeerID</strong></td></tr>");
        this.LOG.info((Object)"Bridget Servlet request");
        Enumeration enumeration = this.discovery.getLocalAdvertisements(0, null, null);
        while (enumeration.hasMoreElements()) {
            printWriter.println("<tr>");
            PeerAdvertisement peerAdvertisement = (PeerAdvertisement)enumeration.nextElement();
            printWriter.println("<td>");
            printWriter.println(peerAdvertisement.getName());
            printWriter.println("</td>");
            printWriter.println("<td>");
            printWriter.println(peerAdvertisement.getID());
            printWriter.println("</td>");
            printWriter.println("</tr>");
        }
        printWriter.println("</table>");
        printWriter.println("</body></html>");
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServletContext servletContext = servletConfig.getServletContext();
        this.pgAdv = (PeerGroupAdvertisement)servletContext.getAttribute("pgadv");
        if (this.pgAdv == null) {
            this.LOG.info((Object)"Startup");
            try {
                ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                InputStream inputStream = classLoader.getResourceAsStream("com/fe/p2p/pgadv.xml");
                StructuredTextDocument structuredTextDocument = (StructuredTextDocument)StructuredDocumentFactory.newStructuredDocument((MimeMediaType)new MimeMediaType("text/xml"), (InputStream)inputStream);
                this.pgAdv = (PeerGroupAdvertisement)AdvertisementFactory.newAdvertisement((XMLElement)((XMLElement)structuredTextDocument));
                this.pgAdv.setName(this.getComputerName());
                this.LOG.info((Object)"Application PeerGroupAdvertisement read and parsed");
                this.configureJXTA();
                this.startJXTA();
                servletContext.setAttribute("pgadv", (Object)this.pgAdv);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
        }
    }

    public void destroy() {
        this.discospin = false;
        try {
            this.membership.resign();
        }
        catch (PeerGroupException peerGroupException) {
            this.LOG.info((Object)"Error resigning from application peergroup", (Throwable)peerGroupException);
        }
        this.pg.stopApp();
        this.LOG.info((Object)"Stopped application peergroup");
        this.netpg.stopApp();
        this.LOG.info((Object)"Stopped parent peergroup");
    }

    private void configureJXTA() {
        this.LOG.info((Object)"Configuring Platform...");
        try {
            String string = "jxtaweb";
            ConfigurationFactory.setHome(new File(string));
            ConfigurationFactory.setPeerID(IDFactory.newPeerID((PeerGroupID)PeerGroupID.defaultNetPeerGroupID));
            ConfigurationFactory.setName(this.getComputerName());
            ConfigurationFactory.setPrincipal("of no");
            ConfigurationFactory.setPassword("consequence");
            ConfigurationFactory.setDescription("p2p task shared execution node");
            String string2 = "http://rdv.jxtahosts.net/cgi-bin/relays.cgi?2";
            String string3 = "http://rdv.jxtahosts.net/cgi-bin/rendezvous.cgi?2";
            ConfigurationFactory.setRdvSeedingURI(new URI(string3));
            ConfigurationFactory.setRelaySeedingURI(new URI(string2));
            ConfigurationFactory.setDebugLevel(this.logLevel);
            ConfigurationFactory.save(ConfigurationFactory.newPlatformConfig(), false);
            this.LOG.info((Object)"Platform configured and saved");
        }
        catch (URISyntaxException uRISyntaxException) {
            this.LOG.info((Object)"Exception", (Throwable)uRISyntaxException);
        }
        catch (IOException iOException) {
            this.LOG.info((Object)"Exception", (Throwable)iOException);
        }
    }

    private void startJXTA() {
        try {
            this.LOG.info((Object)"Starting JXTA Platform...");
            this.netpg = PeerGroupFactory.newNetPeerGroup();
            this.LOG.info((Object)"JXTA Platform started");
            this.LOG.info((Object)("Creating Application Peergroup " + this.pgAdv.getName() + "..."));
            ModuleImplAdvertisement moduleImplAdvertisement = this.netpg.getAllPurposePeerGroupImplAdvertisement();
            moduleImplAdvertisement.setModuleSpecID(this.pgAdv.getModuleSpecID());
            DiscoveryService discoveryService = this.netpg.getDiscoveryService();
            discoveryService.publish((Advertisement)moduleImplAdvertisement);
            discoveryService.remotePublish(null, (Advertisement)moduleImplAdvertisement);
            this.LOG.info((Object)("Bridge PeerGroup Impl Advertisement" + moduleImplAdvertisement));
            this.pg = this.netpg.newGroup(this.pgAdv.getPeerGroupID(), (Advertisement)moduleImplAdvertisement, this.pgAdv.getName(), this.pgAdv.getDescription());
            discoveryService.remotePublish(null, (Advertisement)this.pgAdv);
            this.LOG.info((Object)"New Bridge Application PeerGroup created");
            Element element = null;
            AuthenticationCredential authenticationCredential = new AuthenticationCredential(this.pg, null, element);
            this.membership = this.pg.getMembershipService();
            Authenticator authenticator = this.membership.apply(authenticationCredential);
            if (authenticator.isReadyForJoin()) {
                Credential credential = this.membership.join(authenticator);
                this.LOG.info((Object)("Joined group " + this.pg.getPeerGroupName()));
            } else {
                this.LOG.warn((Object)"Failure: unable to join group");
            }
            this.pg.getRendezVousService().startRendezVous();
            this.pg.getRendezVousService().addListener((RendezvousListener)this);
            this.discovery = this.pg.getDiscoveryService();
            this.discovery.addDiscoveryListener((DiscoveryListener)this);
            new Thread("Adv poll"){

                @Override
                public void run() {
                    int n = 30000;
                    BridgeServlet.this.discospin = true;
                    while (BridgeServlet.this.discospin) {
                        BridgeServlet.this.discovery.getRemoteAdvertisements(null, 0, null, null, 10);
                        try {
                            1.sleep(n);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void discoveryEvent(DiscoveryEvent discoveryEvent) {
        DiscoveryResponseMsg discoveryResponseMsg = discoveryEvent.getResponse();
        Enumeration enumeration = discoveryResponseMsg.getResponses();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (null != string) {
                try {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
                    XMLDocument xMLDocument = (XMLDocument)StructuredDocumentFactory.newStructuredDocument((MimeMediaType)MimeMediaType.XMLUTF8, (InputStream)byteArrayInputStream);
                    Advertisement advertisement = AdvertisementFactory.newAdvertisement((XMLElement)xMLDocument);
                    System.out.println("---------------------->Advertisement received:  " + advertisement.getAdvertisementType());
                }
                catch (IOException iOException) {
                    this.LOG.warn((Object)("Error in discoveryEvent: " + iOException));
                }
                continue;
            }
            this.LOG.warn((Object)"Response advertisement is null!");
        }
    }

    public void rendezvousEvent(RendezvousEvent rendezvousEvent) {
    }

    public String getComputerName() {
        String string = "[unknown]";
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }
}

