/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p;

import com.fe.p2p.P2PService;
import java.io.IOException;
import java.util.Date;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.StringMessageElement;
import net.jxta.pipe.OutputPipe;
import net.jxta.pipe.OutputPipeEvent;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.log4j.Logger;

public class P2PPipeListener
implements PipeMsgListener,
OutputPipeListener {
    public static final String MESSAGE_NAME_SPACE = "PipeTaskMsg";
    private Logger log = Logger.getLogger(P2PPipeListener.class);

    public void pipeMsgEvent(PipeMsgEvent pipeMsgEvent) {
        Message message;
        try {
            System.out.println("pipeMsgEvent() called");
            message = pipeMsgEvent.getMessage();
            if (message == null) {
                System.out.println("Received an empty message");
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        Message.ElementIterator elementIterator = message.getMessageElements();
        if (!elementIterator.hasNext()) {
            return;
        }
        MessageElement messageElement = message.getMessageElement(null, MESSAGE_NAME_SPACE);
        P2PService.messages.add(messageElement);
        if (messageElement.toString() == null) {
            System.out.println("null msg received");
        } else {
            Date date = new Date(System.currentTimeMillis());
            System.out.println("Message received at :" + date.toString());
            System.out.println("Message  created at :" + messageElement.toString());
        }
    }

    public void outputPipeEvent(OutputPipeEvent outputPipeEvent) {
        OutputPipe outputPipe = outputPipeEvent.getOutputPipe();
        try {
            PipeAdvertisement pipeAdvertisement = outputPipe.getAdvertisement();
            System.out.println("Sending message to " + pipeAdvertisement.getID() + " pipe::" + outputPipe.getPipeID());
            Message message = new Message();
            Date date = new Date(System.currentTimeMillis());
            StringMessageElement stringMessageElement = new StringMessageElement(MESSAGE_NAME_SPACE, date.toString() + "--: message to:" + pipeAdvertisement.getID() + ":--", null);
            message.addMessageElement(null, (MessageElement)stringMessageElement);
            outputPipe.send(message);
        }
        catch (IOException iOException) {
            System.out.println("failed to send message");
            iOException.printStackTrace();
            System.exit(-1);
        }
    }
}

