/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p;

import com.fe.Config;
import com.fe.p2p.P2PAdvertisement;
import java.io.File;
import java.net.InetAddress;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.jxta.discovery.DiscoveryEvent;
import net.jxta.discovery.DiscoveryListener;
import net.jxta.discovery.DiscoveryService;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.PipeService;
import net.jxta.platform.NetworkManager;
import net.jxta.protocol.DiscoveryResponseMsg;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class P2PService
extends Thread
implements DiscoveryListener {
    public static final String MESSAGE_NAME_SPACE = "PipeTaskMsg";
    private static transient NetworkManager manager = null;
    protected static HashMap machineList = new HashMap();
    protected static Vector messages = new Vector();
    private static transient DiscoveryService discovery = null;
    private static PipeService pipeService = null;
    private static PeerGroup netPeerGroup = null;
    private static Date startedTime = null;
    private Logger log = Logger.getLogger(P2PService.class);
    private static String defaultP2PGroup = "DiscoveryServer";
    private static String defaultP2PCache = "";
    private static String THIS_HOST_NAME = null;

    public static void setCache() {
        defaultP2PCache = Config.getValue("p2p.cachepath") != null && !Config.getValue("p2p.cachepath").equals("") ? Config.getValue("p2p.cachepath") + ".cache" : ".cache";
    }

    public static void removeCache() {
        P2PService.setCache();
        String string = defaultP2PCache;
        File file = new File(string);
        try {
            if (file.isDirectory()) {
                FileUtils.deleteDirectory((File)file);
                System.out.println("removing .Cache Directory: " + string);
            } else {
                System.out.println(".Cache Directory Does Not Exits");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static NetworkManager getManager() {
        Logger logger = Logger.getLogger(P2PService.class);
        if (manager == null) {
            try {
                PeerGroup peerGroup;
                if (Config.getValue("p2p.groupname") != null && !Config.getValue("p2p.groupname").equals("")) {
                    defaultP2PGroup = Config.getValue("p2p.groupname");
                }
                String string = defaultP2PGroup + P2PService.getComputerName();
                P2PService.setCache();
                String string2 = defaultP2PCache;
                System.out.println("set .Cache Directory: " + string2);
                manager = new NetworkManager(NetworkManager.ConfigMode.ADHOC, string, new File(new File(string2), string).toURI());
                if (Config.getValue(Config.P2P_NO_MULTICAST) != null && Config.getValue(Config.P2P_NO_MULTICAST).equalsIgnoreCase("true")) {
                    peerGroup = manager.getConfigurator();
                    try {
                        peerGroup.setUseMulticast(false);
                        peerGroup.setHttpEnabled(true);
                        peerGroup.setHttpIncoming(true);
                        logger.info((Object)"Disabling IP Multicast");
                    }
                    catch (Exception exception) {
                        logger.error((Object)("Error while configuring network, e:" + exception.getMessage()));
                    }
                }
                peerGroup = manager.startNetwork();
                logger.debug((Object)("pg: group_name:" + peerGroup.getPeerGroupName()));
                logger.debug((Object)("pg: peer_peer:" + peerGroup.getPeerName()));
                logger.debug((Object)("pg: peer name:" + peerGroup.getPeerAdvertisement().getName()));
                logger.debug((Object)("pg: getPeerID unique value:" + peerGroup.getPeerID().getUniqueValue()));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.out.println("----------------------- P2PService.getManager() :Error::" + exception.getMessage());
            }
        }
        return manager;
    }

    public static void stopNetwork() {
        if (manager != null) {
            try {
                manager.stopNetwork();
                discovery = null;
                netPeerGroup = null;
                manager = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static PeerGroup getPeerGroup() {
        if (netPeerGroup == null) {
            netPeerGroup = P2PService.getManager().getNetPeerGroup();
        }
        return netPeerGroup;
    }

    public static DiscoveryService getDiscoveryService() {
        if (discovery == null) {
            discovery = P2PService.getPeerGroup().getDiscoveryService();
        }
        return discovery;
    }

    public static PipeService getPipeService() {
        if (pipeService == null) {
            pipeService = P2PService.getPeerGroup().getPipeService();
        }
        return pipeService;
    }

    public static PipeService getNewPipeService() {
        pipeService = P2PService.getPeerGroup().getPipeService();
        return pipeService;
    }

    public static Date getPeerStartedTime() {
        return startedTime;
    }

    protected static void setPeerStarted() {
        startedTime = new Date();
    }

    public static void sendMessage(String string, String string2) throws Exception {
        try {
            manager.getNetPeerGroup();
            PipeAdvertisement pipeAdvertisement = new P2PAdvertisement().getPipeAdvertisement(string, netPeerGroup);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static synchronized String getComputerName() {
        String string = "[unknown]";
        try {
            if (THIS_HOST_NAME == null) {
                THIS_HOST_NAME = string = InetAddress.getLocalHost().getHostName();
            } else {
                string = THIS_HOST_NAME;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public Map getClientList() {
        DiscoveryService discoveryService = P2PService.getDiscoveryService();
        new Thread("Adv poll"){

            @Override
            public void run() {
                int n = 3000;
                DiscoveryService discoveryService = P2PService.getDiscoveryService();
                discoveryService.addDiscoveryListener((DiscoveryListener)new P2PService());
                P2PService.getDiscoveryService().getRemoteAdvertisements(null, 0, null, null, 1);
                P2PService.this.log.debug((Object)"Adv poll created");
                try {
                    1.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
        try {
            P2PService.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return machineList;
    }

    public static Map getClientListFromMemory() {
        return machineList;
    }

    public void discoveryEvent(DiscoveryEvent discoveryEvent) {
        if (Config.getValue("p2p.groupname") != null && !Config.getValue("p2p.groupname").equals("")) {
            defaultP2PGroup = Config.getValue("p2p.groupname");
        }
        DiscoveryResponseMsg discoveryResponseMsg = discoveryEvent.getResponse();
        Enumeration enumeration = discoveryEvent.getSearchResults();
        this.log.debug((Object)"discoveryEvent() called");
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                PeerAdvertisement peerAdvertisement = (PeerAdvertisement)enumeration.nextElement();
                this.log.debug((Object)(" adv.getName(): " + peerAdvertisement.getName()));
                if (peerAdvertisement.getName().startsWith(defaultP2PGroup)) continue;
                PipeAdvertisement pipeAdvertisement = new P2PAdvertisement().getPipeAdvertisement(peerAdvertisement.getName(), P2PService.getManager().getNetPeerGroup());
                machineList.put(pipeAdvertisement.getPipeID(), peerAdvertisement.getName());
            }
        }
    }
}

