/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p;

import com.fe.p2p.MD4ID;
import java.io.File;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.util.Date;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.document.AdvertisementFactory;
import net.jxta.document.MimeMediaType;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.endpoint.WireFormatMessage;
import net.jxta.endpoint.WireFormatMessageFactory;
import net.jxta.id.ID;
import net.jxta.id.IDFactory;
import net.jxta.peergroup.PeerGroup;
import net.jxta.peergroup.PeerGroupID;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.PipeID;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.pipe.PipeService;
import net.jxta.platform.NetworkManager;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import net.jxta.util.CountingOutputStream;
import net.jxta.util.DevNullOutputStream;

public class TestDiscoveryServer
implements Runnable {
    protected static transient NetworkManager manager;
    private transient DiscoveryService discovery;
    private PipeService pipeService;
    private InputPipe inputPipe = null;
    private final Object lock = new Object();
    private PipeAdvertisement pipeAdv;
    private PeerGroup netPeerGroup;
    public static final String MESSAGE_NAME_SPACE = "PipeTaskMsg";

    public TestDiscoveryServer() {
        try {
            manager = new NetworkManager(NetworkManager.ConfigMode.ADHOC, "DiscoveryServer", new File(new File(".cache"), "DiscoveryServer").toURI());
            manager.startNetwork();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        this.netPeerGroup = manager.getNetPeerGroup();
        this.discovery = this.netPeerGroup.getDiscoveryService();
        this.pipeService = this.netPeerGroup.getPipeService();
    }

    public static void main(String[] stringArray) {
        TestDiscoveryServer testDiscoveryServer = new TestDiscoveryServer();
    }

    @Override
    public void run() {
        long l = 120000L;
        long l2 = 120000L;
        long l3 = 3000L;
        try {
            String string = "[unknown]";
            try {
                string = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            PeerAdvertisement peerAdvertisement = TestDiscoveryServer.getPeerAdvertisement(string);
            this.discovery.publish((Advertisement)peerAdvertisement, Long.MAX_VALUE, Long.MAX_VALUE);
            this.discovery.remotePublish((Advertisement)peerAdvertisement, Long.MAX_VALUE);
            this.pipeAdv = TestDiscoveryServer.getPipeAdvertisement(string, this.netPeerGroup);
            PipeMsgListener pipeMsgListener = new PipeMsgListener(){

                public void pipeMsgEvent(PipeMsgEvent pipeMsgEvent) {
                    Message message;
                    try {
                        System.out.println("pipeMsgEvent() called");
                        message = pipeMsgEvent.getMessage();
                        if (message == null) {
                            System.out.println("Received an empty message");
                            return;
                        }
                        TestDiscoveryServer.printMessageStats(message, true);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return;
                    }
                    Message.ElementIterator elementIterator = message.getMessageElements();
                    if (!elementIterator.hasNext()) {
                        return;
                    }
                    MessageElement messageElement = message.getMessageElement(null, TestDiscoveryServer.MESSAGE_NAME_SPACE);
                    if (messageElement.toString() == null) {
                        System.out.println("null msg received");
                    } else {
                        Date date = new Date(System.currentTimeMillis());
                        System.out.println("Message received at :" + date.toString());
                        System.out.println("Message  created at :" + messageElement.toString());
                    }
                }
            };
            System.out.println("pipe name:" + string);
            this.inputPipe = this.pipeService.createInputPipe(this.pipeAdv, pipeMsgListener);
            System.out.println("Publishing Adv---------->" + this.pipeAdv.getID());
            if (this.inputPipe == null) {
                System.out.println(" cannot open InputPipe");
                System.exit(-1);
            }
            while (true) {
                try {
                    while (true) {
                        System.out.println("Server Sleeping  for :" + l3);
                        Thread.sleep(l3);
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static PipeAdvertisement getPipeAdvertisement(String string, PeerGroup peerGroup) {
        PipeID pipeID = null;
        try {
            pipeID = MD4ID.createPipeID(peerGroup.getPeerGroupID(), string, "taskpip");
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PipeAdvertisement pipeAdvertisement = (PipeAdvertisement)AdvertisementFactory.newAdvertisement((String)PipeAdvertisement.getAdvertisementType());
        pipeAdvertisement.setPipeID((ID)pipeID);
        pipeAdvertisement.setType("JxtaPropagate");
        pipeAdvertisement.setName(string);
        return pipeAdvertisement;
    }

    public static PeerAdvertisement getPeerAdvertisement(String string) throws Exception {
        PeerAdvertisement peerAdvertisement = (PeerAdvertisement)AdvertisementFactory.newAdvertisement((String)PeerAdvertisement.getAdvertisementType());
        peerAdvertisement.setPeerID(IDFactory.newPeerID((PeerGroupID)PeerGroupID.worldPeerGroupID));
        peerAdvertisement.setPeerGroupID(IDFactory.newPeerGroupID((PeerGroupID)PeerGroupID.defaultNetPeerGroupID));
        peerAdvertisement.setName(string);
        return peerAdvertisement;
    }

    public void stop() {
        manager.stopNetwork();
    }

    public static void printMessageStats(Message message, boolean bl) {
        try {
            Message.ElementIterator elementIterator = message.getMessageElements();
            System.out.println("------------------Begin Message---------------------");
            WireFormatMessage wireFormatMessage = WireFormatMessageFactory.toWire((Message)message, (MimeMediaType)new MimeMediaType("application/x-jxta-msg"), null);
            System.out.println("Message Size :" + wireFormatMessage.getByteLength());
            while (elementIterator.hasNext()) {
                MessageElement messageElement = elementIterator.next();
                String string = messageElement.getElementName();
                CountingOutputStream countingOutputStream = new CountingOutputStream((OutputStream)new DevNullOutputStream());
                messageElement.sendToStream((OutputStream)countingOutputStream);
                long l = countingOutputStream.getBytesWritten();
                System.out.println("Element " + string + " : " + l);
                if (!bl) continue;
                System.out.println("[" + messageElement + "]");
            }
            System.out.println("-------------------End Message----------------------");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void pipeMsgEvent(PipeMsgEvent pipeMsgEvent) {
        Message message;
        try {
            System.out.println("pipeMsgEvent() called");
            message = pipeMsgEvent.getMessage();
            if (message == null) {
                System.out.println("Received an empty message");
                return;
            }
            TestDiscoveryServer.printMessageStats(message, true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        Message.ElementIterator elementIterator = message.getMessageElements();
        if (!elementIterator.hasNext()) {
            return;
        }
        MessageElement messageElement = message.getMessageElement(null, MESSAGE_NAME_SPACE);
        if (messageElement.toString() == null) {
            System.out.println("null msg received");
        } else {
            Date date = new Date(System.currentTimeMillis());
            System.out.println("Message received at :" + date.toString());
            System.out.println("Message  created at :" + messageElement.toString());
        }
    }
}

