/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.websocket;

import com.fe.p2p.websocket.CommandAbstract;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CommandMain {
    private Logger log = Logger.getLogger(CommandMain.class);
    private String command;

    public CommandMain(String string) {
        this.command = string;
    }

    public String validate() {
        String[] stringArray = this.command.split(" ");
        String string = "";
        if (stringArray.length > 0) {
            String string2 = CommandMain.command2Class(stringArray[0]);
            String string3 = this.getClass().getPackage().getName() + ".cmd." + string2;
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.log.debug((Object)("commandclass:" + string3));
            try {
                Class<?> clazz = classLoader.loadClass(string3);
                CommandAbstract commandAbstract = (CommandAbstract)clazz.newInstance();
                string = commandAbstract.executeCommand(this.command);
            }
            catch (ClassNotFoundException classNotFoundException) {
                string = "Invalid command";
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return string;
        }
        string = "Invalid command";
        return string;
    }

    public static String command2Class(String string) {
        try {
            Pattern pattern = Pattern.compile("(\\_)([a-z]+?)", 32);
            Matcher matcher = pattern.matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "";
            while (matcher.find()) {
                if (matcher.groupCount() <= 1) continue;
                matcher.appendReplacement(stringBuffer, matcher.group(2).toUpperCase());
            }
            matcher.appendTail(stringBuffer);
            String string3 = stringBuffer.toString();
            char[] cArray = string3.toCharArray();
            cArray[0] = Character.toUpperCase(cArray[0]);
            return new String(cArray);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String classToCommand(String string) {
        try {
            char[] cArray = string.toCharArray();
            cArray[0] = Character.toLowerCase(cArray[0]);
            string = new String(cArray);
            Pattern pattern = Pattern.compile("([A-Z]+?)", 32);
            Matcher matcher = pattern.matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            String string2 = "";
            while (matcher.find()) {
                if (matcher.groupCount() <= 0) continue;
                matcher.appendReplacement(stringBuffer, "_" + matcher.group(1).toLowerCase());
            }
            matcher.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }
}

