/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.websocket;

import com.fe.json.JSONException;
import com.fe.json.JSONObject;
import com.fe.p2p.websocket.CommandMain;
import com.fe.p2p.websocket.TomcatWSServer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.websocket.MessageInbound;
import org.apache.catalina.websocket.StreamInbound;
import org.apache.catalina.websocket.WebSocketServlet;
import org.apache.catalina.websocket.WsOutbound;
import org.apache.log4j.Logger;

public class TomcatWSConsole
extends WebSocketServlet {
    private Logger log = Logger.getLogger(TomcatWSServer.class);
    private static final Set<ChatMessageInbound> connections = new CopyOnWriteArraySet<ChatMessageInbound>();

    protected StreamInbound createWebSocketInbound(String string, HttpServletRequest httpServletRequest) {
        return new ChatMessageInbound();
    }

    public static void consoleToAll(String string) {
        for (ChatMessageInbound chatMessageInbound : connections) {
            try {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("c", string);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                CharBuffer charBuffer = CharBuffer.wrap(jSONObject.toString());
                chatMessageInbound.getWsOutbound().writeTextMessage(charBuffer);
            }
            catch (IOException iOException) {}
        }
    }

    private final class ChatMessageInbound
    extends MessageInbound {
        private ChatMessageInbound() {
        }

        protected void onOpen(WsOutbound wsOutbound) {
            connections.add(this);
            TomcatWSConsole.this.log.debug((Object)"connected...");
        }

        protected void onClose(int n) {
            connections.remove((Object)this);
            TomcatWSConsole.this.log.debug((Object)"closed...");
        }

        protected void onBinaryMessage(ByteBuffer byteBuffer) throws IOException {
            throw new UnsupportedOperationException("Binary message not supported.");
        }

        protected void onTextMessage(CharBuffer charBuffer) throws IOException {
            TomcatWSConsole.this.log.debug((Object)("msg received:" + charBuffer));
            CommandMain commandMain = new CommandMain(charBuffer.toString());
            String string = commandMain.validate();
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put("rs", string);
                this.getWsOutbound().writeTextMessage(CharBuffer.wrap(jSONObject.toString()));
            }
            catch (Exception exception) {
                TomcatWSConsole.this.log.error((Object)("Error onMessage:" + exception.getMessage()));
            }
        }
    }
}

