/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p.websocket;

import com.fe.json.JSONException;
import com.fe.json.JSONObject;
import com.fe.p2p.websocket.CommandMain;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.java_websocket.WebSocket;
import org.java_websocket.drafts.Draft;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;

public class WSServer
extends WebSocketServer {
    private Logger log = Logger.getLogger(WSServer.class);
    private static ArrayList<WebSocket> activeConnections = new ArrayList();

    public WSServer(int n, Draft draft) throws UnknownHostException {
        super(new InetSocketAddress(n), Collections.singletonList(draft));
    }

    public void onOpen(WebSocket webSocket, ClientHandshake clientHandshake) {
        activeConnections.add(webSocket);
        this.log.debug((Object)("new Connection handshake:" + clientHandshake.toString()));
    }

    public void onClose(WebSocket webSocket, int n, String string, boolean bl) {
        activeConnections.remove(webSocket);
        this.log.debug((Object)("removed: reason" + string));
    }

    public void onError(WebSocket webSocket, Exception exception) {
        exception.printStackTrace();
    }

    public void onMessage(WebSocket webSocket, String string) {
        CommandMain commandMain = new CommandMain(string);
        String string2 = commandMain.validate();
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("rs", string2);
            webSocket.send(jSONObject.toString());
        }
        catch (Exception exception) {
            this.log.error((Object)("Error onMessage:" + exception.getMessage()));
        }
    }

    public static void consoleToAll(String string) {
        if (activeConnections.size() > 0) {
            for (WebSocket webSocket : activeConnections) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("c", string);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                webSocket.send(jSONObject.toString());
            }
        }
    }

    public static void main(String[] stringArray) throws UnknownHostException {
    }
}

