/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler;

import com.fe.client.BBSyncMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.db.SchedulerDB;
import com.fe.p2p.P2PService;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.SchedulerExePlanLogs;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.group.RScriptScheduledTask;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

public class ScheduledTaskQueue
implements Runnable {
    private static ConcurrentLinkedQueue<StackFrame> queue = new ConcurrentLinkedQueue();
    private Logger log = Logger.getLogger(ScheduledTaskQueue.class);
    private static StackFrame curExecFrame = null;
    private static long lastExcecutedTime = 0L;
    private static Thread thread = null;

    public static synchronized void add(StackFrame stackFrame) {
        Number number = (Number)stackFrame.getData().get("id");
        if (!queue.contains(stackFrame)) {
            queue.add(stackFrame);
            new SchedulerExePlanLogs(number.intValue(), stackFrame.getTrigger_time()).log("Task added to local queue ", 0);
        } else if (queue.contains(stackFrame) && stackFrame.isDependencyfailed()) {
            new SchedulerExePlanLogs(number.intValue(), stackFrame.getTrigger_time()).log("Task dependency failed ", 0);
            queue.add(stackFrame);
        }
        if (thread == null || thread != null && !thread.isAlive()) {
            thread = new Thread(new ScheduledTaskQueue());
            thread.start();
        }
    }

    public static long lastExcecutedTime() {
        return lastExcecutedTime;
    }

    public static synchronized boolean isExecutingOrQueued() {
        boolean bl = false;
        if (queue.size() > 0 && (thread == null || thread != null && !thread.isAlive())) {
            thread = new Thread(new ScheduledTaskQueue());
            thread.start();
        }
        if (thread != null && thread.isAlive() || queue.size() > 0 || curExecFrame != null) {
            bl = true;
        }
        return bl;
    }

    public static synchronized Number getExecutingTaskId() {
        if (ScheduledTaskQueue.isExecutingOrQueued()) {
            return (Number)curExecFrame.getData().get("id");
        }
        return null;
    }

    public static synchronized StackFrame getExecutingStackFrame() {
        if (ScheduledTaskQueue.isExecutingOrQueued()) {
            return curExecFrame;
        }
        return null;
    }

    public static void killQueueThread() throws Exception {
        thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.debug((Object)"thread started");
        try {
            while (!queue.isEmpty()) {
                StackFrame stackFrame;
                curExecFrame = stackFrame = queue.peek();
                boolean bl = true;
                ScheduledTask scheduledTask = stackFrame.getTask();
                this.log.debug((Object)("Executing task1:" + stackFrame.getData().get("name")));
                if (curExecFrame.getData().get("id") == null) {
                    bl = false;
                }
                String string = null;
                Date date = new Date();
                Number number = (Number)stackFrame.getData().get("id");
                try {
                    if (stackFrame.isDependencyfailed()) {
                        string = ScheduledTask.DEPENDENCY_TIMEOUT;
                        Thread.sleep(100L);
                        continue;
                    }
                    this.log.debug((Object)("just before executing task:sframe:" + stackFrame));
                    this.log.debug((Object)("just before executing task:data:" + stackFrame.getData()));
                    this.log.debug((Object)("task" + scheduledTask));
                    try {
                        this.traceHostAndStart(date, stackFrame.getData(), stackFrame);
                    }
                    catch (Exception exception) {
                        this.log.error((Object)"Error in updating queue log");
                    }
                    if (bl) {
                        new SchedulerExePlanLogs(number.intValue(), stackFrame.getTrigger_time()).log("Execution started ", 0);
                        scheduledTask.execute(stackFrame);
                    } else {
                        new RScriptScheduledTask("Adhoc Rscript", "rscript").executeScript(stackFrame);
                    }
                    this.log.debug((Object)"just after executed task");
                    string = ScheduledTask.EXCECUTION_SUCCESS;
                    lastExcecutedTime = new Date().getTime();
                }
                catch (Exception exception) {
                    this.log.error((Object)("error:::::" + exception.getMessage()));
                    exception.printStackTrace();
                    string = ScheduledTask.EXCECUTION_FAIL;
                    ClientErrorMgmt.reportError(exception, null);
                }
                finally {
                    if (stackFrame.getCallBack() != null) {
                        this.log.debug((Object)"sframe call back");
                        try {
                            stackFrame.getCallBack().callBack(stackFrame, string, null);
                        }
                        catch (Exception exception) {
                            ClientErrorMgmt.reportError(exception, null);
                        }
                    }
                    try {
                        this.log.debug((Object)"finally");
                        new SchedulerExePlanLogs(number.intValue(), stackFrame.getTrigger_time()).log("Execution completed, Status:" + string, 0);
                        if (bl) {
                            int n = this.addLog(date, stackFrame.getData(), string, stackFrame);
                            stackFrame.setLogid(n);
                        } else {
                            this.addScriptLog(date, stackFrame.getData(), string, stackFrame);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        ClientErrorMgmt.reportError(exception, null);
                    }
                    queue.remove(stackFrame);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.log.error((Object)("Errror while running this thread, Error:" + exception.getMessage()));
        }
        finally {
            this.log.debug((Object)"exiting thread:");
            curExecFrame = null;
        }
    }

    public static synchronized Map getQueuedIds() {
        Vector<Object> vector = new Vector<Object>();
        Logger logger = Logger.getLogger(ScheduledTaskQueue.class);
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        if (curExecFrame != null) {
            String string = curExecFrame.getData().get("id") + "_" + curExecFrame.getTrigger_time();
            vector.add(string);
            treeMap.put("executing", string);
        }
        for (StackFrame stackFrame : queue) {
            String string = stackFrame.getData().get("id") + "_" + stackFrame.getTrigger_time();
            vector.add(string);
        }
        treeMap.put("alltasks", vector);
        return treeMap;
    }

    public static synchronized Vector<Number> getQueuedTaskIds() {
        Vector<Number> vector = new Vector<Number>();
        Logger logger = Logger.getLogger(ScheduledTaskQueue.class);
        if (curExecFrame != null && curExecFrame.getData().get("id") != null) {
            Number number = (Number)curExecFrame.getData().get("id");
            vector.add(number);
        }
        for (StackFrame stackFrame : queue) {
            Number number = (Number)stackFrame.getData().get("id");
            vector.add(number);
        }
        return vector;
    }

    private void addScriptLog(Date date, Map map, String string, StackFrame stackFrame) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        schedulerDB.connectDB(BBSyncMgmt.getDBName());
        Number number = (Number)map.get("script_id");
        Date date2 = new Date();
        schedulerDB.addRScriptLog(number.intValue(), P2PService.getComputerName(), string, date, date2, stackFrame.getTasklog());
        schedulerDB.closeDB();
    }

    private void traceHostAndStart(Date date, Map map, StackFrame stackFrame) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        schedulerDB.connectDB(BBSyncMgmt.getDBName());
        Number number = (Number)map.get("id");
        schedulerDB.updateHostAndStarted(number.intValue(), stackFrame.getTrigger_time(), date, P2PService.getComputerName());
        schedulerDB.closeDB();
    }

    private int addLog(Date date, Map map, String string, StackFrame stackFrame) throws Exception {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        schedulerDB.connectDB(BBSyncMgmt.getDBName());
        Number number = (Number)map.get("id");
        String string2 = (String)map.get("timezone");
        Date date2 = new Date();
        int n = number.intValue();
        int n2 = schedulerDB.addSchedulerLog(n, date, date2, string2, string, null);
        if (stackFrame.getStarted_time() > 0L) {
            long l = date2.getTime() - date.getTime();
            date.setTime(stackFrame.getStarted_time());
            long l2 = stackFrame.getStarted_time() + l;
            date2.setTime(l2);
        }
        try {
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            treeMap.put("scheduler_id", number);
            treeMap.put("trigger_time", new Long(stackFrame.getTrigger_time()));
            treeMap.put("start_time", date);
            treeMap.put("end_time", date2);
            treeMap.put("status", string);
            treeMap.put("is_triggered", new Integer(1));
            treeMap.put("log_id", new Integer(n2));
            treeMap.put("host", P2PService.getComputerName());
            Vector vector = new Vector();
            vector.add(treeMap);
            if (stackFrame.getNexttrigger_time() > 0L) {
                TreeMap<String, Number> treeMap2 = new TreeMap<String, Number>();
                treeMap2.put("scheduler_id", number);
                treeMap2.put("trigger_time", new Long(stackFrame.getNexttrigger_time()));
                treeMap.put("log_id", new Integer(n2));
                vector.add(treeMap2);
            }
            this.log.debug((Object)("logging job:+" + stackFrame.getTrigger_time() + " scheduler_Id:" + number));
            schedulerDB.updateQueueLog(vector, new Vector());
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
        }
        this.log.debug((Object)("before adding into db sframe.getTaskLog():" + stackFrame.getTasklog()));
        if (stackFrame.getTasklog() != null && !stackFrame.getTasklog().equals("")) {
            try {
                schedulerDB.updateSchedulerLogMsg(n2, stackFrame.getTasklog());
            }
            catch (Exception exception) {
                this.log.error((Object)("Error while updating log message of R Engine:" + exception.getMessage()));
            }
        }
        schedulerDB.closeDB();
        return n2;
    }
}

