/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.balance;

import com.fe.client.BBSyncMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.client.Debugger;
import com.fe.db.SchedulerDB;
import com.fe.db.SuperDB;
import com.fe.p2p.MessageBean;
import com.fe.p2p.P2PAdvertisement;
import com.fe.p2p.P2PService;
import com.fe.p2p.listener.IncomingMessage;
import com.fe.p2p.listener.IncomingMessageParser;
import com.fe.p2p.listener.OutgoingMessage;
import com.fe.p2p.listener.P2PTransportMessage;
import com.fe.p2p.msg.PostMessage;
import com.fe.p2p.msg.scheduler.PeerOnlineStatus;
import com.fe.p2p.msg.scheduler.TenderSchedulerTask;
import com.fe.scheduler.ScheduledTask;
import com.fe.scheduler.ScheduledTaskFactory;
import com.fe.scheduler.ScheduledTimeoutJob;
import com.fe.scheduler.SchedulerAlert;
import com.fe.scheduler.SchedulerEngine;
import com.fe.scheduler.SchedulerExePlanLogs;
import com.fe.scheduler.balance.LoadBalancingQueueItem;
import com.fe.scheduler.balance.LoadBalancingQueueTimeout;
import com.fe.scheduler.balance.executeR.LoadBalancingNewExecuteRQueue;
import com.fe.scheduler.balance.hsqldb.LoadBalancingHSQLQueue;
import com.fe.scheduler.balance.hsqldb.LoadBalancingHSQLQueueItem;
import com.fe.scheduler.exception.ExceptionExecutionTimeout;
import com.fe.scheduler.group.RScriptScheduledTask;
import com.fe.scheduler.rscript.RScript;
import com.fe.scheduler.rscript.RScriptListener;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import net.jxta.peergroup.PeerGroup;
import net.jxta.pipe.OutputPipeListener;
import net.jxta.pipe.PipeService;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.jcs.JCS;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.log4j.Logger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public abstract class LoadBalancingQueue {
    private static Logger log = Logger.getLogger(LoadBalancingQueue.class);
    private static final int MODE_TASK = 1;
    private static final int MODE_SCRIPT = 2;
    private static LoadBalancingQueue loadBalancingQ = null;
    private static LoadBalancingQueue loadERBalancingQ = null;
    public static boolean priorityQueue = false;
    public String PEER_QUEUE_RESP = "PEER_QUEUE_RESP";
    protected JCS cache = null;
    protected JCS cacheGrouped = null;
    public static String CACHE_GROUP_TIMEOUT = "cached_timedout";
    public static String CACHE_GROUP_FINISHED = "cached_finished";
    public static String CACHE_GROUP_ACTIVEPEERS = "cached_activepeers";
    public static String CACHE_GROUP_TENDERSCHEDULERTASK = "cached_tenderschedulertask";
    public static int CACHE_GROUP_EXPIRY = 45;
    protected Vector<String> shuffleIteration = new Vector();
    private static Semaphore lock = new Semaphore(1, true);

    public static synchronized LoadBalancingQueue getDefault() {
        try {
            lock.tryAcquire(1000L, TimeUnit.MICROSECONDS);
            if (loadBalancingQ == null) {
                loadBalancingQ = new LoadBalancingHSQLQueue();
            }
            lock.release();
        }
        catch (Exception exception) {
            log.error((Object)"Error while acquiring lock");
        }
        return loadBalancingQ;
    }

    public static synchronized LoadBalancingQueue getHSQLQueue() {
        if (loadBalancingQ == null) {
            loadBalancingQ = new LoadBalancingHSQLQueue();
        }
        return loadBalancingQ;
    }

    public static synchronized LoadBalancingQueue getExecuteRScriptDefault() {
        if (loadERBalancingQ == null) {
            loadERBalancingQ = new LoadBalancingNewExecuteRQueue();
        }
        return loadERBalancingQ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector getPeers4PriorityGr(String string, String string2) throws Exception {
        SchedulerDB schedulerDB;
        if (this.cache == null) {
            this.getCache();
        }
        IElementAttributes iElementAttributes = this.cache.getDefaultElementAttributes();
        iElementAttributes.setMaxLifeSeconds(4L);
        Vector vector = (Vector)this.cache.get((Object)"peers_priority_available");
        if (vector != null && vector.size() > 0) {
            schedulerDB = vector.get(0);
        }
        if (vector == null) {
            schedulerDB = SchedulerDB.getSchedulerDB();
            try {
                schedulerDB.connectDB(BBSyncMgmt.getDBName());
                vector = schedulerDB.getAvailablePeers(string, string2);
                this.cache.put((Object)"peers_priority_available", (Object)vector, iElementAttributes);
            }
            catch (Exception exception) {
                log.error((Object)("ERROR:" + exception.getMessage() + " Peer Query:" + string + " taskuid:" + string2));
            }
            finally {
                schedulerDB.closeDB();
            }
        }
        return vector;
    }

    public void releasePeersCache4PriorityGr() {
        if (this.cache != null && this.cache.get((Object)"peers_priority_available") != null) {
            try {
                this.cache.remove((Object)"peers_priority_available");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected JCS getCache() throws Exception {
        if (this.cache == null) {
            this.cache = JCS.getInstance((String)"LoadBalancingQueue");
        }
        return this.cache;
    }

    public JCS getGroupedCache() throws Exception {
        if (this.cacheGrouped == null) {
            this.cacheGrouped = JCS.getInstance((String)"LoadBalancingQueueGroupped");
        }
        return this.cacheGrouped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Object> getRunOnlyOn(String string) {
        try {
            Object object;
            Vector vector = (Vector)this.getCache().get((Object)("available_p_" + string));
            if (vector != null && vector.size() > 0) {
                object = vector.get(0);
            }
            if (vector == null) {
                object = SchedulerDB.getSchedulerDB();
                ((SuperDB)object).connectDB(BBSyncMgmt.getDBName());
                try {
                    vector = ((SchedulerDB)object).getAssoAvailablePeers(string);
                }
                finally {
                    ((SuperDB)object).closeDB();
                }
                if (this.getCache() == null) {
                    this.getCache();
                }
                IElementAttributes iElementAttributes = this.getCache().getDefaultElementAttributes();
                iElementAttributes.setMaxLifeSeconds(5L);
                this.getCache().put((Object)("available_p_" + string), (Object)vector, iElementAttributes);
            }
            object = vector;
            return object;
        }
        catch (Exception exception) {
            log.error((Object)"Error in retrieving associated peers ");
            Vector<Object> vector = new Vector<Object>();
            return vector;
        }
    }

    protected synchronized void sendTask2Peer(Vector<Object> vector, int n, long l, long l2, String string) throws Exception {
        boolean bl = true;
        Vector vector2 = (Vector)this.shuffleIteration.clone();
        Vector vector3 = new Vector();
        for (Object e : vector2) {
            if (!vector.contains(e)) continue;
            vector3.add(e);
        }
        vector.removeAll(vector3);
        vector.addAll(vector3);
        boolean bl2 = true;
        boolean bl3 = false;
        for (String string2 : vector) {
            TenderSchedulerTask tenderSchedulerTask = new TenderSchedulerTask();
            tenderSchedulerTask.setScheduler_id(n + "");
            tenderSchedulerTask.setTrigger_time(l + "");
            tenderSchedulerTask.setNext_trigger_time(l2 + "");
            tenderSchedulerTask.setTaskuid(string);
            String string3 = n + "_" + l;
            if (this.getGroupedCache().getFromGroup((Object)string3, CACHE_GROUP_TENDERSCHEDULERTASK) != null) {
                this.getGroupedCache().remove((Object)string3, CACHE_GROUP_TENDERSCHEDULERTASK);
            }
            IElementAttributes iElementAttributes = this.getGroupedCache().getDefaultElementAttributes();
            iElementAttributes.setMaxLifeSeconds((long)CACHE_GROUP_EXPIRY);
            this.getGroupedCache().putInGroup((Object)string3, CACHE_GROUP_TENDERSCHEDULERTASK, (Object)"0");
            new PostMessage(tenderSchedulerTask, string2).send();
            Debugger.addDebugMsg("Msg to peer " + string2 + " sc_id:" + n + " tr_time: " + l, string2 + " " + n + " " + l);
            if (bl) {
                if (this.shuffleIteration.contains(string2)) {
                    this.shuffleIteration.remove(string2);
                }
                this.shuffleIteration.add(string2);
            }
            bl = false;
            Thread.sleep(5L);
        }
        vector2 = null;
        vector3 = null;
    }

    public final void updatePeerData(String string) throws Exception {
        PeerGroup peerGroup = P2PService.getPeerGroup();
        MessageBean messageBean = new MessageBean();
        messageBean.setType(MessageBean.TYPE_REQUEST);
        messageBean.setReply(MessageBean.REPLYBACK);
        messageBean.setCommand(string);
        Vector vector = this.getStaticClients();
        for (String string2 : vector) {
            PipeAdvertisement pipeAdvertisement = new P2PAdvertisement().getPipeAdvertisement(string2, peerGroup);
            OutgoingMessage outgoingMessage = new OutgoingMessage(null, messageBean, string2);
            PipeService pipeService = P2PService.getPipeService();
            try {
                pipeService.createOutputPipe(pipeAdvertisement, (OutputPipeListener)outgoingMessage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (string.equals(P2PTransportMessage.COMMAND_STATISTICS)) {
            IncomingMessage.updatePeerStatistics(P2PService.getComputerName(), IncomingMessageParser.getServerStatistics());
        }
        if (string.equals(P2PTransportMessage.COMMAND_PEER_QUEUE)) {
            IncomingMessage.updatePeerQueueStat(P2PService.getComputerName(), IncomingMessageParser.getServerPeerQueueStat());
        }
        if (string.equals(P2PTransportMessage.COMMAND_R_PACKAGES)) {
            try {
                IncomingMessage.updatePeerRPackages(P2PService.getComputerName(), RScriptScheduledTask.getRPackageVersion());
            }
            catch (Exception exception) {
                ClientErrorMgmt.reportError(exception, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getStaticClients() throws Exception {
        SchedulerDB schedulerDB;
        if (this.cache == null) {
            this.getCache();
        }
        IElementAttributes iElementAttributes = this.cache.getDefaultElementAttributes();
        iElementAttributes.setMaxLifeSeconds(7L);
        Vector vector = (Vector)this.cache.get((Object)"perminentpeers");
        if (vector != null && vector.size() > 0) {
            schedulerDB = vector.get(0);
        }
        if (vector == null) {
            schedulerDB = SchedulerDB.getSchedulerDB();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            try {
                vector = schedulerDB.getPeersList();
            }
            finally {
                schedulerDB.closeDB();
            }
            vector.remove(P2PService.getComputerName());
            this.cache.put((Object)"perminentpeers", (Object)vector, iElementAttributes);
        }
        return vector;
    }

    public final void findAndUpdateOnlinePeers() throws Exception {
        Vector vector = this.getStaticClients();
        for (String string : vector) {
            PeerOnlineStatus peerOnlineStatus = new PeerOnlineStatus();
            PostMessage postMessage = new PostMessage(peerOnlineStatus, string);
            postMessage.send();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPeerBusyWithTask(String string, int n) {
        boolean bl = false;
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Vector vector = new Vector();
            Collection<LoadBalancingQueueItem> collection = this.getExecutingTasks();
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            for (LoadBalancingQueueItem loadBalancingQueueItem : collection) {
                long l = 0L;
                l = loadBalancingQueueItem instanceof LoadBalancingHSQLQueueItem ? ((LoadBalancingHSQLQueueItem)loadBalancingQueueItem).getTrigger_time() : loadBalancingQueueItem.getSf().getTrigger_time();
                if (!loadBalancingQueueItem.getMachine().equals(string)) continue;
                if (loadBalancingQueueItem.getSchedulerid() != n) {
                    Map map = schedulerDB.getQueueLog(loadBalancingQueueItem.getSchedulerid(), l);
                    if (map.get("status") != null && map.get("host") != null && map.get("end_time") != null) {
                        this.removeItemProcessing(loadBalancingQueueItem, "LoadBalancingQueue removing it from processing Queue", 3002);
                        continue;
                    }
                    loadBalancingQueueItem.getSf().setTasklog("No response from " + string + " for executed task, probably peer could have been crashed");
                    loadBalancingQueueItem.getSf().setDependencyfailed(true);
                    loadBalancingQueueItem.setExecuting(false);
                    this.removeItemProcessing(loadBalancingQueueItem, "No response from " + string + " for executed task, probably peer could have been crashed", 3003);
                    continue;
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                schedulerDB.closeDB();
            }
            catch (Exception exception) {}
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void removeTimeoutForTask(int n, long l) {
        try {
            String string;
            boolean bl;
            StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
            Scheduler scheduler = stdSchedulerFactory.getScheduler();
            if (scheduler.isStarted() && !(bl = scheduler.deleteJob(new JobKey(string = this.getTimeoutJobName(n, l), "MY_SCHEDULER_TIMEOUT_Group")))) return;
        }
        catch (Exception exception) {
            log.error((Object)("error while removing timeout for the task, error:" + exception.getMessage() + " scheduler_id:" + n));
        }
    }

    protected void addLastExecutionDuration(SchedulerDB schedulerDB, LoadBalancingQueueItem loadBalancingQueueItem) throws Exception {
        try {
            Map map = schedulerDB.getLastSuccessfulQLog(loadBalancingQueueItem.getSchedulerid());
            if (map != null) {
                Timestamp timestamp = (Timestamp)map.get("start_time");
                Timestamp timestamp2 = (Timestamp)map.get("end_time");
                long l = timestamp2.getTime() - timestamp.getTime();
                loadBalancingQueueItem.setLastExecutedDuration(l);
            }
        }
        catch (Exception exception) {
            log.error((Object)("addLastExecutionDuration():" + exception.getMessage()));
        }
    }

    protected void addTimeoutAndLastExecTimes(SchedulerDB schedulerDB, LoadBalancingQueueItem loadBalancingQueueItem) throws Exception {
        try {
            long l = schedulerDB.getMaxDurationInLast50Exec(loadBalancingQueueItem.getSchedulerid());
            loadBalancingQueueItem.setOverlaptimeout(l);
            LoadBalancingQueueTimeout loadBalancingQueueTimeout = new LoadBalancingQueueTimeout(schedulerDB, new ScheduledTaskFactory().getTaskUids());
            long l2 = schedulerDB.getTimeoutCriteriaInMs(loadBalancingQueueItem.getSchedulerid());
            if (l2 > 0L) {
                int n = Math.round(l2 / 1000L / 60L);
                if (n <= loadBalancingQueueTimeout.getFewerminutes()) {
                    loadBalancingQueueItem.setTimeoutexpiry(loadBalancingQueueTimeout.getFewerminutesexpiry() * 1000 * 60);
                } else {
                    loadBalancingQueueItem.setTimeoutexpiry(l2 * (long)loadBalancingQueueTimeout.getElsecritieriaxtime());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected final synchronized void addTimeoutForTask(int n, long l, long l2, long l3) {
        try {
            StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
            Scheduler scheduler = stdSchedulerFactory.getScheduler();
            if (scheduler.isStarted() && l3 > 0L) {
                String string = this.getTimeoutJobName(n, l);
                JobDetail jobDetail = scheduler.getJobDetail(new JobKey(string, "MY_SCHEDULER_TIMEOUT_Group"));
                if (jobDetail != null) {
                    scheduler.deleteJob(new JobKey(string, "MY_SCHEDULER_TIMEOUT_Group"));
                }
                JobDetail jobDetail2 = JobBuilder.newJob(ScheduledTimeoutJob.class).withIdentity(string, "MY_SCHEDULER_TIMEOUT_Group").usingJobData("scheduler_id", Integer.valueOf(n)).usingJobData("trigger_time", Long.valueOf(l)).usingJobData("started_time", Long.valueOf(l2)).build();
                Date date = new Date();
                date.setTime(l2 + l3);
                SimpleTrigger simpleTrigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(string, "MY_SCHEDULER_TIMEOUT_Group").startAt(date).build();
                scheduler.scheduleJob(jobDetail2, (Trigger)simpleTrigger);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MMM.yyyy HH:mm:ss");
                log.debug((Object)("----------LoadBalancingQueue:adding timeout into queue will be fired :" + simpleDateFormat.format(date) + " scheduler_id:" + n));
            }
        }
        catch (Exception exception) {
            log.error((Object)("error while setting timeout for the task, error:" + exception.getMessage()));
        }
    }

    private String getTimeoutJobName(int n, long l) {
        return "timeout_" + n + "_" + l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void taskTimedOut(int n, long l, long l2) {
        int n2 = 0;
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            Object object;
            LoadBalancingQueueItem loadBalancingQueueItem = this.getItemFromProcessingQueue(n, l);
            this.removeItemProcessing(loadBalancingQueueItem, null, 3000);
            n2 = 1;
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            Map map = schedulerDB.getScheduler(n);
            n2 = 2;
            String string = (String)map.get("alert_type");
            String string2 = (String)map.get("name");
            String string3 = loadBalancingQueueItem.getMachine();
            n2 = 3;
            IncomingMessage.updateFinishedPeersTime(string3, n, l);
            Map map2 = schedulerDB.getQueueLog(n, l);
            n2 = 4;
            boolean bl = false;
            if (map2 != null && map2.get("status") != null && (object = (String)map2.get("status")) != null && ((String)object).equalsIgnoreCase("success")) {
                bl = true;
            }
            n2 = 5;
            if (!bl) {
                Object object2;
                Object object3;
                new SchedulerExePlanLogs(n, l).log("Execution TimedOut, removed from the Queue", 3000);
                object = new TreeMap();
                ((TreeMap)object).put("scheduler_id", n);
                ((TreeMap)object).put("trigger_time", l);
                ((TreeMap)object).put("host", string3);
                ((TreeMap)object).put("status", ScheduledTask.TIMOUT_WARNING);
                Vector<Object> vector = new Vector<Object>();
                vector.add(object);
                schedulerDB.updateQueueLog(vector, new Vector());
                n2 = 6;
                Map map3 = schedulerDB.getTaskEventActions(n, l);
                if (map3.containsKey(ScheduledTask.FIELD_DEPENDENCY_TIMEOUT) && map3.get(ScheduledTask.FIELD_DEPENDENCY_TIMEOUT) != null && !((String)map3.get(ScheduledTask.FIELD_DEPENDENCY_TIMEOUT)).trim().equals("")) {
                    object3 = (String)map3.get(ScheduledTask.FIELD_DEPENDENCY_TIMEOUT);
                    object2 = ScheduledTask.TASK_EVENT_CALL_EXP_ID_VARIABLE + "=" + n + "\n";
                    object2 = (String)object2 + ScheduledTask.TASK_EVENT_CALL_EXP_TRIGGERTIME_VARIABLE + "=" + l + "\n";
                    new SchedulerEngine().executeScriptExpression((String)object3, "onExecution timeout of " + n, (String)object2);
                }
                n2 = 7;
                object3 = new SchedulerAlert(n, l);
                object2 = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
                Date date = new Date();
                date.setTime(l2);
                Date date2 = new Date();
                String string4 = "Task timed-out! Task started at " + ((DateFormat)object2).format(date) + " on peer " + string3 + " and no response till " + ((DateFormat)object2).format(date2) + " and removed from the queue";
                n2 = 8;
                ExceptionExecutionTimeout exceptionExecutionTimeout = new ExceptionExecutionTimeout(string4);
                schedulerDB.updateResponseCode(n, l, exceptionExecutionTimeout.getErrorcode());
                n2 = 9;
                ((SchedulerAlert)object3).alert(string, string2, SchedulerAlert.ALERT_SUB_TIMEOUT, string4, null, schedulerDB, exceptionExecutionTimeout, map);
                n2 = 10;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            log.error((Object)("error while writing timedout log, e:" + exception.getMessage() + " reached step:" + n2));
        }
        finally {
            try {
                schedulerDB.closeDB();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int dependencyCheck(LoadBalancingQueueItem loadBalancingQueueItem, String string, String string2, SchedulerDB schedulerDB) {
        int n;
        block18: {
            String string3;
            Comparable<Date> comparable;
            Cloneable cloneable;
            Object object;
            n = 1;
            long l = loadBalancingQueueItem.getSf().getNexttrigger_time();
            if (l > 0L) {
                object = new Date(l);
                cloneable = Calendar.getInstance();
                ((Calendar)cloneable).setTime((Date)object);
                ((Calendar)cloneable).add(12, -1);
                comparable = new Date();
                if (((Date)comparable).after(((Calendar)cloneable).getTime())) {
                    n = -1;
                    return n;
                }
            }
            object = new StringTokenizer(string, ",");
            cloneable = new TreeMap();
            comparable = null;
            while (((StringTokenizer)object).hasMoreTokens()) {
                string3 = ((StringTokenizer)object).nextToken();
                try {
                    ((TreeMap)cloneable).put(Integer.parseInt(string3), "fail");
                }
                catch (Exception exception) {}
            }
            try {
                comparable = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (((TreeMap)cloneable).size() > 0 && (Integer)comparable > 0) {
                string3 = null;
                Object object2 = ((TreeMap)cloneable).keySet().iterator();
                while (object2.hasNext()) {
                    string3 = string3 == null ? "" + object2.next() : string3 + "," + object2.next();
                }
                object2 = Calendar.getInstance();
                ((Calendar)object2).add(12, -((Integer)comparable).intValue());
                Date date = ((Calendar)object2).getTime();
                try {
                    Object object3;
                    List list = (List)this.getCache().get((Object)("depids:" + string));
                    if (list != null && list.size() > 0) {
                        object3 = list.get(0);
                    }
                    if (list == null) {
                        object3 = this.getCache().getDefaultElementAttributes();
                        object3.setMaxLifeSeconds(3L);
                        list = schedulerDB.listDependencyList(string3, date);
                        this.getCache().put((Object)("depids:" + string), (Object)list, (IElementAttributes)object3);
                    }
                    if (list.size() > 0) {
                        for (Map map : list) {
                            if (map.get("scheduler_id") == null) continue;
                            ((TreeMap)cloneable).put((Integer)map.get("scheduler_id"), "pass");
                        }
                        if (((TreeMap)cloneable).containsValue("fail")) {
                            n = 0;
                        }
                        break block18;
                    }
                    n = 0;
                }
                catch (Exception exception) {}
            }
        }
        return n;
    }

    public abstract void add(LoadBalancingQueueItem var1);

    public abstract void addExecuteR(RScript var1, RScriptListener var2) throws Exception;

    public abstract List<LoadBalancingQueueItem> getAllTasks();

    public abstract long lastExcecutedTime();

    public abstract RScript startScriptIfNotStarted(RScript var1, String var2);

    public abstract void scriptFinished(RScript var1, String var2, String var3);

    public abstract void removeScriptFromAllQueue(RScript var1);

    public abstract void removeItemProcessing(LoadBalancingQueueItem var1, String var2, int var3);

    public abstract LoadBalancingQueueItem getItemFromProcessingQueue(int var1, long var2);

    public abstract boolean killQueuedTask(int var1, long var2);

    public abstract boolean removeFaultyProcessingTask(int var1, long var2);

    public abstract int startedIfNotStarted(int var1, long var2, String var4);

    public abstract void executionFailed(int var1, long var2, String var4);

    public abstract void executionEnded(int var1, long var2);

    public abstract void cleanupProccesingQueue(int var1, String var2);

    public abstract Collection<LoadBalancingQueueItem> getExecutingTasks();

    public abstract Collection<LoadBalancingQueueItem> getQueuedTasks();

    public abstract void executeScript(Vector<Object> var1, int var2) throws Exception;

    public abstract void peerStarted(int var1, long var2, String var4) throws Exception;

    public abstract void executionEnded(int var1);

    public abstract Collection<RScript> getScriptQueue() throws Exception;

    public abstract Collection<RScript> getScriptProcessingQueue() throws Exception;
}

