/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.engines;

import com.fe.Config;
import com.fe.client.ClientErrorMgmt;
import com.fe.p2p.P2PService;
import com.fe.scheduler.SchedulerExePlanLogs;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.engines.AbstractRScript;
import com.fe.scheduler.exception.ExceptionRServeUnixFailure;
import com.fe.scheduler.exception.ExceptionUnixPeerUnknown;
import com.fe.scheduler.exception.SchedulerException;
import com.fe.scheduler.rserve.RServeSession;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionException;

public abstract class AbstractRServe
extends AbstractRScript {
    private Logger log = Logger.getLogger(AbstractRServe.class);
    protected StackFrame stackframe = null;

    public AbstractRServe(String string, String string2) {
        super(string, string2);
    }

    public abstract RServeSession getRServeSession(int var1, String var2) throws Exception;

    public abstract void evalScript(RServeSession var1, String var2) throws Exception;

    public abstract void closeRconnection(RServeSession var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void execute(StackFrame stackFrame) throws JobExecutionException, Exception {
        this.stackframe = stackFrame;
        Map map = stackFrame.getData();
        String string = (String)map.get("rscript");
        Number number = (Number)map.get("id");
        String string2 = stackFrame.getData().get("name").toString();
        if (string == null) {
            throw new JobExecutionException("Task Failed because no R script found or empty");
        }
        if (string == null) return;
        if (string.equals("")) return;
        try {
            String string3;
            String string4;
            BufferedReader bufferedReader;
            this.log.debug((Object)"R init source file initiated.");
            StringBuffer stringBuffer = new StringBuffer();
            this.log.debug((Object)("------------------<<<<r_script_init:" + Config.getString("r_script_init")));
            if (Config.getString("r_script_init") != null && new File(Config.getString("r_script_init")).exists()) {
                this.log.debug((Object)"including r_script_init");
                bufferedReader = new BufferedReader(new FileReader(Config.getString("r_script_init")));
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (string4 == null || string4.equals("")) continue;
                    stringBuffer.append(string4 + "\n");
                }
                bufferedReader.close();
                this.log.debug((Object)"R init source file initiated.");
            }
            bufferedReader = new BufferedReader(new StringReader(string));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3 == null || string3.equals("")) continue;
                stringBuffer.append(string3 + "\n");
            }
            bufferedReader.close();
            string4 = null;
            RServeSession rServeSession = null;
            File file = null;
            try {
                rServeSession = this.getRServeSession(number.intValue(), string2);
                if (rServeSession == null) throw new ExceptionRServeUnixFailure("Couldn't start RServ Connection!, Connection is null");
                if (rServeSession.getRconnection() == null) throw new ExceptionRServeUnixFailure("Couldn't start RServ Connection!, Connection is null");
                new SchedulerExePlanLogs(number.intValue(), stackFrame.getTrigger_time()).log("RServe session started..", 5009);
                string4 = rServeSession.getRconnection();
                string4.assign(".trigger_time", stackFrame.getTrigger_time() + "");
                string4.assign(".scheduler_id", number + "");
                string4.assign(".machine", P2PService.getComputerName());
                string4.assign(".enginetype", "RServeUnix");
                string4.assign(".connection_ids", "");
                file = File.createTempFile(number.intValue() + "_" + stackFrame.getTrigger_time(), ".log");
                file.getParentFile().setWritable(true, false);
                Object object = file.getPath();
                if (((String)object).contains("\\")) {
                    object = ((String)object).replaceAll("\\\\", "\\\\\\\\");
                }
                file.delete();
                this.log.debug((Object)("---- deleting ff:" + (String)object));
                String string5 = "file(\"" + (String)object + "\", open = \"wt\");";
                this.log.debug((Object)("file assign------fileass:" + string5));
                string4.eval(".console_msg_zz<-" + string5);
                string4.eval("sink(.console_msg_zz)");
                string4.eval("sink(.console_msg_zz, type = \"message\")");
                this.log.debug((Object)"----sink----");
                new SchedulerExePlanLogs(number.intValue(), stackFrame.getTrigger_time()).log("RServe Script evaluation starting..", 5002);
                this.evalScript(rServeSession, stringBuffer.toString());
            }
            catch (SchedulerException schedulerException) {
                throw schedulerException;
            }
            catch (Exception exception) {
                stackFrame.setTasklog(exception.getMessage());
                throw new ExceptionUnixPeerUnknown("RServeUnixTask: Error:" + exception.getMessage());
            }
            finally {
                if (file != null && file.exists()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        stackFrame.setConsole_message(IOUtils.toString((InputStream)fileInputStream));
                    }
                    catch (Exception exception) {
                        this.log.error((Object)("error while accessing the file, Error:" + exception.getMessage()));
                    }
                    finally {
                        fileInputStream.close();
                    }
                    file.delete();
                }
                if (string4 != null) {
                    string4.eval("sink(type = \"message\")");
                    string4.eval("sink()");
                    string4.eval("close(.console_msg_zz)");
                    this.closeRconnection(rServeSession);
                }
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log.debug((Object)(" end of execute() script :" + string2));
            return;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }
}

