/*
 * Decompiled with CFR 0.152.
 */
package com.fe.scheduler.peer;

import com.fe.client.BBSyncMgmt;
import com.fe.db.SchedulerDB;
import com.fe.p2p.P2PService;
import com.fe.scheduler.SchedulerExePlanLogs;
import com.fe.scheduler.StackFrame;
import com.fe.scheduler.exception.ExceptionPeerRejected;
import com.fe.scheduler.peer.QueueExeThread;
import com.fe.scheduler.peer.QueueFactory;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public abstract class QueueAbstract {
    private long lastExcecutedTime;
    private Logger log = Logger.getLogger(QueueAbstract.class);
    private ConcurrentLinkedQueue threads = new ConcurrentLinkedQueue();
    private static Semaphore queueCheckLock = new Semaphore(1, true);
    private static final long TIMEOUT_MS = 1000L;
    private String name = null;

    private void acquireLock() {
        try {
            queueCheckLock.tryAcquire(1000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
    }

    private void releaseLock() {
        try {
            queueCheckLock.release();
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
    }

    public QueueAbstract(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public abstract Vector getTaskUids();

    public abstract int getConcurrentThreads();

    protected void setLastExecutedTime(long l) {
        this.lastExcecutedTime = l;
    }

    public long getLastExecutedTime() {
        return this.lastExcecutedTime;
    }

    public synchronized boolean isRoomForThread() {
        this.acquireLock();
        this.log.debug((Object)("====>> currently " + this.threads + " in queue and maximum in the Q can be " + this.getConcurrentThreads()));
        if (this.threads.size() < this.getConcurrentThreads() && !QueueFactory.restartRequested) {
            try {
                if (this.threads.size() > 0) {
                    this.releaseLock();
                    Thread.sleep(200 * this.threads.size());
                } else {
                    this.releaseLock();
                }
            }
            catch (Exception exception) {
                this.log.error((Object)"Error while delaying thread");
            }
            return true;
        }
        this.releaseLock();
        return false;
    }

    public Object[] getExecutingStacks() {
        return this.threads.toArray();
    }

    public int getExecutingStacksSize() {
        return this.threads.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addExThread(StackFrame stackFrame) throws Exception {
        block18: {
            this.acquireLock();
            try {
                if (this.threads.size() < this.getConcurrentThreads() && !QueueFactory.restartRequested) {
                    Number number = null;
                    if (stackFrame.getData() != null) {
                        number = (Number)stackFrame.getData().get("id");
                        new SchedulerExePlanLogs(number.intValue(), stackFrame.getTrigger_time()).log("Task added into local queue at client side", 5004);
                    }
                    this.threads.add(stackFrame);
                    Thread thread = new Thread(new QueueExeThread(this, stackFrame));
                    thread.start();
                    if (stackFrame.getData() == null) break block18;
                    SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
                    try {
                        schedulerDB.connectDB(BBSyncMgmt.getDBName());
                        schedulerDB.addPeerThreadStatus(P2PService.getComputerName(), this.name, stackFrame.getTask().getUniqueid(), this.getConcurrentThreads(), number.intValue());
                        break block18;
                    }
                    catch (Exception exception) {
                        this.log.error((Object)("error:" + exception.getMessage()));
                        break block18;
                    }
                    finally {
                        try {
                            schedulerDB.closeDB();
                        }
                        catch (Exception exception) {
                            this.log.error((Object)("error:" + exception.getMessage()));
                        }
                    }
                }
                throw new ExceptionPeerRejected(null);
            }
            catch (Exception exception) {
                this.log.error((Object)exception.getMessage());
                throw exception;
            }
            finally {
                this.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishedExec(StackFrame stackFrame) {
        this.acquireLock();
        try {
            this.threads.remove(stackFrame);
        }
        catch (Exception exception) {
            this.log.error((Object)exception.getMessage());
        }
        finally {
            this.releaseLock();
        }
        if (stackFrame.getData() != null) {
            SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
            try {
                Number number = (Number)stackFrame.getData().get("id");
                schedulerDB.connectDB(BBSyncMgmt.getDBName());
                schedulerDB.removePeerThreadStatus(P2PService.getComputerName(), number.intValue());
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    schedulerDB.closeDB();
                }
                catch (Exception exception) {
                    this.log.error((Object)("error:" + exception.getMessage()));
                }
                if (QueueFactory.restartRequested) {
                    // empty if block
                }
            }
        }
    }
}

