/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.AbsractRemoteCacheListener;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;

public class RemoteCacheListener
extends AbsractRemoteCacheListener
implements IRemoteCacheConstants,
Serializable,
IRemoteCacheListener {
    private static final long serialVersionUID = 25345252345322345L;
    private static final Log log = LogFactory.getLog((Class)RemoteCacheListener.class);

    public RemoteCacheListener(IRemoteCacheAttributes irca, ICompositeCacheManager cacheMgr) {
        super(irca, cacheMgr);
        try {
            if (irca.getLocalPort() > 0) {
                UnicastRemoteObject.exportObject((Remote)this, irca.getLocalPort());
            } else {
                UnicastRemoteObject.exportObject(this);
            }
        }
        catch (RemoteException ex) {
            log.error((Object)"Problem exporting object.", (Throwable)ex);
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public synchronized void dispose() throws IOException {
        if (!this.disposed) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Unexporting listener.");
            }
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (RemoteException ex) {
                log.error((Object)"Problem unexporting the listener.", (Throwable)ex);
                throw new IllegalStateException(ex.getMessage());
            }
            this.disposed = true;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n RemoteCacheListener: ");
        buf.append(super.toString());
        return buf.toString();
    }
}

