/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.AbstractRemoteCacheNoWaitFacade;
import org.apache.jcs.auxiliary.remote.RemoteCacheAttributes;
import org.apache.jcs.auxiliary.remote.RemoteCacheFailoverRunner;
import org.apache.jcs.auxiliary.remote.RemoteCacheNoWait;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;

public class RemoteCacheNoWaitFacade
extends AbstractRemoteCacheNoWaitFacade {
    private static final long serialVersionUID = -4529970797620747111L;
    private static final Log log = LogFactory.getLog((Class)RemoteCacheNoWaitFacade.class);

    public RemoteCacheNoWaitFacade(RemoteCacheNoWait[] noWaits, RemoteCacheAttributes rca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        super(noWaits, rca, cacheMgr, cacheEventLogger, elementSerializer);
    }

    protected void failover(int i) {
        if (log.isDebugEnabled()) {
            log.info((Object)("in failover for " + i));
        }
        if (this.remoteCacheAttributes.getRemoteType() == 0) {
            if (this.noWaits[i].getStatus() == 3) {
                RemoteCacheFailoverRunner runner = new RemoteCacheFailoverRunner(this, this.getCompositeCacheManager(), this.cacheEventLogger, this.elementSerializer);
                if (runner != null) {
                    runner.notifyError();
                    Thread t = new Thread(runner);
                    t.setDaemon(true);
                    t.start();
                }
                if (this.getCacheEventLogger() != null) {
                    this.getCacheEventLogger().logApplicationEvent("RemoteCacheNoWaitFacade", "InitiatedFailover", this.noWaits[i] + " was in error.");
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)"The noWait is not in error");
            }
        }
    }
}

