/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.memory;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.group.GroupAttrName;
import org.apache.jcs.engine.control.group.GroupId;
import org.apache.jcs.engine.memory.AbstractMemoryCache;
import org.apache.jcs.engine.memory.util.MemoryElementDescriptor;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;
import org.apache.jcs.utils.struct.DoubleLinkedList;

public abstract class AbstractDoulbeLinkedListMemoryCache
extends AbstractMemoryCache {
    private static final long serialVersionUID = 1422569420563967389L;
    private static final Log log = LogFactory.getLog((Class)AbstractDoulbeLinkedListMemoryCache.class);
    protected DoubleLinkedList list;
    protected int hitCnt = 0;
    protected int missCnt = 0;
    private int putCnt = 0;

    public synchronized void initialize(CompositeCache hub) {
        super.initialize(hub);
        this.list = new DoubleLinkedList();
        log.info((Object)("initialized MemoryCache for " + this.cacheName));
    }

    public Map createMap() {
        return new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void update(ICacheElement ce) throws IOException {
        ++this.putCnt;
        ce.getElementAttributes().setLastAccessTimeNow();
        AbstractDoulbeLinkedListMemoryCache abstractDoulbeLinkedListMemoryCache = this;
        synchronized (abstractDoulbeLinkedListMemoryCache) {
            MemoryElementDescriptor newNode = this.adjustListForUpdate(ce);
            MemoryElementDescriptor oldNode = this.map.put(newNode.ce.getKey(), newNode);
            if (oldNode != null && newNode.ce.getKey().equals(oldNode.ce.getKey())) {
                this.list.remove(oldNode);
            }
        }
        this.spoolIfNeeded();
    }

    protected abstract MemoryElementDescriptor adjustListForUpdate(ICacheElement var1) throws IOException;

    private void spoolIfNeeded() throws Error {
        int size = this.map.size();
        if (size <= this.cattr.getMaxObjects()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"In memory limit reached, spooling");
        }
        int chunkSizeCorrected = Math.min(size, this.chunkSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to spool to disk cache, map size: " + size + ", max objects: " + this.cattr.getMaxObjects() + ", items to spool: " + chunkSizeCorrected));
        }
        for (int i = 0; i < chunkSizeCorrected; ++i) {
            this.spoolLastElement();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("update: After spool map size: " + this.map.size() + " linked list size = " + this.dumpCacheSize()));
        }
    }

    public final synchronized ICacheElement get(Serializable key) throws IOException {
        MemoryElementDescriptor me;
        ICacheElement ce = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getting item from cache " + this.cacheName + " for key " + key));
        }
        if ((me = (MemoryElementDescriptor)this.map.get(key)) != null) {
            ce = me.ce;
            ++this.hitCnt;
            ce.getElementAttributes().setLastAccessTimeNow();
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.cacheName + ": LRUMemoryCache hit for " + ce.getKey()));
            }
            this.adjustListForGet(me);
        } else {
            ++this.missCnt;
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.cacheName + ": LRUMemoryCache miss for " + key));
            }
        }
        this.verifyCache();
        return ce;
    }

    protected abstract void adjustListForGet(MemoryElementDescriptor var1);

    public int freeElements(int numberToFree) throws IOException {
        ICacheElement element;
        int freed;
        for (freed = 0; freed < numberToFree && (element = this.spoolLastElement()) != null; ++freed) {
        }
        return freed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ICacheElement spoolLastElement() throws Error {
        ICacheElement toSpool = null;
        AbstractDoulbeLinkedListMemoryCache abstractDoulbeLinkedListMemoryCache = this;
        synchronized (abstractDoulbeLinkedListMemoryCache) {
            if (this.list.getLast() != null) {
                toSpool = ((MemoryElementDescriptor)this.list.getLast()).ce;
                if (toSpool == null) throw new Error("update: last.ce is null!");
                this.cache.spoolToDisk(((MemoryElementDescriptor)this.list.getLast()).ce);
                if (!this.map.containsKey(((MemoryElementDescriptor)this.list.getLast()).ce.getKey())) {
                    log.error((Object)("update: map does not contain key: " + ((MemoryElementDescriptor)this.list.getLast()).ce.getKey()));
                    this.verifyCache();
                }
                if (this.map.remove(((MemoryElementDescriptor)this.list.getLast()).ce.getKey()) == null) {
                    log.warn((Object)("update: remove failed for key: " + ((MemoryElementDescriptor)this.list.getLast()).ce.getKey()));
                    this.verifyCache();
                }
            } else {
                this.verifyCache();
                throw new Error("update: last is null!");
            }
            this.list.removeLast();
            if (this.map.size() == this.dumpCacheSize()) return toSpool;
            log.warn((Object)("update: After spool, size mismatch: map.size() = " + this.map.size() + ", linked list size = " + this.dumpCacheSize()));
            return toSpool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean remove(Serializable key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing item for key: " + key));
        }
        boolean removed = false;
        if (key instanceof String && ((String)((Object)key)).endsWith(":")) {
            Map map = this.map;
            synchronized (map) {
                Iterator itr = this.map.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Object k = entry.getKey();
                    if (!(k instanceof String) || !((String)k).startsWith(key.toString())) continue;
                    this.list.remove((MemoryElementDescriptor)entry.getValue());
                    itr.remove();
                    removed = true;
                }
            }
        } else if (key instanceof GroupId) {
            Map map = this.map;
            synchronized (map) {
                Iterator itr = this.map.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    Object k = entry.getKey();
                    if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(key)) continue;
                    itr.remove();
                    this.list.remove((MemoryElementDescriptor)entry.getValue());
                    removed = true;
                }
            }
        } else {
            MemoryElementDescriptor me = (MemoryElementDescriptor)this.map.remove(key);
            if (me != null) {
                this.list.remove(me);
                removed = true;
            }
        }
        return removed;
    }

    public synchronized void removeAll() throws IOException {
        this.map.clear();
        this.list.removeAll();
    }

    protected synchronized MemoryElementDescriptor addFirst(ICacheElement ce) {
        MemoryElementDescriptor me = new MemoryElementDescriptor(ce);
        this.list.addFirst(me);
        this.verifyCache(ce.getKey());
        return me;
    }

    protected synchronized MemoryElementDescriptor addLast(ICacheElement ce) {
        MemoryElementDescriptor me = new MemoryElementDescriptor(ce);
        this.list.addLast(me);
        this.verifyCache(ce.getKey());
        return me;
    }

    public void dumpMap() {
        log.debug((Object)"dumpingMap");
        Iterator itr = this.map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = itr.next();
            MemoryElementDescriptor me = (MemoryElementDescriptor)e.getValue();
            log.debug((Object)("dumpMap> key=" + e.getKey() + ", val=" + me.ce.getVal()));
        }
    }

    public void dumpCacheEntries() {
        log.debug((Object)"dumpingCacheEntries");
        MemoryElementDescriptor me = (MemoryElementDescriptor)this.list.getFirst();
        while (me != null) {
            log.debug((Object)("dumpCacheEntries> key=" + me.ce.getKey() + ", val=" + me.ce.getVal()));
            me = (MemoryElementDescriptor)me.next;
        }
    }

    protected int dumpCacheSize() {
        return this.list.size();
    }

    protected void verifyCache() {
        if (!log.isDebugEnabled()) {
            return;
        }
        boolean found = false;
        log.debug((Object)("verifycache[" + this.cacheName + "]: mapContains " + this.map.size() + " elements, linked list contains " + this.dumpCacheSize() + " elements"));
        log.debug((Object)"verifycache: checking linked list by key ");
        MemoryElementDescriptor li = (MemoryElementDescriptor)this.list.getFirst();
        while (li != null) {
            Serializable key = li.ce.getKey();
            if (!this.map.containsKey(key)) {
                log.error((Object)("verifycache[" + this.cacheName + "]: map does not contain key : " + li.ce.getKey()));
                log.error((Object)("li.hashcode=" + li.ce.getKey().hashCode()));
                log.error((Object)("key class=" + key.getClass()));
                log.error((Object)("key hashcode=" + key.hashCode()));
                log.error((Object)("key toString=" + key.toString()));
                if (key instanceof GroupAttrName) {
                    GroupAttrName name = (GroupAttrName)key;
                    log.error((Object)("GroupID hashcode=" + name.groupId.hashCode()));
                    log.error((Object)("GroupID.class=" + name.groupId.getClass()));
                    log.error((Object)("AttrName hashcode=" + name.attrName.hashCode()));
                    log.error((Object)("AttrName.class=" + name.attrName.getClass()));
                }
                this.dumpMap();
            } else if (this.map.get(li.ce.getKey()) == null) {
                log.error((Object)("verifycache[" + this.cacheName + "]: linked list retrieval returned null for key: " + li.ce.getKey()));
            }
            li = (MemoryElementDescriptor)li.next;
        }
        log.debug((Object)"verifycache: checking linked list by value ");
        MemoryElementDescriptor li3 = (MemoryElementDescriptor)this.list.getFirst();
        while (li3 != null) {
            if (!this.map.containsValue(li3)) {
                log.error((Object)("verifycache[" + this.cacheName + "]: map does not contain value : " + li3));
                this.dumpMap();
            }
            li3 = (MemoryElementDescriptor)li3.next;
        }
        log.debug((Object)"verifycache: checking via keysets!");
        Iterator itr2 = this.map.keySet().iterator();
        while (itr2.hasNext()) {
            found = false;
            Serializable val = null;
            try {
                val = (Serializable)itr2.next();
            }
            catch (NoSuchElementException nse) {
                log.error((Object)"verifycache: no such element exception");
            }
            MemoryElementDescriptor li2 = (MemoryElementDescriptor)this.list.getFirst();
            while (li2 != null) {
                if (val.equals(li2.ce.getKey())) {
                    found = true;
                    break;
                }
                li2 = (MemoryElementDescriptor)li2.next;
            }
            if (found) continue;
            log.error((Object)("verifycache[" + this.cacheName + "]: key not found in list : " + val));
            this.dumpCacheEntries();
            if (this.map.containsKey(val)) {
                log.error((Object)"verifycache: map contains key");
                continue;
            }
            log.error((Object)"verifycache: map does NOT contain key, what the HECK!");
        }
    }

    private void verifyCache(Serializable key) {
        if (!log.isDebugEnabled()) {
            return;
        }
        boolean found = false;
        MemoryElementDescriptor li = (MemoryElementDescriptor)this.list.getFirst();
        while (li != null) {
            if (li.ce.getKey() == key) {
                found = true;
                log.debug((Object)("verifycache(key) key match: " + key));
                break;
            }
            li = (MemoryElementDescriptor)li.next;
        }
        if (!found) {
            log.error((Object)("verifycache(key)[" + this.cacheName + "], couldn't find key! : " + key));
        }
    }

    public Iterator getIterator() {
        return new IteratorWrapper(this.map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getKeyArray() {
        AbstractDoulbeLinkedListMemoryCache abstractDoulbeLinkedListMemoryCache = this;
        synchronized (abstractDoulbeLinkedListMemoryCache) {
            return this.map.keySet().toArray();
        }
    }

    public synchronized IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Memory Cache");
        ArrayList<StatElement> elems = new ArrayList<StatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("List Size");
        se.setData("" + this.list.size());
        elems.add(se);
        se = new StatElement();
        se.setName("Map Size");
        se.setData("" + this.map.size());
        elems.add(se);
        se = new StatElement();
        se.setName("Put Count");
        se.setData("" + this.putCnt);
        elems.add(se);
        se = new StatElement();
        se.setName("Hit Count");
        se.setData("" + this.hitCnt);
        elems.add(se);
        se = new StatElement();
        se.setName("Miss Count");
        se.setData("" + this.missCnt);
        elems.add(se);
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    public class MapEntryWrapper
    implements Map.Entry {
        private final Map.Entry e;

        private MapEntryWrapper(Map.Entry e) {
            this.e = e;
        }

        public boolean equals(Object o) {
            return ((Object)this.e).equals(o);
        }

        public Object getKey() {
            return this.e.getKey();
        }

        public Object getValue() {
            return ((MemoryElementDescriptor)this.e.getValue()).ce;
        }

        public int hashCode() {
            return ((Object)this.e).hashCode();
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException("Use normal cache methods to alter the contents of the cache.");
        }
    }

    public class IteratorWrapper
    implements Iterator {
        private final Iterator i;

        private IteratorWrapper(Map m) {
            this.i = m.entrySet().iterator();
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            return new MapEntryWrapper((Map.Entry)this.i.next());
        }

        public void remove() {
            this.i.remove();
        }

        public boolean equals(Object o) {
            return this.i.equals(o);
        }

        public int hashCode() {
            return this.i.hashCode();
        }
    }
}

