/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.memory;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.group.GroupAttrName;
import org.apache.jcs.engine.control.group.GroupId;
import org.apache.jcs.engine.memory.MemoryCache;
import org.apache.jcs.engine.memory.shrinking.ShrinkerThread;
import org.apache.jcs.engine.memory.util.MemoryElementDescriptor;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStats;

public abstract class AbstractMemoryCache
implements MemoryCache,
Serializable {
    private static final long serialVersionUID = -4494626991630099575L;
    private static final Log log = LogFactory.getLog((Class)AbstractMemoryCache.class);
    protected String cacheName;
    protected Map map;
    public IElementAttributes attr;
    public ICompositeCacheAttributes cattr;
    protected CompositeCache cache;
    protected int status;
    protected int chunkSize;
    private static ClockDaemon shrinkerDaemon;

    public synchronized void initialize(CompositeCache hub) {
        this.cacheName = hub.getCacheName();
        this.cattr = hub.getCacheAttributes();
        this.cache = hub;
        this.map = this.createMap();
        this.chunkSize = this.cattr.getSpoolChunkSize();
        this.status = 1;
        if (this.cattr.getUseMemoryShrinker()) {
            if (shrinkerDaemon == null) {
                shrinkerDaemon = new ClockDaemon();
                shrinkerDaemon.setThreadFactory((ThreadFactory)new MyThreadFactory());
            }
            shrinkerDaemon.executePeriodically(this.cattr.getShrinkerIntervalSeconds() * 1000L, (Runnable)new ShrinkerThread(this), false);
        }
    }

    public abstract Map createMap();

    public abstract boolean remove(Serializable var1) throws IOException;

    public abstract ICacheElement get(Serializable var1) throws IOException;

    public Map getMultiple(Set keys) throws IOException {
        HashMap<Serializable, ICacheElement> elements = new HashMap<Serializable, ICacheElement>();
        if (keys != null && !keys.isEmpty()) {
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                Serializable key = (Serializable)iterator.next();
                ICacheElement element = this.get(key);
                if (element == null) continue;
                elements.put(key, element);
            }
        }
        return elements;
    }

    public ICacheElement getQuiet(Serializable key) throws IOException {
        ICacheElement ce = null;
        MemoryElementDescriptor me = (MemoryElementDescriptor)this.map.get(key);
        if (me != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.cacheName + ": MemoryCache quiet hit for " + key));
            }
            ce = me.ce;
        } else if (log.isDebugEnabled()) {
            log.debug((Object)(this.cacheName + ": MemoryCache quiet miss for " + key));
        }
        return ce;
    }

    public abstract void update(ICacheElement var1) throws IOException;

    public abstract Object[] getKeyArray();

    public void removeAll() throws IOException {
        this.map.clear();
    }

    public void dispose() throws IOException {
        log.info((Object)"Memory Cache dispose called.  Shutting down shrinker thread if it is running.");
        if (shrinkerDaemon != null) {
            shrinkerDaemon.shutDown();
        }
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Abstract Memory Cache");
        return stats;
    }

    public int getSize() {
        return this.map.size();
    }

    public int getStatus() {
        return this.status;
    }

    public String getCacheName() {
        return this.cattr.getCacheName();
    }

    public void waterfal(ICacheElement ce) throws IOException {
        this.cache.spoolToDisk(ce);
    }

    public Iterator getIterator() {
        return this.map.entrySet().iterator();
    }

    public ICompositeCacheAttributes getCacheAttributes() {
        return this.cattr;
    }

    public void setCacheAttributes(ICompositeCacheAttributes cattr) {
        this.cattr = cattr;
    }

    public CompositeCache getCompositeCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getGroupKeys(String groupName) {
        GroupId groupId = new GroupId(this.getCacheName(), groupName);
        HashSet<Object> keys = new HashSet<Object>();
        Map map = this.map;
        synchronized (map) {
            Iterator itr = this.map.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                Object k = entry.getKey();
                if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(groupId)) continue;
                keys.add(((GroupAttrName)k).attrName);
            }
        }
        return keys;
    }

    class MyThreadFactory
    implements ThreadFactory {
        MyThreadFactory() {
        }

        public Thread newThread(Runnable runner) {
            Thread t = new Thread(runner);
            String oldName = t.getName();
            t.setName("JCS-AbstractMemoryCache-" + oldName);
            t.setDaemon(true);
            t.setPriority(1);
            return t;
        }
    }
}

