/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.jdbc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCachePoolAccess;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCachePoolAccessAttributes;

public class JDBCDiskCachePoolAccessFactory {
    private static final Log log = LogFactory.getLog((Class)JDBCDiskCachePoolAccessFactory.class);

    public static JDBCDiskCachePoolAccess createPoolAccess(JDBCDiskCachePoolAccessAttributes poolAttributes) throws Exception {
        return JDBCDiskCachePoolAccessFactory.createPoolAccess(poolAttributes.getDriverClassName(), poolAttributes.getPoolName(), poolAttributes.getUrl() + poolAttributes.getDatabase(), poolAttributes.getUserName(), poolAttributes.getPassword(), poolAttributes.getMaxActive());
    }

    public static JDBCDiskCachePoolAccess createPoolAccess(JDBCDiskCacheAttributes cattr) throws Exception {
        return JDBCDiskCachePoolAccessFactory.createPoolAccess(cattr.getDriverClassName(), cattr.getName(), cattr.getUrl() + cattr.getDatabase(), cattr.getUserName(), cattr.getPassword(), cattr.getMaxActive());
    }

    public static JDBCDiskCachePoolAccess createPoolAccess(String driverClassName, String poolName, String fullURL, String userName, String password, int maxActive) throws Exception {
        JDBCDiskCachePoolAccess poolAccess = null;
        try {
            Class.forName(driverClassName);
        }
        catch (ClassNotFoundException e) {
            log.error((Object)("Couldn't find class for driver [" + driverClassName + "]"), (Throwable)e);
        }
        poolAccess = new JDBCDiskCachePoolAccess(poolName);
        poolAccess.setupDriver(fullURL, userName, password, maxActive);
        poolAccess.logDriverStats();
        if (log.isInfoEnabled()) {
            log.info((Object)("Created: " + poolAccess));
        }
        return poolAccess;
    }
}

