/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.lateral.LateralCacheNoWait;
import org.apache.jcs.auxiliary.lateral.LateralCacheWatchRepairable;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheListener;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheManager;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheObserver;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheService;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.logging.behavior.ICacheEventLogger;

public abstract class LateralCacheAbstractManager
implements ILateralCacheManager {
    private static final long serialVersionUID = -515393179178435508L;
    private static final Log log = LogFactory.getLog((Class)LateralCacheAbstractManager.class);
    protected final Map caches = new HashMap();
    protected ILateralCacheAttributes lca;
    private ILateralCacheService lateralService;
    private LateralCacheWatchRepairable lateralWatch;
    protected ICacheEventLogger cacheEventLogger;
    protected IElementSerializer elementSerializer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLateralCacheListener(String cacheName, ILateralCacheListener listener) throws IOException {
        Map map = this.caches;
        synchronized (map) {
            this.lateralWatch.addCacheListener(cacheName, listener);
        }
    }

    public abstract AuxiliaryCache getCache(String var1);

    public int getCacheType() {
        return 3;
    }

    public String getStats() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixCaches(ILateralCacheService lateralService, ILateralCacheObserver lateralWatch) {
        log.debug((Object)"Fixing lateral caches:");
        Map map = this.caches;
        synchronized (map) {
            this.lateralService = lateralService;
            Iterator en = this.caches.values().iterator();
            while (en.hasNext()) {
                LateralCacheNoWait cache = (LateralCacheNoWait)en.next();
                cache.fixCache(this.lateralService);
            }
        }
    }

    public Map getCaches() {
        return this.caches;
    }
}

