/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.auth.AuthUser;
import com.fe.client.Authenticated;
import com.fe.db.AbstractTeamOrgDB;
import com.fe.db.SchedulerDB;
import com.fe.email.SendMail;
import com.fe.email.TemplateParser;
import com.fe.scheduler.SchedulerAlert;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public abstract class AbstractTeamOrgMgmt
extends Authenticated {
    protected static String ACCESS_PRIVILEGE_RWX = "RWX";
    protected static String ACCESS_PRIVILEGE_RX = "RX";
    protected static String ACCESS_PRIVILEGE_R = "R";
    private Logger log = Logger.getLogger(AbstractTeamOrgMgmt.class);

    public AbstractTeamOrgMgmt() throws Exception {
    }

    public AbstractTeamOrgMgmt(HttpServletRequest httpServletRequest) throws Exception {
        super(httpServletRequest);
    }

    protected Map getThemeAccessData(AbstractTeamOrgDB abstractTeamOrgDB) throws Exception {
        String string;
        AuthUser authUser = this.getAuthenticatedUserObj(abstractTeamOrgDB);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (authUser != null) {
            hashMap.put("rwx_tags", authUser.getRwx());
            hashMap.put("rx_tags", authUser.getRx());
            hashMap.put("r_tags", authUser.getR());
        }
        if ((string = (String)this.getRequest().getSession().getAttribute("session^logged^superuser")) != null && !string.equals("")) {
            hashMap.put("superuser", string);
        }
        return hashMap;
    }

    protected String getAccessPrivilege(int n, AbstractTeamOrgDB abstractTeamOrgDB) throws Exception {
        Object object;
        String string = "";
        AuthUser authUser = this.getAuthenticatedUserObj(abstractTeamOrgDB);
        if (authUser != null) {
            object = abstractTeamOrgDB.getThemeTags(n);
            this.log.debug((Object)("themes:" + object));
            this.log.debug((Object)("user.getRwx():" + authUser.getRwx()));
            this.log.debug((Object)("user.getRx():" + authUser.getRx()));
            this.log.debug((Object)("user.getR():" + authUser.getR()));
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (authUser.getRwx().contains(string2)) {
                    string = ACCESS_PRIVILEGE_RWX;
                }
                if (authUser.getRx().contains(string2) && !string.equals(ACCESS_PRIVILEGE_RWX)) {
                    string = ACCESS_PRIVILEGE_RX;
                }
                if (!authUser.getR().contains(string2) || !string.equals("")) continue;
                string = ACCESS_PRIVILEGE_R;
            }
            if (object.size() == 0) {
                string = ACCESS_PRIVILEGE_RWX;
            }
        }
        this.log.debug((Object)("user:" + authUser));
        this.log.debug((Object)("getAccessPrivilege:rtn:" + string));
        object = (String)this.getRequest().getSession().getAttribute("session^logged^superuser");
        if (object != null && !((String)object).equals("")) {
            string = ACCESS_PRIVILEGE_RWX;
        }
        if (string.equals("")) {
            string = null;
        }
        return string;
    }

    protected ArrayList getNotifications(List list, AbstractTeamOrgDB abstractTeamOrgDB) throws Exception {
        Map map = this.getThemeHirarchy(list, abstractTeamOrgDB);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : map.keySet()) {
            if (map.get(string) == null || !((String)map.get(string)).equalsIgnoreCase("rwx")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    protected boolean isAuthorizedUser(SchedulerDB schedulerDB) throws Exception {
        String string = this.getAuthenticatedUser();
        if (string != null) {
            Map map = schedulerDB.getSVNUser4WikiUser(string);
            return map != null && map.get("svn_username") != null && map.get("svn_password") != null && !((String)map.get("svn_username")).equals("") && !((String)map.get("svn_password")).equals("");
        }
        return false;
    }

    protected String getAuthorizedUser(SchedulerDB schedulerDB) throws Exception {
        String string = this.getAuthenticatedUser();
        this.log.debug((Object)("getAuthorizedUser() user:" + string));
        if (string != null) {
            Map map = schedulerDB.getSVNUser4WikiUser(string);
            if (map != null && map.get("svn_username") != null && map.get("svn_password") != null && !((String)map.get("svn_username")).equals("") && !((String)map.get("svn_password")).equals("")) {
                return (String)map.get("svn_username");
            }
            return null;
        }
        return null;
    }

    protected Map getItemTags2(int n, AbstractTeamOrgDB abstractTeamOrgDB) throws Exception {
        ArrayList arrayList;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Vector vector = abstractTeamOrgDB.getTagIds4Item(n);
        Vector vector2 = abstractTeamOrgDB.getTags();
        Vector vector3 = abstractTeamOrgDB.getFollowTagIds4Item(n);
        ArrayList arrayList2 = abstractTeamOrgDB.getThemeNames4Item(n);
        Map map = this.getThemeHirarchy(arrayList2, abstractTeamOrgDB);
        if (map.get("theme") != null) {
            map.remove("theme");
        }
        ArrayList arrayList3 = (arrayList = abstractTeamOrgDB.getFollowTags4Item(n)).size() > 0 ? this.getNotifications(arrayList, abstractTeamOrgDB) : new ArrayList();
        ArrayList<String> arrayList4 = new ArrayList<String>(arrayList);
        arrayList4.addAll(arrayList2);
        hashMap.put("tagids", vector);
        hashMap.put("user_privileges", map);
        hashMap.put("user_notifications", arrayList3);
        hashMap.put("follow_tagids", vector3);
        hashMap.put("notice_escalated", this.getThemeHirarchy(arrayList4, abstractTeamOrgDB));
        hashMap.put("tags", vector2);
        hashMap.putAll(map);
        return hashMap;
    }

    protected void updateAllItemTags(int n, List list, List list2, AbstractTeamOrgDB abstractTeamOrgDB, SchedulerDB schedulerDB, String string, String string2, long l, String string3, Map map, String string4) throws Exception {
        Object object2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Object object2 : list) {
            arrayList.add(Integer.parseInt((String)object2));
        }
        abstractTeamOrgDB.updateItemTagIds(n, arrayList);
        Object object3 = null;
        if (arrayList.size() > 0) {
            object3 = abstractTeamOrgDB.getThemeTagName(arrayList.get(0));
        }
        object2 = new ArrayList();
        for (String string5 : list2) {
            ((ArrayList)object2).add(Integer.parseInt(string5));
        }
        abstractTeamOrgDB.updateFollwerTagIds(n, (List<Integer>)object2);
        this.notifyLastModification(abstractTeamOrgDB, schedulerDB, string, n, string2, l, string3, map, (String)object3, string4);
    }

    private void notifyLastModification(AbstractTeamOrgDB abstractTeamOrgDB, SchedulerDB schedulerDB, String string, int n, String string2, long l, String string3, Map map, String string4, String string5) throws Exception {
        String string6;
        String string72;
        String string8 = this.getAuthorizedUser(schedulerDB);
        ArrayList arrayList = abstractTeamOrgDB.getFollowTags4Item(n);
        if (string4 != null) {
            if (arrayList.contains(string4)) {
                arrayList.remove(string4);
            }
            arrayList.add(0, string4);
        }
        ArrayList arrayList2 = abstractTeamOrgDB.getThemeNames4Item(n);
        for (String string72 : arrayList2) {
            if (arrayList.contains(string72)) continue;
            arrayList.add(string72);
        }
        String string9 = string8 + "@4ecap.com";
        string72 = "";
        InputStream inputStream = SendMail.class.getResourceAsStream(string5);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string6 = bufferedReader.readLine()) != null) {
            string72 = string72 + (string72.equals("") ? string6 : "\n" + string6);
        }
        bufferedReader.close();
        inputStream.close();
        TemplateParser templateParser = new TemplateParser(string72, map);
        String string10 = templateParser.parseTemplate();
        String string11 = templateParser.getSubject();
        try {
            SchedulerAlert.alert(arrayList, "email", string11, string10, null, string9);
        }
        catch (Exception exception) {
            this.log.error((Object)("Couldn't send scheduler update notification to themes " + arrayList + " the followings are error:"));
            exception.printStackTrace();
        }
    }

    protected Map getItemPrivilegeNotifications(ArrayList arrayList, ArrayList arrayList2, AbstractTeamOrgDB abstractTeamOrgDB) throws Exception {
        Map map = this.getThemeHirarchy(arrayList, abstractTeamOrgDB);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        ArrayList<String> arrayList3 = new ArrayList<String>(arrayList2);
        arrayList3.addAll(arrayList);
        ArrayList arrayList4 = this.getNotifications(arrayList3, abstractTeamOrgDB);
        hashMap.put("user_notifications", arrayList4);
        hashMap.put("user_privileges", map);
        hashMap.put("notice_escalated", this.getThemeHirarchy(arrayList3, abstractTeamOrgDB));
        return hashMap;
    }
}

