/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.client.BBSyncMgmt;
import com.fe.db.SchedulerDB;
import com.fe.db.SuperDB;
import com.fe.scheduler.balance.LoadBalancingQueue;
import com.fe.scheduler.balance.executeR.LoadBalancingExecuteRQueue;
import com.fe.scheduler.rscript.RScript;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.jcs.JCS;
import org.apache.log4j.Logger;
import org.directwebremoting.WebContextFactory;

public class ExecuteRMgmt {
    private Logger log = Logger.getLogger(ExecuteRMgmt.class);
    private HttpServletRequest request = null;
    private static Semaphore refreshLock = new Semaphore(1, true);
    private static final long TIMEOUT_MS = 1000L;

    private void acquireLock() {
        try {
            refreshLock.tryAcquire(1000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
    }

    private void releaseLock() {
        try {
            refreshLock.release();
        }
        catch (Exception exception) {
            this.log.error((Object)("Error:" + exception.getMessage()));
        }
    }

    public ExecuteRMgmt() throws Exception {
    }

    public ExecuteRMgmt(HttpServletRequest httpServletRequest) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getQueue() throws Exception {
        this.acquireLock();
        try {
            Object object;
            Object object22;
            Object object3;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ArrayList<RScript> arrayList = new ArrayList<RScript>();
            LoadBalancingQueue loadBalancingQueue = LoadBalancingQueue.getExecuteRScriptDefault();
            Collection<RScript> collection = loadBalancingQueue.getScriptQueue();
            Collection<RScript> collection2 = loadBalancingQueue.getScriptProcessingQueue();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (RScript rScript : collection2) {
                arrayList2.add(rScript.getUid());
            }
            arrayList.addAll(collection2);
            arrayList.addAll(collection);
            JCS jCS = loadBalancingQueue.getGroupedCache();
            int n = 0;
            long l = 0L;
            for (Object e : jCS.getGroupKeys(LoadBalancingQueue.CACHE_GROUP_FINISHED)) {
                object3 = (Long)jCS.getFromGroup(e, LoadBalancingQueue.CACHE_GROUP_FINISHED);
                if (object3 == null) continue;
                l += ((Long)object3).longValue();
                ++n;
            }
            this.log.debug((Object)("totaldelay:" + l + " counter:" + n));
            long l2 = n > 0 && l > 0L ? l / (long)n / 1000L : 0L;
            for (Object object22 : jCS.getGroupKeys(LoadBalancingQueue.CACHE_GROUP_TIMEOUT)) {
                jCS.getFromGroup(object22, LoadBalancingQueue.CACHE_GROUP_TIMEOUT);
            }
            object3 = jCS.getGroupKeys(LoadBalancingQueue.CACHE_GROUP_FINISHED);
            object22 = jCS.getGroupKeys(LoadBalancingQueue.CACHE_GROUP_TIMEOUT);
            Set set = jCS.getGroupKeys(LoadBalancingQueue.CACHE_GROUP_ACTIVEPEERS);
            Map map = null;
            if (this.getRequest() != null && this.getRequest().getSession() != null && this.getRequest().getSession().getAttribute("peer_data") != null) {
                map = (Map)this.getRequest().getSession().getAttribute("peer_data");
            } else {
                object = SchedulerDB.getSchedulerDB();
                try {
                    ((SuperDB)object).connectDB(BBSyncMgmt.getDBName());
                    Vector vector = ((SchedulerDB)object).getPeersData();
                    map = new HashMap();
                    for (Map map2 : vector) {
                        String string = map2.get("friendlyname") != null && ((String)map2.get("friendlyname")).equals("") ? (String)map2.get("friendlyname") : (String)map2.get("peername");
                        map.put(map2.get("peername"), map2.get("friendlyname"));
                    }
                    if (this.getRequest() != null) {
                        this.getRequest().getSession().setAttribute("peer_data", map);
                    }
                }
                catch (Exception exception) {
                    this.log.error((Object)("Error:" + exception.getMessage()));
                }
                finally {
                    ((SuperDB)object).closeDB();
                }
            }
            hashMap.put("queue", arrayList);
            hashMap.put("ave_delay", l2 > 0L ? l2 : 0L);
            hashMap.put("queued_count", collection.size());
            hashMap.put("executing", arrayList2);
            hashMap.put("executing_count", collection2.size());
            hashMap.put("active_peers", set.size());
            hashMap.put("finished", object3);
            hashMap.put("timedout", object22);
            hashMap.put("peernames", map);
            object = hashMap;
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            this.releaseLock();
        }
    }

    public void removeFromAllQueue(String string) throws Exception {
        try {
            RScript rScript = new RScript();
            rScript.setUid(string);
            LoadBalancingQueue loadBalancingQueue = LoadBalancingQueue.getExecuteRScriptDefault();
            loadBalancingQueue.removeScriptFromAllQueue(rScript);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getQueueXML() throws Exception {
        Map map = this.getQueue();
        String string = "<result>";
        for (String string2 : map.keySet()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("ave_delay");
            arrayList.add("queued_count");
            arrayList.add("executing_count");
            arrayList.add("active_peers");
            arrayList.add("finished");
            arrayList.add("timedout");
            if (!arrayList.contains(string2)) continue;
            String string3 = map.get(string2) + "";
            if (map.get(string2) instanceof Collection) {
                string3 = ((Collection)map.get(string2)).size() + "";
            }
            string = string + "<" + string2.toLowerCase() + ">" + string3 + "</" + string2.toLowerCase() + ">";
        }
        string = string + "</result>";
        return string;
    }

    public Map test_queueDebug() throws Exception {
        LoadBalancingExecuteRQueue loadBalancingExecuteRQueue = (LoadBalancingExecuteRQueue)LoadBalancingQueue.getExecuteRScriptDefault();
        return loadBalancingExecuteRQueue.debug_data();
    }

    private HttpServletRequest getRequest() throws Exception {
        return this.request == null && WebContextFactory.get() != null ? WebContextFactory.get().getHttpServletRequest() : this.request;
    }
}

