/*
 * Decompiled with CFR 0.152.
 */
package com.fe.client;

import com.fe.Config;
import com.fe.client.AdminMgmt;
import com.fe.client.ClientErrorMgmt;
import com.fe.client.ReferenceMgmt;
import com.fe.client.SecuritiesMgmt;
import com.fe.client.StrategyMgmt;
import com.fe.connectbl.ConnectBloomberg;
import com.fe.connectbl.SyncManager;
import com.fe.data.Contract;
import com.fe.db.ContractDB;
import com.fe.db.ReferenceDB;
import com.fe.db.SuperDB;
import com.fe.db.UtilDB;
import com.fe.db.mysql.MySQLDateQueryGen;
import com.fe.lucene.LuceneCrawler;
import com.fe.lucene.MyIndexer;
import com.fe.lucene.SearchSession;
import com.fe.migrate.current.CurrentData;
import com.fe.migrate.current.CurrentFundamentalData;
import com.fe.migrate.current.CurrentMarketData;
import com.fe.migrate.current.CurrentStrgyContractData;
import com.fe.migrate.historical.HistoricalData;
import com.fe.migrate.historical.HistoricalFundamentalData;
import com.fe.migrate.historical.HistoricalMarketData;
import com.fe.migrate.historical.HistoricalModelData;
import com.fe.migrate.historical.HistoricalStrgyAllocationData;
import com.fe.migrate.historical.HistoricalStrgyContractData;
import com.fe.migrate.historical.HistoricalStrgyIndicatorData;
import com.fe.util.InputStringTokenParser;
import com.fe.util.PasswordService;
import com.fe.util.SVNInfo;
import com.fe.xml.XMLCommodity;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.directwebremoting.WebContextFactory;
import org.tmatesoft.svn.core.SVNLogEntry;

public class MigrationMgmt {
    private Logger log = Logger.getLogger(MigrationMgmt.class);
    private HttpServletRequest request = null;
    private String ACTIVE_TAB_ATTRIBUTE = "$$$ActiveTab";
    private String clientMessage = "$$$ClientMessage";
    private String currentSecNavigationAttrib = "$$$curSecNa";

    public boolean importMarketHistoryData(boolean bl) throws Exception {
        boolean bl2 = !bl;
        HistoricalMarketData historicalMarketData = new HistoricalMarketData(this);
        try {
            if (historicalMarketData.getFiles().length <= 0) {
                throw new Exception("Importing historical data failed. No source files found!");
            }
            this.setMessageClientServe("Processing...");
            historicalMarketData.startProcess(bl2);
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "ignoreDupCheck:" + bl);
            throw exception;
        }
    }

    public String getMessageFromServe() throws Exception {
        try {
            String string = null;
            if (this.getRequest() != null) {
                string = (String)this.getRequest().getSession().getAttribute(this.clientMessage);
            }
            return string == null ? "" : string;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "");
            throw exception;
        }
    }

    public void setMessageClientServe(String string) throws Exception {
        if (this.getRequest() != null) {
            this.getRequest().getSession().setAttribute(this.clientMessage, (Object)string);
        }
    }

    public boolean importStrategyHistoryData(boolean bl) throws Exception {
        boolean bl2 = !bl;
        HistoricalStrgyContractData historicalStrgyContractData = new HistoricalStrgyContractData(this);
        try {
            this.setMessageClientServe("Processing...");
            if (historicalStrgyContractData.getFiles().length <= 0) {
                throw new Exception("Importing historical data failed. No source files found!");
            }
            this.setMessageClientServe("Processing...");
            historicalStrgyContractData.startProcess(bl2);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ClientErrorMgmt.reportError(exception, "ignoreDupCheck:" + bl);
            throw exception;
        }
    }

    public boolean importFundamentalHistoryData(boolean bl) throws Exception {
        boolean bl2 = !bl;
        HistoricalFundamentalData historicalFundamentalData = new HistoricalFundamentalData(this);
        try {
            this.setMessageClientServe("Processing...");
            if (historicalFundamentalData.getFiles().length <= 0) {
                throw new Exception("Importing historical data failed. No source files found!");
            }
            this.setMessageClientServe("Processing...");
            historicalFundamentalData.startProcess(bl2);
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "ignoreDupCheck:" + bl);
            throw exception;
        }
    }

    public boolean importMarketCurrentData() throws Exception {
        CurrentMarketData currentMarketData = new CurrentMarketData(this);
        try {
            if (currentMarketData.getFiles().length <= 0) {
                throw new Exception("Importing Current data failed. No source files found!");
            }
            currentMarketData.startProcess();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ClientErrorMgmt.reportError(exception, "");
            throw exception;
        }
    }

    public boolean importStrategyCurrentData() throws Exception {
        CurrentStrgyContractData currentStrgyContractData = new CurrentStrgyContractData(this);
        try {
            if (currentStrgyContractData.getFiles().length <= 0) {
                throw new Exception("Importing Current data failed. No source files found!");
            }
            currentStrgyContractData.startProcess();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public boolean importFundamentalCurrentData() throws Exception {
        this.log.debug((Object)"importFundamentalCurrentData() called");
        CurrentFundamentalData currentFundamentalData = new CurrentFundamentalData(this);
        try {
            if (currentFundamentalData.getFiles().length <= 0) {
                throw new Exception("Importing Current data failed. No source files found!");
            }
            currentFundamentalData.startProcess();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public Map getUniqueFields4All() throws Exception {
        TreeMap<String, Map> treeMap = new TreeMap<String, Map>();
        treeMap.put("securitiesuniquecomm", new SecuritiesMgmt().getUniqueSecuriteisFields());
        treeMap.put("marketuniquecomm", this.getUniqueMarketFields());
        treeMap.put("strategyuniquecomm", this.getUniqueStrategyFields(new HistoricalStrgyContractData(this).getDB()));
        treeMap.put("fundamentalyuniquecomm", this.getUniqueFundamentalFields());
        treeMap.put("strategy_a_uniquecomm", this.getUniqueStrategyFields(new HistoricalStrgyAllocationData(this).getDB()));
        treeMap.put("strategy_i_uniquecomm", this.getUniqueStrategyFields(new HistoricalStrgyIndicatorData(this).getDB()));
        treeMap.put("model_uniquecomm", this.getUniqueStrategyFields(new HistoricalModelData(this).getDB()));
        return treeMap;
    }

    private String addNavigationalData(String string, Map map, String string2, int n) throws Exception {
        String string3 = this.currentSecNavigationAttrib + n;
        Map map2 = this.getTables1Navigation(string2);
        map2.put("[All]", "");
        map.put(string + "_navi", map2);
        String string4 = (String)this.getRequest().getSession().getAttribute(string3);
        if (string4 == null && map2.size() > 0) {
            string4 = (String)map2.values().iterator().next();
            map.put(string + "_navi_def", string4);
        }
        if (this.getRequest().getSession().getAttribute(string3) != null) {
            map.put(string + "_navi_def", this.getRequest().getSession().getAttribute(string3));
        }
        return string4;
    }

    private Map getSecurityDescription() throws Exception {
        try {
            ReferenceDB referenceDB = ReferenceDB.getReferenceDB();
            referenceDB.connectDB(ReferenceMgmt.getDBName());
            Map map = referenceDB.getAllSecFieldValues("Name");
            referenceDB.closeDB();
            return map;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    private Map getUniqueStrategyFields(String string) throws Exception {
        UtilDB utilDB = new SuperDB().getUtilDB(string);
        utilDB.connectDB(string);
        List list = utilDB.listAllUniqueFields(utilDB.connection());
        utilDB.closeDB();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("data", list);
        treeMap.put("db", string);
        return treeMap;
    }

    private Map getUniqueFundamentalFields() throws Exception {
        UtilDB utilDB = new SuperDB().getUtilDB(new HistoricalFundamentalData(this).getDB());
        utilDB.connectDB(new HistoricalFundamentalData(this).getDB());
        List list = utilDB.listAllUniqueFields(utilDB.connection());
        utilDB.closeDB();
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("data", list);
        treeMap.put("db", new HistoricalFundamentalData(this).getDB());
        return treeMap;
    }

    private List getStrategyUniqueFields(String string) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(string);
            utilDB.connectDB(string);
            List list = utilDB.uniqueFields(utilDB.connection());
            utilDB.closeDB();
            return list;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    private List getTables1(String string) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(string);
            utilDB.connectDB(string);
            List list = utilDB.listCommodities(utilDB.connection());
            utilDB.closeDB();
            return list;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "db:" + string);
            throw exception;
        }
    }

    private List getTablesWithFilter(String string, String string2) throws Exception {
        try {
            List list;
            UtilDB utilDB = new SuperDB().getUtilDB(string);
            utilDB.connectDB(string);
            if (string2 != null && !string2.equals("")) {
                String string3 = "";
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreElements()) {
                    String string4 = stringTokenizer.nextToken();
                    string3 = string3 + (string3.equals("") ? "'" + string4 + "'" : ",'" + string4 + "'");
                }
                list = utilDB.listCommoditiesWithFilter(utilDB.connection(), string3);
            } else {
                list = utilDB.listCommodities(utilDB.connection());
            }
            utilDB.closeDB();
            return list;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "db:" + string);
            throw exception;
        }
    }

    private Map getTables1Navigation(String string) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(string);
            utilDB.connectDB(string);
            List list = utilDB.listCommoditiesFirstLetters(utilDB.connection());
            utilDB.closeDB();
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            if (list.size() >= 10) {
                int n = list.size() / 10;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string2 = "";
                    String string3 = null;
                    String string4 = null;
                    for (int i = 0; i < n; ++i) {
                        if (!iterator.hasNext()) continue;
                        String string5 = (String)iterator.next();
                        string2 = string2 + (string2.equals("") ? string5 : "," + string5);
                        if (i == 0) {
                            string4 = string5;
                        }
                        string3 = string5;
                    }
                    String string6 = string4.equals(string3) ? string4 : string4 + "-" + string3;
                    treeMap.put(string6, string2);
                }
            } else {
                for (String string7 : list) {
                    treeMap.put(string7, string7);
                }
            }
            return treeMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "db:" + string);
            throw exception;
        }
    }

    public List getFieldTables(String string) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(new HistoricalMarketData(this).getDB());
            utilDB.connectDB(new HistoricalMarketData(this).getDB());
            List list = utilDB.listFieldTables(utilDB.connection(), string);
            utilDB.closeDB();
            return list;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "mtable:" + string);
            throw exception;
        }
    }

    public Map getUniqueMarketFields() throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(new HistoricalMarketData(this).getDB());
            utilDB.connectDB(new HistoricalMarketData(this).getDB());
            List list = utilDB.listAllUniqueFields(utilDB.connection());
            utilDB.closeDB();
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            treeMap.put("data", list);
            treeMap.put("db", new HistoricalMarketData(this).getDB());
            return treeMap;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
            throw exception;
        }
    }

    public List getStrategyFieldTables(String string) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(new HistoricalStrgyContractData(this).getDB());
            utilDB.connectDB(new HistoricalStrgyContractData(this).getDB());
            List list = utilDB.listFieldTables(utilDB.connection(), string);
            utilDB.closeDB();
            return list;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "mtable:" + string);
            throw exception;
        }
    }

    public List getFundamentalFieldTables(String string) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(new HistoricalFundamentalData(this).getDB());
            utilDB.connectDB(new HistoricalFundamentalData(this).getDB());
            List list = utilDB.listFieldTables(utilDB.connection(), string);
            utilDB.closeDB();
            return list;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "mtable:" + string);
            throw exception;
        }
    }

    public String generateMarketContracts(String string, boolean bl, String string2, Vector vector, String string3) throws Exception {
        try {
            if (bl) {
                return this.generateAllContracts(new HistoricalMarketData(this).getDB(), string, string2, vector, string3);
            }
            return this.generateContracts(new HistoricalMarketData(this).getDB(), string);
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "fieldtable:" + string + ",allCommoditiesSelected:" + bl + ",dateQuery:" + string2 + ",commodities:" + vector + ",commString:" + string3);
            throw exception;
        }
    }

    public String generateStrategyContracts(String string, boolean bl, String string2, Vector vector, String string3) throws Exception {
        try {
            if (bl) {
                return this.generateAllContracts(new HistoricalStrgyContractData(this).getDB(), string, string2, vector, string3);
            }
            return this.generateContracts(new HistoricalStrgyContractData(this).getDB(), string);
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "fieldtable:" + string + ",allCommoditiesSelected:" + bl + ",dateQuery:" + string2 + ",commodities:" + vector + ",commString:" + string3);
            throw exception;
        }
    }

    public String generateFundamentalContracts(String string, boolean bl, String string2, Vector vector, String string3) throws Exception {
        try {
            if (bl) {
                return this.generateAllContracts(new HistoricalFundamentalData(this).getDB(), string, string2, vector, string3);
            }
            return this.generateContracts(new HistoricalFundamentalData(this).getDB(), string);
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "fieldtable:" + string + ",allCommoditiesSelected:" + bl + ",dateQuery:" + string2 + ",commodities:" + vector + ",commString:" + string3);
            throw exception;
        }
    }

    protected String generateContracts(String string, String string2) throws Exception {
        ContractDB contractDB = new SuperDB().getContractDB(string2, string);
        contractDB.connectDB(string);
        List list = contractDB.getContractTitles(contractDB.connection());
        contractDB.closeDB();
        String string3 = "";
        for (String string4 : list) {
            string3 = string3 + (!string3.equals("") ? "\r\n" : "") + string4;
        }
        return string3;
    }

    protected String generateAllContracts(String string, String string2, String string3, Vector vector, String string4) throws Exception {
        String string52;
        UtilDB utilDB = new SuperDB().getUtilDB(string);
        utilDB.connectDB(string);
        if (utilDB.isMySQLDriver()) {
            string3 = MySQLDateQueryGen.convertFromSQL(string3);
            this.log.debug((Object)("datequery:" + string3));
        }
        Vector vector2 = new InputStringTokenParser(string4).parseFreeTextTokensLowerCase();
        vector.addAll(vector2);
        this.log.debug((Object)("db:" + string));
        List<String> list = utilDB.listAllTables4Commodities(utilDB.connection(), string2, vector);
        this.log.debug((Object)("commtables:" + list));
        int n = 0;
        String string6 = "";
        for (String string52 : list) {
            if (n > 0) {
                string6 = string6 + "\n UNION ALL ";
            }
            string6 = string6 + " select *,'" + string52 + "' as tbl_name FROM " + string52 + (string3 != null && !string3.equals("") ? "  WHERE " + string3 + " " : "");
            ++n;
        }
        this.log.debug((Object)("jointables:" + string6));
        if (string6 != null && string6.equals("")) {
            throw new Exception("Data found for this commodity/security and field combination");
        }
        TreeMap<String, Vector> treeMap = utilDB.listAllContractTitles(utilDB.connection(), string6);
        this.log.debug((Object)("contracts:" + treeMap));
        utilDB.closeDB();
        utilDB.closeDB();
        string52 = "";
        for (String string7 : list) {
            Vector vector3 = (Vector)treeMap.get(string7);
            if (vector3 == null) continue;
            for (String string8 : vector3) {
                string52 = string52 + (!string52.equals("") ? "\r\n" : "") + string8;
            }
        }
        return string52;
    }

    public List removeFieldTable(String string, String string2) throws Exception {
        UtilDB utilDB = new SuperDB().getUtilDB(new HistoricalMarketData(this).getDB());
        utilDB.connectDB(new HistoricalMarketData(this).getDB());
        List list = null;
        if (!utilDB.removeFieldTable(utilDB.connection(), string)) {
            throw new Exception("Couldn't delete the field");
        }
        list = utilDB.listFieldTables4Admin(utilDB.connection(), string2);
        return list;
    }

    public List removeFieldTableStrategy(String string, String string2) throws Exception {
        UtilDB utilDB = new SuperDB().getUtilDB(new HistoricalStrgyContractData(this).getDB());
        utilDB.connectDB(new HistoricalStrgyContractData(this).getDB());
        List list = null;
        if (!utilDB.removeFieldTable(utilDB.connection(), string)) {
            throw new Exception("Couldn't delete the field");
        }
        list = utilDB.listFieldTables4Admin(utilDB.connection(), string2);
        return list;
    }

    public List removeFieldTableFundamental(String string, String string2) throws Exception {
        UtilDB utilDB = new SuperDB().getUtilDB(new HistoricalFundamentalData(this).getDB());
        utilDB.connectDB(new HistoricalFundamentalData(this).getDB());
        List list = null;
        if (!utilDB.removeFieldTable(utilDB.connection(), string)) {
            throw new Exception("Couldn't delete the field");
        }
        list = utilDB.listFieldTables4Admin(utilDB.connection(), string2);
        return list;
    }

    public List getFields4Admin(String string) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(new HistoricalMarketData(this).getDB());
            utilDB.connectDB(new HistoricalMarketData(this).getDB());
            List list = utilDB.listFieldTables4Admin(utilDB.connection(), string);
            utilDB.closeDB();
            return list;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "mtable" + string);
            throw exception;
        }
    }

    public List getFields4AdminStrategy(String string) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(new HistoricalStrgyContractData(this).getDB());
            utilDB.connectDB(new HistoricalStrgyContractData(this).getDB());
            List list = utilDB.listFieldTables4Admin(utilDB.connection(), string);
            utilDB.closeDB();
            return list;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "mtable" + string);
            throw exception;
        }
    }

    public List getFields4AdminFundamental(String string) throws Exception {
        try {
            UtilDB utilDB = new SuperDB().getUtilDB(new HistoricalFundamentalData(this).getDB());
            utilDB.connectDB(new HistoricalFundamentalData(this).getDB());
            List list = utilDB.listFieldTables4Admin(utilDB.connection(), string);
            utilDB.closeDB();
            return list;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "mtable" + string);
            throw exception;
        }
    }

    protected Map getCurrentFiles(String string) throws Exception {
        File[] fileArray = CurrentData.getFiles(string);
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        if (fileArray != null) {
            Vector<String> vector = new Vector<String>();
            Date date = null;
            for (int i = 0; i < fileArray.length; ++i) {
                vector.add(fileArray[i].getName());
                if (date != null && date.before(new Date(fileArray[i].lastModified()))) {
                    date = new Date(fileArray[i].lastModified());
                    continue;
                }
                if (date != null) continue;
                date = new Date(fileArray[i].lastModified());
            }
            treeMap.put("sourcefolder", string);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
            if (fileArray.length > 0) {
                String string2 = simpleDateFormat.format(date);
                if (simpleDateFormat.format(date).equals(simpleDateFormat.format(new Date()))) {
                    string2 = string2 + " (Today)";
                }
                treeMap.put("recentdate", string2);
                treeMap.put("filescount", fileArray.length);
            }
        } else {
            treeMap.put("sourcefolder", "Folder:" + string + " not found");
        }
        return treeMap;
    }

    private Map getMarketFiles() throws Exception {
        TreeMap<String, Map> treeMap = new TreeMap<String, Map>();
        treeMap.put("history", this.getHistoricalFiles(new HistoricalMarketData(this).getFolder()));
        treeMap.put("current", this.getCurrentFiles(new CurrentMarketData(this).getFolder()));
        return treeMap;
    }

    private Map getStrategyFiles(String string, String string2) throws Exception {
        TreeMap<String, Map> treeMap = new TreeMap<String, Map>();
        treeMap.put("history", this.getHistoricalFiles(string));
        treeMap.put("current", this.getCurrentFiles(string2));
        return treeMap;
    }

    private Map getFundamentalFiles() throws Exception {
        TreeMap<String, Map> treeMap = new TreeMap<String, Map>();
        treeMap.put("history", this.getHistoricalFiles(new HistoricalFundamentalData(this).getFolder()));
        treeMap.put("current", this.getCurrentFiles(new CurrentFundamentalData(this).getFolder()));
        return treeMap;
    }

    protected Map getHistoricalFiles(String string) throws Exception {
        File[] fileArray = HistoricalData.getFiles(string);
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        if (fileArray != null) {
            Vector<String> vector = new Vector<String>();
            Date date = null;
            for (int i = 0; i < fileArray.length; ++i) {
                vector.add(fileArray[i].getName());
                if (date != null && date.before(new Date(fileArray[i].lastModified()))) {
                    date = new Date(fileArray[i].lastModified());
                    continue;
                }
                if (date != null) continue;
                date = new Date(fileArray[i].lastModified());
            }
            treeMap.put("sourcefolder", string);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
            if (fileArray.length > 0) {
                String string2 = simpleDateFormat.format(date);
                if (simpleDateFormat.format(date).equals(simpleDateFormat.format(new Date()))) {
                    string2 = string2 + " (Today)";
                }
                treeMap.put("recentdate", string2);
                treeMap.put("filescount", fileArray.length);
            }
        } else {
            treeMap.put("sourcefolder", "Folder:" + string + " not found");
        }
        return treeMap;
    }

    public boolean synchronize(int n) throws Exception {
        try {
            String string = Config.getString("xls_mkt_bloomberg_mapping");
            String string2 = new HistoricalMarketData(this).getDB();
            SyncManager syncManager = new SyncManager(n, this, string, string2);
            syncManager.start();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, " lastndays:" + n);
            throw exception;
        }
    }

    public boolean synchronizeXML(int n, String string) throws Exception {
        try {
            String string2 = new File(Config.getString("xls_mkt_bloomberg_mapping")).getParent() + File.separator + string;
            File file = new File(string2);
            if (!file.exists()) {
                throw new Exception("XML file does not exist");
            }
            String string3 = Config.getString("xls_mkt_bloomberg_mapping");
            String string4 = new HistoricalMarketData(this).getDB();
            SyncManager syncManager = new SyncManager(n, this, string3, string4);
            syncManager.setFilename(string);
            syncManager.setUpdatesyncdate(false);
            syncManager.start();
            return true;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, " lastndays:" + n + " filename:" + string);
            throw exception;
        }
    }

    public Map getBloombergLive(String string, String string2, String string3, String string4, String string5, String string6, int n, int n2) throws Exception {
        try {
            Object object;
            Cloneable cloneable;
            Cloneable cloneable2;
            Object object2;
            Object object3;
            if (string != null && !string.equals("")) {
                object3 = new StringTokenizer(string, ",");
                if (((StringTokenizer)object3).countTokens() != 2) {
                    throw new Exception("Invalid syntax on Date Range, inputted query:" + string);
                }
                object2 = ((StringTokenizer)object3).nextToken();
                int n3 = Integer.parseInt(((StringTokenizer)object3).nextToken());
                cloneable2 = Calendar.getInstance();
                ((Calendar)cloneable2).setTime(new Date());
                if (((String)object2).equalsIgnoreCase("ndays")) {
                    ((Calendar)cloneable2).add(5, -n3);
                }
                if (((String)object2).equalsIgnoreCase("nweeks")) {
                    ((Calendar)cloneable2).add(5, -(n3 * 7));
                }
                if (((String)object2).equalsIgnoreCase("nmonths")) {
                    ((Calendar)cloneable2).add(2, -n3);
                }
                if (((String)object2).equalsIgnoreCase("nyears")) {
                    ((Calendar)cloneable2).add(1, -n3);
                }
                cloneable = new SimpleDateFormat("yyyyMMdd");
                string2 = ((DateFormat)cloneable).format(((Calendar)cloneable2).getTime());
                string3 = ((DateFormat)cloneable).format(new Date());
            }
            object3 = new XMLCommodity();
            ((XMLCommodity)object3).setContracts(string4);
            object2 = ((XMLCommodity)object3).getContractsAsList();
            ConnectBloomberg connectBloomberg = null;
            if (n == 0) {
                this.setMessageClientServe("Connecting Bloomberg Server...");
                connectBloomberg = new ConnectBloomberg((List)object2, string2, string3, string6, string5, this);
            } else {
                connectBloomberg = new ConnectBloomberg(string6, string2, string3, (List)object2, string5, this);
            }
            cloneable2 = new Vector();
            cloneable2 = connectBloomberg.getData();
            cloneable = new Vector();
            ((Vector)cloneable).addAll(connectBloomberg.getUniqueDates());
            double[] dArray = new double[object2.size()];
            TreeMap<Date, Object> treeMap = new TreeMap<Date, Object>();
            Vector<String> vector = new Vector<String>();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy");
            for (int i = 0; i < ((Vector)cloneable).size(); ++i) {
                object = (Date)((Vector)cloneable).get(i);
                treeMap.put((Date)object, dArray.clone());
                vector.add(simpleDateFormat.format((Date)object));
            }
            this.setMessageClientServe("Processing generating output");
            Object object4 = ((Vector)cloneable2).iterator();
            while (object4.hasNext()) {
                int n4;
                object = (Contract)object4.next();
                double[] dArray2 = (double[])treeMap.get(((Contract)object).getCdate());
                if (dArray2.length <= (n4 = object2.indexOf(((Contract)object).getName()))) continue;
                dArray2[n4] = ((Contract)object).getValue();
            }
            object4 = new TreeMap();
            if (n2 == 1) {
                object = this.generateXLFile(vector, (List)object2, treeMap.values());
                ((TreeMap)object4).put("xlid", object);
            } else {
                ((TreeMap)object4).put("row", vector);
                ((TreeMap)object4).put("col", object2);
                ((TreeMap)object4).put("data", treeMap.values());
            }
            return object4;
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "daterange:" + string + ",datefrom:" + string2 + ",dateto:" + string3 + ",securities:" + string4 + ",sector:" + string5 + ",field:" + string6 + ",mode:" + n + ",outputto:" + n2);
            throw exception;
        }
    }

    private String generateXLFile(Vector vector, List list, Collection collection) throws Exception {
        Object object;
        HSSFCell hSSFCell;
        int n;
        HSSFWorkbook hSSFWorkbook = new HSSFWorkbook();
        HSSFSheet hSSFSheet = hSSFWorkbook.createSheet("worksheet1");
        HSSFRow hSSFRow = hSSFSheet.createRow(0);
        for (n = 0; n < list.size(); ++n) {
            hSSFCell = hSSFRow.createCell((short)(n + 1));
            hSSFCell.setCellValue((String)list.get(n));
        }
        n = 1;
        hSSFCell = new Vector();
        hSSFCell.addAll(collection);
        for (int i = hSSFCell.size() - 1; i >= 0; --i) {
            object = hSSFSheet.createRow((int)((short)n));
            HSSFCell hSSFCell2 = object.createCell((short)0);
            hSSFCell2.setCellValue((String)vector.get(i));
            double[] dArray = (double[])hSSFCell.get(i);
            for (int j = 0; j < dArray.length; ++j) {
                HSSFCell hSSFCell3 = object.createCell((short)(j + 1));
                hSSFCell3.setCellValue(dArray[j]);
            }
            ++n;
        }
        HttpSession httpSession = this.getRequest().getSession();
        object = "XLID_" + Math.random();
        httpSession.setAttribute((String)object, (Object)hSSFWorkbook);
        return object;
    }

    public String dailyStrategyData(String string, String string2, String string3, String string4) throws Exception {
        try {
            return new StrategyMgmt().dailyData(new HistoricalStrgyContractData(this).getDB(), string, string2, string3, string4);
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, "date:" + string + "contractname:" + string2 + ",datefomatted:" + string3 + ",fields:" + string4);
            throw exception;
        }
    }

    public Map loginAsAdmin(String string, String string2) throws Exception {
        TreeMap<String, Object> treeMap;
        block6: {
            treeMap = new TreeMap<String, Object>();
            try {
                this.getRequest().getSession().setAttribute(AdminMgmt.LOGGED_IN_ATTRIBUTE, (Object)"true");
                this.getRequest().getSession().setAttribute(AdminMgmt.LOGGED_IN_USERNAME, (Object)string.toLowerCase());
                this.getRequest().getSession().setMaxInactiveInterval(43200);
                try {
                    Properties properties = new Properties();
                    properties.load(new FileInputStream(AdminMgmt.DB_USER_PROPERTY_FILE));
                    String string3 = PasswordService.getInstance().encrypt(string2);
                    boolean bl = false;
                    if (properties.getProperty(string.toLowerCase()) != null && properties.getProperty(string).equals(string3)) {
                        bl = true;
                    }
                    if (!bl) {
                        treeMap.put("success", false);
                        treeMap.put("message", "Invalid User or Password");
                        break block6;
                    }
                    treeMap.put("success", true);
                }
                catch (IOException iOException) {
                    treeMap.put("success", true);
                }
            }
            catch (Exception exception) {
                treeMap.put("success", false);
                treeMap.put("message", "Login failed");
            }
        }
        return treeMap;
    }

    private boolean isAdminLoggedIn() throws Exception {
        String string = (String)this.getRequest().getSession().getAttribute(AdminMgmt.LOGGED_IN_ATTRIBUTE);
        return string != null && string.equalsIgnoreCase("true");
    }

    public Map logoutAsAdmin() throws Exception {
        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
        this.getRequest().getSession().removeAttribute(AdminMgmt.LOGGED_IN_ATTRIBUTE);
        this.getRequest().getSession().removeAttribute(AdminMgmt.LOGGED_IN_USERNAME);
        treeMap.put("success", true);
        return treeMap;
    }

    public boolean setActiveTab(int n) throws Exception {
        HttpSession httpSession = this.getRequest().getSession();
        httpSession.setAttribute(this.ACTIVE_TAB_ATTRIBUTE, (Object)n);
        return true;
    }

    public int getActiveTab() throws Exception {
        HttpSession httpSession = this.getRequest().getSession();
        int n = 1;
        if (httpSession.getAttribute(this.ACTIVE_TAB_ATTRIBUTE) != null) {
            try {
                n = (Integer)httpSession.getAttribute(this.ACTIVE_TAB_ATTRIBUTE);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    protected HttpServletRequest getRequest() throws Exception {
        return this.request == null && WebContextFactory.get() != null ? WebContextFactory.get().getHttpServletRequest() : this.request;
    }

    public Vector lastSystemReleaseNotes() throws Exception {
        Vector vector = new Vector();
        SVNInfo sVNInfo = new SVNInfo();
        if (sVNInfo.connect()) {
            int n = 0;
            Vector<SVNLogEntry> vector2 = new Vector<SVNLogEntry>(sVNInfo.logMessages());
            for (int i = vector2.size() - 1; i >= 0; --i) {
                SVNLogEntry sVNLogEntry = vector2.get(i);
                if (sVNLogEntry.getMessage() != null && !sVNLogEntry.getMessage().trim().equals("")) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put("date", new SimpleDateFormat("dd MMM, yyyy hh:mm a").format(sVNLogEntry.getDate()));
                    hashMap.put("revision", sVNLogEntry.getRevision());
                    hashMap.put("message", sVNLogEntry.getMessage().replaceAll("\n", "<br>"));
                    vector.add(hashMap);
                    ++n;
                }
                if (n < 10) continue;
                i = -1;
            }
        }
        return vector;
    }

    public Vector commoditiesSearch(String string) throws Exception {
        MyIndexer myIndexer = new MyIndexer(LuceneCrawler.INDEX_TABLE_COMMODITY);
        SearchSession searchSession = new SearchSession(myIndexer);
        Vector vector = searchSession.results(string, 0);
        return vector;
    }

    public Vector contractSearch(String string) throws Exception {
        MyIndexer myIndexer = new MyIndexer(LuceneCrawler.INDEX_TABLE_CONTRACT);
        SearchSession searchSession = new SearchSession(myIndexer);
        Vector vector = searchSession.results(string, 0);
        return vector;
    }

    public Vector fundamentalTickerSearch(String string) throws Exception {
        MyIndexer myIndexer = new MyIndexer(LuceneCrawler.INDEX_TABLE_FUNDAMENTAL_TICKR);
        SearchSession searchSession = new SearchSession(myIndexer);
        Vector vector = searchSession.results(string, 0);
        return vector;
    }
}

