/*
 * Decompiled with CFR 0.152.
 */
package com.fe.io.peer;

import com.fe.io.msg.PeerRequestLogin;
import com.fe.io.peer.PeerIORequestReceive;
import com.fe.p2p.P2PService;
import com.fe.scheduler.queue.QueueStackManager;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.Map;
import org.apache.log4j.Logger;

public class PeerClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = Logger.getLogger((String)PeerClientHandler.class.getName());
    private static ChannelHandlerContext connection2server = null;

    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        log.debug((Object)"channelActive");
        if (connection2server == null || connection2server != null && !connection2server.channel().isActive()) {
            connection2server = channelHandlerContext;
            PeerRequestLogin peerRequestLogin = new PeerRequestLogin();
            String string = P2PService.getComputerName();
            log.debug((Object)"computer name");
            peerRequestLogin.setPeername(string);
            try {
                if (QueueStackManager.getAllQueueStacks().size() <= 0) {
                    QueueStackManager.buildQueue4Peer(string);
                }
                peerRequestLogin.setQueuestring(QueueStackManager.getPeerQueueStatForServer());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            peerRequestLogin.send();
        }
        log.debug((Object)"channelActive end");
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        channelHandlerContext.close();
        if (channelHandlerContext.channel().isOpen()) {
            channelHandlerContext.disconnect();
        }
        connection2server = null;
        System.out.println("PeerClientHandler() channel inactive");
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) throws Exception {
        if (object != null && object instanceof Map) {
            new PeerIORequestReceive((Map)object).process(channelHandlerContext);
        }
    }

    public void exceptionCaught(ChannelHandlerContext channelHandlerContext, Throwable throwable) throws Exception {
        connection2server = null;
        System.out.println("PeerClientHandler() channel exceptionCaught");
        log.error((Object)"exceptionCaught()", throwable);
        channelHandlerContext.close();
        if (channelHandlerContext.channel().isOpen()) {
            channelHandlerContext.disconnect();
        }
    }

    public static ChannelHandlerContext getChannelHandler() {
        return connection2server;
    }
}

