/*
 * Decompiled with CFR 0.152.
 */
package com.fe.lucene;

import com.fe.client.ClientErrorMgmt;
import com.fe.lucene.MyIndexer;
import com.fe.lucene.SearchSession;
import com.fe.lucene.SearchTokenCollector;
import com.fe.lucene.TickerIndexRecord;
import com.fe.lucene.TokenCollectorFactory;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.log4j.Logger;

public class LuceneCrawler
implements Runnable {
    public static String INDEX_TABLE_SECURITY = "market_securities";
    public static String INDEX_TABLE_CONTRACT = "market_contracts";
    public static String INDEX_TABLE_COMMODITY = "market_commodity";
    public static String INDEX_TABLE_FUNDAMENTAL_TICKR = "fundamental_ticker";
    public static String INDEX_SCHEDULER = "scheduler";
    private String tablename;
    private static ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
    private static Hashtable optimizedAccounts = new Hashtable();
    private Logger log = Logger.getLogger(LuceneCrawler.class);
    private long indexid;
    private static boolean threadExecuting = false;

    public LuceneCrawler(String string) {
        this.tablename = string;
    }

    private LuceneCrawler() {
    }

    public synchronized void index(String string) throws Exception {
        this.addToQueue(string, 1);
    }

    private void addToQueue(String string, int n) {
        TickerIndexRecord tickerIndexRecord = new TickerIndexRecord();
        tickerIndexRecord.setTicker(string);
        tickerIndexRecord.setTablename(this.tablename);
        tickerIndexRecord.setAction(n);
        if (!queue.contains(tickerIndexRecord)) {
            queue.add(tickerIndexRecord);
        }
        if (!threadExecuting) {
            threadExecuting = true;
            Thread thread = new Thread(new LuceneCrawler());
            thread.start();
        }
    }

    public void deleteIndex(String string) throws Exception {
        this.addToQueue(string, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            Cloneable cloneable;
            Object object3;
            Iterator iterator;
            Object object2;
            while (!queue.isEmpty()) {
                TickerIndexRecord tickerIndexRecord = (TickerIndexRecord)queue.poll();
                object2 = new MyIndexer(tickerIndexRecord.getTablename());
                iterator = new SearchSession((MyIndexer)object2);
                object3 = TokenCollectorFactory.getTokenCollector(tickerIndexRecord);
                try {
                    ((SearchSession)((Object)iterator)).action(tickerIndexRecord.getAction(), (SearchTokenCollector)object3, tickerIndexRecord.getTicker());
                    this.log.debug((Object)"added to searchsession");
                    if (1 != tickerIndexRecord.getAction() && 2 != tickerIndexRecord.getAction()) {
                        // empty if block
                    }
                }
                catch (Exception exception) {
                    ClientErrorMgmt.reportError(exception, "Error while indexing, Action:" + tickerIndexRecord.getAction() + " id:" + tickerIndexRecord.getTicker() + " db:" + tickerIndexRecord.getTablename());
                }
                int n = 1;
                if (optimizedAccounts.containsKey(tickerIndexRecord.getTablename())) {
                    cloneable = (TreeMap)optimizedAccounts.get(tickerIndexRecord.getTablename());
                    if (((TreeMap)cloneable).containsKey(tickerIndexRecord.getTablename())) {
                        n = (Integer)((TreeMap)cloneable).get(tickerIndexRecord.getTablename());
                        ++n;
                    }
                    ((TreeMap)cloneable).put(tickerIndexRecord.getTablename(), n);
                } else {
                    cloneable = new TreeMap();
                    ((TreeMap)cloneable).put(tickerIndexRecord.getTablename(), n);
                    optimizedAccounts.put(tickerIndexRecord.getTablename(), cloneable);
                }
                this.log.debug((Object)("optimized accounts" + optimizedAccounts));
            }
            int n = 5;
            object2 = new Vector();
            for (Object object3 : optimizedAccounts.keySet()) {
                TreeMap treeMap = (TreeMap)optimizedAccounts.get(object3);
                cloneable = new Vector();
                for (Object object4 : treeMap.keySet()) {
                    Integer n2 = (Integer)treeMap.get(object4);
                    if (n2 < n) continue;
                    ((Vector)cloneable).add(object4);
                    MyIndexer myIndexer = new MyIndexer((String)object3);
                    SearchSession searchSession = new SearchSession(myIndexer);
                    searchSession.action(3, null, null);
                }
                Iterator<Object> iterator2 = ((Vector)cloneable).iterator();
                while (iterator2.hasNext()) {
                    Object object4;
                    object4 = iterator2.next();
                    treeMap.remove(object4);
                }
                if (treeMap.size() > 0) continue;
                ((Vector)object2).add(object3);
            }
            iterator = ((Vector)object2).iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                optimizedAccounts.remove(object3);
            }
            this.log.debug((Object)("optimized accounts at last:" + optimizedAccounts));
        }
        catch (Exception exception) {
            ClientErrorMgmt.reportError(exception, null);
        }
        finally {
            threadExecuting = false;
        }
        if (queue.size() > 0) {
            threadExecuting = true;
            Thread thread = new Thread(new LuceneCrawler());
            thread.start();
        }
    }

    public Hashtable getOptimizationQueueObj() {
        return optimizedAccounts;
    }

    public String getOptimizationStatus() {
        String string = "";
        for (String string2 : optimizedAccounts.keySet()) {
            TreeMap treeMap = (TreeMap)optimizedAccounts.get(string2);
            Vector vector = new Vector();
            for (String string3 : treeMap.keySet()) {
                Integer n = (Integer)treeMap.get(string3);
                string = string + "Account:" + string2 + ", table:" + string3 + ", count:" + n + "\n";
            }
        }
        return string;
    }

    public static int getQueueStat() throws Exception {
        return queue.size();
    }
}

