/*
 * Decompiled with CFR 0.152.
 */
package com.fe.lucene;

import com.fe.Config;
import java.io.File;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class MyIndexer {
    private Logger log = Logger.getLogger(MyIndexer.class);
    private String filename = null;
    private String account;
    private String dbname;
    private final int MAX_BUFFERED_DELETED_TERMS = 20;

    public MyIndexer(String string) {
        this.dbname = string;
        String string2 = Config.getString("lucene_index_folder");
        this.filename = string2 + this.dbname;
        if (!new File(this.filename).isDirectory()) {
            new File(this.filename).mkdirs();
            try {
                IndexWriter indexWriter = new IndexWriter(new File(this.filename), (Analyzer)new StandardAnalyzer(), true, IndexWriter.MaxFieldLength.LIMITED);
                indexWriter.optimize();
                indexWriter.close();
                this.log.info((Object)"Lucene Index created");
            }
            catch (Exception exception) {
                this.log.error((Object)("ERROR in creating index: MSG:" + exception.getMessage()));
            }
        }
    }

    public synchronized IndexReader getIndexReader() throws Exception {
        return IndexReader.open((String)this.filename);
    }

    public synchronized IndexWriter getIndexWriter() throws Exception {
        FSDirectory fSDirectory = FSDirectory.getDirectory((File)new File(this.filename));
        if (IndexWriter.isLocked((Directory)fSDirectory)) {
            this.log.error((Object)("Forced to unclock index of file:" + this.filename));
            IndexWriter.unlock((Directory)fSDirectory);
        }
        IndexWriter indexWriter = new IndexWriter(new File(this.filename), (Analyzer)new StandardAnalyzer(), false, IndexWriter.MaxFieldLength.LIMITED);
        return indexWriter;
    }

    public synchronized IndexSearcher getIndexSearcher() throws Exception {
        return new IndexSearcher(this.filename);
    }
}

