/*
 * Decompiled with CFR 0.152.
 */
package com.fe.lucene;

import com.fe.ValueObject;
import com.fe.lucene.MyIndexer;
import com.fe.lucene.RecordDocument;
import com.fe.lucene.SearchTokenCollector;
import java.util.Date;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class SearchSession {
    private Logger log = Logger.getLogger(SearchSession.class);
    private int maxpage = 1000;
    private MyIndexer myin;
    public static final int ACTION_INDEX = 1;
    public static final int ACTION_DELETE = 2;
    public static final int ACTION_OPTIMIZE = 3;
    private int totalHits = 0;

    public SearchSession(MyIndexer myIndexer) {
        this.myin = myIndexer;
    }

    public void setMaxPerPage(int n) {
        this.maxpage = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void action(int n, SearchTokenCollector searchTokenCollector, String string) throws Exception {
        SearchSession searchSession = this;
        synchronized (searchSession) {
            block19: {
                this.log.debug((Object)"action() invoked");
                IndexReader indexReader = this.myin.getIndexReader();
                IndexWriter indexWriter = this.myin.getIndexWriter();
                try {
                    if (n == 1) {
                        try {
                            searchTokenCollector.processTextTokens(string);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            throw new Exception("Error while processing at ticker:" + string + " Msg:" + exception.getLocalizedMessage());
                        }
                        if (searchTokenCollector.getString() == null) throw new Exception("No content collected  at id:" + string + " Msg:");
                        String string2 = searchTokenCollector.getString();
                        Map map = searchTokenCollector.getCategoryFields();
                        this.log.debug((Object)("cfields:" + map));
                        this.log.debug((Object)("content:" + string2));
                        Term term = new Term("id", "" + string);
                        TermEnum termEnum = indexReader.terms(term);
                        Document document = RecordDocument.Document(string2, string, map);
                        document.add((Fieldable)new Field("updated", DateTools.timeToString((long)new Date().getTime(), (DateTools.Resolution)DateTools.Resolution.DAY), Field.Store.YES, Field.Index.TOKENIZED));
                        for (ValueObject valueObject : searchTokenCollector.getAdditionalFields()) {
                            if (valueObject.getKey() == null || valueObject.getKey().equals("") || valueObject.getValue() == null || valueObject.getValue().equals("")) continue;
                            document.add((Fieldable)new Field(valueObject.getKey(), valueObject.getValue(), Field.Store.YES, Field.Index.TOKENIZED));
                        }
                        if (termEnum.next()) {
                            this.log.debug((Object)"updating document");
                            indexWriter.updateDocument(term, document);
                        } else {
                            document.add((Fieldable)new Field("added", DateTools.timeToString((long)new Date().getTime(), (DateTools.Resolution)DateTools.Resolution.DAY), Field.Store.YES, Field.Index.TOKENIZED));
                            indexWriter.addDocument(document);
                            this.log.debug((Object)"adding document");
                        }
                        break block19;
                    }
                    if (n == 2) {
                        if (indexReader == null || indexWriter == null) {
                            throw new Exception("IndexWriter or IndexReader is empty");
                        }
                        Term term = new Term("id", "" + string);
                        TermEnum termEnum = indexReader.terms(term);
                        if (!termEnum.next()) return;
                        indexWriter.deleteDocuments(term);
                        this.log.debug((Object)"deleting document");
                    } else {
                        if (n != 3) return;
                        this.log.debug((Object)"optimizing indexwriter");
                        indexWriter.optimize();
                    }
                }
                catch (Exception exception) {
                    throw new Exception("Error at id:" + string + " Msg:" + exception.getMessage());
                }
                finally {
                    indexReader.close();
                    indexWriter.close();
                }
            }
            return;
        }
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public Vector results(String string, int n) throws Exception {
        IndexSearcher indexSearcher = this.myin.getIndexSearcher();
        Vector<String> vector = null;
        try {
            StandardAnalyzer standardAnalyzer = new StandardAnalyzer();
            QueryParser queryParser = new QueryParser("content", (Analyzer)standardAnalyzer);
            queryParser.setDefaultOperator(QueryParser.AND_OPERATOR);
            Query query = queryParser.parse(string);
            Hits hits = indexSearcher.search(query);
            this.totalHits = hits.length();
            if (hits.length() == 0) {
            } else {
                vector = new Vector<String>();
                int n2 = n + this.maxpage <= hits.length() ? n + this.maxpage : hits.length();
                for (int i = n; i < n2; ++i) {
                    Document document = hits.doc(i);
                    vector.add(document.get("id"));
                }
            }
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            indexSearcher.close();
        }
        return vector;
    }
}

