/*
 * Decompiled with CFR 0.152.
 */
package com.fe.lucene;

import com.fe.lucene.FundamentalTickersCollector;
import com.fe.lucene.LuceneCrawler;
import com.fe.lucene.MarketCommodityCollector;
import com.fe.lucene.MarketContractCollector;
import com.fe.lucene.MarketSecurityCollector;
import com.fe.lucene.SchedulerTokenCollector;
import com.fe.lucene.SearchTokenCollector;
import com.fe.lucene.TickerIndexRecord;

public class TokenCollectorFactory {
    private TokenCollectorFactory() {
    }

    public static SearchTokenCollector getTokenCollector(TickerIndexRecord tickerIndexRecord) {
        try {
            if (tickerIndexRecord.getTablename().equals(LuceneCrawler.INDEX_TABLE_SECURITY)) {
                return new MarketSecurityCollector(tickerIndexRecord.getTablename());
            }
            if (tickerIndexRecord.getTablename().equals(LuceneCrawler.INDEX_TABLE_CONTRACT)) {
                return new MarketContractCollector(tickerIndexRecord.getTablename());
            }
            if (tickerIndexRecord.getTablename().equals(LuceneCrawler.INDEX_TABLE_COMMODITY)) {
                return new MarketCommodityCollector(tickerIndexRecord.getTablename());
            }
            if (tickerIndexRecord.getTablename().equals(LuceneCrawler.INDEX_TABLE_FUNDAMENTAL_TICKR)) {
                return new FundamentalTickersCollector(tickerIndexRecord.getTablename());
            }
            if (tickerIndexRecord.getTablename().equals(LuceneCrawler.INDEX_SCHEDULER)) {
                return new SchedulerTokenCollector(tickerIndexRecord.getTablename());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

