/*
 * Decompiled with CFR 0.152.
 */
package com.fe.p2p;

import com.fe.Config;
import com.fe.client.BBSyncMgmt;
import com.fe.client.RFunctionMgmt;
import com.fe.data.PeerPackage;
import com.fe.db.RFunctionDB;
import com.fe.db.SchedulerDB;
import com.fe.db.SuperDB;
import com.fe.db.UtilDB;
import com.fe.io.peer.PeerClient;
import com.fe.io.server.ServerScheduler;
import com.fe.p2p.MessageBean;
import com.fe.p2p.P2PAdvertisement;
import com.fe.p2p.P2PService;
import com.fe.p2p.listener.IncomingMessage;
import com.fe.scheduler.balance.ExecutingQueueCleaner;
import com.fe.scheduler.group.RScriptScheduledTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.pipe.InputPipe;
import net.jxta.pipe.PipeMsgListener;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.PipeAdvertisement;
import org.apache.commons.digester.Digester;
import org.apache.commons.io.IOUtils;

public class P2PServiceServlet
extends HttpServlet {
    private static Thread jxtaInpThread = null;
    private static Thread jxtaInpHelperThread = null;
    private InputPipe inputPipe = null;
    private static volatile boolean pipspin;
    private static volatile boolean pipspinhelper;
    private Timer timer = null;
    private org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(P2PServiceServlet.class);
    public static final String helper_prefix = "_helper";
    private static String defaultP2PCache;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.start();
    }

    private void print(String string) {
        System.out.println("P2PServiceServlet:" + string);
    }

    public void start() {
        P2PService.removeCache();
        P2PService.setPeerStarted();
        this.updatePeerName();
        this.print("Peer updated");
        this.startJxta();
        this.print("starteed Jxta");
        try {
            this.capturePackageVersions();
        }
        catch (Exception exception) {
            this.log.error((Object)"!!!!! Error while capturing package information...");
        }
        try {
            if (Config.getString("p2p.ignorejri") == null || !Config.getString("p2p.ignorejri").equalsIgnoreCase("true")) {
                this.print("Before capturing r version");
                RScriptScheduledTask.getRVersion();
            }
            this.print("end of start");
        }
        catch (Exception exception) {
            this.log.error((Object)"STARTUP ERROR:rJava support is not available on this peer");
        }
    }

    public void startHelper() {
        P2PService.removeCache();
        P2PService.setPeerStarted();
        this.startHelperJxta();
    }

    public static boolean isJxtaInpThreadRunning() {
        return jxtaInpThread != null && jxtaInpThread.isAlive();
    }

    private void startJxta() {
        block8: {
            try {
                System.out.println("starting network....................................");
                Logger.getLogger("net.jxta").setLevel(Level.SEVERE);
                DiscoveryService discoveryService = P2PService.getDiscoveryService();
                long l = 10000L;
                String string = P2PService.getComputerName();
                P2PAdvertisement p2PAdvertisement = new P2PAdvertisement();
                PeerAdvertisement peerAdvertisement = p2PAdvertisement.getPeerAdvertisement(string, P2PService.getPeerGroup());
                discoveryService.publish((Advertisement)peerAdvertisement, Long.MAX_VALUE, Long.MAX_VALUE);
                discoveryService.remotePublish((Advertisement)peerAdvertisement, Long.MAX_VALUE);
                jxtaInpThread = new Thread("Input poll"){
                    private org.apache.log4j.Logger log;
                    {
                        this.log = org.apache.log4j.Logger.getLogger(P2PServiceServlet.class);
                    }

                    @Override
                    public void run() {
                        this.log.debug((Object)"jxtaInpThread run()11 ");
                        int n = 180000;
                        String string = P2PService.getComputerName();
                        this.log.debug((Object)("computer name :" + string));
                        P2PAdvertisement p2PAdvertisement = new P2PAdvertisement();
                        this.log.debug((Object)("ad :" + p2PAdvertisement));
                        PipeAdvertisement pipeAdvertisement = p2PAdvertisement.getPipeAdvertisement(string, P2PService.getPeerGroup());
                        this.log.debug((Object)"creating input pipe advertisement ");
                        try {
                            P2PServiceServlet.this.inputPipe = P2PService.getPipeService().createInputPipe(pipeAdvertisement, (PipeMsgListener)new IncomingMessage(null));
                            this.log.debug((Object)"waiting input pipe");
                        }
                        catch (Exception exception) {
                            System.out.println("~~~~~~~~~~~~~FATAL Error P2PServiceServlet2$.run()  on inputpipe service................");
                            exception.printStackTrace();
                        }
                        pipspin = true;
                        while (pipspin) {
                            try {
                                1.sleep(n);
                            }
                            catch (InterruptedException interruptedException) {
                                this.log.error((Object)"Waiting thread intrupted...........");
                            }
                        }
                    }
                };
                jxtaInpThread.start();
                this.log.debug((Object)"jxtaInpThread started ");
                TimerTask timerTask = new TimerTask(){

                    @Override
                    public void run() {
                        if (!jxtaInpThread.isAlive()) {
                            jxtaInpThread.start();
                        }
                    }
                };
                long l2 = 90000L;
                this.timer = new Timer();
                this.timer.scheduleAtFixedRate(timerTask, l2, l2);
                TimerTask timerTask2 = new TimerTask(){
                    org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(P2PServiceServlet.class);

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int n = 5;
                        if (Config.getString("db_close_timeout") != null) {
                            n = Integer.parseInt(Config.getString("db_close_timeout"));
                        }
                        UtilDB utilDB = UtilDB.getUtilDB4SQLServer();
                        try {
                            SuperDB.killConnections(n);
                            Thread.sleep(300L);
                            utilDB.connectDB(P2PServiceServlet.this.getUtilDBName());
                            ArrayList arrayList = utilDB.showOldConnections(n, P2PService.getComputerName());
                            if (arrayList != null && arrayList.size() > 0) {
                                this.log.error((Object)("~~~~~~Killing " + arrayList.size() + " physical connections in database after " + n + " minutes"));
                                this.log.error((Object)"===While killing the following found left unclosed==");
                                this.log.error((Object)SchedulerDB.collectStack4All());
                                this.log.error((Object)"=====");
                                utilDB.killConnections(arrayList);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        finally {
                            try {
                                utilDB.closeDB();
                            }
                            catch (Exception exception) {}
                        }
                    }
                };
                long l3 = 300000L;
                Timer timer = new Timer();
                timer.scheduleAtFixedRate(timerTask2, l3, l3);
                String string2 = "jett_thread_" + new Date().getTime() / 1000L;
                if (Config.getValue("load_balancing_server") != null && Config.getValue("load_balancing_server").equals(P2PService.getComputerName())) {
                    ExecutingQueueCleaner.clean();
                }
                if (Config.getValue("nio.server.mode") != null && Config.getValue("nio.server.mode").trim().equalsIgnoreCase("true") && Config.getValue("nio.server.port") != null && !Config.getValue("nio.server.port").trim().equals("")) {
                    int n = 1818;
                    try {
                        n = Integer.parseInt(Config.getValue("nio.server.port"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Thread thread = new Thread((Runnable)new ServerScheduler(n), string2);
                    thread.start();
                    System.out.println("--->ServerScheduler starting....in port:" + n);
                    break block8;
                }
                if (Config.getValue("nio.server.address") == null || Config.getValue("nio.server.address").trim().equals("") || Config.getValue("nio.server.port") == null || Config.getValue("nio.server.port").trim().equals("")) break block8;
                System.out.println("--->PeerScheduler will start ...in IP:" + Config.getValue("nio.server.address") + " port:" + Config.getValue("nio.server.port"));
                int n = 1818;
                String string3 = Config.getValue("nio.server.address");
                try {
                    n = Integer.parseInt(Config.getValue("nio.server.port"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.log.debug((Object)("server:" + string3 + " port:" + n + " tname:" + string2));
                Thread thread = new Thread((Runnable)new PeerClient(string3, n), string2);
                this.log.debug((Object)("t:" + thread));
                thread.start();
                this.log.debug((Object)"started:");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void startHelperJxta() {
        try {
            Logger.getLogger("net.jxta").setLevel(Level.SEVERE);
            DiscoveryService discoveryService = P2PService.getDiscoveryService();
            long l = 10000L;
            String string = P2PService.getComputerName();
            P2PAdvertisement p2PAdvertisement = new P2PAdvertisement();
            PeerAdvertisement peerAdvertisement = p2PAdvertisement.getPeerAdvertisement(string + helper_prefix, P2PService.getPeerGroup());
            discoveryService.publish((Advertisement)peerAdvertisement, Long.MAX_VALUE, Long.MAX_VALUE);
            discoveryService.remotePublish((Advertisement)peerAdvertisement, Long.MAX_VALUE);
            jxtaInpThread = new Thread("Input poll"){
                private org.apache.log4j.Logger log;
                {
                    this.log = org.apache.log4j.Logger.getLogger(P2PServiceServlet.class);
                }

                @Override
                public void run() {
                    int n = 180000;
                    String string = P2PService.getComputerName();
                    P2PAdvertisement p2PAdvertisement = new P2PAdvertisement();
                    PipeAdvertisement pipeAdvertisement = p2PAdvertisement.getPipeAdvertisement(string + P2PServiceServlet.helper_prefix, P2PService.getPeerGroup());
                    try {
                        P2PServiceServlet.this.inputPipe = P2PService.getPipeService().createInputPipe(pipeAdvertisement, (PipeMsgListener)new IncomingMessage(null));
                        this.log.debug((Object)"waiting input pipe");
                    }
                    catch (Exception exception) {
                        System.out.println("~~~~~~~~~~~~~FATAL Error P2PServiceServlet2$.run()  on inputpipe service................");
                        exception.printStackTrace();
                    }
                    pipspin = true;
                    while (pipspin) {
                        try {
                            4.sleep(n);
                        }
                        catch (InterruptedException interruptedException) {
                            this.log.error((Object)"Waiting thread intrupted...........");
                        }
                    }
                }
            };
            jxtaInpThread.start();
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    if (!jxtaInpThread.isAlive()) {
                        jxtaInpThread.start();
                    }
                }
            };
            long l2 = 90000L;
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate(timerTask, l2, l2);
            TimerTask timerTask2 = new TimerTask(){
                org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(P2PServiceServlet.class);

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int n = 5;
                    if (Config.getString("db_close_timeout") != null) {
                        n = Integer.parseInt(Config.getString("db_close_timeout"));
                    }
                    UtilDB utilDB = UtilDB.getUtilDB4SQLServer();
                    try {
                        SuperDB.killConnections(n);
                        Thread.sleep(300L);
                        utilDB.connectDB(P2PServiceServlet.this.getUtilDBName());
                        ArrayList arrayList = utilDB.showOldConnections(n, P2PService.getComputerName());
                        if (arrayList != null && arrayList.size() > 0) {
                            this.log.error((Object)("~~~~~~Killing " + arrayList.size() + " physical connections in database after " + n + " minutes"));
                            this.log.error((Object)"===While killing the following found left unclosed==");
                            this.log.error((Object)SchedulerDB.collectStack4All());
                            this.log.error((Object)"=====");
                            utilDB.killConnections(arrayList);
                        }
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        try {
                            utilDB.closeDB();
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            long l3 = 300000L;
            Timer timer = new Timer();
            timer.scheduleAtFixedRate(timerTask2, l3, l3);
            if (Config.getValue("load_balancing_server") != null && Config.getValue("load_balancing_server").equals(P2PService.getComputerName())) {
                ExecutingQueueCleaner.clean();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static MessageBean parseMessage(String string) throws Exception {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.addObjectCreate("message", MessageBean.class);
        digester.addBeanPropertySetter("message/type");
        digester.addBeanPropertySetter("message/command");
        digester.addBeanPropertySetter("message/sender");
        digester.addBeanPropertySetter("message/reply");
        MessageBean messageBean = (MessageBean)digester.parse((Reader)new StringReader(string));
        return messageBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePeerName() {
        SchedulerDB schedulerDB = SchedulerDB.getSchedulerDB();
        try {
            String string = P2PService.getComputerName();
            this.log.debug((Object)("updatePeerName() peername: " + string + " db:" + BBSyncMgmt.getDBName()));
            schedulerDB.connectDB(BBSyncMgmt.getDBName());
            schedulerDB.updatePeersList(string);
        }
        catch (Exception exception) {
            this.log.error((Object)("updatePeerName() db: " + BBSyncMgmt.getDBName()));
            exception.printStackTrace();
        }
        finally {
            try {
                schedulerDB.closeDB();
            }
            catch (Exception exception) {}
        }
    }

    private void capturePackageVersions() throws Exception {
        RFunctionDB rFunctionDB = RFunctionDB.getRFunctionDB();
        int n = 0;
        try {
            String string = P2PService.getComputerName();
            rFunctionDB.connectDB(RFunctionMgmt.getDBName());
            n = 100;
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            String string2 = System.getenv("R_HOME");
            string2 = string2 + (string2.endsWith(File.separator) ? "library" : File.separator + "library");
            File[] fileArray = new File(string2).listFiles();
            boolean bl = false;
            ArrayList<PeerPackage> arrayList = new ArrayList<PeerPackage>();
            n = 200;
            for (int i = 0; i < fileArray.length; ++i) {
                File file = new File(fileArray[i].getPath() + File.separator + "DESCRIPTION");
                n = 300;
                if (!file.exists()) continue;
                n = 400;
                try {
                    StringWriter stringWriter = new StringWriter();
                    IOUtils.copy((InputStream)new FileInputStream(file), (Writer)stringWriter);
                    StringTokenizer stringTokenizer = new StringTokenizer(stringWriter.toString(), "\n\r");
                    PeerPackage peerPackage = new PeerPackage();
                    peerPackage.setPackagename(fileArray[i].getName());
                    peerPackage.setLastchecked(new Date());
                    n = 500;
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        if (!string3.startsWith("Version:") || string3.split(":").length <= 1) continue;
                        peerPackage.setVersion(string3.split(":")[1]);
                    }
                    arrayList.add(peerPackage);
                    continue;
                }
                catch (Exception exception) {
                    this.log.error((Object)("Error while getting info of package " + fileArray[i].getName()));
                }
            }
            rFunctionDB.updatePeerPackage(string, arrayList);
            this.log.debug((Object)("peername:" + string + " plist:" + arrayList));
        }
        catch (Exception exception) {
            this.log.error((Object)("Error ,MSG:" + exception.getMessage() + " loc:" + n));
            throw exception;
        }
        finally {
            rFunctionDB.closeDB();
        }
    }

    public void destroy() {
        jxtaInpThread.interrupt();
        pipspin = false;
        if (this.timer != null) {
            this.timer.cancel();
        }
        P2PService.stopNetwork();
    }

    private String getUtilDBName() {
        String string = "master";
        if ("mariadb".equalsIgnoreCase(Config.getValue("db_type"))) {
            string = "mysql";
        }
        return string;
    }

    static {
        defaultP2PCache = "";
    }
}

